/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network.http;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.network.http.CtHttpClient;
import com.clevertap.android.sdk.network.http.Request;
import com.clevertap.android.sdk.network.http.Response;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/clevertap/android/sdk/network/http/UrlConnectionHttpClient;", "Lcom/clevertap/android/sdk/network/http/CtHttpClient;", "isSslPinningEnabled", "", "logger", "Lcom/clevertap/android/sdk/Logger;", "logTag", "", "(ZLcom/clevertap/android/sdk/Logger;Ljava/lang/String;)V", "()Z", "setSslPinningEnabled", "(Z)V", "socketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "socketFactory$delegate", "Lkotlin/Lazy;", "sslContext", "Ljavax/net/ssl/SSLContext;", "getSslContext", "()Ljavax/net/ssl/SSLContext;", "sslContext$delegate", "createSslContext", "execute", "Lcom/clevertap/android/sdk/network/http/Response;", "request", "Lcom/clevertap/android/sdk/network/http/Request;", "openHttpsURLConnection", "Ljavax/net/ssl/HttpsURLConnection;", "Companion", "clevertap-core_release"})
public final class UrlConnectionHttpClient
implements CtHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isSslPinningEnabled;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String logTag;
    @NotNull
    private final Lazy socketFactory$delegate;
    @NotNull
    private final Lazy sslContext$delegate;
    public static final int READ_TIMEOUT = 10000;
    public static final int CONNECT_TIMEOUT = 10000;

    public UrlConnectionHttpClient(boolean isSslPinningEnabled, @NotNull Logger logger, @NotNull String logTag) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        this.isSslPinningEnabled = isSslPinningEnabled;
        this.logger = logger;
        this.logTag = logTag;
        this.socketFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SSLSocketFactory>(this){
            final /* synthetic */ UrlConnectionHttpClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SSLSocketFactory invoke() {
                SSLSocketFactory sSLSocketFactory;
                try {
                    Logger.d("Pinning SSL session to DigiCertGlobalRoot CA certificate");
                    SSLContext sSLContext = UrlConnectionHttpClient.access$getSslContext(this.this$0);
                    sSLSocketFactory = sSLContext != null ? sSLContext.getSocketFactory() : null;
                }
                catch (Exception e) {
                    Logger.d("Issue in pinning SSL,", e);
                    sSLSocketFactory = null;
                }
                return sSLSocketFactory;
            }
        }));
        this.sslContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SSLContext>(this){
            final /* synthetic */ UrlConnectionHttpClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SSLContext invoke() {
                return UrlConnectionHttpClient.access$createSslContext(this.this$0);
            }
        }));
    }

    public final boolean isSslPinningEnabled() {
        return this.isSslPinningEnabled;
    }

    public final void setSslPinningEnabled(boolean bl) {
        this.isSslPinningEnabled = bl;
    }

    private final SSLSocketFactory getSocketFactory() {
        Lazy lazy = this.socketFactory$delegate;
        return (SSLSocketFactory)lazy.getValue();
    }

    private final SSLContext getSslContext() {
        Lazy lazy = this.sslContext$delegate;
        return (SSLContext)lazy.getValue();
    }

    @Override
    @NotNull
    public Response execute(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Ref.ObjectRef connection = new Ref.ObjectRef();
        try {
            Response response;
            connection.element = this.openHttpsURLConnection(request);
            this.logger.debug(this.logTag, "Sending request to: " + request.getUrl());
            int responseCode = ((HttpsURLConnection)connection.element).getResponseCode();
            Map<String, List<String>> headers = ((HttpsURLConnection)connection.element).getHeaderFields();
            Function0 disconnectConnection2 = (Function0)new Function0<Unit>((Ref.ObjectRef<HttpsURLConnection>)connection){
                final /* synthetic */ Ref.ObjectRef<HttpsURLConnection> $connection;
                {
                    this.$connection = $connection;
                    super(0);
                }

                public final void invoke() {
                    ((HttpsURLConnection)this.$connection.element).disconnect();
                }
            };
            if (responseCode == 200) {
                Intrinsics.checkNotNullExpressionValue(headers, (String)"headers");
                response = new Response(request, responseCode, headers, ((HttpsURLConnection)connection.element).getInputStream(), (Function0<Unit>)disconnectConnection2);
            } else {
                Intrinsics.checkNotNullExpressionValue(headers, (String)"headers");
                response = new Response(request, responseCode, headers, ((HttpsURLConnection)connection.element).getErrorStream(), (Function0<Unit>)disconnectConnection2);
            }
            return response;
        }
        catch (Exception e) {
            block4: {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection.element;
                if (httpsURLConnection == null) break block4;
                httpsURLConnection.disconnect();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpsURLConnection openHttpsURLConnection(Request request) {
        HttpsURLConnection httpsURLConnection;
        URL url = new URL(request.getUrl().toString());
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection $this$openHttpsURLConnection_u24lambda_u241 = httpsURLConnection = (HttpsURLConnection)uRLConnection;
        boolean bl = false;
        $this$openHttpsURLConnection_u24lambda_u241.setConnectTimeout(10000);
        $this$openHttpsURLConnection_u24lambda_u241.setReadTimeout(10000);
        for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
            $this$openHttpsURLConnection_u24lambda_u241.setRequestProperty(header.getKey(), header.getValue());
        }
        $this$openHttpsURLConnection_u24lambda_u241.setInstanceFollowRedirects(false);
        if (this.isSslPinningEnabled && this.getSslContext() != null) {
            $this$openHttpsURLConnection_u24lambda_u241.setSSLSocketFactory(this.getSocketFactory());
        }
        if (request.getBody() != null) {
            $this$openHttpsURLConnection_u24lambda_u241.setDoOutput(true);
            Closeable closeable = $this$openHttpsURLConnection_u24lambda_u241.getOutputStream();
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl2 = false;
                byte[] byArray = request.getBody().getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                it.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        HttpsURLConnection connection = httpsURLConnection;
        return connection;
    }

    private final SSLContext createSslContext() {
        try {
            KeyStore keyStore;
            TrustManagerFactory trustManagerFactory;
            SSLContext sSLContext;
            SSLContext $this$createSslContext_u24lambda_u244 = sSLContext = SSLContext.getInstance("TLS");
            boolean bl = false;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            TrustManagerFactory $this$createSslContext_u24lambda_u244_u24lambda_u243 = trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            boolean bl2 = false;
            KeyStore $this$createSslContext_u24lambda_u244_u24lambda_u243_u24lambda_u242 = keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            boolean bl3 = false;
            $this$createSslContext_u24lambda_u244_u24lambda_u243_u24lambda_u242.load(null, null);
            ClassLoader classLoader = $this$createSslContext_u24lambda_u244_u24lambda_u243_u24lambda_u242.getClass().getClassLoader();
            InputStream inputStream = new BufferedInputStream(classLoader != null ? classLoader.getResourceAsStream("com/clevertap/android/sdk/certificates/AmazonRootCA1.cer") : null);
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate x509Certificate3 = (X509Certificate)certificate;
            $this$createSslContext_u24lambda_u244_u24lambda_u243_u24lambda_u242.setCertificateEntry("AmazonRootCA1", x509Certificate3);
            KeyStore keyStore2 = keyStore;
            $this$createSslContext_u24lambda_u244_u24lambda_u243.init(keyStore2);
            TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
            $this$createSslContext_u24lambda_u244.init(null, trustManagerFactory2.getTrustManagers(), null);
            SSLContext sslContext2 = sSLContext;
            Logger.d("SSL Context built");
            return sslContext2;
        }
        catch (Exception e) {
            Logger.i("Error building SSL Context", e);
            return null;
        }
    }

    public static final /* synthetic */ SSLContext access$getSslContext(UrlConnectionHttpClient $this) {
        return $this.getSslContext();
    }

    public static final /* synthetic */ SSLContext access$createSslContext(UrlConnectionHttpClient $this) {
        return $this.createSslContext();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/network/http/UrlConnectionHttpClient$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "READ_TIMEOUT", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

