/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.featureFlags;

import android.text.TextUtils;
import com.clevertap.android.sdk.BaseAnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.OnSuccessListener;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.FileUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class CTFeatureFlagsController {
    final CleverTapInstanceConfig config;
    String guid;
    boolean isInitialized = false;
    final BaseAnalyticsManager mAnalyticsManager;
    final BaseCallbackManager mCallbackManager;
    FileUtils mFileUtils;
    private final Map<String, Boolean> store = Collections.synchronizedMap(new HashMap());

    @Deprecated
    public String getGuid() {
        return this.guid;
    }

    @Deprecated
    CTFeatureFlagsController(String guid, CleverTapInstanceConfig config, BaseCallbackManager callbackManager, BaseAnalyticsManager analyticsManager, FileUtils fileUtils) {
        this.guid = guid;
        this.config = config;
        this.mCallbackManager = callbackManager;
        this.mAnalyticsManager = analyticsManager;
        this.mFileUtils = fileUtils;
        this.init();
    }

    @Deprecated
    public void fetchFeatureFlags() {
        Task<Void> task = CTExecutorFactory.executors(this.config).mainTask();
        task.execute("fetchFeatureFlags", new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    CTFeatureFlagsController.this.mAnalyticsManager.fetchFeatureFlags();
                }
                catch (Exception e) {
                    CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), e.getLocalizedMessage());
                }
                return null;
            }
        });
    }

    @Deprecated
    public Boolean get(String key, boolean defaultValue) {
        if (!this.isInitialized) {
            this.getConfigLogger().verbose(this.getLogTag(), "Controller not initialized, returning default value - " + defaultValue);
            return defaultValue;
        }
        this.getConfigLogger().verbose(this.getLogTag(), "Getting feature flag with key - " + key + " and default value - " + defaultValue);
        Boolean value = this.store.get(key);
        if (value != null) {
            return value;
        }
        this.getConfigLogger().verbose(this.getLogTag(), "Feature flag not found, returning default value - " + defaultValue);
        return defaultValue;
    }

    @Deprecated
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Deprecated
    public void resetWithGuid(String guid) {
        this.guid = guid;
        this.init();
    }

    @Deprecated
    public void setGuidAndInit(String cleverTapID) {
        if (this.isInitialized) {
            return;
        }
        this.guid = cleverTapID;
        this.init();
    }

    @Deprecated
    public synchronized void updateFeatureFlags(JSONObject jsonObject) throws JSONException {
        JSONArray featureFlagList = jsonObject.getJSONArray("kv");
        try {
            for (int i = 0; i < featureFlagList.length(); ++i) {
                JSONObject ff = featureFlagList.getJSONObject(i);
                this.store.put(ff.getString("n"), ff.getBoolean("v"));
            }
            this.getConfigLogger().verbose(this.getLogTag(), "Updating feature flags..." + this.store);
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose(this.getLogTag(), "Error parsing Feature Flag array " + e.getLocalizedMessage());
        }
        this.archiveData(jsonObject);
        this.notifyFeatureFlagUpdate();
    }

    String getCachedDirName() {
        return "Feature_Flag_" + this.config.getAccountId() + "_" + this.guid;
    }

    String getCachedFileName() {
        return "ff_cache.json";
    }

    String getCachedFullPath() {
        return this.getCachedDirName() + "/" + this.getCachedFileName();
    }

    void init() {
        if (TextUtils.isEmpty((CharSequence)this.guid)) {
            return;
        }
        Task<Boolean> task = CTExecutorFactory.executors(this.config).ioTask();
        task.addOnSuccessListener(new OnSuccessListener<Boolean>(){

            @Override
            public void onSuccess(Boolean init) {
                CTFeatureFlagsController.this.isInitialized = init;
            }
        });
        task.execute("initFeatureFlags", new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), "Feature flags init is called");
                    String fileName = CTFeatureFlagsController.this.getCachedFullPath();
                    try {
                        CTFeatureFlagsController.this.store.clear();
                        String content = CTFeatureFlagsController.this.mFileUtils.readFromFile(fileName);
                        if (!TextUtils.isEmpty((CharSequence)content)) {
                            JSONObject jsonObject = new JSONObject(content);
                            JSONArray kvArray = jsonObject.getJSONArray("kv");
                            if (kvArray != null && kvArray.length() > 0) {
                                for (int i = 0; i < kvArray.length(); ++i) {
                                    JSONObject object = (JSONObject)kvArray.get(i);
                                    if (object == null) continue;
                                    String Key2 = object.getString("n");
                                    String Value = object.getString("v");
                                    if (TextUtils.isEmpty((CharSequence)Key2)) continue;
                                    CTFeatureFlagsController.this.store.put(Key2, Boolean.parseBoolean(Value));
                                }
                            }
                            CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), "Feature flags initialized from file " + fileName + " with configs  " + CTFeatureFlagsController.this.store);
                        } else {
                            CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), "Feature flags file is empty-" + fileName);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), "UnArchiveData failed file- " + fileName + " " + e.getLocalizedMessage());
                        return false;
                    }
                    return true;
                }
            }
        });
    }

    private synchronized void archiveData(JSONObject featureFlagRespObj) {
        if (featureFlagRespObj != null) {
            try {
                this.mFileUtils.writeJsonToFile(this.getCachedDirName(), this.getCachedFileName(), featureFlagRespObj);
                this.getConfigLogger().verbose(this.getLogTag(), "Feature flags saved into file-[" + this.getCachedFullPath() + "]" + this.store);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getConfigLogger().verbose(this.getLogTag(), "ArchiveData failed - " + e.getLocalizedMessage());
            }
        }
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    private String getLogTag() {
        return this.config.getAccountId() + "[Feature Flag]";
    }

    private void notifyFeatureFlagUpdate() {
        if (this.mCallbackManager.getFeatureFlagListener() != null) {
            Task<Void> task = CTExecutorFactory.executors(this.config).mainTask();
            task.execute("notifyFeatureFlagUpdate", new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        if (CTFeatureFlagsController.this.mCallbackManager.getFeatureFlagListener() != null) {
                            CTFeatureFlagsController.this.mCallbackManager.getFeatureFlagListener().featureFlagsUpdated();
                        }
                    }
                    catch (Exception e) {
                        CTFeatureFlagsController.this.getConfigLogger().verbose(CTFeatureFlagsController.this.getLogTag(), e.getLocalizedMessage());
                    }
                    return null;
                }
            });
        }
    }
}

