/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.activity.OnBackPressedCallback;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import com.clevertap.android.sdk.CTPreferenceCache;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DidClickForHardPermissionListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.PushPermissionManager;
import com.clevertap.android.sdk.inapp.CTInAppAction;
import com.clevertap.android.sdk.inapp.CTInAppBaseFullFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlCoverFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlHalfInterstitialFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlInterstitialFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeCoverFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeCoverImageFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeHalfInterstitialFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeHalfInterstitialImageFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeInterstitialFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeInterstitialImageFragment;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.inapp.InAppActionType;
import com.clevertap.android.sdk.inapp.InAppListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class InAppNotificationActivity
extends FragmentActivity
implements InAppListener,
DidClickForHardPermissionListener {
    private static boolean isAlertVisible = false;
    private CleverTapInstanceConfig config;
    private CTInAppNotification inAppNotification;
    private WeakReference<InAppListener> listenerWeakReference;
    private WeakReference<PushPermissionResultCallback> pushPermissionResultCallbackWeakReference;
    private PushPermissionManager pushPermissionManager;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getOnBackPressedDispatcher().addCallback((LifecycleOwner)this, new OnBackPressedCallback(true){

            public void handleOnBackPressed() {
                InAppNotificationActivity.this.finish();
                InAppNotificationActivity.this.didDismiss(null);
            }
        });
        int orientation = this.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            this.getWindow().addFlags(1024);
        }
        try {
            Bundle notif = this.getIntent().getExtras();
            if (notif == null) {
                throw new IllegalArgumentException();
            }
            this.inAppNotification = (CTInAppNotification)notif.getParcelable("inApp");
            boolean showHardNotificationPermission = notif.getBoolean("displayHardPermissionDialog", false);
            Bundle configBundle = notif.getBundle("configBundle");
            if (configBundle != null) {
                this.config = (CleverTapInstanceConfig)configBundle.getParcelable("config");
            }
            this.setListener(CleverTapAPI.instanceWithConfig((Context)this, this.config).getCoreState().getInAppController());
            this.setPermissionCallback(CleverTapAPI.instanceWithConfig((Context)this, this.config).getCoreState().getInAppController());
            this.pushPermissionManager = new PushPermissionManager((Activity)this, this.config);
            if (showHardNotificationPermission) {
                boolean shouldShowFallbackSettings = notif.getBoolean("shouldShowFallbackSettings", false);
                this.showHardPermissionPrompt(shouldShowFallbackSettings);
                return;
            }
        }
        catch (Throwable t) {
            Logger.v("Cannot find a valid notification bundle to show!", t);
            this.finish();
            return;
        }
        if (this.inAppNotification == null) {
            this.finish();
            return;
        }
        if (this.inAppNotification.isPortrait() && !this.inAppNotification.isLandscape()) {
            if (orientation == 2) {
                Logger.d("App in Landscape, dismissing portrait InApp Notification");
                this.finish();
                this.didDismiss(null);
                return;
            }
            Logger.d("App in Portrait, displaying InApp Notification anyway");
        }
        if (!this.inAppNotification.isPortrait() && this.inAppNotification.isLandscape()) {
            if (orientation == 1) {
                Logger.d("App in Portrait, dismissing landscape InApp Notification");
                this.finish();
                this.didDismiss(null);
                return;
            }
            Logger.d("App in Landscape, displaying InApp Notification anyway");
        }
        if (savedInstanceState == null) {
            CTInAppBaseFullFragment contentFragment = this.createContentFragment();
            if (contentFragment != null) {
                Bundle bundle = new Bundle();
                bundle.putParcelable("inApp", (Parcelable)this.inAppNotification);
                bundle.putParcelable("config", (Parcelable)this.config);
                contentFragment.setArguments(bundle);
                this.getSupportFragmentManager().beginTransaction().setCustomAnimations(0x10B0000, 0x10B0001).add(0x1020002, (Fragment)contentFragment, this.getFragmentTag()).commitNow();
            }
        } else if (isAlertVisible) {
            this.createContentFragment();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.pushPermissionManager.isFromNotificationSettingsActivity() && Build.VERSION.SDK_INT >= 33) {
            int permissionStatus = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.POST_NOTIFICATIONS");
            if (permissionStatus == 0) {
                ((PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get()).onPushPermissionAccept();
            } else {
                ((PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get()).onPushPermissionDeny();
            }
            this.didDismiss(null);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void finish() {
        super.finish();
        if (Build.VERSION.SDK_INT >= 34) {
            this.overrideActivityTransition(1, 0x10A0000, 0x10A0001);
        } else {
            this.overridePendingTransition(0x10A0000, 0x10A0001);
        }
    }

    @Override
    @Nullable
    public Bundle inAppNotificationDidClick(@NonNull CTInAppNotification inAppNotification, @NonNull CTInAppNotificationButton button, @Nullable Context activityContext) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            return listener.inAppNotificationDidClick(inAppNotification, button, (Context)this);
        }
        return null;
    }

    @Override
    public void inAppNotificationDidDismiss(@NonNull CTInAppNotification inAppNotification, @Nullable Bundle formData) {
        this.didDismiss(formData);
    }

    @Override
    public void inAppNotificationDidShow(@NonNull CTInAppNotification inAppNotification, @Nullable Bundle formData) {
        this.didShow(formData);
    }

    @Override
    @Nullable
    public Bundle inAppNotificationActionTriggered(@NonNull CTInAppNotification inAppNotification, @NonNull CTInAppAction action, @NonNull String callToAction, @Nullable Bundle additionalData, @Nullable Context activityContext) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            return listener.inAppNotificationActionTriggered(inAppNotification, action, callToAction, additionalData, (Context)this);
        }
        return null;
    }

    public void setTheme(int resid) {
        super.setTheme(0x1030010);
    }

    @Override
    public void didClickForHardPermissionWithFallbackSettings(boolean fallbackToSettings) {
        this.showHardPermissionPrompt(fallbackToSettings);
    }

    @SuppressLint(value={"NewApi"})
    public void showHardPermissionPrompt(boolean isFallbackSettingsEnabled) {
        this.pushPermissionManager.showHardPermissionPrompt(isFallbackSettingsEnabled, (PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get());
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        CTPreferenceCache.getInstance((Context)this, this.config).setFirstTimeRequest(false);
        CTPreferenceCache.updateCacheToDisk((Context)this, this.config);
        if (requestCode == 102) {
            boolean granted;
            boolean bl = granted = grantResults.length > 0 && grantResults[0] == 0;
            if (granted) {
                ((PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get()).onPushPermissionAccept();
            } else {
                ((PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get()).onPushPermissionDeny();
            }
            this.didDismiss(null);
        }
    }

    void didDismiss(Bundle data) {
        if (isAlertVisible) {
            isAlertVisible = false;
        }
        this.finish();
        InAppListener listener = this.getListener();
        if (listener != null && this.inAppNotification != null) {
            listener.inAppNotificationDidDismiss(this.inAppNotification, data);
        }
    }

    void didShow(Bundle data) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidShow(this.inAppNotification, data);
        }
    }

    InAppListener getListener() {
        InAppListener listener = null;
        try {
            listener = (InAppListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "InAppActivityListener is null for notification: " + this.inAppNotification.getJsonDescription());
        }
        return listener;
    }

    void setListener(InAppListener listener) {
        this.listenerWeakReference = new WeakReference<InAppListener>(listener);
    }

    public void setPermissionCallback(PushPermissionResultCallback callback) {
        this.pushPermissionResultCallbackWeakReference = new WeakReference<PushPermissionResultCallback>(callback);
    }

    public void notifyPermissionDenied() {
        ((PushPermissionResultCallback)this.pushPermissionResultCallbackWeakReference.get()).onPushPermissionDeny();
    }

    @Nullable
    private Bundle didClick(CTInAppNotificationButton button) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            return listener.inAppNotificationDidClick(this.inAppNotification, button, (Context)this);
        }
        return null;
    }

    private CTInAppBaseFullFragment createContentFragment() {
        CTInAppType type = this.inAppNotification.getInAppType();
        CTInAppBaseFullFragment viewFragment = null;
        switch (type) {
            case CTInAppTypeCoverHTML: {
                viewFragment = new CTInAppHtmlCoverFragment();
                break;
            }
            case CTInAppTypeInterstitialHTML: {
                viewFragment = new CTInAppHtmlInterstitialFragment();
                break;
            }
            case CTInAppTypeHalfInterstitialHTML: {
                viewFragment = new CTInAppHtmlHalfInterstitialFragment();
                break;
            }
            case CTInAppTypeCover: {
                viewFragment = new CTInAppNativeCoverFragment();
                break;
            }
            case CTInAppTypeInterstitial: {
                viewFragment = new CTInAppNativeInterstitialFragment();
                break;
            }
            case CTInAppTypeHalfInterstitial: {
                viewFragment = new CTInAppNativeHalfInterstitialFragment();
                break;
            }
            case CTInAppTypeCoverImageOnly: {
                viewFragment = new CTInAppNativeCoverImageFragment();
                break;
            }
            case CTInAppTypeInterstitialImageOnly: {
                viewFragment = new CTInAppNativeInterstitialImageFragment();
                break;
            }
            case CTInAppTypeHalfInterstitialImageOnly: {
                viewFragment = new CTInAppNativeHalfInterstitialImageFragment();
                break;
            }
            case CTInAppTypeAlert: {
                this.showAlertDialogForInApp();
                break;
            }
            default: {
                this.config.getLogger().verbose("InAppNotificationActivity: Unhandled InApp Type: " + (Object)((Object)type));
            }
        }
        return viewFragment;
    }

    private String getFragmentTag() {
        return this.config.getAccountId() + ":CT_INAPP_CONTENT_FRAGMENT";
    }

    private void showAlertDialogForInApp() {
        CTInAppNotificationButton negativeButton;
        AlertDialog alertDialog;
        ArrayList<CTInAppNotificationButton> buttons = this.inAppNotification.getButtons();
        if (buttons.isEmpty()) {
            this.config.getLogger().debug("InAppNotificationActivity: Notification has no buttons, not showing Alert InApp");
            return;
        }
        CTInAppNotificationButton positiveButton = buttons.get(0);
        if (Build.VERSION.SDK_INT >= 21) {
            alertDialog = new AlertDialog.Builder((Context)this, 16974394).setCancelable(false).setTitle((CharSequence)this.inAppNotification.getTitle()).setMessage((CharSequence)this.inAppNotification.getMessage()).setPositiveButton((CharSequence)positiveButton.getText(), (dialogInterface, i) -> this.onAlertButtonClick(positiveButton, true)).create();
            if (this.inAppNotification.getButtons().size() == 2) {
                negativeButton = buttons.get(1);
                alertDialog.setButton(-2, (CharSequence)negativeButton.getText(), (dialog, which) -> this.onAlertButtonClick(negativeButton, false));
            }
        } else {
            alertDialog = new AlertDialog.Builder((Context)this).setCancelable(false).setTitle((CharSequence)this.inAppNotification.getTitle()).setMessage((CharSequence)this.inAppNotification.getMessage()).setPositiveButton((CharSequence)positiveButton.getText(), (dialogInterface, i) -> this.onAlertButtonClickLegacy(positiveButton)).create();
            if (this.inAppNotification.getButtons().size() == 2) {
                negativeButton = buttons.get(1);
                alertDialog.setButton(-2, (CharSequence)negativeButton.getText(), (dialog, which) -> this.onAlertButtonClickLegacy(negativeButton));
            }
        }
        if (buttons.size() > 2) {
            CTInAppNotificationButton button = buttons.get(2);
            alertDialog.setButton(-3, (CharSequence)button.getText(), (dialogInterface, i) -> this.onAlertButtonClickLegacy(button));
        }
        alertDialog.show();
        isAlertVisible = true;
        this.didShow(null);
    }

    private void onAlertButtonClickLegacy(CTInAppNotificationButton button) {
        Bundle clickData = this.didClick(button);
        this.didDismiss(clickData);
    }

    private void onAlertButtonClick(CTInAppNotificationButton button, boolean isPositive) {
        Bundle clickData = this.didClick(button);
        if (isPositive && this.inAppNotification.isLocalInApp()) {
            this.showHardPermissionPrompt(this.inAppNotification.fallBackToNotificationSettings());
            return;
        }
        CTInAppAction action = button.getAction();
        if (action != null && InAppActionType.REQUEST_FOR_PERMISSIONS == action.getType()) {
            this.showHardPermissionPrompt(action.shouldFallbackToSettings());
            return;
        }
        this.didDismiss(clickData);
    }

    public static interface PushPermissionResultCallback {
        public void onPushPermissionAccept();

        public void onPushPermissionDeny();
    }
}

