/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network.api;

import android.net.Uri;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.network.api.DefineTemplatesRequestBody;
import com.clevertap.android.sdk.network.api.SendQueueRequestBody;
import com.clevertap.android.sdk.network.http.CtHttpClient;
import com.clevertap.android.sdk.network.http.Request;
import com.clevertap.android.sdk.network.http.Response;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 =2\u00020\u0001:\u0001=Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0011J*\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u000e\u0010/\u001a\u0002002\u0006\u0010+\u001a\u000201J\u000e\u00102\u001a\u0002002\u0006\u0010+\u001a\u000203J\u0010\u00104\u001a\u0004\u0018\u00010\u00052\u0006\u0010,\u001a\u00020-J \u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u000e\u00108\u001a\u0002002\u0006\u0010,\u001a\u00020-J\u0016\u00109\u001a\u0002002\u0006\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u000203J\f\u0010:\u001a\u00020;*\u00020;H\u0002J\f\u0010<\u001a\u00020;*\u00020;H\u0002R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001eR\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0018\"\u0004\b\"\u0010\u001eR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0018\"\u0004\b$\u0010\u001eR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0018\"\u0004\b&\u0010\u001eR\u000e\u0010'\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/clevertap/android/sdk/network/api/CtApi;", "", "httpClient", "Lcom/clevertap/android/sdk/network/http/CtHttpClient;", "defaultDomain", "", "domain", "spikyDomain", "region", "proxyDomain", "spikyProxyDomain", "accountId", "accountToken", "sdkVersion", "logger", "Lcom/clevertap/android/sdk/Logger;", "logTag", "(Lcom/clevertap/android/sdk/network/http/CtHttpClient;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/clevertap/android/sdk/Logger;Ljava/lang/String;)V", "<set-?>", "", "currentRequestTimestampSeconds", "getCurrentRequestTimestampSeconds", "()I", "getDefaultDomain", "()Ljava/lang/String;", "defaultHeaders", "", "defaultQueryParams", "getDomain", "setDomain", "(Ljava/lang/String;)V", "getProxyDomain", "setProxyDomain", "getRegion", "setRegion", "getSpikyDomain", "setSpikyDomain", "getSpikyProxyDomain", "setSpikyProxyDomain", "spikyRegionSuffix", "createRequest", "Lcom/clevertap/android/sdk/network/http/Request;", "relativePath", "body", "useSpikyDomain", "", "includeTs", "defineTemplates", "Lcom/clevertap/android/sdk/network/http/Response;", "Lcom/clevertap/android/sdk/network/api/DefineTemplatesRequestBody;", "defineVars", "Lcom/clevertap/android/sdk/network/api/SendQueueRequestBody;", "getActualDomain", "getUriForPath", "Landroid/net/Uri;", "path", "performHandshakeForDomain", "sendQueue", "appendDefaultQueryParams", "Landroid/net/Uri$Builder;", "appendTsQueryParam", "Companion", "clevertap-core_release"})
public final class CtApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CtHttpClient httpClient;
    @NotNull
    private final String defaultDomain;
    @Nullable
    private String domain;
    @Nullable
    private String spikyDomain;
    @Nullable
    private String region;
    @Nullable
    private String proxyDomain;
    @Nullable
    private String spikyProxyDomain;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String logTag;
    @NotNull
    private final Map<String, String> defaultHeaders;
    @NotNull
    private final Map<String, String> defaultQueryParams;
    @NotNull
    private final String spikyRegionSuffix;
    private int currentRequestTimestampSeconds;
    @NotNull
    public static final String DEFAULT_CONTENT_TYPE = "application/json; charset=utf-8";
    @NotNull
    public static final String DEFAULT_QUERY_PARAM_OS = "Android";

    public CtApi(@NotNull CtHttpClient httpClient, @NotNull String defaultDomain, @Nullable String domain, @Nullable String spikyDomain, @Nullable String region, @Nullable String proxyDomain, @Nullable String spikyProxyDomain, @NotNull String accountId, @NotNull String accountToken, @NotNull String sdkVersion, @NotNull Logger logger, @NotNull String logTag) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)defaultDomain, (String)"defaultDomain");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)accountToken, (String)"accountToken");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        this.httpClient = httpClient;
        this.defaultDomain = defaultDomain;
        this.domain = domain;
        this.spikyDomain = spikyDomain;
        this.region = region;
        this.proxyDomain = proxyDomain;
        this.spikyProxyDomain = spikyProxyDomain;
        this.logger = logger;
        this.logTag = logTag;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)DEFAULT_CONTENT_TYPE), TuplesKt.to((Object)"X-CleverTap-Account-ID", (Object)accountId), TuplesKt.to((Object)"X-CleverTap-Token", (Object)accountToken)};
        this.defaultHeaders = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"os", (Object)DEFAULT_QUERY_PARAM_OS), TuplesKt.to((Object)"t", (Object)sdkVersion), TuplesKt.to((Object)"z", (Object)accountId)};
        this.defaultQueryParams = MapsKt.mapOf((Pair[])pairArray);
        this.spikyRegionSuffix = "-spiky";
    }

    @NotNull
    public final String getDefaultDomain() {
        return this.defaultDomain;
    }

    @Nullable
    public final String getDomain() {
        return this.domain;
    }

    public final void setDomain(@Nullable String string2) {
        this.domain = string2;
    }

    @Nullable
    public final String getSpikyDomain() {
        return this.spikyDomain;
    }

    public final void setSpikyDomain(@Nullable String string2) {
        this.spikyDomain = string2;
    }

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    public final void setRegion(@Nullable String string2) {
        this.region = string2;
    }

    @Nullable
    public final String getProxyDomain() {
        return this.proxyDomain;
    }

    public final void setProxyDomain(@Nullable String string2) {
        this.proxyDomain = string2;
    }

    @Nullable
    public final String getSpikyProxyDomain() {
        return this.spikyProxyDomain;
    }

    public final void setSpikyProxyDomain(@Nullable String string2) {
        this.spikyProxyDomain = string2;
    }

    public final int getCurrentRequestTimestampSeconds() {
        return this.currentRequestTimestampSeconds;
    }

    @NotNull
    public final Response sendQueue(boolean useSpikyDomain, @NotNull SendQueueRequestBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.httpClient.execute(this.createRequest("a1", body.toString(), useSpikyDomain, true));
    }

    @NotNull
    public final Response performHandshakeForDomain(boolean useSpikyDomain) {
        Request request = this.createRequest("hello", null, useSpikyDomain, false);
        this.logger.verbose(this.logTag, "Performing handshake with " + request.getUrl());
        return this.httpClient.execute(request);
    }

    @NotNull
    public final Response defineVars(@NotNull SendQueueRequestBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.httpClient.execute(this.createRequest("defineVars", body.toString(), false, true));
    }

    @NotNull
    public final Response defineTemplates(@NotNull DefineTemplatesRequestBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.httpClient.execute(this.createRequest("defineTemplates", body.toString(), false, true));
    }

    @Nullable
    public final String getActualDomain(boolean useSpikyDomain) {
        String string2;
        CharSequence charSequence = this.region;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String regionSuffix = useSpikyDomain ? this.spikyRegionSuffix : "";
            string2 = this.region + regionSuffix + '.' + this.defaultDomain;
        } else {
            string2 = !useSpikyDomain && !((charSequence = (CharSequence)this.proxyDomain) == null || StringsKt.isBlank((CharSequence)charSequence)) ? this.proxyDomain : (useSpikyDomain && !((charSequence = (CharSequence)this.spikyProxyDomain) == null || StringsKt.isBlank((CharSequence)charSequence)) ? this.spikyProxyDomain : (useSpikyDomain ? this.spikyDomain : this.domain));
        }
        return string2;
    }

    private final Request createRequest(String relativePath, String body, boolean useSpikyDomain, boolean includeTs) {
        return new Request(this.getUriForPath(relativePath, useSpikyDomain, includeTs), this.defaultHeaders, body);
    }

    private final Uri getUriForPath(String path, boolean useSpikyDomain, boolean includeTs) {
        Uri.Builder builder = new Uri.Builder().scheme("https");
        String string2 = this.getActualDomain(useSpikyDomain);
        if (string2 == null) {
            string2 = this.defaultDomain;
        }
        Uri.Builder builder2 = builder.authority(string2).appendPath(path);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"Builder()\n            .s\u2026        .appendPath(path)");
        Uri.Builder builder3 = this.appendDefaultQueryParams(builder2);
        if (includeTs) {
            this.appendTsQueryParam(builder3);
        }
        Uri uri = builder3.build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"builder.build()");
        return uri;
    }

    private final Uri.Builder appendDefaultQueryParams(Uri.Builder $this$appendDefaultQueryParams) {
        for (Map.Entry<String, String> queryParam : this.defaultQueryParams.entrySet()) {
            $this$appendDefaultQueryParams.appendQueryParameter(queryParam.getKey(), queryParam.getValue());
        }
        return $this$appendDefaultQueryParams;
    }

    private final Uri.Builder appendTsQueryParam(Uri.Builder $this$appendTsQueryParam) {
        this.currentRequestTimestampSeconds = (int)(System.currentTimeMillis() / (long)1000);
        Uri.Builder builder = $this$appendTsQueryParam.appendQueryParameter("ts", String.valueOf(this.currentRequestTimestampSeconds));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"appendQueryParameter(\"ts\u2026estampSeconds.toString())");
        return builder;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/network/api/CtApi$Companion;", "", "()V", "DEFAULT_CONTENT_TYPE", "", "DEFAULT_QUERY_PARAM_OS", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

