/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification.fcm;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.CountDownTimer;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.interfaces.NotificationRenderedListener;
import com.clevertap.android.sdk.pushnotification.NotificationInfo;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.pushnotification.fcm.FcmNotificationParser;
import com.google.firebase.messaging.RemoteMessage;
import java.util.concurrent.TimeUnit;

public class CTFirebaseMessagingReceiver
extends BroadcastReceiver
implements NotificationRenderedListener {
    private CountDownTimer countDownTimer;
    private String key = "";
    private boolean isPRFinished;
    private BroadcastReceiver.PendingResult pendingResult;
    private static final String TAG = "CTRM";
    private long start;

    @Override
    @SuppressLint(value={"RestrictedApi"})
    public void onNotificationRendered(boolean isRendered) {
        Logger.v(TAG, "push impression sent successfully by core, i should inform OS to kill receiver. my callback key is " + this.key);
        this.finishReceiverAndCancelTimer("push impression sent successfully by core");
    }

    private void finishReceiverAndCancelTimer(String from) {
        try {
            Logger.v(TAG, "got a signal to kill receiver and timer because " + from);
            if (!this.key.trim().isEmpty()) {
                CleverTapAPI.removeNotificationRenderedListener(this.key);
            }
            long end = System.nanoTime();
            if (this.pendingResult != null && !this.isPRFinished) {
                Logger.v(TAG, "informing OS to kill receiver...");
                this.pendingResult.finish();
                this.isPRFinished = true;
                if (this.countDownTimer != null) {
                    this.countDownTimer.cancel();
                }
                Logger.v(TAG, "informed OS to kill receiver...");
                Logger.v(TAG, "receiver was alive for " + TimeUnit.NANOSECONDS.toSeconds(end - this.start) + " seconds");
            } else {
                Logger.v(TAG, "have already informed OS to kill receiver, can not inform again else OS will get angry :-O");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public void onReceive(Context context, Intent intent) {
        this.start = System.nanoTime();
        Logger.d(TAG, "received a message from Firebase");
        if (context == null || intent == null) {
            return;
        }
        RemoteMessage remoteMessage = new RemoteMessage(intent.getExtras());
        Bundle messageBundle = new FcmNotificationParser().toBundle(remoteMessage);
        if (messageBundle == null) {
            return;
        }
        if (remoteMessage.getPriority() != 2) {
            Logger.d(TAG, "returning from CTRM because message priority is not normal");
            return;
        }
        long receiverLifeSpan = Long.parseLong(messageBundle.getString("ctrmt", "4500"));
        this.pendingResult = this.goAsync();
        NotificationInfo notificationInfo = CleverTapAPI.getNotificationInfo(messageBundle);
        if (notificationInfo.fromCleverTap) {
            boolean isRenderFallback = Utils.isRenderFallback(remoteMessage, context);
            if (isRenderFallback) {
                this.key = PushNotificationUtil.buildPushNotificationRenderedListenerKey(PushNotificationUtil.getAccountIdFromNotificationBundle(messageBundle), PushNotificationUtil.getPushIdFromNotificationBundle(messageBundle));
                CleverTapAPI.addNotificationRenderedListener(this.key, this);
                this.countDownTimer = new CountDownTimer(receiverLifeSpan, 1000L){

                    public void onFinish() {
                        CTFirebaseMessagingReceiver.this.finishReceiverAndCancelTimer("receiver life time is expired");
                    }

                    public void onTick(long millisUntilFinished) {
                    }
                };
                this.countDownTimer.start();
                new Thread(() -> {
                    try {
                        CleverTapAPI cleverTapAPI = CleverTapAPI.getGlobalInstance(context, PushNotificationUtil.getAccountIdFromNotificationBundle(messageBundle));
                        if (cleverTapAPI != null) {
                            CTXtensions.flushPushImpressionsOnPostAsyncSafely(cleverTapAPI, "CTRM#flushQueueSync", "PI_R", context);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Logger.v(TAG, "Failed executing CTRM flushQueueSync thread.", e);
                    }
                    finally {
                        this.finishReceiverAndCancelTimer("flush from receiver is done!");
                    }
                }).start();
            } else {
                Logger.v(TAG, "Notification payload does not have a fallback key.");
                this.finishReceiverAndCancelTimer("isRenderFallback is false");
            }
        } else {
            Logger.v(TAG, "Notification payload is not from CleverTap.");
            this.finishReceiverAndCancelTimer("push is not from CleverTap.");
        }
    }
}

