/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp.images;

import android.content.Context;
import android.graphics.Bitmap;
import com.clevertap.android.sdk.ILogger;
import com.clevertap.android.sdk.inapp.images.InAppImageFetchApi;
import com.clevertap.android.sdk.inapp.images.InAppImageFetchApiContract;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.utils.CTCaches;
import com.clevertap.android.sdk.utils.FileCache;
import com.clevertap.android.sdk.utils.LruCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0087\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012'\b\u0002\u0010\f\u001a!\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\r\u0012'\b\u0002\u0010\u0012\u001a!\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00130\r\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\u0019J\u0010\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020\u0019J)\u0010 \u001a\u0004\u0018\u0001H!\"\u0004\b\u0000\u0010!2\u0006\u0010\u001f\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u0019J\u000e\u0010'\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u0019J\u0016\u0010(\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0013J\u001e\u0010*\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\f\u001a!\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0012\u001a!\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00130\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/clevertap/android/sdk/inapp/images/InAppResourceProvider;", "", "context", "Landroid/content/Context;", "logger", "Lcom/clevertap/android/sdk/ILogger;", "(Landroid/content/Context;Lcom/clevertap/android/sdk/ILogger;)V", "images", "Ljava/io/File;", "gifs", "ctCaches", "Lcom/clevertap/android/sdk/utils/CTCaches;", "fileToBitmap", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "file", "Landroid/graphics/Bitmap;", "fileToBytes", "", "inAppRemoteSource", "Lcom/clevertap/android/sdk/inapp/images/InAppImageFetchApiContract;", "(Ljava/io/File;Ljava/io/File;Lcom/clevertap/android/sdk/ILogger;Lcom/clevertap/android/sdk/utils/CTCaches;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/clevertap/android/sdk/inapp/images/InAppImageFetchApiContract;)V", "cachedGif", "cacheKey", "", "cachedImage", "deleteGif", "", "deleteImage", "fetchInAppGif", "url", "fetchInAppImage", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "isGifCached", "", "isImageCached", "saveGif", "bytes", "saveImage", "bitmap", "Companion", "clevertap-core_release"})
public final class InAppResourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File images;
    @NotNull
    private final File gifs;
    @Nullable
    private final ILogger logger;
    @NotNull
    private final CTCaches ctCaches;
    @NotNull
    private final Function1<File, Bitmap> fileToBitmap;
    @NotNull
    private final Function1<File, byte[]> fileToBytes;
    @NotNull
    private final InAppImageFetchApiContract inAppRemoteSource;
    @NotNull
    private static final String IMAGE_DIRECTORY_NAME = "CleverTap.Images.";
    @NotNull
    private static final String GIF_DIRECTORY_NAME = "CleverTap.Gif.";

    public InAppResourceProvider(@NotNull File images, @NotNull File gifs, @Nullable ILogger logger, @NotNull CTCaches ctCaches, @NotNull Function1<? super File, Bitmap> fileToBitmap, @NotNull Function1<? super File, byte[]> fileToBytes, @NotNull InAppImageFetchApiContract inAppRemoteSource) {
        Intrinsics.checkNotNullParameter((Object)images, (String)"images");
        Intrinsics.checkNotNullParameter((Object)gifs, (String)"gifs");
        Intrinsics.checkNotNullParameter((Object)ctCaches, (String)"ctCaches");
        Intrinsics.checkNotNullParameter(fileToBitmap, (String)"fileToBitmap");
        Intrinsics.checkNotNullParameter(fileToBytes, (String)"fileToBytes");
        Intrinsics.checkNotNullParameter((Object)inAppRemoteSource, (String)"inAppRemoteSource");
        this.images = images;
        this.gifs = gifs;
        this.logger = logger;
        this.ctCaches = ctCaches;
        this.fileToBitmap = fileToBitmap;
        this.fileToBytes = fileToBytes;
        this.inAppRemoteSource = inAppRemoteSource;
    }

    public /* synthetic */ InAppResourceProvider(File file, File file2, ILogger iLogger, CTCaches cTCaches, Function1 function1, Function1 function12, InAppImageFetchApiContract inAppImageFetchApiContract, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            iLogger = null;
        }
        if ((n & 8) != 0) {
            cTCaches = CTCaches.Companion.instance$default(CTCaches.Companion, null, iLogger, 1, null);
        }
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function12 = 2.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            inAppImageFetchApiContract = new InAppImageFetchApi();
        }
        this(file, file2, iLogger, cTCaches, (Function1<? super File, Bitmap>)function1, (Function1<? super File, byte[]>)function12, inAppImageFetchApiContract);
    }

    public InAppResourceProvider(@NotNull Context context, @Nullable ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = context.getDir(IMAGE_DIRECTORY_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.getDir(IMAGE_DIR\u2026ME, Context.MODE_PRIVATE)");
        File file2 = context.getDir(GIF_DIRECTORY_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"context.getDir(GIF_DIREC\u2026ME, Context.MODE_PRIVATE)");
        this(file, file2, logger, CTCaches.Companion.instance$default(CTCaches.Companion, null, logger, 1, null), null, null, null, 112, null);
    }

    public /* synthetic */ InAppResourceProvider(Context context, ILogger iLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iLogger = null;
        }
        this(context, iLogger);
    }

    public final void saveImage(@NotNull String cacheKey, @NotNull Bitmap bitmap, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        LruCache<Bitmap> imageMemoryCache = this.ctCaches.imageCache();
        imageMemoryCache.add(cacheKey, bitmap);
        FileCache imageDiskCache = this.ctCaches.imageCacheDisk(this.images);
        imageDiskCache.add(cacheKey, bytes);
    }

    public final void saveGif(@NotNull String cacheKey, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        LruCache<byte[]> gifMemoryCache = this.ctCaches.gifCache();
        gifMemoryCache.add(cacheKey, bytes);
        FileCache gifDiskCache = this.ctCaches.gifCacheDisk(this.gifs);
        gifDiskCache.add(cacheKey, bytes);
    }

    public final boolean isImageCached(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        LruCache<Bitmap> imageMemoryCache = this.ctCaches.imageCache();
        if (imageMemoryCache.get(url) != null) {
            return true;
        }
        FileCache imageDiskCache = this.ctCaches.imageCacheDisk(this.images);
        File file = imageDiskCache.get(url);
        return file != null;
    }

    public final boolean isGifCached(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        LruCache<byte[]> gifMemoryCache = this.ctCaches.gifCache();
        if (gifMemoryCache.get(url) != null) {
            return true;
        }
        FileCache gifDiskCache = this.ctCaches.gifCacheDisk(this.images);
        File file = gifDiskCache.get(url);
        return file != null;
    }

    @Nullable
    public final Bitmap cachedImage(@Nullable String cacheKey) {
        Bitmap bitmapFromFile;
        block4: {
            if (cacheKey == null) {
                ILogger iLogger = this.logger;
                if (iLogger != null) {
                    iLogger.verbose("Bitmap for null key requested");
                }
                return null;
            }
            LruCache<Bitmap> imageMemoryCache = this.ctCaches.imageCache();
            Bitmap bitmap = imageMemoryCache.get(cacheKey);
            if (bitmap != null) {
                return bitmap;
            }
            FileCache imageDiskCache = this.ctCaches.imageCacheDisk(this.images);
            File file = imageDiskCache.get(cacheKey);
            bitmapFromFile = (Bitmap)this.fileToBitmap.invoke((Object)file);
            if (bitmapFromFile == null) break block4;
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("returning cached image for url : " + cacheKey);
            }
        }
        return bitmapFromFile;
    }

    @Nullable
    public final byte[] cachedGif(@Nullable String cacheKey) {
        if (cacheKey == null) {
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("GIF for null key requested");
            }
            return null;
        }
        LruCache<byte[]> gifMemoryCache = this.ctCaches.gifCache();
        byte[] gifStream = gifMemoryCache.get(cacheKey);
        if (gifStream != null) {
            return gifStream;
        }
        FileCache gifDiskCache = this.ctCaches.gifCacheDisk(this.gifs);
        return (byte[])this.fileToBytes.invoke((Object)gifDiskCache.get(cacheKey));
    }

    @Nullable
    public final Bitmap fetchInAppImage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.fetchInAppImage(url, Bitmap.class);
    }

    @Nullable
    public final <T> T fetchInAppImage(@NotNull String url, @NotNull Class<T> clazz) {
        Object object;
        DownloadedBitmap downloadedBitmap;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Bitmap cachedImage = this.cachedImage(url);
        if (cachedImage != null) {
            if (clazz.isAssignableFrom(Bitmap.class)) {
                return (T)(cachedImage instanceof Object ? cachedImage : null);
            }
            if (clazz.isAssignableFrom(byte[].class)) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                cachedImage.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                byte[] byteArray = stream.toByteArray();
                return (T)((byte[])(byteArray instanceof Object ? byteArray : null));
            }
        }
        if (WhenMappings.$EnumSwitchMapping$0[(downloadedBitmap = this.inAppRemoteSource.makeApiCallForInAppBitmap(url)).getStatus().ordinal()] != 1) {
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("There was a problem fetching data for bitmap");
            }
            return null;
        }
        Bitmap bitmap = downloadedBitmap.getBitmap();
        Intrinsics.checkNotNull((Object)bitmap);
        byte[] byArray = downloadedBitmap.getBytes();
        Intrinsics.checkNotNull((Object)byArray);
        this.saveImage(url, bitmap, byArray);
        if (clazz.isAssignableFrom(Bitmap.class)) {
            object = downloadedBitmap.getBitmap();
            if (object == null) {
                object = null;
            }
        } else if (clazz.isAssignableFrom(byte[].class)) {
            byte[] byArray2 = downloadedBitmap.getBytes();
            object = byArray2;
            if (byArray2 == null) {
                object = null;
            }
        } else {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public final byte[] fetchInAppGif(@NotNull String url) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        byte[] cachedGif = this.cachedGif(url);
        if (cachedGif != null) {
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("Returning requested " + url + " gif from cache with size " + cachedGif.length);
            }
            return cachedGif;
        }
        DownloadedBitmap downloadedGif = this.inAppRemoteSource.makeApiCallForInAppBitmap(url);
        if (WhenMappings.$EnumSwitchMapping$0[downloadedGif.getStatus().ordinal()] == 1) {
            byte[] byArray2 = downloadedGif.getBytes();
            Intrinsics.checkNotNull((Object)byArray2);
            this.saveGif(url, byArray2);
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("Returning requested " + url + " gif with network, saved in cache");
            }
            byArray = downloadedGif.getBytes();
        } else {
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("There was a problem fetching data for bitmap, status:" + (Object)((Object)downloadedGif.getStatus()));
            }
            byArray = null;
        }
        return byArray;
    }

    public final void deleteImage(@NotNull String cacheKey) {
        block3: {
            FileCache imageDiskCache;
            boolean b;
            Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
            LruCache<Bitmap> imageMemoryCache = this.ctCaches.imageCache();
            Bitmap bitmap = imageMemoryCache.remove(cacheKey);
            if (bitmap != null) {
                ILogger iLogger = this.logger;
                if (iLogger != null) {
                    iLogger.verbose("successfully removed " + cacheKey + " from memory cache");
                }
            }
            if (!(b = (imageDiskCache = this.ctCaches.imageCacheDisk(this.images)).remove(cacheKey))) break block3;
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("successfully removed " + cacheKey + " from file cache");
            }
        }
    }

    public final void deleteGif(@NotNull String cacheKey) {
        block3: {
            FileCache imageDiskCache;
            boolean b;
            Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
            LruCache<byte[]> imageMemoryCache = this.ctCaches.gifCache();
            byte[] bytes = imageMemoryCache.remove(cacheKey);
            if (bytes != null) {
                ILogger iLogger = this.logger;
                if (iLogger != null) {
                    iLogger.verbose("successfully removed gif " + cacheKey + " from memory cache");
                }
            }
            if (!(b = (imageDiskCache = this.ctCaches.gifCacheDisk(this.gifs)).remove(cacheKey))) break block3;
            ILogger iLogger = this.logger;
            if (iLogger != null) {
                iLogger.verbose("successfully removed gif " + cacheKey + " from file cache");
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/clevertap/android/sdk/inapp/images/InAppResourceProvider$Companion;", "", "()V", "GIF_DIRECTORY_NAME", "", "IMAGE_DIRECTORY_NAME", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DownloadedBitmap.Status.values().length];
            try {
                nArray[DownloadedBitmap.Status.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

