/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.CTWebInterface;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.customviews.CloseImageView;
import com.clevertap.android.sdk.inapp.CTInAppBaseFullFragment;
import com.clevertap.android.sdk.inapp.CTInAppWebView;
import com.clevertap.android.sdk.utils.UriHelper;
import java.net.URLDecoder;

public abstract class CTInAppBaseFullHtmlFragment
extends CTInAppBaseFullFragment {
    protected CTInAppWebView webView;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        return this.displayHTMLView(inflater, container);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.reDrawInApp();
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.reDrawInApp();
    }

    protected RelativeLayout.LayoutParams getLayoutParamsForCloseButton() {
        RelativeLayout.LayoutParams closeIvLp = new RelativeLayout.LayoutParams(-1, -1);
        closeIvLp.addRule(2, this.webView.getId());
        closeIvLp.addRule(1, this.webView.getId());
        int sub = this.getScaledPixels(40) / 2;
        closeIvLp.setMargins(-sub, 0, 0, -sub);
        return closeIvLp;
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private View displayHTMLView(LayoutInflater inflater, ViewGroup container) {
        View inAppView;
        try {
            inAppView = inflater.inflate(R.layout.inapp_html_full, container, false);
            RelativeLayout rl = (RelativeLayout)inAppView.findViewById(R.id.inapp_html_full_relative_layout);
            RelativeLayout.LayoutParams webViewLp = new RelativeLayout.LayoutParams(-2, -2);
            webViewLp.addRule(13);
            this.initWebViewLayoutParams(webViewLp);
            this.webView = new CTInAppWebView(this.context, this.inAppNotification.getWidth(), this.inAppNotification.getHeight(), this.inAppNotification.getWidthPercentage(), this.inAppNotification.getHeightPercentage());
            InAppWebViewClient webViewClient = new InAppWebViewClient();
            this.webView.setWebViewClient(webViewClient);
            if (this.inAppNotification.isJsEnabled()) {
                this.webView.getSettings().setJavaScriptEnabled(true);
                this.webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(false);
                this.webView.getSettings().setAllowContentAccess(false);
                this.webView.getSettings().setAllowFileAccess(false);
                this.webView.getSettings().setAllowFileAccessFromFileURLs(false);
                this.webView.addJavascriptInterface(new CTWebInterface(CleverTapAPI.instanceWithConfig((Context)this.getActivity(), this.config), this), "CleverTap");
            }
            if (this.isDarkenEnabled()) {
                rl.setBackground((Drawable)new ColorDrawable(-1157627904));
            } else {
                rl.setBackground((Drawable)new ColorDrawable(0));
            }
            rl.addView((View)this.webView, (ViewGroup.LayoutParams)webViewLp);
            if (this.isCloseButtonEnabled()) {
                this.closeImageView = new CloseImageView(this.context);
                RelativeLayout.LayoutParams closeIvLp = this.getLayoutParamsForCloseButton();
                this.closeImageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CTInAppBaseFullHtmlFragment.this.didDismiss(null);
                    }
                });
                rl.addView((View)this.closeImageView, (ViewGroup.LayoutParams)closeIvLp);
            }
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Fragment view not created", t);
            return null;
        }
        return inAppView;
    }

    private void initWebViewLayoutParams(RelativeLayout.LayoutParams params) {
        char pos = this.inAppNotification.getPosition();
        switch (pos) {
            case 't': {
                params.addRule(10);
                break;
            }
            case 'l': {
                params.addRule(9);
                break;
            }
            case 'b': {
                params.addRule(12);
                break;
            }
            case 'r': {
                params.addRule(11);
                break;
            }
            case 'c': {
                params.addRule(13);
            }
        }
        params.setMargins(0, 0, 0, 0);
    }

    private boolean isCloseButtonEnabled() {
        return this.inAppNotification.isShowClose();
    }

    private boolean isDarkenEnabled() {
        return this.inAppNotification.isDarkenScreen();
    }

    private void reDrawInApp() {
        this.webView.updateDimension();
        if (this.inAppNotification.getCustomInAppUrl().isEmpty()) {
            int mHeight = this.webView.dim.y;
            int mWidth = this.webView.dim.x;
            float d = this.getResources().getDisplayMetrics().density;
            mHeight = (int)((float)mHeight / d);
            mWidth = (int)((float)mWidth / d);
            String html = this.inAppNotification.getHtml();
            String style2 = "<style>body{width:" + mWidth + "px; height: " + mHeight + "px; margin: 0; padding:0;}</style>";
            html = html.replaceFirst("<head>", "<head>" + style2);
            Logger.v("Density appears to be " + d);
            this.webView.setInitialScale((int)(d * 100.0f));
            this.webView.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
        } else {
            String url = this.inAppNotification.getCustomInAppUrl();
            this.webView.setWebViewClient(new WebViewClient());
            this.webView.loadUrl(url);
        }
    }

    private class InAppWebViewClient
    extends WebViewClient {
        InAppWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            try {
                String[] parts;
                String c2a;
                Bundle formData = UriHelper.getAllKeyValuePairs(url, false);
                if (formData.containsKey("wzrk_c2a") && (c2a = formData.getString("wzrk_c2a")) != null && (parts = c2a.split("__dl__")).length == 2) {
                    formData.putString("wzrk_c2a", URLDecoder.decode(parts[0], "UTF-8"));
                    url = parts[1];
                }
                CTInAppBaseFullHtmlFragment.this.didClick(formData, null);
                Logger.d("Executing call to action for in-app: " + url);
                CTInAppBaseFullHtmlFragment.this.fireUrlThroughIntent(url, formData);
            }
            catch (Throwable t) {
                Logger.v("Error parsing the in-app notification action!", t);
            }
            return true;
        }
    }
}

