/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.task;

import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.task.IOExecutor;
import com.clevertap.android.sdk.task.MainThreadExecutor;
import com.clevertap.android.sdk.task.PostAsyncSafelyExecutor;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.UrlHashGenerator;
import java.util.HashMap;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CTExecutors {
    public final IOExecutor IO_EXECUTOR;
    public final MainThreadExecutor MAIN_EXECUTOR;
    public final MainThreadExecutor DEFAULT_CALLBACK_EXECUTOR;
    protected final CleverTapInstanceConfig config;
    protected String singleThreadExecutorTag;
    private final HashMap<String, PostAsyncSafelyExecutor> postAsyncSafelyTasks;

    CTExecutors(CleverTapInstanceConfig config) {
        this.DEFAULT_CALLBACK_EXECUTOR = this.MAIN_EXECUTOR = new MainThreadExecutor();
        this.postAsyncSafelyTasks = new HashMap();
        this.config = config;
        this.IO_EXECUTOR = new IOExecutor();
    }

    CTExecutors(int ioPoolSize) {
        this.DEFAULT_CALLBACK_EXECUTOR = this.MAIN_EXECUTOR = new MainThreadExecutor();
        this.postAsyncSafelyTasks = new HashMap();
        this.config = null;
        this.IO_EXECUTOR = new IOExecutor(ioPoolSize);
        this.singleThreadExecutorTag = UrlHashGenerator.INSTANCE.hashWithTsSeed();
    }

    CTExecutors() {
        this.DEFAULT_CALLBACK_EXECUTOR = this.MAIN_EXECUTOR = new MainThreadExecutor();
        this.postAsyncSafelyTasks = new HashMap();
        this.config = null;
        this.IO_EXECUTOR = new IOExecutor();
        this.singleThreadExecutorTag = UrlHashGenerator.INSTANCE.hashWithTsSeed();
    }

    public <TResult> Task<TResult> ioTask() {
        return this.taskOnExecutorWithName(this.IO_EXECUTOR, this.DEFAULT_CALLBACK_EXECUTOR, "ioTask");
    }

    public <TResult> Task<TResult> ioTaskNonUi() {
        return this.taskOnExecutorWithName(this.IO_EXECUTOR, this.IO_EXECUTOR, "ioTaskNonUi");
    }

    public <TResult> Task<TResult> mainTask() {
        return this.taskOnExecutorWithName(this.MAIN_EXECUTOR, this.DEFAULT_CALLBACK_EXECUTOR, "Main");
    }

    public <TResult> Task<TResult> postAsyncSafelyTask(String featureTag) {
        if (featureTag == null) {
            throw new IllegalArgumentException("Tag can't be null");
        }
        PostAsyncSafelyExecutor postAsyncSafelyExecutor = this.postAsyncSafelyTasks.get(featureTag);
        if (postAsyncSafelyExecutor == null) {
            postAsyncSafelyExecutor = new PostAsyncSafelyExecutor();
            this.postAsyncSafelyTasks.put(featureTag, postAsyncSafelyExecutor);
        }
        return this.taskOnExecutorWithName(postAsyncSafelyExecutor, this.DEFAULT_CALLBACK_EXECUTOR, "PostAsyncSafely");
    }

    public <TResult> Task<TResult> postAsyncSafelyTask() {
        String key = this.config != null ? this.config.getAccountId() : this.singleThreadExecutorTag;
        return this.postAsyncSafelyTask(key);
    }

    public <TResult> Task<TResult> taskOnExecutor(Executor taskExecutor, String taskName) {
        return this.taskOnExecutorWithName(taskExecutor, this.DEFAULT_CALLBACK_EXECUTOR, taskName);
    }

    public <TResult> Task<TResult> taskOnExecutorWithName(Executor taskExecutor, Executor callbackExecutor, String taskName) {
        if (taskExecutor == null || callbackExecutor == null) {
            throw new IllegalArgumentException("Can't create task " + taskName + " with null executors");
        }
        return new Task(this.config, taskExecutor, callbackExecutor, taskName);
    }
}

