/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.StorageHelper;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0005J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0005J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018J \u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u00030\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/clevertap/android/sdk/inapp/TriggerManager;", "", "context", "Landroid/content/Context;", "accountId", "", "deviceInfo", "Lcom/clevertap/android/sdk/DeviceInfo;", "(Landroid/content/Context;Ljava/lang/String;Lcom/clevertap/android/sdk/DeviceInfo;)V", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getContextRef", "()Ljava/lang/ref/WeakReference;", "setContextRef", "(Ljava/lang/ref/WeakReference;)V", "getTriggers", "", "campaignId", "getTriggersKey", "increment", "", "read", "prefs", "Landroid/content/SharedPreferences;", "storageKey", "removeTriggers", "sharedPrefs", "write", "triggerCount", "Companion", "clevertap-core_release"})
public final class TriggerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accountId;
    @NotNull
    private final DeviceInfo deviceInfo;
    @NotNull
    private WeakReference<Context> contextRef;
    @NotNull
    public static final String PREF_PREFIX = "__triggers";

    public TriggerManager(@NotNull Context context, @NotNull String accountId, @NotNull DeviceInfo deviceInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        this.accountId = accountId;
        this.deviceInfo = deviceInfo;
        this.contextRef = new WeakReference<Context>(context);
    }

    @NotNull
    public final WeakReference<Context> getContextRef() {
        return this.contextRef;
    }

    public final void setContextRef(@NotNull WeakReference<Context> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        this.contextRef = weakReference;
    }

    public final int getTriggers(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        SharedPreferences sharedPreferences = this.sharedPrefs();
        if (sharedPreferences == null) {
            return 0;
        }
        SharedPreferences prefs = sharedPreferences;
        return this.read(prefs, this.getTriggersKey(campaignId));
    }

    public final void increment(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        SharedPreferences sharedPreferences = this.sharedPrefs();
        if (sharedPreferences == null) {
            return;
        }
        SharedPreferences prefs = sharedPreferences;
        int savedTriggers = this.getTriggers(campaignId);
        this.write(prefs, this.getTriggersKey(campaignId), ++savedTriggers);
    }

    public final void removeTriggers(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        SharedPreferences sharedPreferences = this.sharedPrefs();
        if (sharedPreferences == null) {
            return;
        }
        SharedPreferences prefs = sharedPreferences;
        prefs.edit().remove(this.getTriggersKey(campaignId)).apply();
    }

    private final int read(SharedPreferences prefs, String storageKey) {
        return prefs.getInt(storageKey, 0);
    }

    private final void write(SharedPreferences prefs, String storageKey, int triggerCount) {
        prefs.edit().putInt(storageKey, triggerCount).apply();
    }

    @Nullable
    public final SharedPreferences sharedPrefs() {
        String prefName = "triggers_per_inapp:" + this.deviceInfo.getDeviceID() + ':' + this.accountId;
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return null;
        }
        Context context2 = context;
        return StorageHelper.getPreferences(context2, prefName);
    }

    @NotNull
    public final String getTriggersKey(@NotNull String campaignId) {
        Intrinsics.checkNotNullParameter((Object)campaignId, (String)"campaignId");
        return "__triggers_" + campaignId;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/clevertap/android/sdk/inapp/TriggerManager$Companion;", "", "()V", "PREF_PREFIX", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

