/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CTXtensions;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.cryption.CryptHandler;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.QueueCursor;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.interfaces.NotificationRenderedListener;
import com.clevertap.android.sdk.login.IdentityRepoFactory;
import com.clevertap.android.sdk.network.BaseNetworkManager;
import com.clevertap.android.sdk.network.EndpointId;
import com.clevertap.android.sdk.network.NetworkHeadersListener;
import com.clevertap.android.sdk.network.SSLContextBuilder;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.response.ARPResponse;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.ConsoleResponse;
import com.clevertap.android.sdk.response.DisplayUnitResponse;
import com.clevertap.android.sdk.response.FeatureFlagResponse;
import com.clevertap.android.sdk.response.FetchVariablesResponse;
import com.clevertap.android.sdk.response.GeofenceResponse;
import com.clevertap.android.sdk.response.InAppResponse;
import com.clevertap.android.sdk.response.InboxResponse;
import com.clevertap.android.sdk.response.MetadataResponse;
import com.clevertap.android.sdk.response.ProductConfigResponse;
import com.clevertap.android.sdk.response.PushAmpResponse;
import com.clevertap.android.sdk.response.SyncUpstreamResponse;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import com.clevertap.android.sdk.validation.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class NetworkManager
extends BaseNetworkManager {
    private static SSLSocketFactory sslSocketFactory;
    private static SSLContext sslContext;
    private final BaseCallbackManager callbackManager;
    private final List<CleverTapResponse> cleverTapResponses = new ArrayList<CleverTapResponse>();
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private int currentRequestTimestamp = 0;
    private final BaseDatabaseManager databaseManager;
    private final DeviceInfo deviceInfo;
    private final LocalDataStore localDataStore;
    private final Logger logger;
    private int networkRetryCount = 0;
    private final ValidationResultStack validationResultStack;
    private int responseFailureCount = 0;
    private final Validator validator;
    private int minDelayFrequency = 0;
    private final List<NetworkHeadersListener> mNetworkHeadersListeners = new ArrayList<NetworkHeadersListener>();

    public void addNetworkHeadersListener(NetworkHeadersListener listener) {
        this.mNetworkHeadersListeners.add(listener);
    }

    public void removeNetworkHeadersListener(NetworkHeadersListener listener) {
        this.mNetworkHeadersListeners.remove(listener);
    }

    public static boolean isNetworkOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return true;
            }
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    public NetworkManager(Context context, CleverTapInstanceConfig config, DeviceInfo deviceInfo, CoreMetaData coreMetaData, ValidationResultStack validationResultStack, ControllerManager controllerManager, BaseDatabaseManager baseDatabaseManager, BaseCallbackManager callbackManager, CTLockManager ctLockManager, Validator validator, LocalDataStore localDataStore, CryptHandler cryptHandler, InAppResponse inAppResponse) {
        this.context = context;
        this.config = config;
        this.deviceInfo = deviceInfo;
        this.callbackManager = callbackManager;
        this.validator = validator;
        this.localDataStore = localDataStore;
        this.logger = this.config.getLogger();
        this.coreMetaData = coreMetaData;
        this.validationResultStack = validationResultStack;
        this.controllerManager = controllerManager;
        this.databaseManager = baseDatabaseManager;
        this.cleverTapResponses.add(inAppResponse);
        this.cleverTapResponses.add(new MetadataResponse(config, deviceInfo, this));
        this.cleverTapResponses.add(new ARPResponse(config, this, validator, controllerManager));
        this.cleverTapResponses.add(new ConsoleResponse(config));
        this.cleverTapResponses.add(new InboxResponse(config, ctLockManager, callbackManager, controllerManager));
        this.cleverTapResponses.add(new PushAmpResponse(context, config, baseDatabaseManager, callbackManager, controllerManager));
        this.cleverTapResponses.add(new FetchVariablesResponse(config, controllerManager, callbackManager));
        this.cleverTapResponses.add(new DisplayUnitResponse(config, callbackManager, controllerManager));
        this.cleverTapResponses.add(new FeatureFlagResponse(config, controllerManager));
        this.cleverTapResponses.add(new ProductConfigResponse(config, coreMetaData, controllerManager));
        this.cleverTapResponses.add(new GeofenceResponse(config, callbackManager));
        this.cleverTapResponses.add(new SyncUpstreamResponse(localDataStore, this.logger, config.getAccountId()));
    }

    @Override
    public void flushDBQueue(Context context, EventGroup eventGroup, @Nullable String caller) {
        this.config.getLogger().verbose(this.config.getAccountId(), "Somebody has invoked me to send the queue to CleverTap servers");
        QueueCursor previousCursor = null;
        boolean loadMore = true;
        while (loadMore) {
            QueueCursor cursor = this.databaseManager.getQueuedEvents(context, 50, previousCursor, eventGroup);
            if (cursor == null || cursor.isEmpty().booleanValue()) {
                this.config.getLogger().verbose(this.config.getAccountId(), "No events in the queue, failing");
                if (eventGroup != EventGroup.PUSH_NOTIFICATION_VIEWED || previousCursor == null || previousCursor.getData() == null) break;
                try {
                    this.notifyListenersForPushImpressionSentToServer(previousCursor.getData());
                }
                catch (Exception e) {
                    this.config.getLogger().verbose(this.config.getAccountId(), "met with exception while notifying listeners for PushImpressionSentToServer event");
                }
                break;
            }
            previousCursor = cursor;
            JSONArray queue = cursor.getData();
            if (queue == null || queue.length() <= 0) {
                this.config.getLogger().verbose(this.config.getAccountId(), "No events in the queue, failing");
                break;
            }
            loadMore = this.sendQueue(context, eventGroup, queue, caller);
            if (!loadMore) {
                this.controllerManager.invokeCallbacksForNetworkError();
                this.controllerManager.invokeBatchListener(queue, false);
                continue;
            }
            this.controllerManager.invokeBatchListener(queue, true);
        }
    }

    @Override
    public int getDelayFrequency() {
        this.logger.debug(this.config.getAccountId(), "Network retry #" + this.networkRetryCount);
        if (this.networkRetryCount < 10) {
            this.logger.debug(this.config.getAccountId(), "Failure count is " + this.networkRetryCount + ". Setting delay frequency to 1s");
            this.minDelayFrequency = 1000;
            return this.minDelayFrequency;
        }
        if (this.config.getAccountRegion() == null) {
            this.logger.debug(this.config.getAccountId(), "Setting delay frequency to 1s");
            return 1000;
        }
        SecureRandom randomGen = new SecureRandom();
        int randomDelay = (randomGen.nextInt(10) + 1) * 1000;
        this.minDelayFrequency += randomDelay;
        if (this.minDelayFrequency < 600000) {
            this.logger.debug(this.config.getAccountId(), "Setting delay frequency to " + this.minDelayFrequency);
            return this.minDelayFrequency;
        }
        this.minDelayFrequency = 1000;
        this.logger.debug(this.config.getAccountId(), "Setting delay frequency to " + this.minDelayFrequency);
        return this.minDelayFrequency;
    }

    public String getNewNamespaceARPKey() {
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            return null;
        }
        this.logger.verbose(this.config.getAccountId(), "New ARP Key = ARP:" + accountId + ":" + this.deviceInfo.getDeviceID());
        return "ARP:" + accountId + ":" + this.deviceInfo.getDeviceID();
    }

    public void incrementResponseFailureCount() {
        ++this.responseFailureCount;
    }

    @Override
    public void initHandshake(EventGroup eventGroup, Runnable handshakeSuccessCallback) {
        this.responseFailureCount = 0;
        this.performHandshakeForDomain(this.context, eventGroup, handshakeSuccessCallback);
    }

    @Override
    public boolean needsHandshakeForDomain(EventGroup eventGroup) {
        boolean needHandshakeDueToFailure;
        String domain = this.getDomainFromPrefsOrMetadata(eventGroup);
        boolean bl = needHandshakeDueToFailure = this.responseFailureCount > 5;
        if (needHandshakeDueToFailure) {
            this.setDomain(this.context, null);
        }
        return domain == null || needHandshakeDueToFailure;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public void setI(Context context, long i) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_i"), i);
        StorageHelper.persist(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public void setJ(Context context, long j) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_j"), j);
        StorageHelper.persist(editor);
    }

    HttpsURLConnection buildHttpsURLConnection(String endpoint) throws IOException {
        SSLContext _sslContext;
        URL url = new URL(endpoint);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("X-CleverTap-Account-ID", this.config.getAccountId());
        conn.setRequestProperty("X-CleverTap-Token", this.config.getAccountToken());
        conn.setInstanceFollowRedirects(false);
        if (this.config.isSslPinningEnabled() && (_sslContext = NetworkManager.getSSLContext()) != null) {
            conn.setSSLSocketFactory(NetworkManager.getPinnedCertsSslSocketfactory(_sslContext));
        }
        return conn;
    }

    int getCurrentRequestTimestamp() {
        return this.currentRequestTimestamp;
    }

    void setCurrentRequestTimestamp(int currentRequestTimestamp) {
        this.currentRequestTimestamp = currentRequestTimestamp;
    }

    String getDomain(boolean defaultToHandshakeURL, EventGroup eventGroup) {
        boolean emptyDomain;
        String domain = this.getDomainFromPrefsOrMetadata(eventGroup);
        boolean bl = emptyDomain = domain == null || domain.trim().length() == 0;
        if (emptyDomain && !defaultToHandshakeURL) {
            return null;
        }
        domain = emptyDomain ? "clevertap-prod.com/hello" : (eventGroup == EventGroup.VARIABLES ? domain + eventGroup.additionalPath : domain + "/a1");
        return domain;
    }

    public String getDomainFromPrefsOrMetadata(EventGroup eventGroup) {
        try {
            this.setResponseFailureCount(0);
            String region = this.config.getAccountRegion();
            String proxyDomain = this.config.getProxyDomain();
            String spikyProxyDomain = this.config.getSpikyProxyDomain();
            if (region != null && region.trim().length() > 0) {
                return eventGroup.equals((Object)EventGroup.PUSH_NOTIFICATION_VIEWED) ? region.trim().toLowerCase() + eventGroup.httpResource + "." + "clevertap-prod.com" : region.trim().toLowerCase() + "." + "clevertap-prod.com";
            }
            if (eventGroup.equals((Object)EventGroup.REGULAR) && proxyDomain != null && proxyDomain.trim().length() > 0) {
                return proxyDomain;
            }
            if (eventGroup.equals((Object)EventGroup.PUSH_NOTIFICATION_VIEWED) && spikyProxyDomain != null && spikyProxyDomain.trim().length() > 0) {
                return spikyProxyDomain;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return eventGroup.equals((Object)EventGroup.PUSH_NOTIFICATION_VIEWED) ? StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn_spiky", null) : StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn", null);
    }

    String getEndpoint(boolean defaultToHandshakeURL, EventGroup eventGroup) {
        String domain = this.getDomain(defaultToHandshakeURL, eventGroup);
        if (domain == null) {
            this.logger.verbose(this.config.getAccountId(), "Unable to configure endpoint, domain is null");
            return null;
        }
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            this.logger.verbose(this.config.getAccountId(), "Unable to configure endpoint, accountID is null");
            return null;
        }
        String endpoint = "https://" + domain + "?os=Android&t=" + this.deviceInfo.getSdkVersion();
        endpoint = endpoint + "&z=" + accountId;
        boolean needsHandshake = this.needsHandshakeForDomain(eventGroup);
        if (needsHandshake) {
            return endpoint;
        }
        this.currentRequestTimestamp = (int)(System.currentTimeMillis() / 1000L);
        endpoint = endpoint + "&ts=" + this.getCurrentRequestTimestamp();
        return endpoint;
    }

    int getFirstRequestTimestamp() {
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_first_ts", 0);
    }

    int getLastRequestTimestamp() {
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_last_ts", 0);
    }

    void setLastRequestTimestamp(int ts) {
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config, "comms_last_ts"), ts);
    }

    int getResponseFailureCount() {
        return this.responseFailureCount;
    }

    void setResponseFailureCount(int responseFailureCount) {
        this.responseFailureCount = responseFailureCount;
    }

    boolean hasDomainChanged(String newDomain) {
        String oldDomain = StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn", null);
        return !newDomain.equals(oldDomain);
    }

    JSONObject getHeader(Context context, @Nullable String caller) {
        try {
            long j;
            String deviceId;
            JSONObject header = new JSONObject();
            if (caller != null) {
                header.put("d_src", (Object)caller);
            }
            if ((deviceId = this.deviceInfo.getDeviceID()) != null && !deviceId.equals("")) {
                header.put("g", (Object)deviceId);
            } else {
                this.logger.verbose(this.config.getAccountId(), "CRITICAL: Couldn't finalise on a device ID! Using error device ID instead!");
            }
            header.put("type", (Object)"meta");
            JSONObject appFields = this.deviceInfo.getAppLaunchedFields();
            if (this.coreMetaData.isWebInterfaceInitializedExternally()) {
                appFields.put("wv_init", true);
            }
            header.put("af", (Object)appFields);
            long i = this.getI();
            if (i > 0L) {
                header.put("_i", i);
            }
            if ((j = this.getJ()) > 0L) {
                header.put("_j", j);
            }
            String accountId = this.config.getAccountId();
            String token = this.config.getAccountToken();
            if (accountId == null || token == null) {
                this.logger.debug(this.config.getAccountId(), "Account ID/token not found, unable to configure queue request");
                return null;
            }
            header.put("id", (Object)accountId);
            header.put("tk", (Object)token);
            header.put("l_ts", this.getLastRequestTimestamp());
            header.put("f_ts", this.getFirstRequestTimestamp());
            header.put("ct_pi", (Object)IdentityRepoFactory.getRepo(this.context, this.config, this.deviceInfo, this.validationResultStack).getIdentitySet().toString());
            header.put("ddnd", !CTXtensions.areAppNotificationsEnabled(this.context) || !this.controllerManager.getPushProviders().isNotificationSupported());
            if (this.coreMetaData.isBgPing()) {
                header.put("bk", 1);
                this.coreMetaData.setBgPing(false);
            }
            header.put("rtl", (Object)CTJsonConverter.getRenderedTargetList(this.databaseManager.loadDBAdapter(this.context)));
            if (!this.coreMetaData.isInstallReferrerDataSent()) {
                header.put("rct", this.coreMetaData.getReferrerClickTime());
                header.put("ait", this.coreMetaData.getAppInstallTime());
            }
            header.put("frs", this.coreMetaData.isFirstRequestInSession());
            if (CleverTapAPI.getDebugLevel() == 3) {
                header.put("debug", true);
            }
            this.coreMetaData.setFirstRequestInSession(false);
            try {
                JSONObject arp = this.getARP();
                if (arp != null && arp.length() > 0) {
                    header.put("arp", (Object)arp);
                }
            }
            catch (Throwable t) {
                this.logger.verbose(this.config.getAccountId(), "Failed to attach ARP", t);
            }
            JSONObject ref = new JSONObject();
            try {
                String utmCampaign;
                String utmMedium;
                String utmSource = this.coreMetaData.getSource();
                if (utmSource != null) {
                    ref.put("us", (Object)utmSource);
                }
                if ((utmMedium = this.coreMetaData.getMedium()) != null) {
                    ref.put("um", (Object)utmMedium);
                }
                if ((utmCampaign = this.coreMetaData.getCampaign()) != null) {
                    ref.put("uc", (Object)utmCampaign);
                }
                if (ref.length() > 0) {
                    header.put("ref", (Object)ref);
                }
            }
            catch (Throwable t) {
                this.logger.verbose(this.config.getAccountId(), "Failed to attach ref", t);
            }
            JSONObject wzrkParams = this.coreMetaData.getWzrkParams();
            if (wzrkParams != null && wzrkParams.length() > 0) {
                header.put("wzrk_ref", (Object)wzrkParams);
            }
            if (this.controllerManager.getInAppFCManager() != null) {
                Logger.v("Attaching InAppFC to Header");
                this.controllerManager.getInAppFCManager().attachToHeader(context, header);
            } else {
                this.logger.verbose(this.config.getAccountId(), "controllerManager.getInAppFCManager() is NULL, not Attaching InAppFC to Header");
            }
            return header;
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "CommsManager: Failed to attach header", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performHandshakeForDomain(Context context, EventGroup eventGroup, Runnable handshakeSuccessCallback) {
        String endpoint = this.getEndpoint(true, eventGroup);
        if (endpoint == null) {
            this.logger.verbose(this.config.getAccountId(), "Unable to perform handshake, endpoint is null");
        }
        this.logger.verbose(this.config.getAccountId(), "Performing handshake with " + endpoint);
        HttpsURLConnection conn = null;
        try {
            conn = this.buildHttpsURLConnection(endpoint);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                this.logger.verbose(this.config.getAccountId(), "Invalid HTTP status code received for handshake - " + responseCode);
                return;
            }
            this.logger.verbose(this.config.getAccountId(), "Received success from handshake :)");
            if (this.processIncomingHeaders(context, conn)) {
                this.logger.verbose(this.config.getAccountId(), "We are not muted");
                handshakeSuccessCallback.run();
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Failed to perform handshake!", t);
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                    conn.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    boolean processIncomingHeaders(Context context, HttpsURLConnection conn) {
        String muteCommand = conn.getHeaderField("X-WZRK-MUTE");
        if (muteCommand != null && muteCommand.trim().length() > 0) {
            if (muteCommand.equals("true")) {
                this.setMuted(context, true);
                return false;
            }
            this.setMuted(context, false);
        }
        String domainName = conn.getHeaderField("X-WZRK-RD");
        Logger.v("Getting domain from header - " + domainName);
        if (domainName == null || domainName.trim().length() == 0) {
            return true;
        }
        String spikyDomainName = conn.getHeaderField("X-WZRK-SPIKY-RD");
        Logger.v("Getting spiky domain from header - " + spikyDomainName);
        this.setMuted(context, false);
        this.setDomain(context, domainName);
        Logger.v("Setting spiky domain from header as -" + spikyDomainName);
        if (spikyDomainName == null) {
            this.setSpikyDomain(context, domainName);
        } else {
            this.setSpikyDomain(context, spikyDomainName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean sendQueue(Context context, EventGroup eventGroup, JSONArray queue, @Nullable String caller) {
        block44: {
            block42: {
                block43: {
                    block40: {
                        block41: {
                            block38: {
                                block39: {
                                    block36: {
                                        block37: {
                                            if (queue == null || queue.length() <= 0) {
                                                return false;
                                            }
                                            if (this.deviceInfo.getDeviceID() == null) {
                                                this.logger.debug(this.config.getAccountId(), "CleverTap Id not finalized, unable to send queue");
                                                return false;
                                            }
                                            conn = null;
                                            endpoint = this.getEndpoint(false, eventGroup);
                                            if (endpoint != null) break block36;
                                            this.logger.debug(this.config.getAccountId(), "Problem configuring queue endpoint, unable to send queue");
                                            var7_8 = false;
                                            if (conn == null) break block37;
                                            try {
                                                conn.getInputStream().close();
                                                conn.disconnect();
                                            }
                                            catch (Throwable var8_11) {
                                                // empty catch block
                                            }
                                        }
                                        return var7_8;
                                    }
                                    conn = this.buildHttpsURLConnection(endpoint);
                                    header = this.getHeader(context, caller);
                                    endpointId = EndpointId.fromString(endpoint);
                                    if (header == null) {
                                        req = queue.toString();
                                    } else {
                                        for (NetworkHeadersListener listener : this.mNetworkHeadersListeners) {
                                            headersToAttach = listener.onAttachHeaders(endpointId);
                                            if (headersToAttach == null) continue;
                                            CTXtensions.copyFrom(header, headersToAttach);
                                        }
                                        req = "[" + header + ", " + queue.toString().substring(1);
                                    }
                                    if (req != null) break block38;
                                    this.logger.debug(this.config.getAccountId(), "Problem configuring queue request, unable to send queue");
                                    var11_17 = false;
                                    if (conn == null) break block39;
                                    try {
                                        conn.getInputStream().close();
                                        conn.disconnect();
                                    }
                                    catch (Throwable listener) {
                                        // empty catch block
                                    }
                                }
                                return var11_17;
                            }
                            this.logger.debug(this.config.getAccountId(), "Send queue contains " + queue.length() + " items: " + req);
                            this.logger.debug(this.config.getAccountId(), "Sending queue to: " + endpoint);
                            conn.setDoOutput(true);
                            conn.getOutputStream().write(req.getBytes("UTF-8"));
                            responseCode = conn.getResponseCode();
                            if (eventGroup != EventGroup.VARIABLES) break block40;
                            if (!this.handleVariablesResponseError(responseCode, (HttpsURLConnection)conn)) ** GOTO lbl70
                            listener = false;
                            if (conn == null) break block41;
                            try {
                                conn.getInputStream().close();
                                conn.disconnect();
                            }
                            catch (Throwable headersToAttach) {
                                // empty catch block
                            }
                        }
                        return listener;
                    }
                    if (responseCode != 200) {
                        throw new IOException("Response code is not 200. It is " + responseCode);
                    }
lbl70:
                    // 3 sources

                    if ((newDomain = conn.getHeaderField("X-WZRK-RD")) == null || newDomain.trim().length() <= 0 || !this.hasDomainChanged(newDomain)) break block42;
                    this.setDomain(context, newDomain);
                    this.logger.debug(this.config.getAccountId(), "The domain has changed to " + newDomain + ". The request will be retried shortly.");
                    headersToAttach = false;
                    if (conn == null) break block43;
                    try {
                        conn.getInputStream().close();
                        conn.disconnect();
                    }
                    catch (Throwable var14_26) {
                        // empty catch block
                    }
                }
                return headersToAttach;
            }
            for (NetworkHeadersListener listener : this.mNetworkHeadersListeners) {
                if (header == null) continue;
                listener.onSentHeaders(header, endpointId);
            }
            if (this.processIncomingHeaders(context, (HttpsURLConnection)conn)) {
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                body = sb.toString();
                if (eventGroup == EventGroup.VARIABLES) {
                    this.processVariablesResponse(body);
                } else {
                    found = false;
                    for (index = 0; index < queue.length(); ++index) {
                        event = queue.getJSONObject(index);
                        eventType = event.getString("type");
                        if (!"event".equals(eventType) || !"App Launched".equals(evtName = event.getString("evtName")) && !"wzrk_fetch".equals(evtName)) continue;
                        found = true;
                    }
                    this.processAllResponses(body, found);
                }
            }
            this.setLastRequestTimestamp(this.getCurrentRequestTimestamp());
            this.setFirstRequestTimestampIfNeeded(this.getCurrentRequestTimestamp());
            this.logger.debug(this.config.getAccountId(), "Queue sent successfully");
            this.responseFailureCount = 0;
            this.networkRetryCount = 0;
            var13_25 = true;
            if (conn == null) break block44;
            try {
                conn.getInputStream().close();
                conn.disconnect();
            }
            catch (Throwable var14_28) {
                // empty catch block
            }
        }
        return var13_25;
        catch (Throwable e) {
            try {
                this.logger.debug(this.config.getAccountId(), "An exception occurred while sending the queue, will retry: ", e);
                ++this.responseFailureCount;
                ++this.networkRetryCount;
                this.callbackManager.getFailureFlushListener().failureFlush(context);
                var7_10 = false;
                return var7_10;
            }
            catch (Throwable var21_35) {
                throw var21_35;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.getInputStream().close();
                        conn.disconnect();
                    }
                    catch (Throwable var8_13) {}
                }
            }
        }
    }

    private void processVariablesResponse(String body) {
        try {
            JSONObject jsonObject = new JSONObject(body);
            this.logger.verbose(this.config.getAccountId(), "Processing variables response : " + jsonObject);
            new ARPResponse(this.config, this, this.validator, this.controllerManager).processResponse(jsonObject, body, this.context);
            new SyncUpstreamResponse(this.localDataStore, this.logger, this.config.getAccountId()).processResponse(jsonObject, body, this.context);
        }
        catch (JSONException e) {
            this.logger.verbose(this.config.getAccountId(), "Error in parsing response.", e);
            this.incrementResponseFailureCount();
        }
    }

    private void processAllResponses(String body, boolean isFullResponse) {
        try {
            JSONObject jsonObject = new JSONObject(body);
            this.logger.verbose(this.config.getAccountId(), "Processing response : " + jsonObject);
            for (CleverTapResponse response : this.cleverTapResponses) {
                response.isFullResponse = isFullResponse;
                response.processResponse(jsonObject, body, this.context);
            }
        }
        catch (JSONException e) {
            this.logger.verbose(this.config.getAccountId(), "Error in parsing response.", e);
            this.incrementResponseFailureCount();
        }
    }

    private void notifyListenersForPushImpressionSentToServer(JSONArray queue) throws JSONException {
        for (int i = 0; i < queue.length(); ++i) {
            try {
                JSONObject notif = queue.getJSONObject(i).optJSONObject("evtData");
                if (notif == null) continue;
                String pushId = notif.optString("wzrk_pid");
                String pushAccountId = notif.optString("wzrk_acct_id");
                this.notifyListenerForPushImpressionSentToServer(PushNotificationUtil.buildPushNotificationRenderedListenerKey(pushAccountId, pushId));
                continue;
            }
            catch (JSONException e) {
                this.logger.verbose(this.config.getAccountId(), "Encountered an exception while parsing the push notification viewed event queue");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.verbose(this.config.getAccountId(), "push notification viewed event sent successfully");
    }

    private void notifyListenerForPushImpressionSentToServer(@NonNull String listenerKey) {
        NotificationRenderedListener notificationRenderedListener = CleverTapAPI.getNotificationRenderedListener(listenerKey);
        if (notificationRenderedListener != null) {
            this.logger.verbose(this.config.getAccountId(), "notifying listener " + listenerKey + ", that push impression sent successfully");
            notificationRenderedListener.onNotificationRendered(true);
        }
    }

    private boolean handleVariablesResponseError(int responseCode, HttpsURLConnection conn) {
        switch (responseCode) {
            case 200: {
                this.logger.info("variables", "Vars synced successfully.");
                return false;
            }
            case 400: {
                JSONObject errorStreamJson = this.getErrorStreamAsJson(conn);
                if (errorStreamJson != null && !TextUtils.isEmpty((CharSequence)errorStreamJson.optString("error"))) {
                    String errorMessage = errorStreamJson.optString("error");
                    this.logger.info("variables", "Error while syncing vars: " + errorMessage);
                } else {
                    this.logger.info("variables", "Error while syncing vars.");
                }
                return true;
            }
            case 401: {
                this.logger.info("variables", "Unauthorized access from a non-test profile. Please mark this profile as a test profile from the CleverTap dashboard.");
                return true;
            }
        }
        this.logger.info("variables", "Response code " + responseCode + " while syncing vars.");
        return true;
    }

    private JSONObject getErrorStreamAsJson(HttpsURLConnection conn) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));
            StringBuilder text = new StringBuilder();
            while ((line = br.readLine()) != null) {
                text.append(line);
            }
            return new JSONObject(text.toString());
        }
        catch (IOException | JSONException e) {
            return null;
        }
    }

    void setDomain(Context context, String domainName) {
        this.logger.verbose(this.config.getAccountId(), "Setting domain to " + domainName);
        StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn"), domainName);
        if (this.callbackManager.getSCDomainListener() != null) {
            if (domainName != null) {
                this.callbackManager.getSCDomainListener().onSCDomainAvailable(Utils.getSCDomain(domainName));
            } else {
                this.callbackManager.getSCDomainListener().onSCDomainUnavailable();
            }
        }
    }

    void setFirstRequestTimestampIfNeeded(int ts) {
        if (this.getFirstRequestTimestamp() > 0) {
            return;
        }
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config, "comms_first_ts"), ts);
    }

    void setSpikyDomain(Context context, String spikyDomainName) {
        this.logger.verbose(this.config.getAccountId(), "Setting spiky domain to " + spikyDomainName);
        StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn_spiky"), spikyDomainName);
    }

    private JSONObject getARP() {
        try {
            String nameSpaceKey = this.getNewNamespaceARPKey();
            if (nameSpaceKey == null) {
                return null;
            }
            SharedPreferences prefs = !StorageHelper.getPreferences(this.context, nameSpaceKey).getAll().isEmpty() ? StorageHelper.getPreferences(this.context, nameSpaceKey) : this.migrateARPToNewNameSpace(nameSpaceKey, this.getNamespaceARPKey());
            Map all = prefs.getAll();
            Iterator iter = all.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry kv = iter.next();
                Object o = kv.getValue();
                if (!(o instanceof Number) || ((Number)o).intValue() != -1) continue;
                iter.remove();
            }
            JSONObject ret = new JSONObject(all);
            this.logger.verbose(this.config.getAccountId(), "Fetched ARP for namespace key: " + nameSpaceKey + " values: " + all);
            return ret;
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Failed to construct ARP object", t);
            return null;
        }
    }

    private long getI() {
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_i", 0, "IJ");
    }

    private long getJ() {
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_j", 0, "IJ");
    }

    private String getNamespaceARPKey() {
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            return null;
        }
        this.logger.verbose(this.config.getAccountId(), "Old ARP Key = ARP:" + accountId);
        return "ARP:" + accountId;
    }

    private SharedPreferences migrateARPToNewNameSpace(String newKey, String oldKey) {
        SharedPreferences oldPrefs = StorageHelper.getPreferences(this.context, oldKey);
        SharedPreferences newPrefs = StorageHelper.getPreferences(this.context, newKey);
        SharedPreferences.Editor editor = newPrefs.edit();
        Map all = oldPrefs.getAll();
        for (Map.Entry kv : all.entrySet()) {
            Object o = kv.getValue();
            if (o instanceof Number) {
                int update = ((Number)o).intValue();
                editor.putInt((String)kv.getKey(), update);
                continue;
            }
            if (o instanceof String) {
                if (((String)o).length() < 100) {
                    editor.putString((String)kv.getKey(), (String)o);
                    continue;
                }
                this.logger.verbose(this.config.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (string value too long)");
                continue;
            }
            if (o instanceof Boolean) {
                editor.putBoolean((String)kv.getKey(), ((Boolean)o).booleanValue());
                continue;
            }
            this.logger.verbose(this.config.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (invalid data type)");
        }
        this.logger.verbose(this.config.getAccountId(), "Completed ARP update for namespace key: " + newKey + "");
        StorageHelper.persist(editor);
        oldPrefs.edit().clear().apply();
        return newPrefs;
    }

    private void setMuted(Context context, boolean mute) {
        if (mute) {
            int now = (int)(System.currentTimeMillis() / 1000L);
            StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), now);
            this.setDomain(context, null);
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            task.execute("CommsManager#setMuted", () -> {
                this.databaseManager.clearQueues(context);
                return null;
            });
        } else {
            StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), 0);
        }
    }

    private static SSLSocketFactory getPinnedCertsSslSocketfactory(SSLContext sslContext) {
        if (sslContext == null) {
            return null;
        }
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = sslContext.getSocketFactory();
                Logger.d("Pinning SSL session to DigiCertGlobalRoot CA certificate");
            }
            catch (Throwable e) {
                Logger.d("Issue in pinning SSL,", e);
            }
        }
        return sslSocketFactory;
    }

    private static synchronized SSLContext getSSLContext() {
        if (sslContext == null) {
            sslContext = new SSLContextBuilder().build();
        }
        return sslContext;
    }
}

