/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.util.Log;
import com.clevertap.android.sdk.CleverTapAPI;

public final class Logger {
    private int debugLevel;

    public static void d(String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)"CleverTap", (String)message);
        }
    }

    public static void d(String suffix, String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)("CleverTap:" + suffix), (String)message);
        }
    }

    public static void d(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    public static void d(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    public static void i(String message) {
        if (Logger.getStaticDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)"CleverTap", (String)message);
        }
    }

    public static void i(String suffix, String message) {
        if (Logger.getStaticDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)("CleverTap:" + suffix), (String)message);
        }
    }

    public static void i(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    public static void i(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    public static void v(String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)"CleverTap", (String)message);
        }
    }

    public static void v(String suffix, String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)("CleverTap:" + suffix), (String)message);
        }
    }

    public static void v(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    public static void v(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    Logger(int level) {
        this.debugLevel = level;
    }

    public void debug(String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)"CleverTap", (String)message);
        }
    }

    public void debug(String suffix, String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            if (message.length() > 4000) {
                Log.d((String)("CleverTap:" + suffix), (String)message.substring(0, 4000));
                this.debug(suffix, message.substring(4000));
            } else {
                Log.d((String)("CleverTap:" + suffix), (String)message);
            }
        }
    }

    public void debug(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    public void debug(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    public void info(String message) {
        if (this.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)"CleverTap", (String)message);
        }
    }

    public void info(String suffix, String message) {
        if (this.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)("CleverTap:" + suffix), (String)message);
        }
    }

    public void info(String suffix, String message, Throwable t) {
        if (this.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    public void info(String message, Throwable t) {
        if (this.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    public void verbose(String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)"CleverTap", (String)message);
        }
    }

    public void verbose(String suffix, String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            if (message.length() > 4000) {
                Log.v((String)("CleverTap:" + suffix), (String)message.substring(0, 4000));
                this.verbose(suffix, message.substring(4000));
            } else {
                Log.v((String)("CleverTap:" + suffix), (String)message);
            }
        }
    }

    public void verbose(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    public void verbose(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    private int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int level) {
        this.debugLevel = level;
    }

    private static int getStaticDebugLevel() {
        return CleverTapAPI.getDebugLevel();
    }
}

