/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.cryption;

import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.cryption.Crypt;
import com.clevertap.android.sdk.cryption.CryptFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler;", "", "encryptionLevel", "", "encryptionType", "Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "accountID", "", "(ILcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;Ljava/lang/String;)V", "crypt", "Lcom/clevertap/android/sdk/cryption/Crypt;", "encryptionFlagStatus", "getEncryptionFlagStatus", "()I", "setEncryptionFlagStatus", "(I)V", "Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionLevel;", "decrypt", "cipherText", "key", "encrypt", "plainText", "Companion", "EncryptionAlgorithm", "EncryptionLevel", "clevertap-core_release"})
public final class CryptHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EncryptionLevel encryptionLevel;
    @NotNull
    private EncryptionAlgorithm encryptionType;
    @NotNull
    private Crypt crypt;
    @NotNull
    private String accountID;
    private int encryptionFlagStatus;

    public CryptHandler(int encryptionLevel, @NotNull EncryptionAlgorithm encryptionType, @NotNull String accountID) {
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionType), (String)"encryptionType");
        Intrinsics.checkNotNullParameter((Object)accountID, (String)"accountID");
        this.encryptionLevel = EncryptionLevel.values()[encryptionLevel];
        this.encryptionType = encryptionType;
        this.accountID = accountID;
        this.encryptionFlagStatus = 0;
        this.crypt = CryptFactory.Companion.getCrypt(encryptionType);
    }

    public final int getEncryptionFlagStatus() {
        return this.encryptionFlagStatus;
    }

    public final void setEncryptionFlagStatus(int n) {
        this.encryptionFlagStatus = n;
    }

    @Nullable
    public final String encrypt(@NotNull String plainText, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (WhenMappings.$EnumSwitchMapping$0[this.encryptionLevel.ordinal()] == 1) {
            if (Constants.MEDIUM_CRYPT_KEYS.contains(key) && !Companion.isTextEncrypted(plainText)) {
                return this.crypt.encryptInternal(plainText, this.accountID);
            }
        } else {
            return plainText;
        }
        return plainText;
    }

    @Nullable
    public final String decrypt(@NotNull String cipherText, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (Companion.isTextEncrypted(cipherText)) {
            if (WhenMappings.$EnumSwitchMapping$0[this.encryptionLevel.ordinal()] == 1) {
                if (Constants.MEDIUM_CRYPT_KEYS.contains(key)) {
                    return this.crypt.decryptInternal(cipherText, this.accountID);
                }
            } else {
                return this.crypt.decryptInternal(cipherText, this.accountID);
            }
        }
        return cipherText;
    }

    @JvmStatic
    public static final boolean isTextEncrypted(@NotNull String plainText) {
        return Companion.isTextEncrypted(plainText);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionAlgorithm;", "", "(Ljava/lang/String;I)V", "AES", "clevertap-core_release"})
    public static final class EncryptionAlgorithm
    extends Enum<EncryptionAlgorithm> {
        public static final /* enum */ EncryptionAlgorithm AES = new EncryptionAlgorithm();
        private static final /* synthetic */ EncryptionAlgorithm[] $VALUES;

        public static EncryptionAlgorithm[] values() {
            return (EncryptionAlgorithm[])$VALUES.clone();
        }

        public static EncryptionAlgorithm valueOf(String value) {
            return Enum.valueOf(EncryptionAlgorithm.class, value);
        }

        static {
            $VALUES = encryptionAlgorithmArray = new EncryptionAlgorithm[]{EncryptionAlgorithm.AES};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler$EncryptionLevel;", "", "value", "", "(Ljava/lang/String;II)V", "intValue", "NONE", "MEDIUM", "clevertap-core_release"})
    public static final class EncryptionLevel
    extends Enum<EncryptionLevel> {
        private final int value;
        public static final /* enum */ EncryptionLevel NONE = new EncryptionLevel(0);
        public static final /* enum */ EncryptionLevel MEDIUM = new EncryptionLevel(1);
        private static final /* synthetic */ EncryptionLevel[] $VALUES;

        private EncryptionLevel(int value) {
            this.value = value;
        }

        public final int intValue() {
            return this.value;
        }

        public static EncryptionLevel[] values() {
            return (EncryptionLevel[])$VALUES.clone();
        }

        public static EncryptionLevel valueOf(String value) {
            return Enum.valueOf(EncryptionLevel.class, value);
        }

        static {
            $VALUES = encryptionLevelArray = new EncryptionLevel[]{EncryptionLevel.NONE, EncryptionLevel.MEDIUM};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/clevertap/android/sdk/cryption/CryptHandler$Companion;", "", "()V", "isTextEncrypted", "", "plainText", "", "clevertap-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isTextEncrypted(@NotNull String plainText) {
            Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
            return StringsKt.startsWith$default((CharSequence)plainText, (char)'[', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)plainText, (char)']', (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptionLevel.values().length];
            try {
                nArray[EncryptionLevel.MEDIUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

