/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.bitmap.GzipBitmapInputStreamReader;
import com.clevertap.android.sdk.bitmap.IBitmapInputStreamReader;
import com.clevertap.android.sdk.network.DownloadedBitmap;
import com.clevertap.android.sdk.network.DownloadedBitmapFactory;
import java.io.InputStream;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/clevertap/android/sdk/bitmap/BitmapInputStreamDecoder;", "Lcom/clevertap/android/sdk/bitmap/IBitmapInputStreamReader;", "nextBitmapInputStreamReader", "Lcom/clevertap/android/sdk/bitmap/GzipBitmapInputStreamReader;", "(Lcom/clevertap/android/sdk/bitmap/GzipBitmapInputStreamReader;)V", "readInputStream", "Lcom/clevertap/android/sdk/network/DownloadedBitmap;", "inputStream", "Ljava/io/InputStream;", "connection", "Ljava/net/HttpURLConnection;", "downloadStartTimeInMilliseconds", "", "clevertap-core_release"})
public final class BitmapInputStreamDecoder
implements IBitmapInputStreamReader {
    @Nullable
    private final GzipBitmapInputStreamReader nextBitmapInputStreamReader;

    public BitmapInputStreamDecoder(@Nullable GzipBitmapInputStreamReader nextBitmapInputStreamReader) {
        this.nextBitmapInputStreamReader = nextBitmapInputStreamReader;
    }

    public /* synthetic */ BitmapInputStreamDecoder(GzipBitmapInputStreamReader gzipBitmapInputStreamReader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gzipBitmapInputStreamReader = null;
        }
        this(gzipBitmapInputStreamReader);
    }

    @Override
    @Nullable
    public DownloadedBitmap readInputStream(@NotNull InputStream inputStream, @NotNull HttpURLConnection connection, long downloadStartTimeInMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Logger.v("reading bitmap input stream in BitmapInputStreamDecoder....");
        Object object = this.nextBitmapInputStreamReader;
        if (object == null || (object = ((GzipBitmapInputStreamReader)object).readInputStream(inputStream, connection, downloadStartTimeInMilliseconds)) == null) {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeStream(inputStream)");
            object = DownloadedBitmapFactory.INSTANCE.successBitmap(bitmap, Utils.getNowInMillis() - downloadStartTimeInMilliseconds);
        }
        return object;
    }

    public BitmapInputStreamDecoder() {
        this(null, 1, null);
    }
}

