/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import java.lang.reflect.Method;

public class PackageUtils {
    private static final String GOOGLE_PLAY_STORE_PACKAGE_OLD = "com.google.market";
    private static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";

    public static boolean isGooglePlayServicesAvailable(@NonNull Context context) {
        try {
            Class.forName("com.google.android.gms.common.GooglePlayServicesUtil");
            int status = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context);
            return status == 0;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isGooglePlayStoreAvailable(@NonNull Context context) {
        return PackageUtils.isPackageAvailable(context, GOOGLE_PLAY_STORE_PACKAGE) || PackageUtils.isPackageAvailable(context, GOOGLE_PLAY_STORE_PACKAGE_OLD);
    }

    private static boolean isPackageAvailable(Context context, String packageName) {
        try {
            context.getPackageManager().getPackageInfo(packageName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private static boolean isIntentResolved(Context context, Intent intent) {
        return intent != null && context.getPackageManager().resolveActivity(intent, 65536) != null;
    }

    public static boolean isXiaomiDeviceRunningMiui(Context context) {
        try {
            String manufacturer = "xiaomi";
            if (!manufacturer.equalsIgnoreCase(Build.MANUFACTURER)) {
                return false;
            }
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            String miui = (String)get.invoke(c, "ro.miui.ui.version.code");
            if (miui != null && !TextUtils.isEmpty((CharSequence)miui.trim())) {
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return PackageUtils.isIntentResolved(context, new Intent("miui.intent.action.OP_AUTO_START").addCategory("android.intent.category.DEFAULT")) || PackageUtils.isIntentResolved(context, new Intent().setComponent(new ComponentName("com.miui.securitycenter", "com.miui.permcenter.autostart.AutoStartManagementActivity"))) || PackageUtils.isIntentResolved(context, new Intent("miui.intent.action.POWER_HIDE_MODE_APP_LIST").addCategory("android.intent.category.DEFAULT")) || PackageUtils.isIntentResolved(context, new Intent().setComponent(new ComponentName("com.miui.securitycenter", "com.miui.powercenter.PowerSettings")));
    }
}

