/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import com.clevertap.android.sdk.variables.callbacks.FetchVariablesCallback;
import org.json.JSONObject;

public class FetchVariablesResponse
extends CleverTapResponseDecorator {
    private final CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final ControllerManager controllerManager;
    private final BaseCallbackManager callbackMgr;

    public FetchVariablesResponse(CleverTapResponse cleverTapResponse, CleverTapInstanceConfig config, ControllerManager controllerManager, BaseCallbackManager mgr) {
        this.cleverTapResponse = cleverTapResponse;
        this.config = config;
        this.controllerManager = controllerManager;
        this.callbackMgr = mgr;
    }

    private void logD(String m) {
        Logger.d("variables", m);
    }

    private void logI(String m) {
        Logger.d("variables", m);
    }

    private void logI(String m, Throwable t) {
        Logger.i("variables", m, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        this.logI("Processing Variable response...");
        this.logD("processResponse() called with: response = [" + response + "], stringBody = [" + stringBody + "], context = [" + context + "]");
        if (this.config.isAnalyticsOnly()) {
            this.logI("CleverTap instance is configured to analytics only, not processing Variable response");
            this.cleverTapResponse.processResponse(response, stringBody, context);
            return;
        }
        if (response == null) {
            this.logI("Can't parse Variable Response, JSON response object is null");
            return;
        }
        String varsKey = "vars";
        if (!response.has(varsKey)) {
            this.logI("JSON object doesn't contain the " + varsKey + " key");
            this.cleverTapResponse.processResponse(response, stringBody, context);
            return;
        }
        try {
            this.logI("Processing Request Variables response");
            JSONObject kvJson = response.getJSONObject(varsKey);
            if (this.controllerManager.getCtVariables() != null) {
                FetchVariablesCallback callback = this.callbackMgr.getFetchVariablesCallback();
                this.controllerManager.getCtVariables().handleVariableResponse(kvJson, callback);
                this.callbackMgr.setFetchVariablesCallback(null);
            } else {
                this.logI("Can't parse Variable Response, CTVariables is null");
            }
        }
        catch (Throwable t) {
            this.logI("Failed to parse response", t);
        }
        finally {
            this.cleverTapResponse.processResponse(response, stringBody, context);
        }
    }
}

