/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.ResourcesCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.inbox.CTInboxActivity;
import com.clevertap.android.sdk.inbox.CTInboxListViewFragment;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTInboxMessageContent;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.ui.StyledPlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInboxBaseMessageViewHolder
extends RecyclerView.ViewHolder {
    Context context;
    LinearLayout ctaLinearLayout;
    LinearLayout bodyRelativeLayout;
    FrameLayout frameLayout;
    ImageView mediaImage;
    ImageView squareImage;
    RelativeLayout mediaLayout;
    FrameLayout progressBarFrameLayout;
    RelativeLayout relativeLayout;
    RelativeLayout clickLayout;
    private CTInboxMessageContent firstContentItem;
    private CTInboxMessage message;
    private ImageView muteIcon;
    private WeakReference<CTInboxListViewFragment> parentWeakReference;
    private boolean requiresMediaPlayer;
    protected final ImageView readDot;

    CTInboxBaseMessageViewHolder(@NonNull View itemView) {
        super(itemView);
        this.readDot = (ImageView)itemView.findViewById(R.id.read_circle);
    }

    public boolean addMediaPlayer(StyledPlayerView videoSurfaceView) {
        int height;
        int width;
        if (!this.requiresMediaPlayer) {
            return false;
        }
        FrameLayout frameLayout = this.getLayoutForMediaPlayer();
        if (frameLayout == null) {
            return false;
        }
        frameLayout.removeAllViews();
        frameLayout.setVisibility(8);
        Resources resources = this.context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (CTInboxActivity.orientation == 2) {
            if (this.message.getOrientation().equalsIgnoreCase("l")) {
                width = Math.round((float)this.mediaImage.getMeasuredHeight() * 1.76f);
                height = this.mediaImage.getMeasuredHeight();
            } else {
                width = height = this.squareImage.getMeasuredHeight();
            }
        } else {
            width = resources.getDisplayMetrics().widthPixels;
            height = this.message.getOrientation().equalsIgnoreCase("l") ? Math.round((float)width * 0.5625f) : width;
        }
        videoSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
        frameLayout.addView((View)videoSurfaceView);
        frameLayout.setBackgroundColor(Color.parseColor((String)this.message.getBgColor()));
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(0);
        }
        ExoPlayer player = (ExoPlayer)videoSurfaceView.getPlayer();
        float currentVolume = 0.0f;
        if (player != null) {
            currentVolume = player.getVolume();
        }
        if (this.firstContentItem.mediaIsVideo()) {
            this.muteIcon = new ImageView(this.context);
            this.muteIcon.setVisibility(8);
            if (currentVolume > 0.0f) {
                this.muteIcon.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.ct_volume_on, null));
            } else {
                this.muteIcon.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.ct_volume_off, null));
            }
            int iconWidth = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)displayMetrics);
            int iconHeight = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)displayMetrics);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(iconWidth, iconHeight);
            int iconTop = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)displayMetrics);
            int iconRight = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
            layoutParams.setMargins(0, iconTop, iconRight, 0);
            layoutParams.gravity = 0x800005;
            this.muteIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.muteIcon.setOnClickListener(v -> {
                float currentVolume1 = 0.0f;
                if (player != null) {
                    currentVolume1 = player.getVolume();
                }
                if (currentVolume1 > 0.0f) {
                    player.setVolume(0.0f);
                    this.muteIcon.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.ct_volume_off, null));
                } else if (currentVolume1 == 0.0f) {
                    if (player != null) {
                        player.setVolume(1.0f);
                    }
                    this.muteIcon.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.ct_volume_on, null));
                }
            });
            frameLayout.addView((View)this.muteIcon);
        }
        videoSurfaceView.requestFocus();
        videoSurfaceView.setShowBuffering(0);
        DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter.Builder(this.context).build();
        Context ctx = this.context;
        String userAgent = Util.getUserAgent((Context)ctx, (String)ctx.getPackageName());
        String uriString = this.firstContentItem.getMedia();
        MediaItem mediaItem = MediaItem.fromUri((String)uriString);
        DefaultHttpDataSource.Factory dsf = new DefaultHttpDataSource.Factory().setUserAgent(userAgent).setTransferListener((TransferListener)defaultBandwidthMeter);
        DefaultDataSource.Factory dataSourceFactory = new DefaultDataSource.Factory(ctx, (DataSource.Factory)dsf);
        if (uriString != null) {
            HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(mediaItem);
            if (player != null) {
                player.setMediaSource((MediaSource)hlsMediaSource);
                player.prepare();
                if (this.firstContentItem.mediaIsAudio()) {
                    videoSurfaceView.showController();
                    player.setPlayWhenReady(false);
                    player.setVolume(1.0f);
                } else if (this.firstContentItem.mediaIsVideo()) {
                    player.setPlayWhenReady(true);
                    player.setVolume(currentVolume);
                }
            }
        }
        return true;
    }

    String calculateDisplayTimestamp(long time) {
        long now = System.currentTimeMillis() / 1000L;
        long diff = now - time;
        if (diff < 60L) {
            return "Just Now";
        }
        if (diff > 60L && diff < 3540L) {
            return diff / 60L + " mins ago";
        }
        if (diff > 3540L && diff < 81420L) {
            return diff / 3600L > 1L ? diff / 3600L + " hours ago" : diff / 3600L + " hour ago";
        }
        if (diff > 86400L && diff < 172800L) {
            return "Yesterday";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM");
        return sdf.format(new Date(time * 1000L));
    }

    void configureWithMessage(CTInboxMessage inboxMessage, CTInboxListViewFragment parent, int position) {
        this.context = parent.getContext();
        this.parentWeakReference = new WeakReference<CTInboxListViewFragment>(parent);
        this.message = inboxMessage;
        this.firstContentItem = this.message.getInboxMessageContents().get(0);
        this.requiresMediaPlayer = this.firstContentItem.mediaIsAudio() || this.firstContentItem.mediaIsVideo();
    }

    int getImageBackgroundColor() {
        return 0;
    }

    CTInboxListViewFragment getParent() {
        return (CTInboxListViewFragment)((Object)this.parentWeakReference.get());
    }

    void hideOneButton(Button mainButton, Button secondaryButton, Button tertiaryButton) {
        tertiaryButton.setVisibility(8);
        LinearLayout.LayoutParams mainLayoutParams = new LinearLayout.LayoutParams(0, -1, 3.0f);
        mainButton.setLayoutParams((ViewGroup.LayoutParams)mainLayoutParams);
        LinearLayout.LayoutParams secondaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 3.0f);
        secondaryButton.setLayoutParams((ViewGroup.LayoutParams)secondaryLayoutParams);
        LinearLayout.LayoutParams tertiaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 0.0f);
        tertiaryButton.setLayoutParams((ViewGroup.LayoutParams)tertiaryLayoutParams);
    }

    void hideTwoButtons(Button mainButton, Button secondaryButton, Button tertiaryButton) {
        secondaryButton.setVisibility(8);
        tertiaryButton.setVisibility(8);
        LinearLayout.LayoutParams mainLayoutParams = new LinearLayout.LayoutParams(0, -1, 6.0f);
        mainButton.setLayoutParams((ViewGroup.LayoutParams)mainLayoutParams);
        LinearLayout.LayoutParams secondaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 0.0f);
        secondaryButton.setLayoutParams((ViewGroup.LayoutParams)secondaryLayoutParams);
        LinearLayout.LayoutParams tertiaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 0.0f);
        tertiaryButton.setLayoutParams((ViewGroup.LayoutParams)tertiaryLayoutParams);
    }

    public boolean needsMediaPlayer() {
        return this.requiresMediaPlayer;
    }

    public void playerBuffering() {
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(0);
        }
    }

    public void playerReady() {
        FrameLayout frameLayout = this.getLayoutForMediaPlayer();
        frameLayout.setVisibility(0);
        if (this.muteIcon != null) {
            this.muteIcon.setVisibility(0);
        }
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(8);
        }
    }

    public void playerRemoved() {
        FrameLayout frameLayout;
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(8);
        }
        if (this.muteIcon != null) {
            this.muteIcon.setVisibility(8);
        }
        if ((frameLayout = this.getLayoutForMediaPlayer()) != null) {
            frameLayout.removeAllViews();
        }
    }

    void setDots(ImageView[] dots, int dotsCount, Context appContext, LinearLayout sliderDots) {
        for (int k = 0; k < dotsCount; ++k) {
            dots[k] = new ImageView(appContext);
            dots[k].setVisibility(0);
            dots[k].setImageDrawable(ResourcesCompat.getDrawable((Resources)appContext.getResources(), (int)R.drawable.ct_unselected_dot, null));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.setMargins(8, 6, 4, 6);
            params.gravity = 17;
            if (sliderDots.getChildCount() >= dotsCount) continue;
            sliderDots.addView((View)dots[k], (ViewGroup.LayoutParams)params);
        }
    }

    public boolean shouldAutoPlay() {
        return this.firstContentItem.mediaIsVideo();
    }

    private FrameLayout getLayoutForMediaPlayer() {
        return this.frameLayout;
    }

    protected void markItemAsRead(final CTInboxMessage inboxMessage, final int position) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final CTInboxListViewFragment parent = CTInboxBaseMessageViewHolder.this.getParent();
                if (parent != null) {
                    FragmentActivity activity = parent.getActivity();
                    if (activity == null) {
                        return;
                    }
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CTInboxBaseMessageViewHolder.this.readDot.getVisibility() == 0) {
                                parent.didShow(null, position);
                            }
                            CTInboxBaseMessageViewHolder.this.readDot.setVisibility(8);
                            inboxMessage.setRead(true);
                        }
                    });
                }
            }
        };
        Handler handler = new Handler();
        handler.postDelayed(runnable, 2000L);
    }
}

