/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.BaseSessionManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.events.EventDetail;
import com.clevertap.android.sdk.validation.Validator;

public class SessionManager
extends BaseSessionManager {
    private long appLastSeen = 0L;
    private int lastVisitTime;
    private final CoreMetaData cleverTapMetaData;
    private final CleverTapInstanceConfig config;
    private final LocalDataStore localDataStore;
    private final Validator validator;

    public SessionManager(CleverTapInstanceConfig config, CoreMetaData coreMetaData, Validator validator, LocalDataStore localDataStore) {
        this.config = config;
        this.cleverTapMetaData = coreMetaData;
        this.validator = validator;
        this.localDataStore = localDataStore;
    }

    public void checkTimeoutSession() {
        if (this.appLastSeen <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.appLastSeen > 1200000L) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Session Timed Out");
            this.destroySession();
            CoreMetaData.setCurrentActivity(null);
        }
    }

    @Override
    public void destroySession() {
        this.cleverTapMetaData.setCurrentSessionId(0);
        this.cleverTapMetaData.setAppLaunchPushed(false);
        if (this.cleverTapMetaData.isFirstSession()) {
            this.cleverTapMetaData.setFirstSession(false);
        }
        this.config.getLogger().verbose(this.config.getAccountId(), "Session destroyed; Session ID is now 0");
        this.cleverTapMetaData.clearSource();
        this.cleverTapMetaData.clearMedium();
        this.cleverTapMetaData.clearCampaign();
        this.cleverTapMetaData.clearWzrkParams();
    }

    public long getAppLastSeen() {
        return this.appLastSeen;
    }

    public void setAppLastSeen(long appLastSeen) {
        this.appLastSeen = appLastSeen;
    }

    public int getLastVisitTime() {
        return this.lastVisitTime;
    }

    @Override
    public void lazyCreateSession(Context context) {
        if (!this.cleverTapMetaData.inCurrentSession()) {
            this.cleverTapMetaData.setFirstRequestInSession(true);
            if (this.validator != null) {
                this.validator.setDiscardedEvents(null);
            }
            this.createSession(context);
        }
    }

    void setLastVisitTime() {
        EventDetail ed = this.localDataStore.getEventDetail("App Launched");
        this.lastVisitTime = ed == null ? -1 : ed.getLastTime();
    }

    private void createSession(Context context) {
        int sessionId = (int)(System.currentTimeMillis() / 1000L);
        this.cleverTapMetaData.setCurrentSessionId(sessionId);
        this.config.getLogger().verbose(this.config.getAccountId(), "Session created with ID: " + this.cleverTapMetaData.getCurrentSessionId());
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        int lastSessionID = StorageHelper.getIntFromPrefs(context, this.config, "lastSessionId", 0);
        int lastSessionTime = StorageHelper.getIntFromPrefs(context, this.config, "sexe", 0);
        if (lastSessionTime > 0) {
            this.cleverTapMetaData.setLastSessionLength(lastSessionTime - lastSessionID);
        }
        this.config.getLogger().verbose(this.config.getAccountId(), "Last session length: " + this.cleverTapMetaData.getLastSessionLength() + " seconds");
        if (lastSessionID == 0) {
            this.cleverTapMetaData.setFirstSession(true);
        }
        SharedPreferences.Editor editor = prefs.edit().putInt(StorageHelper.storageKeyWithSuffix(this.config, "lastSessionId"), this.cleverTapMetaData.getCurrentSessionId());
        StorageHelper.persist(editor);
    }
}

