/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.core.app.NotificationManagerCompat;
import com.clevertap.android.sdk.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\u0012\u0010\u0007\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\f"}, d2={"targetSdkVersion", "", "Landroid/content/Context;", "getTargetSdkVersion", "(Landroid/content/Context;)I", "areAppNotificationsEnabled", "", "isNotificationChannelEnabled", "channelId", "", "isPackageAndOsTargetsAbove", "apiLevel", "clevertap-core_release"})
@JvmName(name="CTXtensions")
public final class CTXtensions {
    public static final boolean isPackageAndOsTargetsAbove(@NotNull Context $this$isPackageAndOsTargetsAbove, int apiLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackageAndOsTargetsAbove, (String)"<this>");
        return Build.VERSION.SDK_INT > apiLevel && CTXtensions.getTargetSdkVersion($this$isPackageAndOsTargetsAbove) > apiLevel;
    }

    public static final int getTargetSdkVersion(@NotNull Context $this$targetSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$targetSdkVersion, (String)"<this>");
        return $this$targetSdkVersion.getApplicationContext().getApplicationInfo().targetSdkVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotificationChannelEnabled(@NotNull Context $this$isNotificationChannelEnabled, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotificationChannelEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        if (Build.VERSION.SDK_INT >= 26) {
            if (!CTXtensions.areAppNotificationsEnabled($this$isNotificationChannelEnabled)) return false;
            try {
                Object object = $this$isNotificationChannelEnabled.getSystemService("notification");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                NotificationManager nm = (NotificationManager)object;
                if (nm.getNotificationChannel(channelId).getImportance() == 0) return false;
                return true;
            }
            catch (Exception e) {
                Logger.d("Unable to find notification channel with id = " + channelId);
                return false;
            }
        }
        boolean bl = CTXtensions.areAppNotificationsEnabled($this$isNotificationChannelEnabled);
        return bl;
    }

    public static final boolean areAppNotificationsEnabled(@NotNull Context $this$areAppNotificationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$areAppNotificationsEnabled, (String)"<this>");
        return NotificationManagerCompat.from((Context)$this$areAppNotificationsEnabled).areNotificationsEnabled();
    }
}

