/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inbox.CTInboxActivity;
import com.clevertap.android.sdk.inbox.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.inbox.CTInboxButtonClickListener;
import com.clevertap.android.sdk.inbox.CTInboxListViewFragment;
import com.clevertap.android.sdk.inbox.CTInboxMessage;
import com.clevertap.android.sdk.inbox.CTInboxMessageContent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CTSimpleMessageViewHolder
extends CTInboxBaseMessageViewHolder {
    private final Button cta1;
    private final Button cta2;
    private final Button cta3;
    private final TextView message;
    private final TextView timestamp;
    private final TextView title;

    CTSimpleMessageViewHolder(@NonNull View itemView) {
        super(itemView);
        itemView.setTag((Object)this);
        this.title = (TextView)itemView.findViewById(R.id.messageTitle);
        this.message = (TextView)itemView.findViewById(R.id.messageText);
        this.timestamp = (TextView)itemView.findViewById(R.id.timestamp);
        this.cta1 = (Button)itemView.findViewById(R.id.cta_button_1);
        this.cta2 = (Button)itemView.findViewById(R.id.cta_button_2);
        this.cta3 = (Button)itemView.findViewById(R.id.cta_button_3);
        this.mediaImage = (ImageView)itemView.findViewById(R.id.media_image);
        this.relativeLayout = (RelativeLayout)itemView.findViewById(R.id.simple_message_relative_layout);
        this.frameLayout = (FrameLayout)itemView.findViewById(R.id.simple_message_frame_layout);
        this.squareImage = (ImageView)itemView.findViewById(R.id.square_media_image);
        this.clickLayout = (RelativeLayout)itemView.findViewById(R.id.click_relative_layout);
        this.ctaLinearLayout = (LinearLayout)itemView.findViewById(R.id.cta_linear_layout);
        this.bodyRelativeLayout = (LinearLayout)itemView.findViewById(R.id.body_linear_layout);
        this.progressBarFrameLayout = (FrameLayout)itemView.findViewById(R.id.simple_progress_frame_layout);
        this.mediaLayout = (RelativeLayout)itemView.findViewById(R.id.media_layout);
    }

    @Override
    void configureWithMessage(CTInboxMessage inboxMessage, CTInboxListViewFragment parent, int position) {
        int width;
        int height;
        super.configureWithMessage(inboxMessage, parent, position);
        CTInboxListViewFragment parentWeak = this.getParent();
        CTInboxMessageContent content = inboxMessage.getInboxMessageContents().get(0);
        this.title.setText((CharSequence)content.getTitle());
        this.title.setTextColor(Color.parseColor((String)content.getTitleColor()));
        this.message.setText((CharSequence)content.getMessage());
        this.message.setTextColor(Color.parseColor((String)content.getMessageColor()));
        this.bodyRelativeLayout.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        String displayTimestamp = this.calculateDisplayTimestamp(inboxMessage.getDate());
        this.timestamp.setText((CharSequence)displayTimestamp);
        this.timestamp.setTextColor(Color.parseColor((String)content.getTitleColor()));
        if (inboxMessage.isRead()) {
            this.readDot.setVisibility(8);
        } else {
            this.readDot.setVisibility(0);
        }
        this.frameLayout.setVisibility(8);
        JSONArray linksArray = content.getLinks();
        if (linksArray != null) {
            this.ctaLinearLayout.setVisibility(0);
            int size = linksArray.length();
            try {
                switch (size) {
                    case 1: {
                        JSONObject cta1Object = linksArray.getJSONObject(0);
                        this.cta1.setVisibility(0);
                        this.cta1.setText((CharSequence)content.getLinkText(cta1Object));
                        this.cta1.setTextColor(Color.parseColor((String)content.getLinkColor(cta1Object)));
                        this.cta1.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta1Object)));
                        this.hideTwoButtons(this.cta1, this.cta2, this.cta3);
                        if (parentWeak == null) break;
                        this.cta1.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta1.getText().toString(), cta1Object, parentWeak, false));
                        break;
                    }
                    case 2: {
                        JSONObject cta1Object = linksArray.getJSONObject(0);
                        this.cta1.setVisibility(0);
                        this.cta1.setText((CharSequence)content.getLinkText(cta1Object));
                        this.cta1.setTextColor(Color.parseColor((String)content.getLinkColor(cta1Object)));
                        this.cta1.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta1Object)));
                        JSONObject cta2Object = linksArray.getJSONObject(1);
                        this.cta2.setVisibility(0);
                        this.cta2.setText((CharSequence)content.getLinkText(cta2Object));
                        this.cta2.setTextColor(Color.parseColor((String)content.getLinkColor(cta2Object)));
                        this.cta2.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta2Object)));
                        this.hideOneButton(this.cta1, this.cta2, this.cta3);
                        if (parentWeak == null) break;
                        this.cta1.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta1.getText().toString(), cta1Object, parentWeak, false));
                        this.cta2.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta2.getText().toString(), cta2Object, parentWeak, false));
                        break;
                    }
                    case 3: {
                        JSONObject cta1Object = linksArray.getJSONObject(0);
                        this.cta1.setVisibility(0);
                        this.cta1.setText((CharSequence)content.getLinkText(cta1Object));
                        this.cta1.setTextColor(Color.parseColor((String)content.getLinkColor(cta1Object)));
                        this.cta1.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta1Object)));
                        JSONObject cta2Object = linksArray.getJSONObject(1);
                        this.cta2.setVisibility(0);
                        this.cta2.setText((CharSequence)content.getLinkText(cta2Object));
                        this.cta2.setTextColor(Color.parseColor((String)content.getLinkColor(cta2Object)));
                        this.cta2.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta2Object)));
                        JSONObject cta3Object = linksArray.getJSONObject(2);
                        this.cta3.setVisibility(0);
                        this.cta3.setText((CharSequence)content.getLinkText(cta3Object));
                        this.cta3.setTextColor(Color.parseColor((String)content.getLinkColor(cta3Object)));
                        this.cta3.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta3Object)));
                        if (parentWeak == null) break;
                        this.cta1.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta1.getText().toString(), cta1Object, parentWeak, false));
                        this.cta2.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta2.getText().toString(), cta2Object, parentWeak, false));
                        this.cta3.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta3.getText().toString(), cta3Object, parentWeak, false));
                    }
                }
            }
            catch (JSONException e) {
                Logger.d("Error parsing CTA JSON - " + e.getLocalizedMessage());
            }
        } else {
            this.ctaLinearLayout.setVisibility(8);
        }
        this.mediaImage.setVisibility(8);
        this.mediaImage.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        this.squareImage.setVisibility(8);
        this.squareImage.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        this.mediaLayout.setVisibility(8);
        this.progressBarFrameLayout.setVisibility(8);
        try {
            switch (inboxMessage.getOrientation()) {
                case "l": {
                    if (content.mediaIsImage()) {
                        this.mediaLayout.setVisibility(0);
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        try {
                            Glide.with((Context)this.mediaImage.getContext()).load(content.getMedia()).apply(((RequestOptions)new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image"))).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(this.mediaImage);
                        }
                        catch (NoSuchMethodError error) {
                            Logger.d("CleverTap SDK requires Glide v4.9.0 or above. Please refer CleverTap Documentation for more info");
                            Glide.with((Context)this.mediaImage.getContext()).load(content.getMedia()).into(this.mediaImage);
                        }
                        break;
                    }
                    if (content.mediaIsGIF()) {
                        this.mediaLayout.setVisibility(0);
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        try {
                            Glide.with((Context)this.mediaImage.getContext()).asGif().load(content.getMedia()).apply(((RequestOptions)new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image"))).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(this.mediaImage);
                        }
                        catch (NoSuchMethodError error) {
                            Logger.d("CleverTap SDK requires Glide v4.9.0 or above. Please refer CleverTap Documentation for more info");
                            Glide.with((Context)this.mediaImage.getContext()).asGif().load(content.getMedia()).into(this.mediaImage);
                        }
                        break;
                    }
                    if (content.mediaIsVideo()) {
                        if (!content.getPosterUrl().isEmpty()) {
                            this.mediaLayout.setVisibility(0);
                            this.mediaImage.setVisibility(0);
                            this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                            try {
                                Glide.with((Context)this.mediaImage.getContext()).load(content.getPosterUrl()).apply(((RequestOptions)new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_video_1"))).error(Utils.getThumbnailImage(this.context, "ct_video_1"))).into(this.mediaImage);
                            }
                            catch (NoSuchMethodError error) {
                                Logger.d("CleverTap SDK requires Glide v4.9.0 or above. Please refer CleverTap Documentation for more info");
                                Glide.with((Context)this.mediaImage.getContext()).load(content.getPosterUrl()).into(this.mediaImage);
                            }
                            break;
                        }
                        this.mediaLayout.setVisibility(0);
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        int drawableId = Utils.getThumbnailImage(this.context, "ct_video_1");
                        if (drawableId != -1) {
                            Glide.with((Context)this.mediaImage.getContext()).load(Integer.valueOf(drawableId)).into(this.mediaImage);
                        }
                    } else {
                        if (!content.mediaIsAudio()) break;
                        this.mediaLayout.setVisibility(0);
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        this.mediaImage.setBackgroundColor(this.getImageBackgroundColor());
                        int drawableId = Utils.getThumbnailImage(this.context, "ct_audio");
                        if (drawableId != -1) {
                            Glide.with((Context)this.mediaImage.getContext()).load(Integer.valueOf(drawableId)).into(this.mediaImage);
                        }
                    }
                    break;
                }
                case "p": {
                    if (content.mediaIsImage()) {
                        this.mediaLayout.setVisibility(0);
                        this.squareImage.setVisibility(0);
                        this.squareImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        try {
                            Glide.with((Context)this.squareImage.getContext()).load(content.getMedia()).apply(((RequestOptions)new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image"))).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(this.squareImage);
                        }
                        catch (NoSuchMethodError error) {
                            Logger.d("CleverTap SDK requires Glide v4.9.0 or above. Please refer CleverTap Documentation for more info");
                            Glide.with((Context)this.squareImage.getContext()).load(content.getMedia()).into(this.squareImage);
                        }
                        break;
                    }
                    if (content.mediaIsGIF()) {
                        this.mediaLayout.setVisibility(0);
                        this.squareImage.setVisibility(0);
                        this.squareImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        try {
                            Glide.with((Context)this.squareImage.getContext()).asGif().load(content.getMedia()).apply(((RequestOptions)new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image"))).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(this.squareImage);
                        }
                        catch (NoSuchMethodError error) {
                            Logger.d("CleverTap SDK requires Glide v4.9.0 or above. Please refer CleverTap Documentation for more info");
                            Glide.with((Context)this.squareImage.getContext()).asGif().load(content.getMedia()).into(this.squareImage);
                        }
                        break;
                    }
                    if (content.mediaIsVideo()) {
                        if (!content.getPosterUrl().isEmpty()) {
                            this.mediaLayout.setVisibility(0);
                            this.squareImage.setVisibility(0);
                            if (CTInboxActivity.orientation == 2) {
                                this.squareImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                            } else {
                                this.squareImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                            }
                            try {
                                Glide.with((Context)this.squareImage.getContext()).load(content.getPosterUrl()).apply(((RequestOptions)new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_video_1"))).error(Utils.getThumbnailImage(this.context, "ct_video_1"))).into(this.squareImage);
                            }
                            catch (NoSuchMethodError error) {
                                Logger.d("CleverTap SDK requires Glide v4.9.0 or above. Please refer CleverTap Documentation for more info");
                                Glide.with((Context)this.squareImage.getContext()).load(content.getPosterUrl()).into(this.squareImage);
                            }
                            break;
                        }
                        this.mediaLayout.setVisibility(0);
                        this.squareImage.setVisibility(0);
                        if (CTInboxActivity.orientation == 2) {
                            this.squareImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        } else {
                            this.squareImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        }
                        int drawableId = Utils.getThumbnailImage(this.context, "ct_video_1");
                        if (drawableId != -1) {
                            Glide.with((Context)this.squareImage.getContext()).load(Integer.valueOf(drawableId)).into(this.squareImage);
                        }
                        break;
                    }
                    if (!content.mediaIsAudio()) break;
                    this.mediaLayout.setVisibility(0);
                    this.squareImage.setVisibility(0);
                    this.squareImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    this.squareImage.setBackgroundColor(this.getImageBackgroundColor());
                    int drawableId = Utils.getThumbnailImage(this.context, "ct_audio");
                    if (drawableId == -1) break;
                    Glide.with((Context)this.squareImage.getContext()).load(Integer.valueOf(drawableId)).into(this.squareImage);
                }
            }
        }
        catch (NoClassDefFoundError error) {
            Logger.d("CleverTap SDK requires Glide dependency. Please refer CleverTap Documentation for more info");
        }
        Resources resources = this.context.getResources();
        if (CTInboxActivity.orientation == 2) {
            height = resources.getDisplayMetrics().heightPixels / 2;
            width = resources.getDisplayMetrics().widthPixels / 2;
        } else {
            width = resources.getDisplayMetrics().widthPixels;
            height = inboxMessage.getOrientation().equalsIgnoreCase("l") ? Math.round((float)width * 0.5625f) : width;
        }
        this.progressBarFrameLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, height));
        this.markItemAsRead(inboxMessage, position);
        if (parentWeak != null) {
            this.clickLayout.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, null, null, parentWeak, true));
        }
    }
}

