/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.displayunits;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnit;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class CTDisplayUnitController {
    final HashMap<String, CleverTapDisplayUnit> items = new HashMap();

    @Nullable
    public synchronized ArrayList<CleverTapDisplayUnit> getAllDisplayUnits() {
        if (!this.items.isEmpty()) {
            return new ArrayList<CleverTapDisplayUnit>(this.items.values());
        }
        Logger.d("DisplayUnit : ", "Failed to return Display Units, nothing found in the cache");
        return null;
    }

    @Nullable
    public synchronized CleverTapDisplayUnit getDisplayUnitForID(String unitId) {
        if (!TextUtils.isEmpty((CharSequence)unitId)) {
            return this.items.get(unitId);
        }
        Logger.d("DisplayUnit : ", "Can't return Display Unit, id was null");
        return null;
    }

    public synchronized void reset() {
        this.items.clear();
        Logger.d("DisplayUnit : ", "Cleared Display Units Cache");
    }

    @Nullable
    public synchronized ArrayList<CleverTapDisplayUnit> updateDisplayUnits(JSONArray messages) {
        this.reset();
        if (messages != null && messages.length() > 0) {
            ArrayList<CleverTapDisplayUnit> list = new ArrayList<CleverTapDisplayUnit>();
            try {
                for (int i = 0; i < messages.length(); ++i) {
                    CleverTapDisplayUnit item = CleverTapDisplayUnit.toDisplayUnit((JSONObject)messages.get(i));
                    if (TextUtils.isEmpty((CharSequence)item.getError())) {
                        this.items.put(item.getUnitID(), item);
                        list.add(item);
                        continue;
                    }
                    Logger.d("DisplayUnit : ", "Failed to convert JsonArray item at index:" + i + " to Display Unit");
                }
            }
            catch (Exception e) {
                Logger.d("DisplayUnit : ", "Failed while parsing Display Unit:" + e.getLocalizedMessage());
                return null;
            }
            return !list.isEmpty() ? list : null;
        }
        Logger.d("DisplayUnit : ", "Null json array response can't parse Display Units ");
        return null;
    }
}

