/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class StorageHelper {
    public static SharedPreferences getPreferences(@NonNull Context context, String namespace) {
        String path = "WizRocket";
        if (namespace != null) {
            path = path + "_" + namespace;
        }
        return context.getSharedPreferences(path, 0);
    }

    public static SharedPreferences getPreferences(@NonNull Context context) {
        return StorageHelper.getPreferences(context, null);
    }

    public static String getString(@NonNull Context context, @NonNull String key, String defaultValue) {
        return StorageHelper.getPreferences(context).getString(key, defaultValue);
    }

    public static String getStringFromPrefs(@NonNull Context context, @NonNull CleverTapInstanceConfig config, String rawKey, String defaultValue) {
        if (config.isDefaultInstance()) {
            String _new = StorageHelper.getString(context, StorageHelper.storageKeyWithSuffix(config, rawKey), defaultValue);
            return _new != null ? _new : StorageHelper.getString(context, rawKey, defaultValue);
        }
        return StorageHelper.getString(context, StorageHelper.storageKeyWithSuffix(config, rawKey), defaultValue);
    }

    public static void persist(SharedPreferences.Editor editor) {
        try {
            editor.apply();
        }
        catch (Throwable t) {
            Logger.v("CRITICAL: Failed to persist shared preferences!", t);
        }
    }

    @WorkerThread
    public static void persistImmediately(SharedPreferences.Editor editor) {
        try {
            editor.commit();
        }
        catch (Throwable t) {
            Logger.v("CRITICAL: Failed to persist shared preferences!", t);
        }
    }

    public static void putString(Context context, String key, String value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putString(key, value);
        StorageHelper.persist(editor);
    }

    public static void putString(Context context, CleverTapInstanceConfig config, String key, String value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putString(StorageHelper.storageKeyWithSuffix(config, key), value);
        StorageHelper.persist(editor);
    }

    public static void putStringImmediate(Context context, String key, String value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putString(key, value);
        StorageHelper.persistImmediately(editor);
    }

    public static void remove(Context context, String key) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().remove(key);
        StorageHelper.persist(editor);
    }

    public static void removeImmediate(Context context, String key) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().remove(key);
        StorageHelper.persistImmediately(editor);
    }

    public static String storageKeyWithSuffix(@NonNull CleverTapInstanceConfig config, @NonNull String key) {
        return key + ":" + config.getAccountId();
    }

    static boolean getBoolean(Context context, String key, boolean defaultValue) {
        return StorageHelper.getPreferences(context).getBoolean(key, defaultValue);
    }

    static boolean getBooleanFromPrefs(Context context, CleverTapInstanceConfig config, String rawKey) {
        if (config.isDefaultInstance()) {
            boolean _new = StorageHelper.getBoolean(context, StorageHelper.storageKeyWithSuffix(config, rawKey), false);
            return !_new ? StorageHelper.getBoolean(context, rawKey, false) : _new;
        }
        return StorageHelper.getBoolean(context, StorageHelper.storageKeyWithSuffix(config, rawKey), false);
    }

    public static int getInt(Context context, String key, int defaultValue) {
        return StorageHelper.getPreferences(context).getInt(key, defaultValue);
    }

    public static int getIntFromPrefs(Context context, CleverTapInstanceConfig config, String rawKey, int defaultValue) {
        if (config.isDefaultInstance()) {
            int dummy = -1000;
            int _new = StorageHelper.getInt(context, StorageHelper.storageKeyWithSuffix(config, rawKey), dummy);
            return _new != dummy ? _new : StorageHelper.getInt(context, rawKey, defaultValue);
        }
        return StorageHelper.getInt(context, StorageHelper.storageKeyWithSuffix(config, rawKey), defaultValue);
    }

    static long getLong(Context context, String key, long defaultValue) {
        return StorageHelper.getPreferences(context).getLong(key, defaultValue);
    }

    static long getLong(Context context, String nameSpace, String key, long defaultValue) {
        return StorageHelper.getPreferences(context, nameSpace).getLong(key, defaultValue);
    }

    public static long getLongFromPrefs(Context context, CleverTapInstanceConfig config, String rawKey, int defaultValue, String nameSpace) {
        if (config.isDefaultInstance()) {
            long dummy = -1000L;
            long _new = StorageHelper.getLong(context, nameSpace, StorageHelper.storageKeyWithSuffix(config, rawKey), dummy);
            return _new != dummy ? _new : StorageHelper.getLong(context, nameSpace, rawKey, defaultValue);
        }
        return StorageHelper.getLong(context, nameSpace, StorageHelper.storageKeyWithSuffix(config, rawKey), defaultValue);
    }

    static String getString(Context context, String nameSpace, String key, String defaultValue) {
        return StorageHelper.getPreferences(context, nameSpace).getString(key, defaultValue);
    }

    static void putBoolean(Context context, String key, boolean value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putBoolean(key, value);
        StorageHelper.persist(editor);
    }

    public static void putInt(Context context, String key, int value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putInt(key, value);
        StorageHelper.persist(editor);
    }

    static void putLong(Context context, String key, long value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putLong(key, value);
        StorageHelper.persist(editor);
    }
}

