/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTFeatureFlagsListener;
import com.clevertap.android.sdk.CTInboxListener;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.FailureFlushListener;
import com.clevertap.android.sdk.GeofenceCallback;
import com.clevertap.android.sdk.InAppNotificationButtonListener;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.SyncListener;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.displayunits.DisplayUnitListener;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnit;
import com.clevertap.android.sdk.interfaces.NotificationRenderedListener;
import com.clevertap.android.sdk.interfaces.OnInitCleverTapIDListener;
import com.clevertap.android.sdk.interfaces.SCDomainListener;
import com.clevertap.android.sdk.product_config.CTProductConfigListener;
import com.clevertap.android.sdk.pushnotification.CTPushNotificationListener;
import com.clevertap.android.sdk.pushnotification.amp.CTPushAmpListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CallbackManager
extends BaseCallbackManager {
    private WeakReference<DisplayUnitListener> displayUnitListenerWeakReference;
    private GeofenceCallback geofenceCallback;
    private SCDomainListener scDomainListener;
    private WeakReference<InAppNotificationButtonListener> inAppNotificationButtonListener;
    private InAppNotificationListener inAppNotificationListener;
    private CTInboxListener inboxListener;
    private final CleverTapInstanceConfig config;
    private final DeviceInfo deviceInfo;
    private FailureFlushListener failureFlushListener;
    private WeakReference<CTFeatureFlagsListener> featureFlagListenerWeakReference;
    private NotificationRenderedListener notificationRenderedListener;
    private OnInitCleverTapIDListener onInitCleverTapIDListener;
    private WeakReference<CTProductConfigListener> productConfigListener;
    private CTPushAmpListener pushAmpListener = null;
    private CTPushNotificationListener pushNotificationListener = null;
    private SyncListener syncListener = null;

    public CallbackManager(CleverTapInstanceConfig config, DeviceInfo deviceInfo) {
        this.config = config;
        this.deviceInfo = deviceInfo;
    }

    @Override
    public void _notifyInboxMessagesDidUpdate() {
        if (this.inboxListener != null) {
            Utils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (CallbackManager.this.inboxListener != null) {
                        CallbackManager.this.inboxListener.inboxMessagesDidUpdate();
                    }
                }
            });
        }
    }

    @Override
    public FailureFlushListener getFailureFlushListener() {
        return this.failureFlushListener;
    }

    @Override
    public void setFailureFlushListener(FailureFlushListener failureFlushListener) {
        this.failureFlushListener = failureFlushListener;
    }

    @Override
    public CTFeatureFlagsListener getFeatureFlagListener() {
        if (this.featureFlagListenerWeakReference != null && this.featureFlagListenerWeakReference.get() != null) {
            return (CTFeatureFlagsListener)this.featureFlagListenerWeakReference.get();
        }
        return null;
    }

    @Override
    public void setFeatureFlagListener(CTFeatureFlagsListener listener) {
        this.featureFlagListenerWeakReference = new WeakReference<CTFeatureFlagsListener>(listener);
    }

    @Override
    public GeofenceCallback getGeofenceCallback() {
        return this.geofenceCallback;
    }

    @Override
    public void setGeofenceCallback(GeofenceCallback geofenceCallback) {
        this.geofenceCallback = geofenceCallback;
    }

    @Override
    public SCDomainListener getSCDomainListener() {
        return this.scDomainListener;
    }

    @Override
    public void setSCDomainListener(SCDomainListener scDomainListener) {
        this.scDomainListener = scDomainListener;
    }

    @Override
    public InAppNotificationButtonListener getInAppNotificationButtonListener() {
        if (this.inAppNotificationButtonListener != null && this.inAppNotificationButtonListener.get() != null) {
            return (InAppNotificationButtonListener)this.inAppNotificationButtonListener.get();
        }
        return null;
    }

    @Override
    public void setInAppNotificationButtonListener(InAppNotificationButtonListener inAppNotificationButtonListener) {
        this.inAppNotificationButtonListener = new WeakReference<InAppNotificationButtonListener>(inAppNotificationButtonListener);
    }

    @Override
    public InAppNotificationListener getInAppNotificationListener() {
        return this.inAppNotificationListener;
    }

    @Override
    public void setInAppNotificationListener(InAppNotificationListener inAppNotificationListener) {
        this.inAppNotificationListener = inAppNotificationListener;
    }

    @Override
    public CTInboxListener getInboxListener() {
        return this.inboxListener;
    }

    @Override
    public void setInboxListener(CTInboxListener inboxListener) {
        this.inboxListener = inboxListener;
    }

    @Override
    public CTProductConfigListener getProductConfigListener() {
        if (this.productConfigListener != null && this.productConfigListener.get() != null) {
            return (CTProductConfigListener)this.productConfigListener.get();
        }
        return null;
    }

    @Override
    public void setProductConfigListener(CTProductConfigListener productConfigListener) {
        if (productConfigListener != null) {
            this.productConfigListener = new WeakReference<CTProductConfigListener>(productConfigListener);
        }
    }

    @Override
    public CTPushAmpListener getPushAmpListener() {
        return this.pushAmpListener;
    }

    @Override
    public void setPushAmpListener(CTPushAmpListener pushAmpListener) {
        this.pushAmpListener = pushAmpListener;
    }

    @Override
    public CTPushNotificationListener getPushNotificationListener() {
        return this.pushNotificationListener;
    }

    @Override
    public void setPushNotificationListener(CTPushNotificationListener pushNotificationListener) {
        this.pushNotificationListener = pushNotificationListener;
    }

    @Override
    public SyncListener getSyncListener() {
        return this.syncListener;
    }

    @Override
    public void setSyncListener(SyncListener syncListener) {
        this.syncListener = syncListener;
    }

    @Override
    public OnInitCleverTapIDListener getOnInitCleverTapIDListener() {
        return this.onInitCleverTapIDListener;
    }

    @Override
    public void setOnInitCleverTapIDListener(OnInitCleverTapIDListener onInitCleverTapIDListener) {
        this.onInitCleverTapIDListener = onInitCleverTapIDListener;
    }

    @Override
    public void setNotificationRenderedListener(NotificationRenderedListener notificationRenderedListener) {
        this.notificationRenderedListener = notificationRenderedListener;
    }

    @Override
    public NotificationRenderedListener getNotificationRenderedListener() {
        return this.notificationRenderedListener;
    }

    @Override
    public void notifyUserProfileInitialized(String deviceID) {
        String string = deviceID = deviceID != null ? deviceID : this.deviceInfo.getDeviceID();
        if (deviceID == null) {
            return;
        }
        try {
            SyncListener sl = this.getSyncListener();
            if (sl != null) {
                sl.profileDidInitialize(deviceID);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setDisplayUnitListener(DisplayUnitListener listener) {
        if (listener != null) {
            this.displayUnitListenerWeakReference = new WeakReference<DisplayUnitListener>(listener);
        } else {
            this.config.getLogger().verbose(this.config.getAccountId(), "DisplayUnit : Failed to set - DisplayUnitListener can't be null");
        }
    }

    @Override
    void _notifyInboxInitialized() {
        if (this.inboxListener != null) {
            this.inboxListener.inboxDidInitialize();
        }
    }

    @Override
    public void notifyDisplayUnitsLoaded(final ArrayList<CleverTapDisplayUnit> displayUnits) {
        if (displayUnits != null && !displayUnits.isEmpty()) {
            if (this.displayUnitListenerWeakReference != null && this.displayUnitListenerWeakReference.get() != null) {
                Utils.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (CallbackManager.this.displayUnitListenerWeakReference != null && CallbackManager.this.displayUnitListenerWeakReference.get() != null) {
                            ((DisplayUnitListener)CallbackManager.this.displayUnitListenerWeakReference.get()).onDisplayUnitsLoaded(displayUnits);
                        }
                    }
                });
            } else {
                this.config.getLogger().verbose(this.config.getAccountId(), "DisplayUnit : No registered listener, failed to notify");
            }
        } else {
            this.config.getLogger().verbose(this.config.getAccountId(), "DisplayUnit : No Display Units found");
        }
    }

    @Override
    void notifyUserProfileInitialized() {
        this.notifyUserProfileInitialized(this.deviceInfo.getDeviceID());
    }
}

