/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.util.concurrent.Callable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppResponse
extends CleverTapResponseDecorator {
    private final CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final ControllerManager controllerManager;
    private final boolean isSendTest;
    private final Logger logger;

    public InAppResponse(CleverTapResponse cleverTapResponse, CleverTapInstanceConfig config, ControllerManager controllerManager, boolean isSendTest) {
        this.cleverTapResponse = cleverTapResponse;
        this.config = config;
        this.logger = this.config.getLogger();
        this.controllerManager = controllerManager;
        this.isSendTest = isSendTest;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, final Context context) {
        try {
            JSONArray inappNotifs;
            if (this.config.isAnalyticsOnly()) {
                this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing inapp messages");
                this.cleverTapResponse.processResponse(response, stringBody, context);
                return;
            }
            this.logger.verbose(this.config.getAccountId(), "InApp: Processing response");
            if (!response.has("inapp_notifs")) {
                this.logger.verbose(this.config.getAccountId(), "InApp: Response JSON object doesn't contain the inapp key, failing");
                this.cleverTapResponse.processResponse(response, stringBody, context);
                return;
            }
            int perSession = 10;
            int perDay = 10;
            if (response.has("imc") && response.get("imc") instanceof Integer) {
                perSession = response.getInt("imc");
            }
            if (response.has("imp") && response.get("imp") instanceof Integer) {
                perDay = response.getInt("imp");
            }
            if (!this.isSendTest && this.controllerManager.getInAppFCManager() != null) {
                Logger.v("Updating InAppFC Limits");
                this.controllerManager.getInAppFCManager().updateLimits(context, perDay, perSession);
                this.controllerManager.getInAppFCManager().processResponse(context, response);
            } else {
                this.logger.verbose(this.config.getAccountId(), "controllerManager.getInAppFCManager() is NULL, not Updating InAppFC Limits");
            }
            try {
                inappNotifs = response.getJSONArray("inapp_notifs");
            }
            catch (JSONException e) {
                this.logger.debug(this.config.getAccountId(), "InApp: In-app key didn't contain a valid JSON array");
                this.cleverTapResponse.processResponse(response, stringBody, context);
                return;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context);
            SharedPreferences.Editor editor = prefs.edit();
            try {
                JSONArray inappsFromPrefs = new JSONArray(StorageHelper.getStringFromPrefs(context, this.config, "inApp", "[]"));
                if (inappNotifs != null && inappNotifs.length() > 0) {
                    for (int i = 0; i < inappNotifs.length(); ++i) {
                        try {
                            JSONObject inappNotif = inappNotifs.getJSONObject(i);
                            inappsFromPrefs.put((Object)inappNotif);
                            continue;
                        }
                        catch (JSONException e) {
                            Logger.v("InAppManager: Malformed inapp notification");
                        }
                    }
                }
                editor.putString(StorageHelper.storageKeyWithSuffix(this.config, "inApp"), inappsFromPrefs.toString());
                StorageHelper.persist(editor);
            }
            catch (Throwable e) {
                this.logger.verbose(this.config.getAccountId(), "InApp: Failed to parse the in-app notifications properly");
                this.logger.verbose(this.config.getAccountId(), "InAppManager: Reason: " + e.getMessage(), e);
            }
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
            task.execute("InAppResponse#processResponse", new Callable<Void>(){

                @Override
                public Void call() {
                    InAppResponse.this.controllerManager.getInAppController().showNotificationIfAvailable(context);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            Logger.v("InAppManager: Failed to parse response", t);
        }
        this.cleverTapResponse.processResponse(response, stringBody, context);
    }
}

