/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.util.LruCache;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jacoco.agent.rt.internal_28bab1d.Offline;

public class ImageCache {
    private static final int MIN_CACHE_SIZE = 20480;
    private static final int maxMemory;
    private static final int cacheSize;
    private static final int MAX_BITMAP_SIZE = 10000000;
    private static final String DIRECTORY_NAME = "CleverTap.Images.";
    private static final String FILE_PREFIX = "CT_IMAGE_";
    private static LruCache<String, Bitmap> memoryCache;
    private static File imageFileDirectory;
    private static MessageDigest messageDigest;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public ImageCache() {
        boolean[] blArray = ImageCache.$jacocoInit();
        blArray[0] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean addBitmap(String string, Bitmap bitmap) {
        String key;
        boolean[] blArray = ImageCache.$jacocoInit();
        if (memoryCache == null) {
            blArray[1] = true;
            return false;
        }
        if (ImageCache.getBitmapFromMemCache(key) != null) {
            blArray[2] = true;
        } else {
            Class<ImageCache> clazz = ImageCache.class;
            // MONITORENTER : com.clevertap.android.sdk.utils.ImageCache.class
            try {
                void available;
                void imageSize;
                void bitmap2;
                blArray[3] = true;
                int n = ImageCache.getImageSizeInKB((Bitmap)bitmap2);
                blArray[4] = true;
                int n2 = ImageCache.getAvailableMemory();
                blArray[5] = true;
                Logger.v("CleverTap.ImageCache: image size: " + (int)imageSize + "KB. Available mem: " + (int)available + "KB.");
                blArray[6] = true;
                if (imageSize > ImageCache.getAvailableMemory()) {
                    blArray[8] = true;
                    Logger.v("CleverTap.ImageCache: insufficient memory to add image: " + key);
                    // MONITOREXIT : clazz
                    blArray[9] = true;
                    return false;
                }
                blArray[7] = true;
                memoryCache.put((Object)key, (Object)bitmap2);
                blArray[10] = true;
                Logger.v("CleverTap.ImageCache: added image for key: " + key);
                // MONITOREXIT : clazz
                blArray[11] = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT : clazz
                blArray[12] = true;
                throw throwable;
            }
        }
        blArray[13] = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmap(String string) {
        boolean[] blArray = ImageCache.$jacocoInit();
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            block7: {
                Bitmap bitmap;
                try {
                    String key;
                    blArray[14] = true;
                    if (key == null) {
                        blArray[15] = true;
                        break block7;
                    }
                    blArray[16] = true;
                    if (memoryCache == null) {
                        bitmap = null;
                        blArray[17] = true;
                    } else {
                        bitmap = (Bitmap)memoryCache.get((Object)key);
                        blArray[18] = true;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    blArray[19] = true;
                }
                catch (Throwable throwable) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    blArray[21] = true;
                    throw throwable;
                }
                return bitmap;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            blArray[20] = true;
            return null;
        }
    }

    public static Bitmap getOrFetchBitmap(String string) {
        String url;
        boolean[] blArray = ImageCache.$jacocoInit();
        Bitmap bitmap = ImageCache.getBitmap(url);
        if (bitmap != null) {
            blArray[22] = true;
        } else {
            blArray[23] = true;
            File imageFile = ImageCache.getOrFetchAndWriteImageFile(url);
            if (imageFile != null) {
                blArray[24] = true;
                bitmap = ImageCache.decodeImageFromFile(imageFile);
                blArray[25] = true;
                ImageCache.addBitmap(url, bitmap);
                blArray[26] = true;
            } else {
                blArray[27] = true;
                return null;
            }
        }
        blArray[28] = true;
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void init() {
        boolean[] blArray = ImageCache.$jacocoInit();
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            try {
                blArray[29] = true;
                if (memoryCache != null) {
                    blArray[30] = true;
                } else {
                    blArray[31] = true;
                    Logger.v("CleverTap.ImageCache: init with max device memory: " + maxMemory + "KB and allocated cache size: " + cacheSize + "KB");
                    try {
                        blArray[32] = true;
                        memoryCache = new LruCache<String, Bitmap>(cacheSize){
                            private static transient /* synthetic */ boolean[] $jacocoData;
                            {
                                void maxSize;
                                boolean[] blArray = 1.$jacocoInit();
                                super((int)maxSize);
                                blArray[0] = true;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            protected int sizeOf(String string, Bitmap bitmap) {
                                void key;
                                void size;
                                void bitmap2;
                                boolean[] blArray = 1.$jacocoInit();
                                int n = ImageCache.access$000((Bitmap)bitmap2);
                                blArray[1] = true;
                                Logger.v("CleverTap.ImageCache: have image of size: " + (int)size + "KB for key: " + (String)key);
                                blArray[2] = true;
                                return (int)size;
                            }

                            private static /* synthetic */ boolean[] $jacocoInit() {
                                boolean[] blArray = $jacocoData;
                                if ($jacocoData == null) {
                                    blArray = $jacocoData = Offline.getProbes((long)-3732303478356255810L, (String)"com/clevertap/android/sdk/utils/ImageCache$1", (int)4);
                                }
                                return blArray;
                            }
                        };
                        blArray[33] = true;
                    }
                    catch (Throwable throwable) {
                        void t;
                        blArray[34] = true;
                        Logger.v("CleverTap.ImageCache: unable to initialize cache: ", t.getCause());
                        blArray[35] = true;
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            catch (Throwable throwable) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                blArray[36] = true;
                throw throwable;
            }
            blArray[37] = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initWithPersistence(Context context) {
        boolean[] blArray = ImageCache.$jacocoInit();
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            try {
                blArray[38] = true;
                if (imageFileDirectory != null) {
                    blArray[39] = true;
                } else {
                    Context context2;
                    blArray[40] = true;
                    imageFileDirectory = context2.getDir(DIRECTORY_NAME, 0);
                    blArray[41] = true;
                }
                if (messageDigest != null) {
                    blArray[42] = true;
                } else {
                    try {
                        blArray[43] = true;
                        messageDigest = MessageDigest.getInstance("SHA256");
                        blArray[44] = true;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        blArray[45] = true;
                        Logger.d("CleverTap.ImageCache: image file system caching unavailable as SHA1 hash function not available on platform");
                        blArray[46] = true;
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            catch (Throwable throwable) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                blArray[47] = true;
                throw throwable;
            }
            ImageCache.init();
            blArray[48] = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void removeBitmap(String string, boolean bl) {
        boolean[] blArray = ImageCache.$jacocoInit();
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            String key;
            try {
                void isPersisted;
                blArray[49] = true;
                if (isPersisted == false) {
                    blArray[50] = true;
                } else {
                    blArray[51] = true;
                    ImageCache.removeFromFileSystem(key);
                    blArray[52] = true;
                }
                if (memoryCache == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    blArray[54] = true;
                    return;
                }
                blArray[53] = true;
            }
            catch (Throwable throwable) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                blArray[57] = true;
                throw throwable;
            }
            memoryCache.remove((Object)key);
            blArray[55] = true;
            Logger.v("CleverTap.ImageCache: removed image for key: " + key);
            blArray[56] = true;
            ImageCache.cleanup();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            blArray[58] = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanup() {
        boolean[] blArray = ImageCache.$jacocoInit();
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            try {
                blArray[59] = true;
                if (!ImageCache.isEmpty()) {
                    blArray[60] = true;
                } else {
                    blArray[61] = true;
                    Logger.v("CTInAppNotification.ImageCache: cache is empty, removing it");
                    memoryCache = null;
                    blArray[62] = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            catch (Throwable throwable) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                blArray[63] = true;
                throw throwable;
            }
            blArray[64] = true;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Bitmap decodeImageFromFile(File file) {
        void imageSizeKb;
        File file2;
        boolean[] blArray = ImageCache.$jacocoInit();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        blArray[65] = true;
        BitmapFactory.decodeFile((String)file2.getAbsolutePath(), (BitmapFactory.Options)options);
        float imageSize = (float)options.outHeight * (float)options.outWidth * 4.0f;
        float f = imageSize / 1024.0f;
        blArray[66] = true;
        if (imageSizeKb > (float)ImageCache.getAvailableMemory()) {
            blArray[67] = true;
            Logger.v("CleverTap.ImageCache: image too large to decode");
            blArray[68] = true;
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)file2.getAbsolutePath());
        if (bitmap != null) {
            blArray[69] = true;
        } else {
            blArray[70] = true;
            file2.delete();
            blArray[71] = true;
        }
        blArray[72] = true;
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getAvailableMemory() {
        boolean[] blArray = ImageCache.$jacocoInit();
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            int n;
            try {
                blArray[73] = true;
                if (memoryCache == null) {
                    n = 0;
                    blArray[74] = true;
                } else {
                    n = cacheSize - memoryCache.size();
                    blArray[75] = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                blArray[76] = true;
            }
            catch (Throwable throwable) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                blArray[77] = true;
                throw throwable;
            }
            return n;
        }
    }

    private static Bitmap getBitmapFromMemCache(String string) {
        String key;
        boolean[] blArray = ImageCache.$jacocoInit();
        if (key != null) {
            Bitmap bitmap;
            blArray[78] = true;
            if (memoryCache == null) {
                bitmap = null;
                blArray[79] = true;
            } else {
                bitmap = (Bitmap)memoryCache.get((Object)key);
                blArray[80] = true;
            }
            blArray[81] = true;
            return bitmap;
        }
        blArray[82] = true;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static File getFile(String string) {
        void safeName;
        void hashed;
        String url;
        boolean[] blArray = ImageCache.$jacocoInit();
        if (messageDigest == null) {
            blArray[83] = true;
            return null;
        }
        byte[] byArray = messageDigest.digest(url.getBytes());
        blArray[84] = true;
        String string2 = FILE_PREFIX + Base64.encodeToString((byte[])hashed, (int)10);
        blArray[85] = true;
        blArray[86] = true;
        return new File(imageFileDirectory, (String)safeName);
    }

    private static int getImageSizeInKB(Bitmap bitmap) {
        Bitmap bitmap2;
        boolean[] blArray = ImageCache.$jacocoInit();
        blArray[87] = true;
        return bitmap2.getByteCount() / 1024;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static File getOrFetchAndWriteImageFile(String var0) {
        block25: {
            block28: {
                var1_1 = ImageCache.$jacocoInit();
                var2_2 = ImageCache.getFile(url);
                var1_1[88] = true;
                if (file != null) break block28;
                var1_1[89] = true;
                ** GOTO lbl12
            }
            if (file.exists()) {
                var1_1[90] = true;
            } else {
                var1_1[91] = true;
lbl12:
                // 2 sources

                bytes = Utils.getByteArrayFromImageURL(url);
                if (bytes == null) {
                    var1_1[92] = true;
                } else if (file == null) {
                    var1_1[93] = true;
                } else if (bytes.length >= 10000000) {
                    var1_1[94] = true;
                } else {
                    block24: {
                        var4_4 = null;
                        var1_1[95] = true;
                        out = new FileOutputStream((File)file);
                        var1_1[96] = true;
                        out.write(bytes);
                        if (out != null) break block24;
                        var1_1[97] = true;
                        break block25;
                    }
                    try {
                        var1_1[98] = true;
                        out.close();
                        var1_1[99] = true;
                    }
                    catch (IOException var5_5) {
                        var1_1[100] = true;
                        Logger.v("CleverTap.ImageCache: error closing image output file", (Throwable)e);
                        var1_1[101] = true;
                    }
                }
            }
            break block25;
            catch (FileNotFoundException e) {
                block26: {
                    var1_1[102] = true;
                    Logger.v("CleverTap.ImageCache: error writing image file", e);
                    var6_8 = null;
                    if (out != null) break block26;
                    var1_1[103] = true;
                }
                try {
                    var1_1[104] = true;
                    out.close();
                    var1_1[105] = true;
                }
                catch (IOException var7_10) {
                    var1_1[106] = true;
                    Logger.v("CleverTap.ImageCache: error closing image output file", (Throwable)e);
                    var1_1[107] = true;
                }
                var1_1[108] = true;
                return var6_8;
            }
            catch (IOException e) {
                block27: {
                    var1_1[109] = true;
                    Logger.v("CleverTap.ImageCache: error writing image file", e);
                    var6_9 = null;
                    if (out != null) break block27;
                    var1_1[110] = true;
                    {
                        catch (Throwable var8_12) {
                            if (out == null) {
                                var1_1[116] = true;
                            } else {
                                try {
                                    var1_1[117] = true;
                                    out.close();
                                    var1_1[118] = true;
                                }
                                catch (IOException var9_13) {
                                    var1_1[119] = true;
                                    Logger.v("CleverTap.ImageCache: error closing image output file", (Throwable)e);
                                    var1_1[120] = true;
                                }
                            }
                            var1_1[121] = true;
                            throw var8_12;
                        }
                    }
                }
                try {
                    var1_1[111] = true;
                    out.close();
                    var1_1[112] = true;
                }
                catch (IOException e) {
                    var1_1[113] = true;
                    Logger.v("CleverTap.ImageCache: error closing image output file", e);
                    var1_1[114] = true;
                }
                var1_1[115] = true;
                return var6_9;
            }
        }
        var1_1[122] = true;
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEmpty() {
        boolean[] blArray = ImageCache.$jacocoInit();
        Class<ImageCache> clazz = ImageCache.class;
        synchronized (ImageCache.class) {
            boolean bl;
            try {
                blArray[123] = true;
                if (memoryCache.size() <= 0) {
                    bl = blArray[124] = true;
                } else {
                    bl = false;
                    blArray[125] = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                blArray[126] = true;
            }
            catch (Throwable throwable) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                blArray[127] = true;
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void removeFromFileSystem(String string) {
        void file;
        String url;
        boolean[] blArray = ImageCache.$jacocoInit();
        File file2 = ImageCache.getFile(url);
        blArray[128] = true;
        if (file == null) {
            blArray[129] = true;
        } else if (!file.exists()) {
            blArray[130] = true;
        } else {
            blArray[131] = true;
            file.delete();
            blArray[132] = true;
        }
        blArray[133] = true;
    }

    static /* synthetic */ int access$000(Bitmap bitmap) {
        Bitmap x0;
        boolean[] blArray = ImageCache.$jacocoInit();
        blArray[134] = true;
        return ImageCache.getImageSizeInKB(x0);
    }

    static {
        boolean[] blArray = ImageCache.$jacocoInit();
        maxMemory = (int)Runtime.getRuntime().maxMemory() / 1024;
        blArray[135] = true;
        cacheSize = Math.max(maxMemory / 32, 20480);
        blArray[136] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)7389741573326068176L, (String)"com/clevertap/android/sdk/utils/ImageCache", (int)137);
        }
        return blArray;
    }
}

