/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONObject;

public class GeofenceResponse
extends CleverTapResponseDecorator {
    private final BaseCallbackManager callbackManager;
    private final CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final Logger logger;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public GeofenceResponse(CleverTapResponse cleverTapResponse, CleverTapInstanceConfig cleverTapInstanceConfig, BaseCallbackManager baseCallbackManager) {
        void callbackManager;
        void config;
        void cleverTapResponse2;
        boolean[] blArray = GeofenceResponse.$jacocoInit();
        this.cleverTapResponse = cleverTapResponse2;
        this.config = config;
        blArray[0] = true;
        this.logger = this.config.getLogger();
        this.callbackManager = callbackManager;
        blArray[1] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processResponse(JSONObject jSONObject, String string, Context context) {
        void context2;
        void stringBody;
        void response;
        boolean[] blArray = GeofenceResponse.$jacocoInit();
        this.logger.verbose(this.config.getAccountId(), "Processing GeoFences response...");
        blArray[2] = true;
        if (this.config.isAnalyticsOnly()) {
            blArray[3] = true;
            this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing geofence response");
            blArray[4] = true;
            this.cleverTapResponse.processResponse((JSONObject)response, (String)stringBody, (Context)context2);
            blArray[5] = true;
            return;
        }
        if (response == null) {
            blArray[6] = true;
            this.logger.verbose(this.config.getAccountId(), "Geofences : Can't parse Geofences Response, JSON response object is null");
            blArray[7] = true;
            return;
        }
        if (!response.has("geofences")) {
            blArray[9] = true;
            this.logger.verbose(this.config.getAccountId(), "Geofences : JSON object doesn't contain the Geofences key");
            blArray[10] = true;
            this.cleverTapResponse.processResponse((JSONObject)response, (String)stringBody, (Context)context2);
            blArray[11] = true;
            return;
        }
        blArray[8] = true;
        try {
            if (this.callbackManager.getGeofenceCallback() != null) {
                void jsonObject;
                blArray[12] = true;
                JSONObject jSONObject2 = new JSONObject();
                blArray[13] = true;
                jsonObject.put("geofences", (Object)response.getJSONArray("geofences"));
                blArray[14] = true;
                this.logger.verbose(this.config.getAccountId(), "Geofences : Processing Geofences response");
                blArray[15] = true;
                this.callbackManager.getGeofenceCallback().handleGeoFences((JSONObject)jsonObject);
                blArray[16] = true;
            } else {
                this.logger.debug(this.config.getAccountId(), "Geofences : Geofence SDK has not been initialized to handle the response");
                blArray[17] = true;
            }
            blArray[18] = true;
        }
        catch (Throwable t) {
            blArray[19] = true;
            this.logger.verbose(this.config.getAccountId(), "Geofences : Failed to handle Geofences response", t);
            blArray[20] = true;
        }
        this.cleverTapResponse.processResponse((JSONObject)response, (String)stringBody, (Context)context2);
        blArray[21] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)4784012964699622034L, (String)"com/clevertap/android/sdk/response/GeofenceResponse", (int)22);
        }
        return blArray;
    }
}

