/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.displayunits.CTDisplayUnitController;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnit;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import java.util.ArrayList;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONArray;
import org.json.JSONObject;

public class DisplayUnitResponse
extends CleverTapResponseDecorator {
    private final Object displayUnitControllerLock;
    private final BaseCallbackManager callbackManager;
    private final CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final ControllerManager controllerManager;
    private final Logger logger;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public DisplayUnitResponse(CleverTapResponse cleverTapResponse, CleverTapInstanceConfig cleverTapInstanceConfig, BaseCallbackManager baseCallbackManager, ControllerManager controllerManager) {
        void controllerManager2;
        void callbackManager;
        void config;
        void cleverTapResponse2;
        boolean[] blArray = DisplayUnitResponse.$jacocoInit();
        blArray[0] = true;
        this.displayUnitControllerLock = new Object();
        this.cleverTapResponse = cleverTapResponse2;
        this.config = config;
        blArray[1] = true;
        this.logger = this.config.getLogger();
        this.callbackManager = callbackManager;
        this.controllerManager = controllerManager2;
        blArray[2] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processResponse(JSONObject jSONObject, String string, Context context) {
        void context2;
        void stringBody;
        void response;
        boolean[] blArray = DisplayUnitResponse.$jacocoInit();
        this.logger.verbose(this.config.getAccountId(), "Processing Display Unit items...");
        blArray[3] = true;
        if (this.config.isAnalyticsOnly()) {
            blArray[4] = true;
            this.logger.verbose(this.config.getAccountId(), "CleverTap instance is configured to analytics only, not processing Display Unit response");
            blArray[5] = true;
            this.cleverTapResponse.processResponse((JSONObject)response, (String)stringBody, (Context)context2);
            blArray[6] = true;
            return;
        }
        if (response == null) {
            blArray[7] = true;
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : Can't parse Display Unit Response, JSON response object is null");
            blArray[8] = true;
            return;
        }
        if (!response.has("adUnit_notifs")) {
            blArray[10] = true;
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : JSON object doesn't contain the Display Units key");
            blArray[11] = true;
            this.cleverTapResponse.processResponse((JSONObject)response, (String)stringBody, (Context)context2);
            blArray[12] = true;
            return;
        }
        blArray[9] = true;
        try {
            blArray[13] = true;
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : Processing Display Unit response");
            blArray[14] = true;
            this.parseDisplayUnits(response.getJSONArray("adUnit_notifs"));
            blArray[15] = true;
        }
        catch (Throwable throwable) {
            void t;
            blArray[16] = true;
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : Failed to parse response", (Throwable)t);
            blArray[17] = true;
        }
        this.cleverTapResponse.processResponse((JSONObject)response, (String)stringBody, (Context)context2);
        blArray[18] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void parseDisplayUnits(JSONArray jSONArray) {
        void displayUnits;
        void messages;
        block10: {
            block9: {
                block8: {
                    boolean[] blArray = DisplayUnitResponse.$jacocoInit();
                    if (messages != null) break block8;
                    blArray[19] = true;
                    break block9;
                }
                if (messages.length() != 0) break block10;
                blArray[20] = true;
            }
            this.logger.verbose(this.config.getAccountId(), "DisplayUnit : Can't parse Display Units, jsonArray is either empty or null");
            blArray[21] = true;
            return;
        }
        ArrayList<CleverTapDisplayUnit> arrayList = this.displayUnitControllerLock;
        synchronized (arrayList) {
            try {
                blArray[22] = true;
                if (this.controllerManager.getCTDisplayUnitController() != null) {
                    blArray[23] = true;
                } else {
                    blArray[24] = true;
                    this.controllerManager.setCTDisplayUnitController(new CTDisplayUnitController());
                    blArray[25] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
                blArray[26] = true;
                throw throwable;
            }
        }
        blArray[27] = true;
        arrayList = this.controllerManager.getCTDisplayUnitController().updateDisplayUnits((JSONArray)messages);
        blArray[28] = true;
        this.callbackManager.notifyDisplayUnitsLoaded((ArrayList<CleverTapDisplayUnit>)displayUnits);
        blArray[29] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-8533457148724563092L, (String)"com/clevertap/android/sdk/response/DisplayUnitResponse", (int)30);
        }
        return blArray;
    }
}

