/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.DBAdapter;
import com.clevertap.android.sdk.pushnotification.CTPushProvider;
import com.clevertap.android.sdk.pushnotification.CTPushProviderListener;
import com.clevertap.android.sdk.pushnotification.CoreNotificationRenderer;
import com.clevertap.android.sdk.pushnotification.INotificationRenderer;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.pushnotification.UnregistrableCTPushProvider;
import com.clevertap.android.sdk.pushnotification.amp.CTBackgroundJobService;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.PackageUtils;
import com.clevertap.android.sdk.validation.ValidationResult;
import com.clevertap.android.sdk.validation.ValidationResultFactory;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PushProviders
implements CTPushProviderListener {
    private final ArrayList<PushConstants.PushType> allEnabledPushTypes;
    private final ArrayList<PushConstants.PushType> allDisabledPushTypes;
    private final ArrayList<CTPushProvider> availableCTPushProviders;
    private final ArrayList<PushConstants.PushType> customEnabledPushTypes;
    private final AnalyticsManager analyticsManager;
    private final BaseDatabaseManager baseDatabaseManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private INotificationRenderer iNotificationRenderer;
    private final ValidationResultStack validationResultStack;
    private final Object tokenLock;
    private CleverTapAPI.DevicePushTokenRefreshListener tokenRefreshListener;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static PushProviders load(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, BaseDatabaseManager baseDatabaseManager, ValidationResultStack validationResultStack, AnalyticsManager analyticsManager, ControllerManager controllerManager) {
        void controllerManager2;
        void providers;
        void analyticsManager2;
        void validationResultStack2;
        void baseDatabaseManager2;
        void config;
        Context context2;
        boolean[] blArray = PushProviders.$jacocoInit();
        PushProviders pushProviders = new PushProviders(context2, (CleverTapInstanceConfig)config, (BaseDatabaseManager)baseDatabaseManager2, (ValidationResultStack)validationResultStack2, (AnalyticsManager)analyticsManager2);
        blArray[0] = true;
        super.init();
        blArray[1] = true;
        controllerManager2.setPushProviders((PushProviders)providers);
        blArray[2] = true;
        return providers;
    }

    /*
     * WARNING - void declaration
     */
    private PushProviders(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, BaseDatabaseManager baseDatabaseManager, ValidationResultStack validationResultStack, AnalyticsManager analyticsManager) {
        void analyticsManager2;
        void validationResultStack2;
        void baseDatabaseManager2;
        void config;
        void context2;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[3] = true;
        this.allEnabledPushTypes = new ArrayList();
        blArray[4] = true;
        this.allDisabledPushTypes = new ArrayList();
        blArray[5] = true;
        this.availableCTPushProviders = new ArrayList();
        blArray[6] = true;
        this.customEnabledPushTypes = new ArrayList();
        blArray[7] = true;
        this.iNotificationRenderer = new CoreNotificationRenderer();
        blArray[8] = true;
        this.tokenLock = new Object();
        this.context = context2;
        this.config = config;
        this.baseDatabaseManager = baseDatabaseManager2;
        this.validationResultStack = validationResultStack2;
        this.analyticsManager = analyticsManager2;
        blArray[9] = true;
        this.initPushAmp();
        blArray[10] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void _createNotification(Context context, Bundle bundle, int n) {
        void extras;
        block8: {
            block7: {
                block6: {
                    boolean[] blArray = PushProviders.$jacocoInit();
                    if (extras != null) break block6;
                    blArray[11] = true;
                    break block7;
                }
                if (extras.get("wzrk_pn") != null) break block8;
                blArray[12] = true;
            }
            blArray[13] = true;
            return;
        }
        if (this.config.isAnalyticsOnly()) {
            blArray[15] = true;
            blArray[16] = true;
            this.config.getLogger().debug(this.config.getAccountId(), "Instance is set for Analytics only, cannot create notification");
            blArray[17] = true;
            return;
        }
        blArray[14] = true;
        try {
            void notificationId;
            void context2;
            void task;
            Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            blArray[18] = true;
            task.execute("CleverTapAPI#_createNotification", new Callable<Void>(this, (Bundle)extras, (Context)context2, (int)notificationId){
                final /* synthetic */ Bundle val$extras;
                final /* synthetic */ Context val$context;
                final /* synthetic */ int val$notificationId;
                final /* synthetic */ PushProviders this$0;
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 1.$jacocoInit();
                    this.this$0 = this$0;
                    this.val$extras = bundle;
                    this.val$context = context;
                    this.val$notificationId = n;
                    blArray[0] = true;
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public Void call() {
                    block14: {
                        block13: {
                            block16: {
                                block17: {
                                    block15: {
                                        var1_1 = 1.$jacocoInit();
                                        var2_2 = this.val$extras.getString("extras_from");
                                        var1_1[1] = true;
                                        if (extrasFrom != null) break block15;
                                        var1_1[2] = true;
                                        break block16;
                                    }
                                    if (!extrasFrom.equals("PTReceiver")) break block17;
                                    var1_1[3] = true;
                                    ** GOTO lbl74
                                }
                                var1_1[4] = true;
                            }
                            var1_1[5] = true;
                            PushProviders.access$000(this.this$0).getLogger().debug(PushProviders.access$000(this.this$0).getAccountId(), "Handling notification: " + this.val$extras.toString());
                            var1_1[6] = true;
                            if (this.val$extras.getString("wzrk_pid") == null) {
                                var1_1[7] = true;
                                break block13;
                            }
                            var1_1[8] = true;
                            var1_1[9] = true;
                            if (!PushProviders.access$100(this.this$0).loadDBAdapter(this.val$context).doesPushNotificationIdExist(this.val$extras.getString("wzrk_pid"))) {
                                var1_1[10] = true;
                                break block13;
                            }
                            var1_1[11] = true;
                            PushProviders.access$000(this.this$0).getLogger().debug(PushProviders.access$000(this.this$0).getAccountId(), "Push Notification already rendered, not showing again");
                            var1_1[12] = true;
                            return null;
                        }
                        var1_1[13] = true;
                        notifMessage = PushProviders.access$200(this.this$0).getMessage(this.val$extras);
                        if (notifMessage != null) {
                            v0 = notifMessage;
                            var1_1[14] = true;
                        } else {
                            v0 = "";
                            var1_1[15] = true;
                        }
                        notifMessage = v0;
                        var1_1[16] = true;
                        if (!notifMessage.isEmpty()) {
                            var1_1[17] = true;
                            break block14;
                        }
                        var1_1[18] = true;
                        var1_1[19] = true;
                        PushProviders.access$000(this.this$0).getLogger().verbose(PushProviders.access$000(this.this$0).getAccountId(), "Push notification message is empty, not rendering");
                        var1_1[20] = true;
                        var1_1[21] = true;
                        PushProviders.access$100(this.this$0).loadDBAdapter(this.val$context).storeUninstallTimestamp();
                        var1_1[22] = true;
                        var4_5 = this.val$extras.getString("pf", "");
                        var1_1[23] = true;
                        if (TextUtils.isEmpty((CharSequence)pingFreq)) {
                            var1_1[24] = true;
                        } else {
                            var1_1[25] = true;
                            this.this$0.updatePingFrequencyIfNeeded(this.val$context, Integer.parseInt((String)pingFreq));
                            var1_1[26] = true;
                        }
                        var1_1[27] = true;
                        return null;
                    }
                    try {
                        pingFreq = PushProviders.access$200(this.this$0).getTitle(this.val$extras, this.val$context);
                        var1_1[28] = true;
                        if (notifTitle.isEmpty()) {
                            v1 = this.val$context.getApplicationInfo().name;
                            var1_1[29] = true;
                        } else {
                            v1 = notifTitle;
                            var1_1[30] = true;
                        }
                        notifTitle = v1;
                        var1_1[31] = true;
lbl74:
                        // 2 sources

                        PushProviders.access$300(this.this$0, this.val$context, this.val$extras, this.val$notificationId);
                        var1_1[32] = true;
                    }
                    catch (Throwable extrasFrom) {
                        var1_1[33] = true;
                        var1_1[34] = true;
                        PushProviders.access$000(this.this$0).getLogger().debug(PushProviders.access$000(this.this$0).getAccountId(), "Couldn't render notification: ", (Throwable)t);
                        var1_1[35] = true;
                    }
                    var1_1[36] = true;
                    return null;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)-2662502821273636353L, (String)"com/clevertap/android/sdk/pushnotification/PushProviders$1", (int)38);
                    }
                    return blArray;
                }
            });
            blArray[19] = true;
        }
        catch (Throwable task) {
            void t;
            blArray[20] = true;
            this.config.getLogger().debug(this.config.getAccountId(), "Failed to process push notification", (Throwable)t);
            blArray[21] = true;
        }
        blArray[22] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void cacheToken(String string, PushConstants.PushType pushType) {
        void pushType2;
        void token;
        block6: {
            block5: {
                block4: {
                    boolean[] blArray = PushProviders.$jacocoInit();
                    if (!TextUtils.isEmpty((CharSequence)token)) break block4;
                    blArray[23] = true;
                    break block5;
                }
                if (pushType2 != null) break block6;
                blArray[25] = true;
            }
            blArray[26] = true;
            return;
        }
        blArray[24] = true;
        try {
            void task;
            Task task2 = CTExecutorFactory.executors(this.config).ioTask();
            blArray[27] = true;
            task.execute("PushProviders#cacheToken", new Callable<Void>(this, (String)token, (PushConstants.PushType)pushType2){
                final /* synthetic */ String val$token;
                final /* synthetic */ PushConstants.PushType val$pushType;
                final /* synthetic */ PushProviders this$0;
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 2.$jacocoInit();
                    this.this$0 = this$0;
                    this.val$token = string;
                    this.val$pushType = pushType;
                    blArray[0] = true;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Void call() {
                    void key;
                    boolean[] blArray = 2.$jacocoInit();
                    if (PushProviders.access$400(this.this$0, this.val$token, this.val$pushType)) {
                        blArray[1] = true;
                        return null;
                    }
                    String string = this.val$pushType.getTokenPrefKey();
                    blArray[2] = true;
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        blArray[3] = true;
                        return null;
                    }
                    blArray[4] = true;
                    StorageHelper.putStringImmediate(PushProviders.access$500(this.this$0), StorageHelper.storageKeyWithSuffix(PushProviders.access$000(this.this$0), (String)key), this.val$token);
                    blArray[5] = true;
                    PushProviders.access$000(this.this$0).log("PushProvider", (Object)((Object)this.val$pushType) + "Cached New Token successfully " + this.val$token);
                    blArray[6] = true;
                    return null;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)-8329754709704523967L, (String)"com/clevertap/android/sdk/pushnotification/PushProviders$2", (int)8);
                    }
                    return blArray;
                }
            });
            blArray[28] = true;
        }
        catch (Throwable task) {
            void t;
            blArray[29] = true;
            this.config.log("PushProvider", pushType2 + "Unable to cache token " + (String)token, (Throwable)t);
            blArray[30] = true;
        }
        blArray[31] = true;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void doTokenRefresh(String string, PushConstants.PushType pushType) {
        void pushType2;
        void token;
        block11: {
            block10: {
                block9: {
                    boolean[] blArray = PushProviders.$jacocoInit();
                    if (!TextUtils.isEmpty((CharSequence)token)) break block9;
                    blArray[32] = true;
                    break block10;
                }
                if (pushType2 != null) break block11;
                blArray[33] = true;
            }
            blArray[34] = true;
            return;
        }
        switch (8.$SwitchMap$com$clevertap$android$sdk$pushnotification$PushConstants$PushType[pushType2.ordinal()]) {
            default: {
                blArray[35] = true;
                break;
            }
            case 1: {
                this.handleToken((String)token, PushConstants.PushType.FCM, true);
                blArray[36] = true;
                break;
            }
            case 2: {
                this.handleToken((String)token, PushConstants.PushType.XPS, true);
                blArray[37] = true;
                break;
            }
            case 3: {
                this.handleToken((String)token, PushConstants.PushType.HPS, true);
                blArray[38] = true;
                break;
            }
            case 4: {
                this.handleToken((String)token, PushConstants.PushType.BPS, true);
                blArray[39] = true;
                break;
            }
            case 5: {
                this.handleToken((String)token, PushConstants.PushType.ADM, true);
                blArray[40] = true;
            }
        }
        blArray[41] = true;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void forcePushDeviceToken(boolean bl) {
        boolean[] blArray = PushProviders.$jacocoInit();
        Iterator<PushConstants.PushType> iterator = this.allEnabledPushTypes.iterator();
        blArray[42] = true;
        while (iterator.hasNext()) {
            void pushType;
            void register;
            PushConstants.PushType pushType2 = iterator.next();
            blArray[43] = true;
            this.pushDeviceTokenEvent(null, (boolean)register, (PushConstants.PushType)pushType);
            blArray[44] = true;
        }
        blArray[45] = true;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ArrayList<PushConstants.PushType> getAvailablePushTypes() {
        void pushTypes;
        boolean[] blArray = PushProviders.$jacocoInit();
        ArrayList arrayList = new ArrayList();
        blArray[46] = true;
        Iterator<CTPushProvider> iterator = this.availableCTPushProviders.iterator();
        blArray[47] = true;
        while (iterator.hasNext()) {
            void pushProvider;
            CTPushProvider cTPushProvider = iterator.next();
            blArray[48] = true;
            pushTypes.add(pushProvider.getPushType());
            blArray[49] = true;
        }
        blArray[50] = true;
        return pushTypes;
    }

    /*
     * WARNING - void declaration
     */
    public String getCachedToken(PushConstants.PushType pushType) {
        void pushType2;
        boolean[] blArray = PushProviders.$jacocoInit();
        if (pushType2 == null) {
            blArray[51] = true;
        } else {
            void key;
            blArray[52] = true;
            String string = pushType2.getTokenPrefKey();
            blArray[53] = true;
            if (TextUtils.isEmpty((CharSequence)key)) {
                blArray[54] = true;
            } else {
                void cachedToken;
                blArray[55] = true;
                String string2 = StorageHelper.getStringFromPrefs(this.context, this.config, (String)key, null);
                blArray[56] = true;
                this.config.log("PushProvider", pushType2 + "getting Cached Token - " + (String)cachedToken);
                blArray[57] = true;
                return cachedToken;
            }
        }
        if (pushType2 == null) {
            blArray[58] = true;
        } else {
            blArray[59] = true;
            this.config.log("PushProvider", pushType2 + " Unable to find cached Token for type ");
            blArray[60] = true;
        }
        blArray[61] = true;
        return null;
    }

    public CleverTapAPI.DevicePushTokenRefreshListener getDevicePushTokenRefreshListener() {
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[62] = true;
        return this.tokenRefreshListener;
    }

    /*
     * WARNING - void declaration
     */
    public void setDevicePushTokenRefreshListener(CleverTapAPI.DevicePushTokenRefreshListener devicePushTokenRefreshListener) {
        void tokenRefreshListener;
        boolean[] blArray = PushProviders.$jacocoInit();
        this.tokenRefreshListener = tokenRefreshListener;
        blArray[63] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void handleToken(String string, PushConstants.PushType pushType, boolean bl) {
        void pushType2;
        void token;
        void register;
        boolean[] blArray = PushProviders.$jacocoInit();
        if (register != false) {
            blArray[64] = true;
            this.registerToken((String)token, (PushConstants.PushType)pushType2);
            blArray[65] = true;
        } else {
            this.unregisterToken((String)token, (PushConstants.PushType)pushType2);
            blArray[66] = true;
        }
        blArray[67] = true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNotificationSupported() {
        boolean[] blArray = PushProviders.$jacocoInit();
        Iterator<PushConstants.PushType> iterator = this.getAvailablePushTypes().iterator();
        blArray[68] = true;
        while (iterator.hasNext()) {
            void pushType;
            PushConstants.PushType pushType2 = iterator.next();
            blArray[69] = true;
            if (this.getCachedToken((PushConstants.PushType)pushType) != null) {
                blArray[70] = true;
                return true;
            }
            blArray[71] = true;
        }
        blArray[72] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onNewToken(String string, PushConstants.PushType pushType) {
        void freshToken;
        boolean[] blArray = PushProviders.$jacocoInit();
        if (TextUtils.isEmpty((CharSequence)freshToken)) {
            blArray[73] = true;
        } else {
            void pushType2;
            blArray[74] = true;
            this.doTokenRefresh((String)freshToken, (PushConstants.PushType)pushType2);
            blArray[75] = true;
            this.deviceTokenDidRefresh((String)freshToken, (PushConstants.PushType)pushType2);
            blArray[76] = true;
        }
        blArray[77] = true;
    }

    public void onTokenRefresh() {
        boolean[] blArray = PushProviders.$jacocoInit();
        this.refreshAllTokens();
        blArray[78] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void processCustomPushNotification(Bundle bundle) {
        void extras;
        void task;
        boolean[] blArray = PushProviders.$jacocoInit();
        Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        blArray[79] = true;
        task.execute("customHandlePushAmplification", new Callable<Void>(this, (Bundle)extras){
            final /* synthetic */ Bundle val$extras;
            final /* synthetic */ PushProviders this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 3.$jacocoInit();
                this.this$0 = this$0;
                this.val$extras = bundle;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Void call() {
                String string;
                boolean[] blArray = 3.$jacocoInit();
                String notifMessage = this.val$extras.getString("nm");
                if (notifMessage != null) {
                    string = notifMessage;
                    blArray[1] = true;
                } else {
                    string = "";
                    blArray[2] = true;
                }
                notifMessage = string;
                blArray[3] = true;
                if (notifMessage.isEmpty()) {
                    void pingFreq;
                    blArray[4] = true;
                    blArray[5] = true;
                    PushProviders.access$000(this.this$0).getLogger().verbose(PushProviders.access$000(this.this$0).getAccountId(), "Push notification message is empty, not rendering");
                    blArray[6] = true;
                    PushProviders.access$100(this.this$0).loadDBAdapter(PushProviders.access$500(this.this$0)).storeUninstallTimestamp();
                    blArray[7] = true;
                    String string2 = this.val$extras.getString("pf", "");
                    blArray[8] = true;
                    if (TextUtils.isEmpty((CharSequence)pingFreq)) {
                        blArray[9] = true;
                    } else {
                        blArray[10] = true;
                        this.this$0.updatePingFrequencyIfNeeded(PushProviders.access$500(this.this$0), Integer.parseInt((String)pingFreq));
                        blArray[11] = true;
                    }
                    blArray[12] = true;
                } else {
                    void wzrk_ttl;
                    void dbAdapter;
                    void wzrk_pid;
                    void ttl;
                    String pingFreq = this.val$extras.getString("wzrk_pid");
                    blArray[13] = true;
                    blArray[14] = true;
                    blArray[15] = true;
                    String string3 = this.val$extras.getString("wzrk_ttl", (System.currentTimeMillis() + 345600000L) / 1000L + "");
                    blArray[16] = true;
                    long l = Long.parseLong((String)ttl);
                    blArray[17] = true;
                    DBAdapter dBAdapter = PushProviders.access$100(this.this$0).loadDBAdapter(PushProviders.access$500(this.this$0));
                    blArray[18] = true;
                    PushProviders.access$000(this.this$0).getLogger().verbose("Storing Push Notification..." + (String)wzrk_pid + " - with ttl - " + (String)ttl);
                    blArray[19] = true;
                    dbAdapter.storePushNotificationId((String)wzrk_pid, (long)wzrk_ttl);
                    blArray[20] = true;
                }
                blArray[21] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)5879773568904948523L, (String)"com/clevertap/android/sdk/pushnotification/PushProviders$3", (int)23);
                }
                return blArray;
            }
        });
        blArray[80] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterToken(String string, PushConstants.PushType pushType) {
        void pushType2;
        void token;
        boolean[] blArray = PushProviders.$jacocoInit();
        this.pushDeviceTokenEvent((String)token, false, (PushConstants.PushType)pushType2);
        blArray[81] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void updatePingFrequencyIfNeeded(Context context, int n) {
        void context2;
        void frequency;
        boolean[] blArray = PushProviders.$jacocoInit();
        this.config.getLogger().verbose("Ping frequency received - " + (int)frequency);
        blArray[82] = true;
        this.config.getLogger().verbose("Stored Ping Frequency - " + this.getPingFrequency((Context)context2));
        blArray[83] = true;
        if (frequency == this.getPingFrequency((Context)context2)) {
            blArray[84] = true;
        } else {
            blArray[85] = true;
            this.setPingFrequency((Context)context2, (int)frequency);
            blArray[86] = true;
            if (!this.config.isBackgroundSync()) {
                blArray[87] = true;
            } else if (this.config.isAnalyticsOnly()) {
                blArray[88] = true;
            } else {
                void task;
                blArray[89] = true;
                Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
                blArray[90] = true;
                task.execute("createOrResetJobScheduler", new Callable<Void>(this, (Context)context2){
                    final /* synthetic */ Context val$context;
                    final /* synthetic */ PushProviders this$0;
                    private static transient /* synthetic */ boolean[] $jacocoData;
                    {
                        void this$0;
                        boolean[] blArray = 4.$jacocoInit();
                        this.this$0 = this$0;
                        this.val$context = context;
                        blArray[0] = true;
                    }

                    @Override
                    public Void call() {
                        boolean[] blArray = 4.$jacocoInit();
                        if (Build.VERSION.SDK_INT >= 21) {
                            blArray[1] = true;
                            PushProviders.access$000(this.this$0).getLogger().verbose("Creating job");
                            blArray[2] = true;
                            PushProviders.access$600(this.this$0, this.val$context);
                            blArray[3] = true;
                        } else {
                            PushProviders.access$000(this.this$0).getLogger().verbose("Resetting alarm");
                            blArray[4] = true;
                            PushProviders.access$700(this.this$0, this.val$context);
                            blArray[5] = true;
                        }
                        blArray[6] = true;
                        return null;
                    }

                    private static /* synthetic */ boolean[] $jacocoInit() {
                        boolean[] blArray = $jacocoData;
                        if ($jacocoData == null) {
                            blArray = $jacocoData = Offline.getProbes((long)8814720843219413853L, (String)"com/clevertap/android/sdk/pushnotification/PushProviders$4", (int)8);
                        }
                        return blArray;
                    }
                });
                blArray[91] = true;
            }
        }
        blArray[92] = true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean alreadyHaveToken(String var1_1, PushConstants.PushType var2_2) {
        block5: {
            block4: {
                var3_3 = PushProviders.$jacocoInit();
                if (!TextUtils.isEmpty((CharSequence)newToken)) break block4;
                var3_3[93] = true;
                ** GOTO lbl15
            }
            if (pushType != null) break block5;
            var3_3[94] = true;
            ** GOTO lbl15
        }
        var3_3[95] = true;
        if (newToken.equalsIgnoreCase(this.getCachedToken((PushConstants.PushType)pushType))) {
            v0 = var3_3[97] = true;
        } else {
            var3_3[96] = true;
lbl15:
            // 3 sources

            v0 = false;
            var3_3[98] = true;
        }
        alreadyAvailable = v0;
        if (pushType == null) {
            var3_3[99] = true;
        } else {
            var3_3[100] = true;
            this.config.log("PushProvider", pushType + "Token Already available value: " + alreadyAvailable);
            var3_3[101] = true;
        }
        var3_3[102] = true;
        return alreadyAvailable;
    }

    /*
     * WARNING - void declaration
     */
    public void runInstanceJobWork(Context context, JobParameters jobParameters) {
        void parameters;
        void context2;
        void task;
        boolean[] blArray = PushProviders.$jacocoInit();
        Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
        blArray[103] = true;
        task.execute("runningJobService", new Callable<Void>(this, (Context)context2, (JobParameters)parameters){
            final /* synthetic */ Context val$context;
            final /* synthetic */ JobParameters val$parameters;
            final /* synthetic */ PushProviders this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 5.$jacocoInit();
                this.this$0 = this$0;
                this.val$context = context;
                this.val$parameters = jobParameters;
                blArray[0] = true;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public Void call() {
                block16: {
                    var1_1 = 5.$jacocoInit();
                    if (!this.this$0.isNotificationSupported()) {
                        var1_1[1] = true;
                        Logger.v(PushProviders.access$000(this.this$0).getAccountId(), "Token is not present, not running the Job");
                        var1_1[2] = true;
                        return null;
                    }
                    var2_2 = Calendar.getInstance();
                    var1_1[3] = true;
                    var3_3 = now.get(11);
                    var1_1[4] = true;
                    var4_4 = now.get(12);
                    var1_1[5] = true;
                    var5_5 = PushProviders.access$800(this.this$0, (int)hour + ":" + (int)minute);
                    var1_1[6] = true;
                    var6_6 = PushProviders.access$800(this.this$0, "22:00");
                    var1_1[7] = true;
                    var7_7 = PushProviders.access$800(this.this$0, "06:00");
                    var1_1[8] = true;
                    if (PushProviders.access$900(this.this$0, (Date)startTime, (Date)endTime, (Date)currentTime)) {
                        var1_1[9] = true;
                        Logger.v(PushProviders.access$000(this.this$0).getAccountId(), "Job Service won't run in default DND hours");
                        var1_1[10] = true;
                        return null;
                    }
                    var8_8 = PushProviders.access$100(this.this$0).loadDBAdapter(this.val$context).getLastUninstallTimestamp();
                    var1_1[11] = true;
                    if (lastTS != 0L) break block16;
                    var1_1[12] = true;
                    ** GOTO lbl35
                }
                if (lastTS <= System.currentTimeMillis() - 86400000L) {
                    var1_1[13] = true;
                } else {
                    try {
                        var1_1[14] = true;
lbl35:
                        // 2 sources

                        var10_9 = new JSONObject();
                        var1_1[15] = true;
                        eventObject.put("bk", 1);
                        var1_1[16] = true;
                        PushProviders.access$1000(this.this$0).sendPingEvent((JSONObject)eventObject);
                        flagsAlarmPendingIntent = 0x8000000;
                        if (Build.VERSION.SDK_INT < 31) {
                            var1_1[17] = true;
                        } else {
                            flagsAlarmPendingIntent |= 0x2000000;
                            var1_1[18] = true;
                        }
                        if (this.val$parameters != null) {
                            var1_1[19] = true;
                        } else {
                            var1_1[20] = true;
                            pingFrequency = PushProviders.access$1100(this.this$0, this.val$context);
                            var1_1[21] = true;
                            var13_13 = (AlarmManager)this.val$context.getSystemService("alarm");
                            var1_1[22] = true;
                            var14_14 = new Intent("com.clevertap.BG_EVENT");
                            var1_1[23] = true;
                            cancelIntent.setPackage(this.val$context.getPackageName());
                            var1_1[24] = true;
                            alarmPendingIntent = PendingIntent.getService((Context)this.val$context, (int)PushProviders.access$000(this.this$0).getAccountId().hashCode(), (Intent)cancelIntent, (int)flagsAlarmPendingIntent);
                            if (alarmManager == null) {
                                var1_1[25] = true;
                            } else {
                                var1_1[26] = true;
                                alarmManager.cancel(alarmPendingIntent);
                                var1_1[27] = true;
                            }
                            var16_16 = new Intent("com.clevertap.BG_EVENT");
                            var1_1[28] = true;
                            alarmIntent.setPackage(this.val$context.getPackageName());
                            var1_1[29] = true;
                            alarmServicePendingIntent = PendingIntent.getService((Context)this.val$context, (int)PushProviders.access$000(this.this$0).getAccountId().hashCode(), (Intent)alarmIntent, (int)flagsAlarmPendingIntent);
                            if (alarmManager == null) {
                                var1_1[30] = true;
                            } else if (pingFrequency == -1) {
                                var1_1[31] = true;
                            } else {
                                var1_1[32] = true;
                                var1_1[33] = true;
                                alarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime() + (long)pingFrequency * 60000L, 60000L * (long)pingFrequency, alarmServicePendingIntent);
                                var1_1[34] = true;
                            }
                        }
                        var1_1[35] = true;
                    }
                    catch (JSONException eventObject) {
                        var1_1[36] = true;
                        Logger.v("Unable to raise background Ping event");
                        var1_1[37] = true;
                    }
                }
                var1_1[38] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)410107318299851508L, (String)"com/clevertap/android/sdk/pushnotification/PushProviders$5", (int)40);
                }
                return blArray;
            }
        });
        blArray[104] = true;
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(api=21)
    private void createOrResetJobScheduler(Context var1_1) {
        block21: {
            var2_2 = PushProviders.$jacocoInit();
            var3_3 = StorageHelper.getInt((Context)context, "pfjobid", -1);
            var2_2[105] = true;
            jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            if (Build.VERSION.SDK_INT < 26) {
                if (existingJobId < 0) {
                    var2_2[106] = true;
                } else {
                    var2_2[107] = true;
                    jobScheduler.cancel((int)existingJobId);
                    var2_2[108] = true;
                    StorageHelper.putInt((Context)context, "pfjobid", -1);
                    var2_2[109] = true;
                }
                var2_2[110] = true;
                this.config.getLogger().debug(this.config.getAccountId(), "Push Amplification feature is not supported below Oreo");
                var2_2[111] = true;
                return;
            }
            if (jobScheduler == null) {
                var2_2[112] = true;
                return;
            }
            pingFrequency = this.getPingFrequency((Context)context);
            if (existingJobId >= 0) {
                var2_2[113] = true;
            } else if (pingFrequency >= 0) {
                var2_2[114] = true;
            } else {
                var2_2[115] = true;
                return;
            }
            if (pingFrequency < 0) {
                var2_2[116] = true;
                jobScheduler.cancel((int)existingJobId);
                var2_2[117] = true;
                StorageHelper.putInt((Context)context, "pfjobid", -1);
                var2_2[118] = true;
                return;
            }
            componentName = new ComponentName((Context)context, CTBackgroundJobService.class);
            if (existingJobId < 0) break block21;
            var2_2[119] = true;
            ** GOTO lbl46
        }
        if (pingFrequency > 0) {
            v0 = var2_2[121] = true;
        } else {
            var2_2[120] = true;
lbl46:
            // 2 sources

            v0 = false;
            var2_2[122] = true;
        }
        var7_7 = v0;
        var2_2[123] = true;
        existingJobInfo = PushProviders.getJobInfo((int)existingJobId, jobScheduler);
        if (existingJobInfo == null) {
            var2_2[124] = true;
        } else {
            var2_2[125] = true;
            if (existingJobInfo.getIntervalMillis() == (long)pingFrequency * 60000L) {
                var2_2[126] = true;
            } else {
                var2_2[127] = true;
                jobScheduler.cancel((int)existingJobId);
                var2_2[128] = true;
                StorageHelper.putInt((Context)context, "pfjobid", -1);
                needsCreate = true;
                var2_2[129] = true;
            }
        }
        if (!needsCreate) {
            var2_2[130] = true;
        } else {
            var2_2[131] = true;
            var9_9 = this.config.getAccountId().hashCode();
            var2_2[132] = true;
            var10_10 = new JobInfo.Builder((int)jobid, componentName);
            var2_2[133] = true;
            builder.setRequiredNetworkType(1);
            var2_2[134] = true;
            builder.setRequiresCharging(false);
            var2_2[135] = true;
            builder.setPeriodic((long)pingFrequency * 60000L, 300000L);
            var2_2[136] = true;
            builder.setRequiresBatteryNotLow(true);
            var2_2[137] = true;
            if (!Utils.hasPermission((Context)context, "android.permission.RECEIVE_BOOT_COMPLETED")) {
                var2_2[138] = true;
            } else {
                var2_2[139] = true;
                builder.setPersisted(true);
                var2_2[140] = true;
            }
            var11_11 = builder.build();
            var2_2[141] = true;
            resultCode = jobScheduler.schedule((JobInfo)jobInfo);
            if (resultCode == 1) {
                var2_2[142] = true;
                Logger.d(this.config.getAccountId(), "Job scheduled - " + (int)jobid);
                var2_2[143] = true;
                StorageHelper.putInt((Context)context, "pfjobid", (int)jobid);
                var2_2[144] = true;
            } else {
                Logger.d(this.config.getAccountId(), "Job not scheduled - " + (int)jobid);
                var2_2[145] = true;
            }
        }
        var2_2[146] = true;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private List<CTPushProvider> createProviders() {
        void providers;
        Object pushProvider;
        PushConstants.PushType pushType;
        boolean[] blArray = PushProviders.$jacocoInit();
        ArrayList arrayList = new ArrayList();
        blArray[147] = true;
        Iterator<PushConstants.PushType> iterator = this.allEnabledPushTypes.iterator();
        blArray[148] = true;
        while (iterator.hasNext()) {
            PushConstants.PushType pushType2 = iterator.next();
            blArray[149] = true;
            pushProvider = this.getCTPushProviderFromPushType(pushType, true);
            if (pushProvider == null) {
                blArray[150] = true;
                continue;
            }
            providers.add(pushProvider);
            blArray[151] = true;
        }
        iterator = this.allDisabledPushTypes.iterator();
        blArray[152] = true;
        while (iterator.hasNext()) {
            pushType = iterator.next();
            if (pushType != PushConstants.PushType.XPS) {
                blArray[153] = true;
            } else {
                void cachedTokenXps;
                blArray[154] = true;
                pushProvider = this.getCachedToken(PushConstants.PushType.XPS);
                blArray[155] = true;
                if (TextUtils.isEmpty((CharSequence)cachedTokenXps)) {
                    blArray[156] = true;
                } else {
                    blArray[157] = true;
                    CTPushProvider pushProvider2 = this.getCTPushProviderFromPushType(pushType, false);
                    if (!(pushProvider2 instanceof UnregistrableCTPushProvider)) {
                        blArray[158] = true;
                    } else {
                        blArray[159] = true;
                        ((UnregistrableCTPushProvider)((Object)pushProvider2)).unregisterPush(this.context);
                        blArray[160] = true;
                        this.config.log("PushProvider", "unregistering existing token for disabled " + (Object)((Object)pushType));
                        blArray[161] = true;
                    }
                }
            }
            blArray[162] = true;
        }
        blArray[163] = true;
        return providers;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private CTPushProvider getCTPushProviderFromPushType(PushConstants.PushType pushType, boolean bl) {
        CTPushProvider pushProvider;
        void pushType2;
        boolean[] blArray = PushProviders.$jacocoInit();
        String className = pushType2.getCtProviderClassName();
        Object var5_5 = null;
        try {
            void isInit;
            blArray[164] = true;
            Class<?> providerClass = Class.forName(className);
            if (isInit != false) {
                void constructor;
                blArray[165] = true;
                Constructor<?> constructor2 = providerClass.getConstructor(CTPushProviderListener.class, Context.class, CleverTapInstanceConfig.class);
                blArray[166] = true;
                pushProvider = (CTPushProvider)constructor.newInstance(this, this.context, this.config);
                blArray[167] = true;
            } else {
                blArray[168] = true;
                Constructor<?> constructor = providerClass.getConstructor(CTPushProviderListener.class, Context.class, CleverTapInstanceConfig.class, Boolean.class);
                blArray[169] = true;
                pushProvider = (CTPushProvider)constructor.newInstance(this, this.context, this.config, false);
                blArray[170] = true;
            }
            this.config.log("PushProvider", "Found provider:" + className);
            blArray[171] = true;
        }
        catch (InstantiationException providerClass) {
            blArray[172] = true;
            this.config.log("PushProvider", "Unable to create provider InstantiationException" + className);
            blArray[173] = true;
        }
        catch (IllegalAccessException e) {
            blArray[174] = true;
            this.config.log("PushProvider", "Unable to create provider IllegalAccessException" + className);
            blArray[175] = true;
        }
        catch (ClassNotFoundException e) {
            blArray[176] = true;
            this.config.log("PushProvider", "Unable to create provider ClassNotFoundException" + className);
            blArray[177] = true;
        }
        catch (Exception e) {
            blArray[178] = true;
            blArray[179] = true;
            blArray[180] = true;
            this.config.log("PushProvider", "Unable to create provider " + className + " Exception:" + e.getClass().getName());
            blArray[181] = true;
        }
        blArray[182] = true;
        return pushProvider;
    }

    /*
     * WARNING - void declaration
     */
    private void deviceTokenDidRefresh(String string, PushConstants.PushType pushType) {
        boolean[] blArray = PushProviders.$jacocoInit();
        if (this.tokenRefreshListener == null) {
            blArray[183] = true;
        } else {
            void type;
            void token;
            blArray[184] = true;
            this.config.getLogger().debug(this.config.getAccountId(), "Notifying devicePushTokenDidRefresh: " + (String)token);
            blArray[185] = true;
            this.tokenRefreshListener.devicePushTokenDidRefresh((String)token, (PushConstants.PushType)type);
            blArray[186] = true;
        }
        blArray[187] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void findCTPushProviders(List<CTPushProvider> list) {
        void providers;
        boolean[] blArray = PushProviders.$jacocoInit();
        if (providers.isEmpty()) {
            blArray[188] = true;
            this.config.log("PushProvider", "No push providers found!. Make sure to install at least one push provider");
            blArray[189] = true;
            return;
        }
        Iterator iterator = providers.iterator();
        blArray[190] = true;
        while (iterator.hasNext()) {
            void provider;
            CTPushProvider cTPushProvider = (CTPushProvider)iterator.next();
            blArray[191] = true;
            if (!this.isValid((CTPushProvider)provider)) {
                blArray[192] = true;
                this.config.log("PushProvider", "Invalid Provider: " + provider.getClass());
                blArray[193] = true;
                continue;
            }
            if (!provider.isSupported()) {
                blArray[194] = true;
                this.config.log("PushProvider", "Unsupported Provider: " + provider.getClass());
                blArray[195] = true;
                continue;
            }
            if (provider.isAvailable()) {
                blArray[196] = true;
                this.config.log("PushProvider", "Available Provider: " + provider.getClass());
                blArray[197] = true;
                this.availableCTPushProviders.add((CTPushProvider)provider);
                blArray[198] = true;
            } else {
                this.config.log("PushProvider", "Unavailable Provider: " + provider.getClass());
                blArray[199] = true;
            }
            blArray[200] = true;
        }
        blArray[201] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void findCustomEnabledPushTypes() {
        boolean[] blArray = PushProviders.$jacocoInit();
        this.customEnabledPushTypes.addAll(this.allEnabledPushTypes);
        blArray[202] = true;
        Iterator<CTPushProvider> iterator = this.availableCTPushProviders.iterator();
        blArray[203] = true;
        while (iterator.hasNext()) {
            void pushProvider;
            CTPushProvider cTPushProvider = iterator.next();
            blArray[204] = true;
            this.customEnabledPushTypes.remove((Object)pushProvider.getPushType());
            blArray[205] = true;
        }
        blArray[206] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void findEnabledPushTypes() {
        boolean[] blArray = PushProviders.$jacocoInit();
        PushConstants.PushType[] pushTypeArray = PushNotificationUtil.getPushTypes(this.config.getAllowedPushTypes());
        int n = pushTypeArray.length;
        blArray[207] = true;
        for (int i = 0; i < n; ++i) {
            void className;
            void pushType;
            PushConstants.PushType pushType2 = pushTypeArray[i];
            blArray[208] = true;
            String string = pushType.getMessagingSDKClassName();
            try {
                blArray[209] = true;
                Class.forName((String)className);
                blArray[210] = true;
                this.allEnabledPushTypes.add((PushConstants.PushType)pushType);
                blArray[211] = true;
                this.config.log("PushProvider", "SDK Class Available :" + (String)className);
                blArray[212] = true;
                if (pushType.getRunningDevices() != 3) {
                    blArray[213] = true;
                } else {
                    blArray[214] = true;
                    this.allEnabledPushTypes.remove(pushType);
                    blArray[215] = true;
                    this.allDisabledPushTypes.add((PushConstants.PushType)pushType);
                    blArray[216] = true;
                    this.config.log("PushProvider", "disabling " + pushType + " due to flag set as PushConstants.NO_DEVICES");
                    blArray[217] = true;
                }
                if (pushType.getRunningDevices() != 2) {
                    blArray[218] = true;
                } else {
                    blArray[219] = true;
                    if (PackageUtils.isXiaomiDeviceRunningMiui(this.context)) {
                        blArray[220] = true;
                    } else {
                        blArray[221] = true;
                        this.allEnabledPushTypes.remove(pushType);
                        blArray[222] = true;
                        this.allDisabledPushTypes.add((PushConstants.PushType)pushType);
                        blArray[223] = true;
                        this.config.log("PushProvider", "disabling " + pushType + " due to flag set as PushConstants.XIAOMI_MIUI_DEVICES");
                        blArray[224] = true;
                    }
                }
                blArray[225] = true;
            }
            catch (Exception exception) {
                void e;
                blArray[226] = true;
                blArray[227] = true;
                blArray[228] = true;
                this.config.log("PushProvider", "SDK class Not available " + (String)className + " Exception:" + e.getClass().getName());
                blArray[229] = true;
            }
            blArray[230] = true;
        }
        blArray[231] = true;
    }

    /*
     * WARNING - void declaration
     */
    private int getPingFrequency(Context context) {
        void context2;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[232] = true;
        return StorageHelper.getInt((Context)context2, "pf", 240);
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void providers;
        boolean[] blArray = PushProviders.$jacocoInit();
        this.findEnabledPushTypes();
        blArray[233] = true;
        List<CTPushProvider> list = this.createProviders();
        blArray[234] = true;
        this.findCTPushProviders((List<CTPushProvider>)providers);
        blArray[235] = true;
        this.findCustomEnabledPushTypes();
        blArray[236] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void initPushAmp() {
        boolean[] blArray = PushProviders.$jacocoInit();
        if (!this.config.isBackgroundSync()) {
            blArray[237] = true;
        } else {
            blArray[238] = true;
            if (this.config.isAnalyticsOnly()) {
                blArray[239] = true;
            } else {
                void task;
                blArray[240] = true;
                Task task2 = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
                blArray[241] = true;
                task.execute("createOrResetJobScheduler", new Callable<Void>(this){
                    final /* synthetic */ PushProviders this$0;
                    private static transient /* synthetic */ boolean[] $jacocoData;
                    {
                        void this$0;
                        boolean[] blArray = 6.$jacocoInit();
                        this.this$0 = this$0;
                        blArray[0] = true;
                    }

                    @Override
                    public Void call() {
                        boolean[] blArray = 6.$jacocoInit();
                        if (Build.VERSION.SDK_INT >= 21) {
                            blArray[1] = true;
                            PushProviders.access$600(this.this$0, PushProviders.access$500(this.this$0));
                            blArray[2] = true;
                        } else {
                            PushProviders.access$1200(this.this$0, PushProviders.access$500(this.this$0));
                            blArray[3] = true;
                        }
                        blArray[4] = true;
                        return null;
                    }

                    private static /* synthetic */ boolean[] $jacocoInit() {
                        boolean[] blArray = $jacocoData;
                        if ($jacocoData == null) {
                            blArray = $jacocoData = Offline.getProbes((long)-4520325936482340079L, (String)"com/clevertap/android/sdk/pushnotification/PushProviders$6", (int)6);
                        }
                        return blArray;
                    }
                });
                blArray[242] = true;
            }
        }
        blArray[243] = true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isTimeBetweenDNDTime(Date var1_1, Date var2_2, Date var3_3) {
        block6: {
            var4_4 = PushProviders.$jacocoInit();
            var5_5 = Calendar.getInstance();
            var4_4[244] = true;
            startTimeCalendar.setTime((Date)startTime);
            var4_4[245] = true;
            var6_6 = Calendar.getInstance();
            var4_4[246] = true;
            currentTimeCalendar.setTime((Date)currentTime);
            var4_4[247] = true;
            var7_7 = Calendar.getInstance();
            var4_4[248] = true;
            stopTimeCalendar.setTime((Date)stopTime);
            var4_4[249] = true;
            if (stopTime.compareTo((Date)startTime) >= 0) {
                var4_4[250] = true;
            } else {
                var4_4[251] = true;
                if (currentTimeCalendar.compareTo((Calendar)stopTimeCalendar) >= 0) {
                    var4_4[252] = true;
                } else {
                    var4_4[253] = true;
                    currentTimeCalendar.add(5, 1);
                    var4_4[254] = true;
                }
                stopTimeCalendar.add(5, 1);
                var4_4[255] = true;
            }
            if (currentTimeCalendar.compareTo((Calendar)startTimeCalendar) >= 0) break block6;
            var4_4[256] = true;
            ** GOTO lbl35
        }
        var4_4[257] = true;
        if (currentTimeCalendar.compareTo((Calendar)stopTimeCalendar) < 0) {
            v0 = var4_4[259] = true;
        } else {
            var4_4[258] = true;
lbl35:
            // 2 sources

            v0 = false;
            var4_4[260] = true;
        }
        var4_4[261] = true;
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValid(CTPushProvider cTPushProvider) {
        void provider;
        boolean[] blArray = PushProviders.$jacocoInit();
        if (40500 < provider.minSDKSupportVersionCode()) {
            blArray[262] = true;
            this.config.log("PushProvider", "Provider: %s version %s does not match the SDK version %s. Make sure all CleverTap dependencies are the same version.");
            blArray[263] = true;
            return false;
        }
        switch (8.$SwitchMap$com$clevertap$android$sdk$pushnotification$PushConstants$PushType[provider.getPushType().ordinal()]) {
            default: {
                blArray[264] = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (provider.getPlatform() == 1) {
                    blArray[265] = true;
                    break;
                }
                blArray[266] = true;
                blArray[267] = true;
                blArray[268] = true;
                this.config.log("PushProvider", "Invalid Provider: " + provider.getClass() + " delivery is only available for Android platforms." + (Object)((Object)provider.getPushType()));
                blArray[269] = true;
                return false;
            }
            case 5: {
                if (provider.getPlatform() == 2) {
                    blArray[270] = true;
                    break;
                }
                blArray[271] = true;
                blArray[272] = true;
                blArray[273] = true;
                blArray[274] = true;
                this.config.log("PushProvider", "Invalid Provider: " + provider.getClass() + " ADM delivery is only available for Amazon platforms." + (Object)((Object)provider.getPushType()));
                blArray[275] = true;
                return false;
            }
        }
        blArray[276] = true;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private Date parseTimeToDate(String string) {
        boolean[] blArray = PushProviders.$jacocoInit();
        String string2 = "HH:mm";
        blArray[277] = true;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm", Locale.US);
        try {
            void time;
            void inputParser;
            blArray[278] = true;
            blArray[279] = true;
            return inputParser.parse((String)time);
        }
        catch (ParseException parseException) {
            blArray[280] = true;
            blArray[281] = true;
            return new Date(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void pushDeviceTokenEvent(String string, boolean bl, PushConstants.PushType pushType) {
        String string2;
        String token;
        void pushType2;
        boolean[] blArray = PushProviders.$jacocoInit();
        if (pushType2 == null) {
            blArray[282] = true;
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)token)) {
            string2 = token;
            blArray[283] = true;
        } else {
            string2 = this.getCachedToken((PushConstants.PushType)pushType2);
            blArray[284] = true;
        }
        token = string2;
        blArray[285] = true;
        if (TextUtils.isEmpty((CharSequence)token)) {
            blArray[286] = true;
            return;
        }
        Object object = this.tokenLock;
        synchronized (object) {
            try {
                void action;
                String string3;
                void register;
                blArray[287] = true;
                JSONObject jSONObject = new JSONObject();
                blArray[288] = true;
                JSONObject data = new JSONObject();
                if (register != false) {
                    string3 = "register";
                    blArray[289] = true;
                } else {
                    string3 = "unregister";
                    blArray[290] = true;
                }
                String string4 = string3;
                try {
                    void event;
                    blArray[291] = true;
                    data.put("action", (Object)action);
                    blArray[292] = true;
                    data.put("id", (Object)token);
                    blArray[293] = true;
                    data.put("type", (Object)pushType2.getType());
                    blArray[294] = true;
                    event.put("data", (Object)data);
                    blArray[295] = true;
                    this.config.getLogger().verbose(this.config.getAccountId(), pushType2 + (String)action + " device token " + token);
                    blArray[296] = true;
                    this.analyticsManager.sendDataEvent((JSONObject)event);
                    blArray[297] = true;
                }
                catch (Throwable throwable) {
                    void t;
                    blArray[298] = true;
                    this.config.getLogger().verbose(this.config.getAccountId(), pushType2 + (String)action + " device token failed", (Throwable)t);
                    blArray[299] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl56 : MonitorExitStatement: MONITOREXIT : var5_5
                blArray[300] = true;
                throw throwable;
            }
        }
        blArray[301] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void refreshAllTokens() {
        void task;
        boolean[] blArray = PushProviders.$jacocoInit();
        Task task2 = CTExecutorFactory.executors(this.config).ioTask();
        blArray[302] = true;
        task.execute("PushProviders#refreshAllTokens", new Callable<Void>(this){
            final /* synthetic */ PushProviders this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 7.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public Void call() {
                boolean[] blArray = 7.$jacocoInit();
                PushProviders.access$1300(this.this$0);
                blArray[1] = true;
                PushProviders.access$1400(this.this$0);
                blArray[2] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-6127856697771820302L, (String)"com/clevertap/android/sdk/pushnotification/PushProviders$7", (int)4);
                }
                return blArray;
            }
        });
        blArray[303] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void refreshCTProviderTokens() {
        boolean[] blArray = PushProviders.$jacocoInit();
        Iterator<CTPushProvider> iterator = this.availableCTPushProviders.iterator();
        blArray[304] = true;
        while (iterator.hasNext()) {
            void pushProvider;
            CTPushProvider cTPushProvider = iterator.next();
            try {
                blArray[305] = true;
                pushProvider.requestToken();
                blArray[306] = true;
            }
            catch (Throwable throwable) {
                void t;
                blArray[307] = true;
                this.config.log("PushProvider", "Token Refresh error " + pushProvider, (Throwable)t);
                blArray[308] = true;
            }
            blArray[309] = true;
        }
        blArray[310] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void refreshCustomProviderTokens() {
        boolean[] blArray = PushProviders.$jacocoInit();
        Iterator<PushConstants.PushType> iterator = this.customEnabledPushTypes.iterator();
        blArray[311] = true;
        while (iterator.hasNext()) {
            void pushType;
            PushConstants.PushType pushType2 = iterator.next();
            try {
                blArray[312] = true;
                this.pushDeviceTokenEvent(this.getCachedToken((PushConstants.PushType)pushType), true, (PushConstants.PushType)pushType);
                blArray[313] = true;
            }
            catch (Throwable throwable) {
                void t;
                blArray[314] = true;
                this.config.log("PushProvider", "Token Refresh error " + pushType, (Throwable)t);
                blArray[315] = true;
            }
            blArray[316] = true;
        }
        blArray[317] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void registerToken(String string, PushConstants.PushType pushType) {
        void pushType2;
        void token;
        boolean[] blArray = PushProviders.$jacocoInit();
        this.pushDeviceTokenEvent((String)token, true, (PushConstants.PushType)pushType2);
        blArray[318] = true;
        this.cacheToken((String)token, (PushConstants.PushType)pushType2);
        blArray[319] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void resetAlarmScheduler(Context context) {
        void context2;
        boolean[] blArray = PushProviders.$jacocoInit();
        if (this.getPingFrequency((Context)context2) <= 0) {
            blArray[320] = true;
            this.stopAlarmScheduler((Context)context2);
            blArray[321] = true;
        } else {
            this.stopAlarmScheduler((Context)context2);
            blArray[322] = true;
            this.createAlarmScheduler((Context)context2);
            blArray[323] = true;
        }
        blArray[324] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void setPingFrequency(Context context, int n) {
        void pingFrequency;
        void context2;
        boolean[] blArray = PushProviders.$jacocoInit();
        StorageHelper.putInt((Context)context2, "pf", (int)pingFrequency);
        blArray[325] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void createAlarmScheduler(Context context) {
        void context2;
        boolean[] blArray = PushProviders.$jacocoInit();
        int pingFrequency = this.getPingFrequency((Context)context2);
        if (pingFrequency <= 0) {
            blArray[326] = true;
        } else {
            void alarmManager;
            void intent;
            blArray[327] = true;
            AlarmManager alarmManager2 = (AlarmManager)context2.getSystemService("alarm");
            blArray[328] = true;
            Intent intent2 = new Intent("com.clevertap.BG_EVENT");
            blArray[329] = true;
            intent.setPackage(context2.getPackageName());
            int flagsAlarmPendingIntent = 0x8000000;
            if (Build.VERSION.SDK_INT < 31) {
                blArray[330] = true;
            } else {
                flagsAlarmPendingIntent |= 0x2000000;
                blArray[331] = true;
            }
            blArray[332] = true;
            PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context2, (int)this.config.getAccountId().hashCode(), (Intent)intent, (int)flagsAlarmPendingIntent);
            if (alarmManager == null) {
                blArray[333] = true;
            } else {
                blArray[334] = true;
                alarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime(), 60000L * (long)pingFrequency, alarmPendingIntent);
                blArray[335] = true;
            }
        }
        blArray[336] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void stopAlarmScheduler(Context context) {
        void alarmManager;
        void cancelIntent;
        void context2;
        boolean[] blArray = PushProviders.$jacocoInit();
        AlarmManager alarmManager2 = (AlarmManager)context2.getSystemService("alarm");
        blArray[337] = true;
        Intent intent = new Intent("com.clevertap.BG_EVENT");
        blArray[338] = true;
        cancelIntent.setPackage(context2.getPackageName());
        int flagsAlarmPendingIntent = 0x8000000;
        if (Build.VERSION.SDK_INT < 31) {
            blArray[339] = true;
        } else {
            flagsAlarmPendingIntent |= 0x2000000;
            blArray[340] = true;
        }
        blArray[341] = true;
        PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context2, (int)this.config.getAccountId().hashCode(), (Intent)cancelIntent, (int)flagsAlarmPendingIntent);
        if (alarmManager == null) {
            blArray[342] = true;
        } else if (alarmPendingIntent == null) {
            blArray[343] = true;
        } else {
            blArray[344] = true;
            alarmManager.cancel(alarmPendingIntent);
            blArray[345] = true;
        }
        blArray[346] = true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public INotificationRenderer getPushNotificationRenderer() {
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[347] = true;
        return this.iNotificationRenderer;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(api=21)
    private static JobInfo getJobInfo(int n, JobScheduler jobScheduler) {
        void jobScheduler2;
        boolean[] blArray = PushProviders.$jacocoInit();
        Iterator iterator = jobScheduler2.getAllPendingJobs().iterator();
        blArray[348] = true;
        while (iterator.hasNext()) {
            int jobId;
            void jobInfo;
            JobInfo jobInfo2 = (JobInfo)iterator.next();
            blArray[349] = true;
            if (jobInfo.getId() == jobId) {
                blArray[350] = true;
                return jobInfo;
            }
            blArray[351] = true;
        }
        blArray[352] = true;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setPushNotificationRenderer(@NonNull INotificationRenderer iNotificationRenderer) {
        void iNotificationRenderer2;
        boolean[] blArray = PushProviders.$jacocoInit();
        this.iNotificationRenderer = iNotificationRenderer2;
        blArray[353] = true;
    }

    /*
     * Unable to fully structure code
     */
    private void triggerNotification(Context var1_1, Bundle var2_2, int var3_3) {
        block71: {
            block59: {
                block57: {
                    block56: {
                        var4_4 = PushProviders.$jacocoInit();
                        var4_4[354] = true;
                        notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            var6_6 = "Unable to render notification, Notification Manager is null.";
                            var4_4[355] = true;
                            this.config.getLogger().debug(this.config.getAccountId(), (String)notificationManagerError);
                            var4_4[356] = true;
                            return;
                        }
                        channelId = extras.getString("wzrk_cid", "");
                        if (Build.VERSION.SDK_INT >= 26) {
                            v0 = var4_4[357] = true;
                        } else {
                            v0 = false;
                            var4_4[358] = true;
                        }
                        requiresChannelId = v0;
                        if (Build.VERSION.SDK_INT < 26) {
                            var4_4[359] = true;
                        } else {
                            messageCode = -1;
                            var9_10 = "";
                            var4_4[360] = true;
                            if (channelId.isEmpty()) {
                                messageCode = 8;
                                var4_4[361] = true;
                                value = extras.toString();
                                var4_4[362] = true;
                            } else if (notificationManager.getNotificationChannel(channelId) != null) {
                                var4_4[363] = true;
                            } else {
                                messageCode = 9;
                                value = channelId;
                                var4_4[364] = true;
                            }
                            if (messageCode == -1) {
                                var4_4[365] = true;
                            } else {
                                var4_4[366] = true;
                                var10_13 = ValidationResultFactory.create(512, messageCode, new String[]{value});
                                var4_4[367] = true;
                                this.config.getLogger().debug(this.config.getAccountId(), channelIdError.getErrorDesc());
                                var4_4[368] = true;
                                this.validationResultStack.pushValidationResult((ValidationResult)channelIdError);
                                var4_4[369] = true;
                                return;
                            }
                        }
                        try {
                            x = ManifestInfo.getInstance((Context)context).getNotificationIcon();
                            if (x == null) {
                                var4_4[370] = true;
                                var4_4[371] = true;
                                throw new IllegalArgumentException();
                            }
                            smallIcon = context.getResources().getIdentifier(x, "drawable", context.getPackageName());
                            if (smallIcon == 0) {
                                var4_4[372] = true;
                                var4_4[373] = true;
                                throw new IllegalArgumentException();
                            }
                            var4_4[374] = true;
                        }
                        catch (Throwable x) {
                            var4_4[375] = true;
                            smallIcon = DeviceInfo.getAppIconAsIntId((Context)context);
                            var4_4[376] = true;
                        }
                        this.iNotificationRenderer.setSmallIcon(smallIcon, (Context)context);
                        t = false;
                        var4_4[377] = true;
                        priority = extras.getString("pr");
                        if (priority == null) {
                            var4_4[378] = true;
                        } else {
                            var4_4[379] = true;
                            if (!priority.equals("high")) {
                                var4_4[380] = true;
                            } else {
                                priorityInt = 1;
                                var4_4[381] = true;
                            }
                            if (!priority.equals("max")) {
                                var4_4[382] = true;
                            } else {
                                priorityInt = 2;
                                var4_4[383] = true;
                            }
                        }
                        if (notificationId != -1000) break block57;
                        try {
                            block58: {
                                var4_4[384] = true;
                                var4_4[385] = true;
                                collapse_key = this.iNotificationRenderer.getCollapseKey((Bundle)extras);
                                if (collapse_key == null) {
                                    var4_4[386] = true;
                                    break block56;
                                }
                                if (collapse_key instanceof Number) {
                                    var4_4[387] = true;
                                    notificationId = ((Number)collapse_key).intValue();
                                    var4_4[388] = true;
                                } else if (!(collapse_key instanceof String)) {
                                    var4_4[389] = true;
                                } else {
                                    var4_4[390] = true;
                                    notificationId = Integer.parseInt(collapse_key.toString());
                                    var4_4[391] = true;
                                    this.config.getLogger().verbose(this.config.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                                    var4_4[392] = true;
                                }
                                break block58;
                                catch (NumberFormatException var12_17) {
                                    var4_4[393] = true;
                                    notificationId = collapse_key.toString().hashCode();
                                    var4_4[394] = true;
                                    this.config.getLogger().verbose(this.config.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                                    var4_4[395] = true;
                                }
                            }
                            notificationId = Math.abs(notificationId);
                            var4_4[396] = true;
                            this.config.getLogger().debug(this.config.getAccountId(), "Creating the notification id: " + notificationId + " from collapse_key: " + collapse_key);
                        }
                        catch (NumberFormatException collapse_key) {
                            var4_4[399] = true;
                        }
                        var4_4[397] = true;
                    }
                    var4_4[398] = true;
                    break block59;
                    break block59;
                }
                this.config.getLogger().debug(this.config.getAccountId(), "Have user provided notificationId: " + notificationId + " won't use collapse_key (if any) as basis for notificationId");
                var4_4[400] = true;
            }
            if (notificationId != -1000) {
                var4_4[401] = true;
            } else {
                var4_4[402] = true;
                notificationId = (int)(Math.random() * 100.0);
                var4_4[403] = true;
                this.config.getLogger().debug(this.config.getAccountId(), "Setting random notificationId: " + notificationId);
                var4_4[404] = true;
            }
            if (requiresChannelId) {
                var4_4[405] = true;
                nb = new NotificationCompat.Builder((Context)context, channelId);
                var4_4[406] = true;
                badgeIconParam = extras.getString("wzrk_bi", null);
                if (badgeIconParam == null) {
                    var4_4[407] = true;
                } else {
                    try {
                        var4_4[408] = true;
                        badgeIconType = Integer.parseInt(badgeIconParam);
                        if (badgeIconType < 0) {
                            var4_4[409] = true;
                        } else {
                            var4_4[410] = true;
                            nb.setBadgeIconType(badgeIconType);
                            var4_4[411] = true;
                        }
                        var4_4[412] = true;
                    }
                    catch (Throwable badgeIconType) {
                        var4_4[413] = true;
                    }
                }
                badgeCountParam = extras.getString("wzrk_bc", null);
                if (badgeCountParam == null) {
                    var4_4[414] = true;
                } else {
                    try {
                        var4_4[415] = true;
                        badgeCount = Integer.parseInt((String)badgeCountParam);
                        if (badgeCount < 0) {
                            var4_4[416] = true;
                        } else {
                            var4_4[417] = true;
                            nb.setNumber(badgeCount);
                            var4_4[418] = true;
                        }
                        var4_4[419] = true;
                    }
                    catch (Throwable badgeCount) {
                        var4_4[420] = true;
                    }
                }
                var4_4[421] = true;
            } else {
                nb = new NotificationCompat.Builder((Context)context);
                var4_4[422] = true;
            }
            nb.setPriority(priorityInt);
            try {
                block61: {
                    block65: {
                        block70: {
                            block69: {
                                block68: {
                                    block67: {
                                        block66: {
                                            block63: {
                                                block64: {
                                                    block62: {
                                                        block60: {
                                                            var4_4[423] = true;
                                                            if (extras.containsKey("wzrk_sound")) break block60;
                                                            var4_4[424] = true;
                                                            break block61;
                                                        }
                                                        badgeIconParam = null;
                                                        var4_4[425] = true;
                                                        badgeCountParam = extras.get("wzrk_sound");
                                                        var4_4[426] = true;
                                                        if (o instanceof Boolean) break block62;
                                                        var4_4[427] = true;
                                                        break block63;
                                                    }
                                                    if (!((Boolean)o).booleanValue()) break block64;
                                                    var4_4[429] = true;
                                                    soundUri = RingtoneManager.getDefaultUri((int)2);
                                                    var4_4[430] = true;
                                                    break block65;
                                                }
                                                var4_4[428] = true;
                                            }
                                            if (o instanceof String) break block66;
                                            var4_4[431] = true;
                                            break block65;
                                        }
                                        badgeCount = o;
                                        var4_4[432] = true;
                                        if (!s.equals("true")) break block67;
                                        var4_4[433] = true;
                                        soundUri = RingtoneManager.getDefaultUri((int)2);
                                        var4_4[434] = true;
                                        break block65;
                                    }
                                    if (!s.isEmpty()) break block68;
                                    var4_4[435] = true;
                                    break block65;
                                }
                                var4_4[436] = true;
                                if (!s.contains(".mp3")) break block69;
                                var4_4[437] = true;
                                ** GOTO lbl230
                            }
                            if (!s.contains(".ogg")) break block70;
                            var4_4[438] = true;
                            ** GOTO lbl230
                        }
                        if (!s.contains(".wav")) {
                            var4_4[439] = true;
                        } else {
                            var4_4[440] = true;
lbl230:
                            // 3 sources

                            s = s.substring(0, s.length() - 4);
                            var4_4[441] = true;
                        }
                        var4_4[442] = true;
                        soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + s));
                        var4_4[443] = true;
                    }
                    if (soundUri == null) {
                        var4_4[444] = true;
                    } else {
                        var4_4[445] = true;
                        nb.setSound(soundUri);
                        var4_4[446] = true;
                    }
                }
                var4_4[447] = true;
            }
            catch (Throwable soundUri) {
                var4_4[448] = true;
                this.config.getLogger().debug(this.config.getAccountId(), "Could not process sound parameter", (Throwable)t);
                var4_4[449] = true;
            }
            nb = this.iNotificationRenderer.renderNotification((Bundle)extras, (Context)context, nb, this.config, notificationId);
            if (nb == null) {
                var4_4[450] = true;
                return;
            }
            t = nb.build();
            var4_4[451] = true;
            notificationManager.notify(notificationId, (Notification)n);
            var4_4[452] = true;
            this.config.getLogger().debug(this.config.getAccountId(), "Rendered notification: " + n.toString());
            var4_4[453] = true;
            o = extras.getString("extras_from");
            var4_4[454] = true;
            if (extrasFrom != null) break block71;
            var4_4[455] = true;
            ** GOTO lbl270
        }
        if (extrasFrom.equals("PTReceiver")) {
            var4_4[456] = true;
        } else {
            var4_4[457] = true;
lbl270:
            // 2 sources

            var4_4[458] = true;
            var4_4[459] = true;
            s = extras.getString("wzrk_ttl", (System.currentTimeMillis() + 345600000L) / 1000L + "");
            var4_4[460] = true;
            var15_27 = Long.parseLong((String)ttl);
            var4_4[461] = true;
            var17_28 = extras.getString("wzrk_pid");
            var4_4[462] = true;
            var18_29 = this.baseDatabaseManager.loadDBAdapter((Context)context);
            var4_4[463] = true;
            this.config.getLogger().verbose("Storing Push Notification..." + (String)wzrk_pid + " - with ttl - " + (String)ttl);
            var4_4[464] = true;
            dbAdapter.storePushNotificationId((String)wzrk_pid, (long)wzrk_ttl);
            var4_4[465] = true;
            notificationViewedEnabled = "true".equals(extras.getString("wzrk_rnv", ""));
            if (!notificationViewedEnabled) {
                v1 = new String[1];
                var4_4[466] = true;
                v1[0] = extras.toString();
                var20_31 = ValidationResultFactory.create(512, 10, v1);
                var4_4[467] = true;
                this.config.getLogger().debug(notificationViewedError.getErrorDesc());
                var4_4[468] = true;
                this.validationResultStack.pushValidationResult((ValidationResult)notificationViewedError);
                var4_4[469] = true;
                return;
            }
            this.analyticsManager.pushNotificationViewedEvent((Bundle)extras);
            var4_4[470] = true;
        }
        var4_4[471] = true;
    }

    static /* synthetic */ CleverTapInstanceConfig access$000(PushProviders pushProviders) {
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[472] = true;
        return x0.config;
    }

    static /* synthetic */ BaseDatabaseManager access$100(PushProviders pushProviders) {
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[473] = true;
        return x0.baseDatabaseManager;
    }

    static /* synthetic */ INotificationRenderer access$200(PushProviders pushProviders) {
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[474] = true;
        return x0.iNotificationRenderer;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(PushProviders pushProviders, Context context, Bundle bundle, int n) {
        void x3;
        void x2;
        void x1;
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        x0.triggerNotification((Context)x1, (Bundle)x2, (int)x3);
        blArray[475] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$400(PushProviders pushProviders, String string, PushConstants.PushType pushType) {
        void x2;
        void x1;
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[476] = true;
        return x0.alreadyHaveToken((String)x1, (PushConstants.PushType)x2);
    }

    static /* synthetic */ Context access$500(PushProviders pushProviders) {
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[477] = true;
        return x0.context;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(PushProviders pushProviders, Context context) {
        void x1;
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        x0.createOrResetJobScheduler((Context)x1);
        blArray[478] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(PushProviders pushProviders, Context context) {
        void x1;
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        x0.resetAlarmScheduler((Context)x1);
        blArray[479] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Date access$800(PushProviders pushProviders, String string) {
        void x1;
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[480] = true;
        return x0.parseTimeToDate((String)x1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$900(PushProviders pushProviders, Date date, Date date2, Date date3) {
        void x3;
        void x2;
        void x1;
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[481] = true;
        return x0.isTimeBetweenDNDTime((Date)x1, (Date)x2, (Date)x3);
    }

    static /* synthetic */ AnalyticsManager access$1000(PushProviders pushProviders) {
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[482] = true;
        return x0.analyticsManager;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1100(PushProviders pushProviders, Context context) {
        void x1;
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        blArray[483] = true;
        return x0.getPingFrequency((Context)x1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1200(PushProviders pushProviders, Context context) {
        void x1;
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        x0.createAlarmScheduler((Context)x1);
        blArray[484] = true;
    }

    static /* synthetic */ void access$1300(PushProviders pushProviders) {
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        x0.refreshCTProviderTokens();
        blArray[485] = true;
    }

    static /* synthetic */ void access$1400(PushProviders pushProviders) {
        PushProviders x0;
        boolean[] blArray = PushProviders.$jacocoInit();
        x0.refreshCustomProviderTokens();
        blArray[486] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)8565881502196102571L, (String)"com/clevertap/android/sdk/pushnotification/PushProviders", (int)487);
        }
        return blArray;
    }
}

