/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.gif;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.gif.GifFrame;
import com.clevertap.android.sdk.gif.GifHeader;
import com.clevertap.android.sdk.gif.GifHeaderParser;
import com.clevertap.android.sdk.gif.SimpleBitmapProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import org.jacoco.agent.rt.internal_28bab1d.Offline;

class GifDecoder {
    static final int STATUS_OK = 0;
    static final int STATUS_FORMAT_ERROR = 1;
    static final int STATUS_OPEN_ERROR = 2;
    static final int STATUS_PARTIAL_DECODE = 3;
    static final int LOOP_FOREVER = -1;
    private static final String TAG;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    private static final int NULL_CODE = -1;
    private static final int INITIAL_FRAME_POINTER = -1;
    private static final int BYTES_PER_INTEGER = 4;
    private static final int WORK_BUFFER_SIZE = 16384;
    private int[] act;
    private final BitmapProvider bitmapProvider;
    private byte[] block;
    private int downsampledHeight;
    private int downsampledWidth;
    private int framePointer;
    private GifHeader header;
    private boolean isFirstFrameTransparent;
    private int loopIndex;
    private byte[] mainPixels;
    private int[] mainScratch;
    private GifHeaderParser parser;
    private final int[] pct;
    private byte[] pixelStack;
    private short[] prefix;
    private Bitmap previousImage;
    private ByteBuffer rawData;
    private int sampleSize;
    private boolean savePrevious;
    private int status;
    private byte[] suffix;
    @Nullable
    private byte[] workBuffer;
    private int workBufferPosition;
    private int workBufferSize;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    GifDecoder(BitmapProvider bitmapProvider, GifHeader gifHeader, ByteBuffer byteBuffer) {
        void rawData;
        void gifHeader2;
        void provider;
        boolean[] blArray = GifDecoder.$jacocoInit();
        this((BitmapProvider)provider, (GifHeader)gifHeader2, (ByteBuffer)rawData, 1);
        blArray[0] = true;
    }

    /*
     * WARNING - void declaration
     */
    GifDecoder(BitmapProvider bitmapProvider, GifHeader gifHeader, ByteBuffer byteBuffer, int n) {
        void sampleSize;
        void rawData;
        void gifHeader2;
        void provider;
        boolean[] blArray = GifDecoder.$jacocoInit();
        this((BitmapProvider)provider);
        blArray[1] = true;
        this.setData((GifHeader)gifHeader2, (ByteBuffer)rawData, (int)sampleSize);
        blArray[2] = true;
    }

    /*
     * WARNING - void declaration
     */
    GifDecoder(BitmapProvider bitmapProvider) {
        void provider;
        boolean[] blArray = GifDecoder.$jacocoInit();
        this.pct = new int[256];
        this.workBufferPosition = 0;
        this.workBufferSize = 0;
        this.bitmapProvider = provider;
        blArray[3] = true;
        this.header = new GifHeader();
        blArray[4] = true;
    }

    GifDecoder() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        this(new SimpleBitmapProvider());
        blArray[5] = true;
    }

    boolean advance() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        if (this.header.frameCount <= 0) {
            blArray[6] = true;
            return false;
        }
        if (this.framePointer != this.getFrameCount() - 1) {
            blArray[7] = true;
        } else {
            ++this.loopIndex;
            blArray[8] = true;
        }
        if (this.header.loopCount == -1) {
            blArray[9] = true;
        } else if (this.loopIndex <= this.header.loopCount) {
            blArray[10] = true;
        } else {
            blArray[11] = true;
            return false;
        }
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
        blArray[12] = true;
        return true;
    }

    void clear() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        this.header = null;
        if (this.mainPixels == null) {
            blArray[13] = true;
        } else {
            blArray[14] = true;
            this.bitmapProvider.release(this.mainPixels);
            blArray[15] = true;
        }
        if (this.mainScratch == null) {
            blArray[16] = true;
        } else {
            blArray[17] = true;
            this.bitmapProvider.release(this.mainScratch);
            blArray[18] = true;
        }
        if (this.previousImage == null) {
            blArray[19] = true;
        } else {
            blArray[20] = true;
            this.bitmapProvider.release(this.previousImage);
            blArray[21] = true;
        }
        this.previousImage = null;
        this.rawData = null;
        this.isFirstFrameTransparent = false;
        if (this.block == null) {
            blArray[22] = true;
        } else {
            blArray[23] = true;
            this.bitmapProvider.release(this.block);
            blArray[24] = true;
        }
        if (this.workBuffer == null) {
            blArray[25] = true;
        } else {
            blArray[26] = true;
            this.bitmapProvider.release(this.workBuffer);
            blArray[27] = true;
        }
        blArray[28] = true;
    }

    int getByteSize() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        blArray[29] = true;
        return this.rawData.limit() + this.mainPixels.length + this.mainScratch.length * 4;
    }

    int getCurrentFrameIndex() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        blArray[30] = true;
        return this.framePointer;
    }

    ByteBuffer getData() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        blArray[31] = true;
        return this.rawData;
    }

    /*
     * WARNING - void declaration
     */
    int getDelay(int n) {
        void n2;
        boolean[] blArray = GifDecoder.$jacocoInit();
        int delay = -1;
        if (n2 < 0) {
            blArray[32] = true;
        } else if (n2 >= this.header.frameCount) {
            blArray[33] = true;
        } else {
            blArray[34] = true;
            delay = this.header.frames.get((int)n2).delay;
            blArray[35] = true;
        }
        blArray[36] = true;
        return delay;
    }

    int getFrameCount() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        blArray[37] = true;
        return this.header.frameCount;
    }

    int getHeight() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        blArray[38] = true;
        return this.header.height;
    }

    int getLoopCount() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        blArray[39] = true;
        return this.header.loopCount;
    }

    int getLoopIndex() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        blArray[40] = true;
        return this.loopIndex;
    }

    int getNextDelay() {
        block4: {
            block3: {
                block2: {
                    boolean[] blArray = GifDecoder.$jacocoInit();
                    if (this.header.frameCount > 0) break block2;
                    blArray[41] = true;
                    break block3;
                }
                if (this.framePointer >= 0) break block4;
                blArray[42] = true;
            }
            blArray[43] = true;
            return 0;
        }
        blArray[44] = true;
        return this.getDelay(this.framePointer);
    }

    /*
     * Unable to fully structure code
     */
    synchronized Bitmap getNextFrame() {
        block15: {
            block14: {
                block13: {
                    block12: {
                        var1_1 = GifDecoder.$jacocoInit();
                        if (this.header.frameCount > 0) break block12;
                        var1_1[45] = true;
                        ** GOTO lbl10
                    }
                    if (this.framePointer >= 0) {
                        var1_1[46] = true;
                    } else {
                        var1_1[47] = true;
lbl10:
                        // 2 sources

                        Logger.d(GifDecoder.TAG, "unable to decode frame, frameCount=" + this.header.frameCount + " framePointer=" + this.framePointer);
                        this.status = 1;
                        var1_1[48] = true;
                    }
                    if (this.status != 1) break block13;
                    var1_1[49] = true;
                    break block14;
                }
                if (this.status != 2) break block15;
                var1_1[50] = true;
            }
            Logger.d(GifDecoder.TAG, "Unable to decode frame, status=" + this.status);
            var1_1[51] = true;
            return null;
        }
        this.status = 0;
        var1_1[52] = true;
        currentFrame = this.header.frames.get(this.framePointer);
        previousFrame = null;
        previousIndex = this.framePointer - 1;
        if (previousIndex < 0) {
            var1_1[53] = true;
        } else {
            var1_1[54] = true;
            previousFrame = this.header.frames.get(previousIndex);
            var1_1[55] = true;
        }
        if (currentFrame.lct != null) {
            v0 = currentFrame.lct;
            var1_1[56] = true;
        } else {
            v0 = this.header.gct;
            var1_1[57] = true;
        }
        this.act = v0;
        if (this.act == null) {
            var1_1[58] = true;
            Logger.d(GifDecoder.TAG, "No Valid Color Table for frame #" + this.framePointer);
            this.status = 1;
            var1_1[59] = true;
            return null;
        }
        if (!currentFrame.transparency) {
            var1_1[60] = true;
        } else {
            var1_1[61] = true;
            System.arraycopy(this.act, 0, this.pct, 0, this.act.length);
            this.act = this.pct;
            this.act[currentFrame.transIndex] = 0;
            var1_1[62] = true;
        }
        var1_1[63] = true;
        return this.setPixels(currentFrame, previousFrame);
    }

    int getStatus() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        blArray[64] = true;
        return this.status;
    }

    int getWidth() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        blArray[65] = true;
        return this.header.width;
    }

    /*
     * Unable to fully structure code
     */
    int read(InputStream var1_1, int var2_2) {
        block9: {
            var3_3 = GifDecoder.$jacocoInit();
            if (is == null) break block9;
            try {
                var3_3[66] = true;
                if (contentLength > 0) {
                    v0 = contentLength + 4096;
                    var3_3[67] = true;
                } else {
                    v0 = 16384;
                    var3_3[68] = true;
                }
                var4_4 = v0;
                var3_3[69] = true;
                buffer = new ByteArrayOutputStream((int)capacity);
                var7_8 = new byte[16384];
                var3_3[70] = true;
                while ((nRead = is.read((byte[])data, 0, ((void)data).length)) != -1) {
                    var3_3[71] = true;
                    buffer.write((byte[])data, 0, nRead);
                    var3_3[72] = true;
                }
                buffer.flush();
                var3_3[73] = true;
                this.read(buffer.toByteArray());
                var3_3[74] = true;
            }
            catch (IOException capacity) {
                var3_3[75] = true;
                Logger.d(GifDecoder.TAG, "Error reading data from stream", (Throwable)e);
                var3_3[76] = true;
            }
            ** GOTO lbl36
        }
        this.status = 2;
        try {
            var3_3[77] = true;
lbl36:
            // 3 sources

            if (is == null) {
                var3_3[78] = true;
            } else {
                var3_3[79] = true;
                is.close();
                var3_3[80] = true;
            }
            var3_3[81] = true;
        }
        catch (IOException e) {
            var3_3[82] = true;
            Logger.d(GifDecoder.TAG, "Error closing stream", e);
            var3_3[83] = true;
        }
        var3_3[84] = true;
        return this.status;
    }

    /*
     * WARNING - void declaration
     */
    synchronized int read(byte[] byArray) {
        void data;
        boolean[] blArray = GifDecoder.$jacocoInit();
        this.header = this.getHeaderParser().setData((byte[])data).parseHeader();
        if (data == null) {
            blArray[85] = true;
        } else {
            blArray[86] = true;
            this.setData(this.header, (byte[])data);
            blArray[87] = true;
        }
        blArray[88] = true;
        return this.status;
    }

    void resetFrameIndex() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        this.framePointer = -1;
        blArray[89] = true;
    }

    void resetLoopIndex() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        this.loopIndex = 0;
        blArray[90] = true;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setData(GifHeader gifHeader, byte[] byArray) {
        void data;
        void header;
        boolean[] blArray = GifDecoder.$jacocoInit();
        this.setData((GifHeader)header, ByteBuffer.wrap((byte[])data));
        blArray[91] = true;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setData(GifHeader gifHeader, ByteBuffer byteBuffer) {
        void buffer;
        void header;
        boolean[] blArray = GifDecoder.$jacocoInit();
        this.setData((GifHeader)header, (ByteBuffer)buffer, 1);
        blArray[92] = true;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setData(GifHeader gifHeader, ByteBuffer byteBuffer, int n) {
        void buffer;
        void header;
        int sampleSize;
        boolean[] blArray = GifDecoder.$jacocoInit();
        if (sampleSize <= 0) {
            blArray[93] = true;
            blArray[94] = true;
            throw new IllegalArgumentException("Sample size must be >=0, not: " + sampleSize);
        }
        sampleSize = Integer.highestOneBit(sampleSize);
        this.status = 0;
        this.header = header;
        this.isFirstFrameTransparent = false;
        this.framePointer = -1;
        blArray[95] = true;
        this.resetLoopIndex();
        blArray[96] = true;
        this.rawData = buffer.asReadOnlyBuffer();
        blArray[97] = true;
        this.rawData.position(0);
        blArray[98] = true;
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        this.savePrevious = false;
        blArray[99] = true;
        Iterator<GifFrame> iterator = header.frames.iterator();
        blArray[100] = true;
        while (true) {
            if (!iterator.hasNext()) {
                blArray[101] = true;
                break;
            }
            GifFrame frame = iterator.next();
            if (frame.dispose == 3) {
                this.savePrevious = true;
                blArray[102] = true;
                break;
            }
            blArray[103] = true;
        }
        this.sampleSize = sampleSize;
        this.downsampledWidth = header.width / sampleSize;
        this.downsampledHeight = header.height / sampleSize;
        blArray[104] = true;
        this.mainPixels = this.bitmapProvider.obtainByteArray(header.width * header.height);
        blArray[105] = true;
        this.mainScratch = this.bitmapProvider.obtainIntArray(this.downsampledWidth * this.downsampledHeight);
        blArray[106] = true;
    }

    /*
     * WARNING - void declaration
     */
    boolean setFrameIndex(int n) {
        void frame;
        block4: {
            block3: {
                block2: {
                    boolean[] blArray = GifDecoder.$jacocoInit();
                    if (frame >= -1) break block2;
                    blArray[107] = true;
                    break block3;
                }
                if (frame < this.getFrameCount()) break block4;
                blArray[108] = true;
            }
            blArray[109] = true;
            return false;
        }
        this.framePointer = frame;
        blArray[110] = true;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private int averageColorsNear(int n, int n2, int n3) {
        void currentFrameIw;
        int currentColor;
        int currentColorIndex;
        void maxPositionInMainPixels;
        void i;
        void positionInMainPixels;
        boolean[] blArray = GifDecoder.$jacocoInit();
        int alphaSum = 0;
        int redSum = 0;
        int greenSum = 0;
        int blueSum = 0;
        int totalAdded = 0;
        void var10_10 = positionInMainPixels;
        blArray[111] = true;
        while (true) {
            if (i >= positionInMainPixels + this.sampleSize) {
                blArray[112] = true;
                break;
            }
            if (i >= this.mainPixels.length) {
                blArray[113] = true;
                break;
            }
            if (i >= maxPositionInMainPixels) {
                blArray[114] = true;
                break;
            }
            currentColorIndex = this.mainPixels[i] & 0xFF;
            currentColor = this.act[currentColorIndex];
            if (currentColor == 0) {
                blArray[115] = true;
            } else {
                alphaSum += currentColor >> 24 & 0xFF;
                redSum += currentColor >> 16 & 0xFF;
                greenSum += currentColor >> 8 & 0xFF;
                blueSum += currentColor & 0xFF;
                ++totalAdded;
                blArray[116] = true;
            }
            ++i;
            blArray[117] = true;
        }
        i = positionInMainPixels + currentFrameIw;
        blArray[118] = true;
        while (true) {
            if (i >= positionInMainPixels + currentFrameIw + this.sampleSize) {
                blArray[119] = true;
                break;
            }
            if (i >= this.mainPixels.length) {
                blArray[120] = true;
                break;
            }
            if (i >= maxPositionInMainPixels) {
                blArray[121] = true;
                break;
            }
            currentColorIndex = this.mainPixels[i] & 0xFF;
            currentColor = this.act[currentColorIndex];
            if (currentColor == 0) {
                blArray[122] = true;
            } else {
                alphaSum += currentColor >> 24 & 0xFF;
                redSum += currentColor >> 16 & 0xFF;
                greenSum += currentColor >> 8 & 0xFF;
                blueSum += currentColor & 0xFF;
                ++totalAdded;
                blArray[123] = true;
            }
            ++i;
            blArray[124] = true;
        }
        if (totalAdded == 0) {
            blArray[125] = true;
            return 0;
        }
        blArray[126] = true;
        return alphaSum / totalAdded << 24 | redSum / totalAdded << 16 | greenSum / totalAdded << 8 | blueSum / totalAdded;
    }

    /*
     * Exception decompiling
     */
    private void decodeBitmapData(GifFrame var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[UNCONDITIONALDOLOOP]], but top level block is 4[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private void fillRect(int[] nArray, GifFrame gifFrame, int n) {
        void left;
        void frame;
        boolean[] blArray = GifDecoder.$jacocoInit();
        int downsampledIH = frame.ih / this.sampleSize;
        int downsampledIY = frame.iy / this.sampleSize;
        int downsampledIW = frame.iw / this.sampleSize;
        int downsampledIX = frame.ix / this.sampleSize;
        int topLeft = downsampledIY * this.downsampledWidth + downsampledIX;
        int bottomLeft = topLeft + downsampledIH * this.downsampledWidth;
        int n2 = topLeft;
        blArray[169] = true;
        while (left < bottomLeft) {
            void pointer;
            void right = left + downsampledIW;
            void var13_13 = left;
            blArray[170] = true;
            while (pointer < right) {
                void bgColor;
                dest[pointer] = bgColor;
                ++pointer;
                blArray[171] = true;
            }
            left += this.downsampledWidth;
            blArray[172] = true;
        }
        blArray[173] = true;
    }

    private GifHeaderParser getHeaderParser() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        if (this.parser != null) {
            blArray[174] = true;
        } else {
            blArray[175] = true;
            this.parser = new GifHeaderParser();
            blArray[176] = true;
        }
        blArray[177] = true;
        return this.parser;
    }

    /*
     * WARNING - void declaration
     */
    private Bitmap getNextBitmap() {
        void result;
        void config;
        Bitmap.Config config2;
        boolean[] blArray = GifDecoder.$jacocoInit();
        if (this.isFirstFrameTransparent) {
            config2 = Bitmap.Config.ARGB_8888;
            blArray[178] = true;
        } else {
            config2 = Bitmap.Config.RGB_565;
            blArray[179] = true;
        }
        Bitmap.Config config3 = config2;
        blArray[180] = true;
        Bitmap bitmap = this.bitmapProvider.obtain(this.downsampledWidth, this.downsampledHeight, (Bitmap.Config)config);
        blArray[181] = true;
        GifDecoder.setAlpha((Bitmap)result);
        blArray[182] = true;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private int readBlock() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        int blockSize = this.readByte();
        if (blockSize <= 0) {
            blArray[183] = true;
        } else {
            try {
                blArray[184] = true;
                if (this.block != null) {
                    blArray[185] = true;
                } else {
                    blArray[186] = true;
                    this.block = this.bitmapProvider.obtainByteArray(255);
                    blArray[187] = true;
                }
                int remaining = this.workBufferSize - this.workBufferPosition;
                if (remaining >= blockSize) {
                    blArray[188] = true;
                    System.arraycopy(this.workBuffer, this.workBufferPosition, this.block, 0, blockSize);
                    this.workBufferPosition += blockSize;
                    blArray[189] = true;
                } else if (this.rawData.remaining() + remaining >= blockSize) {
                    void secondHalfRemaining;
                    blArray[190] = true;
                    System.arraycopy(this.workBuffer, this.workBufferPosition, this.block, 0, remaining);
                    this.workBufferPosition = this.workBufferSize;
                    blArray[191] = true;
                    this.readChunkIfNeeded();
                    int n = blockSize - remaining;
                    blArray[192] = true;
                    System.arraycopy(this.workBuffer, 0, this.block, remaining, (int)secondHalfRemaining);
                    this.workBufferPosition += secondHalfRemaining;
                    blArray[193] = true;
                } else {
                    this.status = 1;
                    blArray[194] = true;
                }
                blArray[195] = true;
            }
            catch (Exception remaining) {
                void e;
                blArray[196] = true;
                Logger.d(TAG, "Error Reading Block", (Throwable)e);
                this.status = 1;
                blArray[197] = true;
            }
        }
        blArray[198] = true;
        return blockSize;
    }

    private int readByte() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        try {
            this.readChunkIfNeeded();
            blArray[199] = true;
            return this.workBuffer[this.workBufferPosition++] & 0xFF;
        }
        catch (Exception e) {
            this.status = 1;
            blArray[200] = true;
            return 0;
        }
    }

    private void readChunkIfNeeded() {
        boolean[] blArray = GifDecoder.$jacocoInit();
        if (this.workBufferSize > this.workBufferPosition) {
            blArray[201] = true;
            return;
        }
        if (this.workBuffer != null) {
            blArray[202] = true;
        } else {
            blArray[203] = true;
            this.workBuffer = this.bitmapProvider.obtainByteArray(16384);
            blArray[204] = true;
        }
        this.workBufferPosition = 0;
        blArray[205] = true;
        this.workBufferSize = Math.min(this.rawData.remaining(), 16384);
        blArray[206] = true;
        this.rawData.get(this.workBuffer, 0, this.workBufferSize);
        blArray[207] = true;
    }

    /*
     * Unable to fully structure code
     */
    private Bitmap setPixels(GifFrame var1_1, GifFrame var2_2) {
        block51: {
            block52: {
                block50: {
                    var3_3 = GifDecoder.$jacocoInit();
                    dest = this.mainScratch;
                    if (previousFrame != null) {
                        var3_3[208] = true;
                    } else {
                        var3_3[209] = true;
                        Arrays.fill(dest, 0);
                        var3_3[210] = true;
                    }
                    if (previousFrame == null) {
                        var3_3[211] = true;
                    } else if (previousFrame.dispose <= 0) {
                        var3_3[212] = true;
                    } else if (previousFrame.dispose == 2) {
                        c = 0;
                        if (!currentFrame.transparency) {
                            c = this.header.bgColor;
                            if (currentFrame.lct == null) {
                                var3_3[213] = true;
                            } else if (this.header.bgIndex != currentFrame.transIndex) {
                                var3_3[214] = true;
                            } else {
                                c = 0;
                                var3_3[215] = true;
                            }
                        } else if (this.framePointer != 0) {
                            var3_3[216] = true;
                        } else {
                            this.isFirstFrameTransparent = true;
                            var3_3[217] = true;
                        }
                        this.fillRect(dest, (GifFrame)previousFrame, c);
                        var3_3[218] = true;
                    } else if (previousFrame.dispose != 3) {
                        var3_3[219] = true;
                    } else if (this.previousImage == null) {
                        var3_3[220] = true;
                        this.fillRect(dest, (GifFrame)previousFrame, 0);
                        var3_3[221] = true;
                    } else {
                        downsampledIH = previousFrame.ih / this.sampleSize;
                        downsampledIY = previousFrame.iy / this.sampleSize;
                        downsampledIW = previousFrame.iw / this.sampleSize;
                        downsampledIX = previousFrame.ix / this.sampleSize;
                        var9_9 = downsampledIY * this.downsampledWidth + downsampledIX;
                        var3_3[222] = true;
                        this.previousImage.getPixels(dest, (int)topLeft, this.downsampledWidth, downsampledIX, downsampledIY, downsampledIW, downsampledIH);
                        var3_3[223] = true;
                    }
                    this.decodeBitmapData((GifFrame)currentFrame);
                    downsampledIH = currentFrame.ih / this.sampleSize;
                    downsampledIY = currentFrame.iy / this.sampleSize;
                    downsampledIW = currentFrame.iw / this.sampleSize;
                    downsampledIX = currentFrame.ix / this.sampleSize;
                    pass = 1;
                    inc = 8;
                    iline = 0;
                    if (this.framePointer == 0) {
                        v0 = var3_3[224] = true;
                    } else {
                        v0 = false;
                        var3_3[225] = true;
                    }
                    isFirstFrame = v0;
                    var13_13 = false;
                    var3_3[226] = true;
                    while (i < downsampledIH) {
                        line = i;
                        if (!currentFrame.interlace) {
                            var3_3[227] = true;
                        } else {
                            if (iline < downsampledIH) {
                                var3_3[228] = true;
                            } else {
                                switch (++pass) {
                                    default: {
                                        var3_3[229] = true;
                                        break;
                                    }
                                    case 2: {
                                        iline = 4;
                                        var3_3[230] = true;
                                        break;
                                    }
                                    case 3: {
                                        iline = 2;
                                        inc = 4;
                                        var3_3[231] = true;
                                        break;
                                    }
                                    case 4: {
                                        iline = 1;
                                        inc = 2;
                                        var3_3[232] = true;
                                        break;
                                    }
                                }
                            }
                            line = iline;
                            iline += inc;
                            var3_3[233] = true;
                        }
                        if ((line += downsampledIY) >= this.downsampledHeight) {
                            var3_3[234] = true;
                        } else {
                            k = line * this.downsampledWidth;
                            dx = k + downsampledIX;
                            dlim = dx + downsampledIW;
                            if (k + this.downsampledWidth >= dlim) {
                                var3_3[235] = true;
                            } else {
                                dlim = k + this.downsampledWidth;
                                var3_3[236] = true;
                            }
                            sx = i * this.sampleSize * currentFrame.iw;
                            var19_20 = sx + (dlim - dx) * this.sampleSize;
                            var3_3[237] = true;
                            while (true) {
                                if (dx >= dlim) {
                                    var3_3[238] = true;
                                    break;
                                }
                                if (this.sampleSize == 1) {
                                    currentColorIndex = this.mainPixels[sx] & 255;
                                    averageColor = this.act[currentColorIndex];
                                    var3_3[239] = true;
                                } else {
                                    averageColor = this.averageColorsNear((int)sx, (int)maxPositionInSource, currentFrame.iw);
                                    var3_3[240] = true;
                                }
                                if (averageColor != 0) {
                                    dest[dx] = averageColor;
                                    var3_3[241] = true;
                                } else if (this.isFirstFrameTransparent) {
                                    var3_3[242] = true;
                                } else if (!isFirstFrame) {
                                    var3_3[243] = true;
                                } else {
                                    this.isFirstFrameTransparent = true;
                                    var3_3[244] = true;
                                }
                                sx += this.sampleSize;
                                ++dx;
                                var3_3[245] = true;
                            }
                        }
                        ++i;
                        var3_3[246] = true;
                    }
                    if (this.savePrevious) break block50;
                    var3_3[247] = true;
                    break block51;
                }
                if (currentFrame.dispose != 0) break block52;
                var3_3[248] = true;
                ** GOTO lbl153
            }
            if (currentFrame.dispose != 1) {
                var3_3[249] = true;
            } else {
                var3_3[250] = true;
lbl153:
                // 2 sources

                if (this.previousImage != null) {
                    var3_3[251] = true;
                } else {
                    var3_3[252] = true;
                    this.previousImage = this.getNextBitmap();
                    var3_3[253] = true;
                }
                this.previousImage.setPixels(dest, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
                var3_3[254] = true;
            }
        }
        i = this.getNextBitmap();
        var3_3[255] = true;
        result.setPixels(dest, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
        var3_3[256] = true;
        return result;
    }

    @TargetApi(value=12)
    private static void setAlpha(Bitmap bitmap) {
        boolean[] blArray = GifDecoder.$jacocoInit();
        if (Build.VERSION.SDK_INT < 12) {
            blArray[257] = true;
        } else {
            Bitmap bitmap2;
            blArray[258] = true;
            bitmap2.setHasAlpha(true);
            blArray[259] = true;
        }
        blArray[260] = true;
    }

    static {
        boolean[] blArray = GifDecoder.$jacocoInit();
        TAG = GifDecoder.class.getSimpleName();
        blArray[261] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-4522567921414397340L, (String)"com/clevertap/android/sdk/gif/GifDecoder", (int)262);
        }
        return blArray;
    }

    static interface BitmapProvider {
        @NonNull
        public Bitmap obtain(int var1, int var2, Bitmap.Config var3);

        public byte[] obtainByteArray(int var1);

        public int[] obtainIntArray(int var1);

        public void release(byte[] var1);

        public void release(Bitmap var1);

        public void release(int[] var1);
    }
}

