/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jacoco.agent.rt.internal_28bab1d.Offline;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class InAppFCManager {
    private final SimpleDateFormat ddMMyyyy;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private String deviceId;
    private final ArrayList<String> mDismissedThisSession;
    private final HashMap<String, Integer> mShownThisSession;
    private int mShownThisSessionCount;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    InAppFCManager(Context context, CleverTapInstanceConfig cleverTapInstanceConfig, String string) {
        void task;
        void deviceId;
        void context2;
        void config;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        blArray[0] = true;
        this.ddMMyyyy = new SimpleDateFormat("ddMMyyyy", Locale.US);
        blArray[1] = true;
        this.mDismissedThisSession = new ArrayList();
        blArray[2] = true;
        this.mShownThisSession = new HashMap();
        this.mShownThisSessionCount = 0;
        this.config = config;
        this.context = context2;
        this.deviceId = deviceId;
        blArray[3] = true;
        Task task2 = CTExecutorFactory.executors((CleverTapInstanceConfig)config).postAsyncSafelyTask();
        blArray[4] = true;
        task.execute("initInAppFCManager", new Callable<Void>(this){
            final /* synthetic */ InAppFCManager this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            @Override
            public Void call() {
                boolean[] blArray = 1.$jacocoInit();
                InAppFCManager.access$100(this.this$0, InAppFCManager.access$000(this.this$0));
                blArray[1] = true;
                return null;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)6403272566325885418L, (String)"com/clevertap/android/sdk/InAppFCManager$1", (int)3);
                }
                return blArray;
            }
        });
        blArray[5] = true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean canShow(CTInAppNotification cTInAppNotification) {
        block14: {
            void inapp;
            block13: {
                block12: {
                    block11: {
                        boolean[] blArray = InAppFCManager.$jacocoInit();
                        try {
                            if (inapp != null) {
                                blArray[6] = true;
                                break block11;
                            }
                            blArray[7] = true;
                            return false;
                        }
                        catch (Throwable t) {
                            blArray[18] = true;
                            return false;
                        }
                    }
                    String id2 = this.getInAppID((CTInAppNotification)inapp);
                    if (id2 != null) {
                        blArray[8] = true;
                        break block12;
                    }
                    blArray[9] = true;
                    return blArray[9];
                }
                if (!inapp.isExcludeFromCaps()) {
                    blArray[10] = true;
                    break block13;
                }
                blArray[11] = true;
                return blArray[11];
            }
            if (this.hasSessionCapacityMaxedOut((CTInAppNotification)inapp)) {
                blArray[12] = true;
                break block14;
            }
            blArray[13] = true;
            if (this.hasLifetimeCapacityMaxedOut((CTInAppNotification)inapp)) {
                blArray[14] = true;
                break block14;
            }
            blArray[15] = true;
            if (this.hasDailyCapacityMaxedOut((CTInAppNotification)inapp)) {
                blArray[16] = true;
                break block14;
            }
            blArray[17] = true;
            return blArray[17];
        }
        blArray[19] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void changeUser(String string) {
        void deviceId;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        this.mShownThisSession.clear();
        this.mShownThisSessionCount = 0;
        blArray[20] = true;
        this.mDismissedThisSession.clear();
        this.deviceId = deviceId;
        blArray[21] = true;
        this.init((String)deviceId);
        blArray[22] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void didDismiss(CTInAppNotification cTInAppNotification) {
        void inapp;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        String id2 = inapp.getId();
        if (id2 == null) {
            blArray[23] = true;
        } else {
            blArray[24] = true;
            this.mDismissedThisSession.add(id2.toString());
            blArray[25] = true;
        }
        blArray[26] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void didShow(Context context, CTInAppNotification cTInAppNotification) {
        void context2;
        void inapp;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        String id2 = this.getInAppID((CTInAppNotification)inapp);
        if (id2 == null) {
            blArray[27] = true;
            return;
        }
        ++this.mShownThisSessionCount;
        blArray[28] = true;
        Integer count = this.mShownThisSession.get(id2);
        if (count != null) {
            blArray[29] = true;
        } else {
            blArray[30] = true;
            count = 1;
            blArray[31] = true;
        }
        count = count + 1;
        this.mShownThisSession.put(id2, count);
        blArray[32] = true;
        this.incrementInAppCountsInPersistentStore(id2);
        blArray[33] = true;
        int shownToday = this.getIntFromPrefs(this.getKeyWithDeviceId("istc_inapp", this.deviceId), 0);
        blArray[34] = true;
        StorageHelper.putInt((Context)context2, this.storageKeyWithSuffix(this.getKeyWithDeviceId("istc_inapp", this.deviceId)), ++shownToday);
        blArray[35] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void attachToHeader(Context context, JSONObject jSONObject) {
        boolean[] blArray = InAppFCManager.$jacocoInit();
        try {
            void all;
            void prefs;
            void context2;
            void header;
            header.put("imp", this.getIntFromPrefs(this.getKeyWithDeviceId("istc_inapp", this.deviceId), 0));
            blArray[36] = true;
            JSONArray arr = new JSONArray();
            blArray[37] = true;
            SharedPreferences sharedPreferences = StorageHelper.getPreferences((Context)context2, this.getKeyWithDeviceId("counts_per_inapp", this.deviceId));
            blArray[38] = true;
            Map map = prefs.getAll();
            blArray[39] = true;
            Iterator iterator = all.keySet().iterator();
            blArray[40] = true;
            while (iterator.hasNext()) {
                void inapp;
                String string = (String)iterator.next();
                blArray[41] = true;
                Object o = all.get(inapp);
                if (!(o instanceof String)) {
                    blArray[42] = true;
                } else {
                    blArray[43] = true;
                    String[] parts = ((String)o).split(",");
                    if (parts.length != 2) {
                        blArray[44] = true;
                    } else {
                        void a;
                        blArray[45] = true;
                        JSONArray jSONArray = new JSONArray();
                        blArray[46] = true;
                        a.put(0, (Object)inapp);
                        blArray[47] = true;
                        a.put(1, Integer.parseInt(parts[0]));
                        blArray[48] = true;
                        a.put(2, Integer.parseInt(parts[1]));
                        blArray[49] = true;
                        arr.put((Object)a);
                        blArray[50] = true;
                    }
                }
                blArray[51] = true;
            }
            header.put("tlc", (Object)arr);
            blArray[52] = true;
        }
        catch (Throwable arr) {
            void t;
            blArray[53] = true;
            Logger.v("Failed to attach FC to header", (Throwable)t);
            blArray[54] = true;
        }
        blArray[55] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void processResponse(Context context, JSONObject jSONObject) {
        void response;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        if (!response.has("inapp_stale")) {
            blArray[57] = true;
            return;
        }
        blArray[56] = true;
        try {
            void editor;
            void i;
            void prefs;
            void context2;
            JSONArray arr = response.getJSONArray("inapp_stale");
            blArray[58] = true;
            blArray[59] = true;
            SharedPreferences sharedPreferences = StorageHelper.getPreferences((Context)context2, this.getKeyWithDeviceId("counts_per_inapp", this.deviceId));
            blArray[60] = true;
            SharedPreferences.Editor editor2 = prefs.edit();
            blArray[61] = true;
            boolean bl = false;
            blArray[62] = true;
            while (i < arr.length()) {
                blArray[63] = true;
                Object o = arr.get((int)i);
                if (o instanceof Integer) {
                    blArray[64] = true;
                    editor.remove("" + o);
                    blArray[65] = true;
                    Logger.d("Purged stale in-app - " + o);
                    blArray[66] = true;
                } else if (!(o instanceof String)) {
                    blArray[67] = true;
                } else {
                    blArray[68] = true;
                    editor.remove((String)o);
                    blArray[69] = true;
                    Logger.d("Purged stale in-app - " + o);
                    blArray[70] = true;
                }
                ++i;
                blArray[71] = true;
            }
            StorageHelper.persist((SharedPreferences.Editor)editor);
            blArray[72] = true;
        }
        catch (Throwable arr) {
            void t;
            blArray[73] = true;
            Logger.v("Failed to purge out stale targets", (Throwable)t);
            blArray[74] = true;
        }
        blArray[75] = true;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void updateLimits(Context context, int n, int n2) {
        void perSession;
        void perDay;
        void context2;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        StorageHelper.putInt((Context)context2, this.storageKeyWithSuffix(this.getKeyWithDeviceId("istmcd_inapp", this.deviceId)), (int)perDay);
        blArray[76] = true;
        StorageHelper.putInt((Context)context2, this.storageKeyWithSuffix(this.getKeyWithDeviceId("imc", this.deviceId)), (int)perSession);
        blArray[77] = true;
    }

    private String getConfigAccountId() {
        boolean[] blArray = InAppFCManager.$jacocoInit();
        blArray[78] = true;
        return this.config.getAccountId();
    }

    private Logger getConfigLogger() {
        boolean[] blArray = InAppFCManager.$jacocoInit();
        blArray[79] = true;
        return this.config.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    private int[] getInAppCountsFromPersistentStore(String string) {
        String[] parts;
        block5: {
            void inappID;
            void prefs;
            boolean[] blArray = InAppFCManager.$jacocoInit();
            blArray[80] = true;
            blArray[81] = true;
            SharedPreferences sharedPreferences = StorageHelper.getPreferences(this.context, this.getKeyWithDeviceId("counts_per_inapp", this.deviceId));
            blArray[82] = true;
            String str = prefs.getString((String)inappID, null);
            if (str == null) {
                blArray[84] = true;
                return new int[]{0, 0};
            }
            blArray[83] = true;
            try {
                parts = str.split(",");
                if (parts.length == 2) {
                    blArray[85] = true;
                    break block5;
                }
                blArray[86] = true;
                return new int[]{0, 0};
            }
            catch (Throwable t) {
                blArray[88] = true;
                return new int[]{0, 0};
            }
        }
        blArray[87] = true;
        return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
    }

    /*
     * WARNING - void declaration
     */
    private String getInAppID(CTInAppNotification cTInAppNotification) {
        void inapp;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        if (inapp.getId() == null) {
            blArray[89] = true;
            return null;
        }
        if (!inapp.getId().isEmpty()) {
            try {
                blArray[90] = true;
                blArray[91] = true;
                return inapp.getId();
            }
            catch (Throwable ignored) {
                blArray[92] = true;
                return null;
            }
        }
        blArray[93] = true;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int getIntFromPrefs(String string, int n) {
        void defaultValue;
        void rawKey;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        if (this.config.isDefaultInstance()) {
            int n2;
            void _new;
            void dummy;
            int n3 = -1000;
            blArray[94] = true;
            int n4 = StorageHelper.getInt(this.context, this.storageKeyWithSuffix((String)rawKey), (int)dummy);
            blArray[95] = true;
            if (_new != dummy) {
                n2 = _new;
                blArray[96] = true;
            } else {
                n2 = StorageHelper.getInt(this.context, (String)rawKey, (int)defaultValue);
                blArray[97] = true;
            }
            blArray[98] = true;
            return n2;
        }
        blArray[99] = true;
        return StorageHelper.getInt(this.context, this.storageKeyWithSuffix((String)rawKey), (int)defaultValue);
    }

    /*
     * WARNING - void declaration
     */
    private String getKeyWithDeviceId(String string, String string2) {
        void deviceId;
        void key;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        blArray[100] = true;
        return (String)key + ":" + (String)deviceId;
    }

    /*
     * WARNING - void declaration
     */
    private String getStringFromPrefs(String string, String string2) {
        void defaultValue;
        void rawKey;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        if (this.config.isDefaultInstance()) {
            String string3;
            void _new;
            blArray[101] = true;
            String string4 = StorageHelper.getString(this.context, this.storageKeyWithSuffix((String)rawKey), (String)defaultValue);
            blArray[102] = true;
            if (_new != null) {
                string3 = _new;
                blArray[103] = true;
            } else {
                string3 = StorageHelper.getString(this.context, (String)rawKey, (String)defaultValue);
                blArray[104] = true;
            }
            blArray[105] = true;
            return string3;
        }
        blArray[106] = true;
        return StorageHelper.getString(this.context, this.storageKeyWithSuffix((String)rawKey), (String)defaultValue);
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasDailyCapacityMaxedOut(CTInAppNotification cTInAppNotification) {
        int maxPerDay;
        String id2;
        block7: {
            void shownTodayCount;
            void inapp;
            boolean[] blArray = InAppFCManager.$jacocoInit();
            id2 = this.getInAppID((CTInAppNotification)inapp);
            if (id2 == null) {
                blArray[107] = true;
                return false;
            }
            int n = this.getIntFromPrefs(this.getKeyWithDeviceId("istc_inapp", this.deviceId), 0);
            blArray[108] = true;
            int maxPerDayCount = this.getIntFromPrefs(this.getKeyWithDeviceId("istmcd_inapp", this.deviceId), 1);
            if (shownTodayCount >= maxPerDayCount) {
                blArray[110] = true;
                return true;
            }
            blArray[109] = true;
            try {
                maxPerDay = inapp.getTotalDailyCount();
                if (maxPerDay != -1) {
                    blArray[111] = true;
                    break block7;
                }
                blArray[112] = true;
                return false;
            }
            catch (Throwable t) {
                blArray[114] = true;
                return true;
            }
        }
        int[] counts = this.getInAppCountsFromPersistentStore(id2);
        if (counts[0] >= maxPerDay) {
            blArray[113] = true;
            return blArray[113];
        }
        blArray[115] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasLifetimeCapacityMaxedOut(CTInAppNotification cTInAppNotification) {
        void inapp;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        String id2 = this.getInAppID((CTInAppNotification)inapp);
        if (id2 == null) {
            blArray[116] = true;
            return false;
        }
        if (inapp.getTotalLifetimeCount() == -1) {
            blArray[118] = true;
            return false;
        }
        blArray[117] = true;
        try {
            void counts;
            int[] nArray = this.getInAppCountsFromPersistentStore(id2);
            blArray[119] = true;
            if (counts[1] >= inapp.getTotalLifetimeCount()) {
                blArray[120] = true;
                return blArray[120];
            }
        }
        catch (Exception e) {
            blArray[121] = true;
            return true;
        }
        blArray[122] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasSessionCapacityMaxedOut(CTInAppNotification cTInAppNotification) {
        boolean bl;
        block10: {
            void inapp;
            boolean[] blArray = InAppFCManager.$jacocoInit();
            String id2 = this.getInAppID((CTInAppNotification)inapp);
            if (id2 == null) {
                blArray[123] = true;
                return false;
            }
            if (this.mDismissedThisSession.contains(id2)) {
                blArray[125] = true;
                return true;
            }
            blArray[124] = true;
            try {
                void maxPerSession;
                void c;
                int n;
                if (inapp.getMaxPerSession() >= 0) {
                    n = inapp.getMaxPerSession();
                    blArray[126] = true;
                } else {
                    n = 1000;
                    blArray[127] = true;
                }
                int n2 = n;
                blArray[128] = true;
                Integer n3 = this.mShownThisSession.get(id2);
                blArray[129] = true;
                if (c == null) {
                    blArray[130] = true;
                    break block10;
                }
                if (c.intValue() < maxPerSession) {
                    blArray[131] = true;
                    break block10;
                }
                blArray[132] = true;
                return blArray[132];
            }
            catch (Throwable t) {
                blArray[133] = true;
                return true;
            }
        }
        int c = this.getIntFromPrefs(this.getKeyWithDeviceId("imc", this.deviceId), 1);
        if (this.mShownThisSessionCount >= c) {
            bl = blArray[134] = true;
        } else {
            bl = false;
            blArray[135] = true;
        }
        blArray[136] = true;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void incrementInAppCountsInPersistentStore(String string) {
        void editor;
        void prefs;
        void inappID;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        int[] current = this.getInAppCountsFromPersistentStore((String)inappID);
        current[0] = current[0] + 1;
        current[1] = current[1] + 1;
        blArray[137] = true;
        blArray[138] = true;
        SharedPreferences sharedPreferences = StorageHelper.getPreferences(this.context, this.getKeyWithDeviceId("counts_per_inapp", this.deviceId));
        blArray[139] = true;
        SharedPreferences.Editor editor2 = prefs.edit();
        blArray[140] = true;
        editor.putString((String)inappID, current[0] + "," + current[1]);
        blArray[141] = true;
        StorageHelper.persist((SharedPreferences.Editor)editor);
        blArray[142] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void init(String string) {
        boolean[] blArray = InAppFCManager.$jacocoInit();
        blArray[143] = true;
        this.getConfigLogger().verbose(this.config.getAccountId() + ":async_deviceID", "InAppFCManager init() called");
        try {
            void lastUpdated;
            void today;
            void deviceId;
            blArray[144] = true;
            this.migrateToNewPrefsKey((String)deviceId);
            blArray[145] = true;
            String string2 = this.ddMMyyyy.format(new Date());
            blArray[146] = true;
            String string3 = this.getStringFromPrefs(this.getKeyWithDeviceId("ict_date", (String)deviceId), "20140428");
            blArray[147] = true;
            if (today.equals(lastUpdated)) {
                blArray[148] = true;
            } else {
                void editor;
                void all;
                void prefs;
                blArray[149] = true;
                StorageHelper.putString(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("ict_date", (String)deviceId)), (String)today);
                blArray[150] = true;
                blArray[151] = true;
                StorageHelper.putInt(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("istc_inapp", (String)deviceId)), 0);
                blArray[152] = true;
                blArray[153] = true;
                SharedPreferences sharedPreferences = StorageHelper.getPreferences(this.context, this.getKeyWithDeviceId("counts_per_inapp", (String)deviceId));
                blArray[154] = true;
                SharedPreferences.Editor editor2 = prefs.edit();
                blArray[155] = true;
                Map map = prefs.getAll();
                blArray[156] = true;
                Iterator iterator = all.keySet().iterator();
                blArray[157] = true;
                while (iterator.hasNext()) {
                    void inapp;
                    String string4 = (String)iterator.next();
                    blArray[158] = true;
                    Object ov = all.get(inapp);
                    if (!(ov instanceof String)) {
                        blArray[159] = true;
                        editor.remove((String)inapp);
                        blArray[160] = true;
                        continue;
                    }
                    String[] oldValues = ((String)ov).split(",");
                    if (oldValues.length != 2) {
                        blArray[162] = true;
                        editor.remove((String)inapp);
                        blArray[163] = true;
                        continue;
                    }
                    blArray[161] = true;
                    try {
                        editor.putString((String)inapp, "0," + oldValues[1]);
                        blArray[164] = true;
                    }
                    catch (Throwable throwable) {
                        void t;
                        blArray[165] = true;
                        blArray[166] = true;
                        this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to reset todayCount for inapp " + (String)inapp, (Throwable)t);
                        blArray[167] = true;
                    }
                    blArray[168] = true;
                }
                StorageHelper.persist((SharedPreferences.Editor)editor);
                blArray[169] = true;
            }
            blArray[170] = true;
        }
        catch (Exception today) {
            void e;
            blArray[171] = true;
            blArray[172] = true;
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to init inapp manager " + e.getLocalizedMessage());
            blArray[173] = true;
        }
        blArray[174] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void migrateToNewPrefsKey(String string) {
        void newEditor;
        void all;
        void newPrefs;
        void oldPrefs;
        void ict_date;
        void deviceId;
        block8: {
            block7: {
                block6: {
                    boolean[] blArray = InAppFCManager.$jacocoInit();
                    if (this.getStringFromPrefs(this.storageKeyWithSuffix(this.getKeyWithDeviceId("ict_date", (String)deviceId)), null) == null) break block6;
                    blArray[175] = true;
                    break block7;
                }
                blArray[176] = true;
                if (this.getStringFromPrefs("ict_date", null) != null) break block8;
                blArray[177] = true;
            }
            blArray[178] = true;
            return;
        }
        Logger.v("Migrating InAppFC Prefs");
        blArray[179] = true;
        String string2 = this.getStringFromPrefs("ict_date", "20140428");
        blArray[180] = true;
        StorageHelper.putString(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("ict_date", (String)deviceId)), (String)ict_date);
        blArray[181] = true;
        int keyCountsShownToday = this.getIntFromPrefs(this.storageKeyWithSuffix("istc_inapp"), 0);
        blArray[182] = true;
        StorageHelper.putInt(this.context, this.storageKeyWithSuffix(this.getKeyWithDeviceId("istc_inapp", (String)deviceId)), keyCountsShownToday);
        blArray[183] = true;
        SharedPreferences sharedPreferences = StorageHelper.getPreferences(this.context, "counts_per_inapp");
        blArray[184] = true;
        SharedPreferences.Editor editor = oldPrefs.edit();
        blArray[185] = true;
        blArray[186] = true;
        SharedPreferences sharedPreferences2 = StorageHelper.getPreferences(this.context, this.getKeyWithDeviceId("counts_per_inapp", (String)deviceId));
        blArray[187] = true;
        SharedPreferences.Editor editor2 = newPrefs.edit();
        blArray[188] = true;
        Map map = oldPrefs.getAll();
        blArray[189] = true;
        Iterator iterator = all.keySet().iterator();
        blArray[190] = true;
        while (iterator.hasNext()) {
            void inapp;
            String string3 = (String)iterator.next();
            blArray[191] = true;
            Object ov = all.get(inapp);
            if (!(ov instanceof String)) {
                blArray[192] = true;
                editor.remove((String)inapp);
                blArray[193] = true;
                continue;
            }
            String[] oldValues = ((String)ov).split(",");
            if (oldValues.length != 2) {
                blArray[194] = true;
                editor.remove((String)inapp);
                blArray[195] = true;
                continue;
            }
            newEditor.putString((String)inapp, ov.toString());
            blArray[196] = true;
        }
        StorageHelper.persist((SharedPreferences.Editor)newEditor);
        blArray[197] = true;
        editor.clear().apply();
        blArray[198] = true;
    }

    /*
     * WARNING - void declaration
     */
    private String storageKeyWithSuffix(String string) {
        void key;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        blArray[199] = true;
        return (String)key + ":" + this.getConfigAccountId();
    }

    static /* synthetic */ String access$000(InAppFCManager inAppFCManager) {
        InAppFCManager x0;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        blArray[200] = true;
        return x0.deviceId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(InAppFCManager inAppFCManager, String string) {
        void x1;
        InAppFCManager x0;
        boolean[] blArray = InAppFCManager.$jacocoInit();
        x0.init((String)x1);
        blArray[201] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)4370959324159466842L, (String)"com/clevertap/android/sdk/InAppFCManager", (int)202);
        }
        return blArray;
    }
}

