/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inbox;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.Logger;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CTInboxMessageContent
implements Parcelable {
    public static final Parcelable.Creator<CTInboxMessageContent> CREATOR = new Parcelable.Creator<CTInboxMessageContent>(){

        public CTInboxMessageContent createFromParcel(Parcel in) {
            return new CTInboxMessageContent(in);
        }

        public CTInboxMessageContent[] newArray(int size) {
            return new CTInboxMessageContent[size];
        }
    };
    private String actionUrl;
    private String contentType;
    private Boolean hasLinks;
    private Boolean hasUrl;
    private String icon;
    private JSONArray links;
    private String media;
    private String message;
    private String messageColor;
    private String posterUrl;
    private String title;
    private String titleColor;

    CTInboxMessageContent() {
    }

    protected CTInboxMessageContent(Parcel in) {
        this.title = in.readString();
        this.titleColor = in.readString();
        this.message = in.readString();
        this.messageColor = in.readString();
        this.media = in.readString();
        this.hasUrl = in.readByte() != 0;
        this.hasLinks = in.readByte() != 0;
        this.actionUrl = in.readString();
        this.icon = in.readString();
        try {
            this.links = in.readByte() == 0 ? null : new JSONArray(in.readString());
        }
        catch (JSONException e) {
            Logger.v("Unable to init CTInboxMessageContent with Parcel - " + e.getLocalizedMessage());
        }
        this.contentType = in.readString();
        this.posterUrl = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public String getActionUrl() {
        return this.actionUrl;
    }

    void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getIcon() {
        return this.icon;
    }

    void setIcon(String icon) {
        this.icon = icon;
    }

    public String getLinkBGColor(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            return jsonObject.has("bg") ? jsonObject.getString("bg") : "";
        }
        catch (JSONException e) {
            Logger.v("Unable to get Link Text Color with JSON - " + e.getLocalizedMessage());
            return null;
        }
    }

    public String getLinkColor(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            return jsonObject.has("color") ? jsonObject.getString("color") : "";
        }
        catch (JSONException e) {
            Logger.v("Unable to get Link Text Color with JSON - " + e.getLocalizedMessage());
            return null;
        }
    }

    public String getLinkCopyText(JSONObject jsonObject) {
        if (jsonObject == null) {
            return "";
        }
        try {
            JSONObject copyObject;
            JSONObject jSONObject = copyObject = jsonObject.has("copyText") ? jsonObject.getJSONObject("copyText") : null;
            if (copyObject != null) {
                return copyObject.has("text") ? copyObject.getString("text") : "";
            }
            return "";
        }
        catch (JSONException e) {
            Logger.v("Unable to get Link Text with JSON - " + e.getLocalizedMessage());
            return "";
        }
    }

    public HashMap<String, String> getLinkKeyValue(JSONObject jsonObject) {
        if (jsonObject == null || !jsonObject.has("kv")) {
            return null;
        }
        try {
            JSONObject keyValues = jsonObject.getJSONObject("kv");
            Iterator keys = keyValues.keys();
            HashMap<String, String> keyValuesMap = new HashMap<String, String>();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = keyValues.getString(key);
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                keyValuesMap.put(key, value);
            }
            return !keyValuesMap.isEmpty() ? keyValuesMap : null;
        }
        catch (JSONException e) {
            Logger.v("Unable to get Link Key Value with JSON - " + e.getLocalizedMessage());
            return null;
        }
    }

    public String getLinkText(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            return jsonObject.has("text") ? jsonObject.getString("text") : "";
        }
        catch (JSONException e) {
            Logger.v("Unable to get Link Text with JSON - " + e.getLocalizedMessage());
            return null;
        }
    }

    public String getLinkUrl(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            JSONObject androidObject;
            JSONObject urlObject;
            JSONObject jSONObject = urlObject = jsonObject.has("url") ? jsonObject.getJSONObject("url") : null;
            if (urlObject == null) {
                return null;
            }
            JSONObject jSONObject2 = androidObject = urlObject.has("android") ? urlObject.getJSONObject("android") : null;
            if (androidObject != null) {
                return androidObject.has("text") ? androidObject.getString("text") : "";
            }
            return "";
        }
        catch (JSONException e) {
            Logger.v("Unable to get Link URL with JSON - " + e.getLocalizedMessage());
            return null;
        }
    }

    public JSONArray getLinks() {
        return this.links;
    }

    void setLinks(JSONArray links) {
        this.links = links;
    }

    public String getLinktype(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            return jsonObject.has("type") ? jsonObject.getString("type") : "";
        }
        catch (JSONException e) {
            Logger.v("Unable to get Link Type with JSON - " + e.getLocalizedMessage());
            return null;
        }
    }

    public String getMedia() {
        return this.media;
    }

    void setMedia(String media) {
        this.media = media;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public String getMessageColor() {
        return this.messageColor;
    }

    void setMessageColor(String messageColor) {
        this.messageColor = messageColor;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String posterUrl) {
        this.posterUrl = posterUrl;
    }

    public String getTitle() {
        return this.title;
    }

    void setTitle(String title) {
        this.title = title;
    }

    public String getTitleColor() {
        return this.titleColor;
    }

    void setTitleColor(String titleColor) {
        this.titleColor = titleColor;
    }

    public boolean mediaIsAudio() {
        String contentType = this.getContentType();
        return contentType != null && this.media != null && contentType.startsWith("audio");
    }

    public boolean mediaIsGIF() {
        String contentType = this.getContentType();
        return contentType != null && this.media != null && contentType.equals("image/gif");
    }

    public boolean mediaIsImage() {
        String contentType = this.getContentType();
        return contentType != null && this.media != null && contentType.startsWith("image") && !contentType.equals("image/gif");
    }

    public boolean mediaIsVideo() {
        String contentType = this.getContentType();
        return contentType != null && this.media != null && contentType.startsWith("video");
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.title);
        dest.writeString(this.titleColor);
        dest.writeString(this.message);
        dest.writeString(this.messageColor);
        dest.writeString(this.media);
        dest.writeByte((byte)(this.hasUrl != false ? 1 : 0));
        dest.writeByte((byte)(this.hasLinks != false ? 1 : 0));
        dest.writeString(this.actionUrl);
        dest.writeString(this.icon);
        if (this.links == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.links.toString());
        }
        dest.writeString(this.contentType);
        dest.writeString(this.posterUrl);
    }

    CTInboxMessageContent initWithJSON(JSONObject contentObject) {
        try {
            JSONObject actionObject;
            JSONObject mediaObject;
            JSONObject iconObject;
            JSONObject msgObject;
            JSONObject titleObject;
            JSONObject jSONObject = titleObject = contentObject.has("title") ? contentObject.getJSONObject("title") : null;
            if (titleObject != null) {
                this.title = titleObject.has("text") ? titleObject.getString("text") : "";
                this.titleColor = titleObject.has("color") ? titleObject.getString("color") : "";
            }
            JSONObject jSONObject2 = msgObject = contentObject.has("message") ? contentObject.getJSONObject("message") : null;
            if (msgObject != null) {
                this.message = msgObject.has("text") ? msgObject.getString("text") : "";
                this.messageColor = msgObject.has("color") ? msgObject.getString("color") : "";
            }
            JSONObject jSONObject3 = iconObject = contentObject.has("icon") ? contentObject.getJSONObject("icon") : null;
            if (iconObject != null) {
                this.icon = iconObject.has("url") ? iconObject.getString("url") : "";
            }
            JSONObject jSONObject4 = mediaObject = contentObject.has("media") ? contentObject.getJSONObject("media") : null;
            if (mediaObject != null) {
                this.media = mediaObject.has("url") ? mediaObject.getString("url") : "";
                this.contentType = mediaObject.has("content_type") ? mediaObject.getString("content_type") : "";
                this.posterUrl = mediaObject.has("poster") ? mediaObject.getString("poster") : "";
            }
            JSONObject jSONObject5 = actionObject = contentObject.has("action") ? contentObject.getJSONObject("action") : null;
            if (actionObject != null) {
                JSONObject urlObject;
                this.hasUrl = actionObject.has("hasUrl") && actionObject.getBoolean("hasUrl");
                this.hasLinks = actionObject.has("hasLinks") && actionObject.getBoolean("hasLinks");
                JSONObject jSONObject6 = urlObject = actionObject.has("url") ? actionObject.getJSONObject("url") : null;
                if (urlObject != null && this.hasUrl.booleanValue()) {
                    JSONObject androidObject;
                    JSONObject jSONObject7 = androidObject = urlObject.has("android") ? urlObject.getJSONObject("android") : null;
                    if (androidObject != null) {
                        String string = this.actionUrl = androidObject.has("text") ? androidObject.getString("text") : "";
                    }
                }
                if (urlObject != null && this.hasLinks.booleanValue()) {
                    this.links = actionObject.has("links") ? actionObject.getJSONArray("links") : null;
                }
            }
        }
        catch (JSONException e) {
            Logger.v("Unable to init CTInboxMessageContent with JSON - " + e.getLocalizedMessage());
        }
        return this;
    }
}

