/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.pushnotification.CTPushNotificationReceiver;

class LaunchPendingIntentFactory {
    LaunchPendingIntentFactory() {
    }

    static PendingIntent getLaunchPendingIntent(@NonNull Bundle extras, @NonNull Context context) {
        PendingIntent pIntent;
        if (Build.VERSION.SDK_INT >= 31) {
            Intent launchIntent;
            if (extras.containsKey("wzrk_dl")) {
                launchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)extras.getString("wzrk_dl")));
                Utils.setPackageNameFromResolveInfoList(context, launchIntent);
            } else {
                launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                if (launchIntent == null) {
                    return null;
                }
            }
            launchIntent.setFlags(0x34000000);
            launchIntent.putExtras(extras);
            launchIntent.removeExtra("wzrk_acts");
            int flagsLaunchPendingIntent = 0xC000000;
            pIntent = PendingIntent.getActivity((Context)context, (int)((int)System.currentTimeMillis()), (Intent)launchIntent, (int)flagsLaunchPendingIntent);
        } else {
            Intent launchIntent = new Intent(context, CTPushNotificationReceiver.class);
            launchIntent.putExtras(extras);
            launchIntent.removeExtra("wzrk_acts");
            int flagsLaunchPendingIntent = 0x8000000;
            if (Build.VERSION.SDK_INT >= 23) {
                flagsLaunchPendingIntent |= 0x4000000;
            }
            pIntent = PendingIntent.getBroadcast((Context)context, (int)((int)System.currentTimeMillis()), (Intent)launchIntent, (int)flagsLaunchPendingIntent);
        }
        return pIntent;
    }
}

