/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification.fcm;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.pushnotification.CTPushProviderListener;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.fcm.IFcmSdkHandler;
import com.clevertap.android.sdk.utils.PackageUtils;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;

public class FcmSdkHandlerImpl
implements IFcmSdkHandler {
    private final CTPushProviderListener listener;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private ManifestInfo manifestInfo;

    public FcmSdkHandlerImpl(CTPushProviderListener listener, Context context, CleverTapInstanceConfig config) {
        this.context = context;
        this.config = config;
        this.listener = listener;
        this.manifestInfo = ManifestInfo.getInstance(context);
    }

    @Override
    public PushConstants.PushType getPushType() {
        return PushConstants.PushType.FCM;
    }

    @Override
    public boolean isAvailable() {
        try {
            if (!PackageUtils.isGooglePlayServicesAvailable(this.context)) {
                this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "Google Play services is currently unavailable.");
                return false;
            }
            String senderId = this.getSenderId();
            if (TextUtils.isEmpty((CharSequence)senderId)) {
                this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "The FCM sender ID is not set. Unable to register for FCM.");
                return false;
            }
        }
        catch (Throwable t) {
            this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "Unable to register with FCM.", t);
            return false;
        }
        return true;
    }

    @Override
    public boolean isSupported() {
        return PackageUtils.isGooglePlayStoreAvailable(this.context);
    }

    @Override
    public void requestToken() {
        if (!Utils.haveDeprecatedFirebaseInstanceId) {
            this.config.getLogger().debug(this.config.getAccountId(), "Downgrade you're FCM dependency to v20.2.4 or else CleverTap SDK will not be able to generate a token for this device.");
            this.listener.onNewToken(null, this.getPushType());
            return;
        }
        try {
            String tokenUsingManifestMetaEntry = Utils.getFcmTokenUsingManifestMetaEntry(this.context, this.config);
            if (!TextUtils.isEmpty((CharSequence)tokenUsingManifestMetaEntry)) {
                this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "FCM token - " + tokenUsingManifestMetaEntry);
                this.listener.onNewToken(tokenUsingManifestMetaEntry, this.getPushType());
            } else {
                this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "Requesting FCM token using googleservices.json");
                FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

                    public void onComplete(@NonNull Task<InstanceIdResult> task) {
                        if (!task.isSuccessful()) {
                            FcmSdkHandlerImpl.this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "FCM token using googleservices.json failed", task.getException());
                            FcmSdkHandlerImpl.this.listener.onNewToken(null, FcmSdkHandlerImpl.this.getPushType());
                            return;
                        }
                        String token = task.getResult() != null ? ((InstanceIdResult)task.getResult()).getToken() : null;
                        FcmSdkHandlerImpl.this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "FCM token using googleservices.json - " + token);
                        FcmSdkHandlerImpl.this.listener.onNewToken(token, FcmSdkHandlerImpl.this.getPushType());
                    }
                });
            }
        }
        catch (Throwable t) {
            this.config.log("PushProvider", PushConstants.FCM_LOG_TAG + "Error requesting FCM token", t);
            this.listener.onNewToken(null, this.getPushType());
        }
    }

    String getFCMSenderID() {
        return this.manifestInfo.getFCMSenderId();
    }

    String getSenderId() {
        String senderId = this.getFCMSenderID();
        if (!TextUtils.isEmpty((CharSequence)senderId)) {
            return senderId;
        }
        FirebaseApp app = FirebaseApp.getInstance();
        return app.getOptions().getGcmSenderId();
    }

    void setManifestInfo(ManifestInfo manifestInfo) {
        this.manifestInfo = manifestInfo;
    }
}

