/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.customviews.CloseImageView;
import com.clevertap.android.sdk.gif.GifImageView;
import com.clevertap.android.sdk.inapp.CTInAppBaseFullNativeFragment;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;

public class CTInAppNativeInterstitialFragment
extends CTInAppBaseFullNativeFragment {
    private static long mediaPosition = 0L;
    private boolean exoPlayerFullscreen = false;
    private Dialog fullScreenDialog;
    private ImageView fullScreenIcon;
    private GifImageView gifImageView;
    private SimpleExoPlayer player;
    private PlayerView playerView;
    private RelativeLayout relativeLayout;
    private FrameLayout videoFrameLayout;
    private ViewGroup.LayoutParams videoFramelayoutParams;
    private ViewGroup.LayoutParams playerViewLayoutParams;
    private ViewGroup.LayoutParams imageViewLayoutParams;

    @RequiresApi(api=17)
    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        ArrayList<Button> inAppButtons = new ArrayList<Button>();
        View inAppView = this.inAppNotification.isTablet() && this.isTablet() ? inflater.inflate(R.layout.tab_inapp_interstitial, container, false) : inflater.inflate(R.layout.inapp_interstitial, container, false);
        final FrameLayout fl = (FrameLayout)inAppView.findViewById(R.id.inapp_interstitial_frame_layout);
        final CloseImageView closeImageView = (CloseImageView)fl.findViewById(199272);
        this.relativeLayout = (RelativeLayout)fl.findViewById(R.id.interstitial_relative_layout);
        this.relativeLayout.setBackgroundColor(Color.parseColor((String)this.inAppNotification.getBackgroundColor()));
        switch (this.currentOrientation) {
            case 1: {
                this.relativeLayout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        RelativeLayout relativeLayout1 = (RelativeLayout)fl.findViewById(R.id.interstitial_relative_layout);
                        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)relativeLayout1.getLayoutParams();
                        if (CTInAppNativeInterstitialFragment.this.inAppNotification.isTablet() && CTInAppNativeInterstitialFragment.this.isTablet()) {
                            CTInAppNativeInterstitialFragment.this.redrawInterstitialTabletInApp(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, fl, closeImageView);
                        } else if (CTInAppNativeInterstitialFragment.this.isTablet()) {
                            CTInAppNativeInterstitialFragment.this.redrawInterstitialMobileInAppOnTablet(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, fl, closeImageView);
                        } else {
                            CTInAppNativeInterstitialFragment.this.redrawInterstitialInApp(relativeLayout1, layoutParams, closeImageView);
                        }
                        CTInAppNativeInterstitialFragment.this.relativeLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                });
                break;
            }
            case 2: {
                this.relativeLayout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)CTInAppNativeInterstitialFragment.this.relativeLayout.getLayoutParams();
                        if (CTInAppNativeInterstitialFragment.this.inAppNotification.isTablet() && CTInAppNativeInterstitialFragment.this.isTablet()) {
                            CTInAppNativeInterstitialFragment.this.redrawLandscapeInterstitialTabletInApp(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, fl, closeImageView);
                        } else if (CTInAppNativeInterstitialFragment.this.isTablet()) {
                            CTInAppNativeInterstitialFragment.this.redrawLandscapeInterstitialMobileInAppOnTablet(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, fl, closeImageView);
                        } else {
                            CTInAppNativeInterstitialFragment.this.redrawLandscapeInterstitialInApp(CTInAppNativeInterstitialFragment.this.relativeLayout, layoutParams, closeImageView);
                        }
                        CTInAppNativeInterstitialFragment.this.relativeLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                });
            }
        }
        if (!this.inAppNotification.getMediaList().isEmpty()) {
            if (this.inAppNotification.getMediaList().get(0).isImage()) {
                Bitmap image = this.inAppNotification.getImage(this.inAppNotification.getMediaList().get(0));
                if (image != null) {
                    ImageView imageView = (ImageView)this.relativeLayout.findViewById(R.id.backgroundImage);
                    imageView.setVisibility(0);
                    imageView.setImageBitmap(this.inAppNotification.getImage(this.inAppNotification.getMediaList().get(0)));
                }
            } else if (this.inAppNotification.getMediaList().get(0).isGIF()) {
                if (this.inAppNotification.getGifByteArray(this.inAppNotification.getMediaList().get(0)) != null) {
                    this.gifImageView = (GifImageView)this.relativeLayout.findViewById(R.id.gifImage);
                    this.gifImageView.setVisibility(0);
                    this.gifImageView.setBytes(this.inAppNotification.getGifByteArray(this.inAppNotification.getMediaList().get(0)));
                    this.gifImageView.startAnimation();
                }
            } else if (this.inAppNotification.getMediaList().get(0).isVideo()) {
                this.initFullScreenDialog();
                this.prepareMedia();
                this.playMedia();
            } else if (this.inAppNotification.getMediaList().get(0).isAudio()) {
                this.prepareMedia();
                this.playMedia();
                this.disableFullScreenButton();
            }
        }
        LinearLayout linearLayout = (LinearLayout)this.relativeLayout.findViewById(R.id.interstitial_linear_layout);
        Button mainButton = (Button)linearLayout.findViewById(R.id.interstitial_button1);
        inAppButtons.add(mainButton);
        Button secondaryButton = (Button)linearLayout.findViewById(R.id.interstitial_button2);
        inAppButtons.add(secondaryButton);
        TextView textView1 = (TextView)this.relativeLayout.findViewById(R.id.interstitial_title);
        textView1.setText((CharSequence)this.inAppNotification.getTitle());
        textView1.setTextColor(Color.parseColor((String)this.inAppNotification.getTitleColor()));
        TextView textView2 = (TextView)this.relativeLayout.findViewById(R.id.interstitial_message);
        textView2.setText((CharSequence)this.inAppNotification.getMessage());
        textView2.setTextColor(Color.parseColor((String)this.inAppNotification.getMessageColor()));
        ArrayList<CTInAppNotificationButton> buttons = this.inAppNotification.getButtons();
        if (buttons.size() == 1) {
            if (this.currentOrientation == 2) {
                mainButton.setVisibility(8);
            } else if (this.currentOrientation == 1) {
                mainButton.setVisibility(4);
            }
            this.setupInAppButton(secondaryButton, buttons.get(0), 0);
        } else if (!buttons.isEmpty()) {
            for (int i = 0; i < buttons.size(); ++i) {
                if (i >= 2) continue;
                CTInAppNotificationButton inAppNotificationButton = buttons.get(i);
                Button button = (Button)inAppButtons.get(i);
                this.setupInAppButton(button, inAppNotificationButton, i);
            }
        }
        fl.setBackground((Drawable)new ColorDrawable(-1157627904));
        closeImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CTInAppNativeInterstitialFragment.this.didDismiss(null);
                if (CTInAppNativeInterstitialFragment.this.gifImageView != null) {
                    CTInAppNativeInterstitialFragment.this.gifImageView.clear();
                }
                CTInAppNativeInterstitialFragment.this.getActivity().finish();
            }
        });
        if (!this.inAppNotification.isHideCloseButton()) {
            closeImageView.setVisibility(8);
        } else {
            closeImageView.setVisibility(0);
        }
        return inAppView;
    }

    public void onStart() {
        super.onStart();
        if (this.gifImageView != null) {
            this.gifImageView.setBytes(this.inAppNotification.getGifByteArray(this.inAppNotification.getMediaList().get(0)));
            this.gifImageView.startAnimation();
        }
    }

    public void onResume() {
        super.onResume();
        if (!this.inAppNotification.getMediaList().isEmpty() && this.player == null && (this.inAppNotification.getMediaList().get(0).isVideo() || this.inAppNotification.getMediaList().get(0).isAudio())) {
            this.prepareMedia();
            this.playMedia();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.gifImageView != null) {
            this.gifImageView.clear();
        }
        if (this.exoPlayerFullscreen) {
            this.closeFullscreenDialog();
        }
        if (this.player != null) {
            mediaPosition = this.player.getCurrentPosition();
            this.player.stop();
            this.player.release();
            this.player = null;
        }
    }

    public void onStop() {
        super.onStop();
        if (this.gifImageView != null) {
            this.gifImageView.clear();
        }
        if (this.player != null) {
            this.player.stop();
            this.player.release();
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    @Override
    void cleanup() {
        super.cleanup();
        if (this.gifImageView != null) {
            this.gifImageView.clear();
        }
        if (this.player != null) {
            this.player.stop();
            this.player.release();
            this.player = null;
        }
    }

    private void closeFullscreenDialog() {
        ((ViewGroup)this.playerView.getParent()).removeView((View)this.playerView);
        this.playerView.setLayoutParams(this.playerViewLayoutParams);
        ((FrameLayout)this.videoFrameLayout.findViewById(R.id.video_frame)).addView((View)this.playerView);
        this.fullScreenIcon.setLayoutParams(this.imageViewLayoutParams);
        ((FrameLayout)this.videoFrameLayout.findViewById(R.id.video_frame)).addView((View)this.fullScreenIcon);
        this.videoFrameLayout.setLayoutParams(this.videoFramelayoutParams);
        ((RelativeLayout)this.relativeLayout.findViewById(R.id.interstitial_relative_layout)).addView((View)this.videoFrameLayout);
        this.exoPlayerFullscreen = false;
        this.fullScreenDialog.dismiss();
        this.fullScreenIcon.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ct_ic_fullscreen_expand));
    }

    private void disableFullScreenButton() {
        this.fullScreenIcon.setVisibility(8);
    }

    private void initFullScreenDialog() {
        this.fullScreenDialog = new Dialog(this.context, 16973834){

            public void onBackPressed() {
                if (CTInAppNativeInterstitialFragment.this.exoPlayerFullscreen) {
                    CTInAppNativeInterstitialFragment.this.closeFullscreenDialog();
                }
                super.onBackPressed();
            }
        };
    }

    private void openFullscreenDialog() {
        this.imageViewLayoutParams = this.fullScreenIcon.getLayoutParams();
        this.playerViewLayoutParams = this.playerView.getLayoutParams();
        this.videoFramelayoutParams = this.videoFrameLayout.getLayoutParams();
        ((ViewGroup)this.playerView.getParent()).removeView((View)this.playerView);
        ((ViewGroup)this.fullScreenIcon.getParent()).removeView((View)this.fullScreenIcon);
        ((ViewGroup)this.videoFrameLayout.getParent()).removeView((View)this.videoFrameLayout);
        this.fullScreenDialog.addContentView((View)this.playerView, new ViewGroup.LayoutParams(-1, -1));
        this.exoPlayerFullscreen = true;
        this.fullScreenDialog.show();
    }

    private void playMedia() {
        this.playerView.requestFocus();
        this.playerView.setVisibility(0);
        this.playerView.setPlayer((Player)this.player);
        this.player.setPlayWhenReady(true);
    }

    private void prepareMedia() {
        int iconTop;
        FrameLayout.LayoutParams layoutParams;
        int iconHeight;
        int iconWidth;
        this.videoFrameLayout = (FrameLayout)this.relativeLayout.findViewById(R.id.video_frame);
        this.videoFrameLayout.setVisibility(0);
        this.playerView = new PlayerView(this.context);
        this.fullScreenIcon = new ImageView(this.context);
        this.fullScreenIcon.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.ct_ic_fullscreen_expand, null));
        this.fullScreenIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!CTInAppNativeInterstitialFragment.this.exoPlayerFullscreen) {
                    CTInAppNativeInterstitialFragment.this.openFullscreenDialog();
                } else {
                    CTInAppNativeInterstitialFragment.this.closeFullscreenDialog();
                }
            }
        });
        if (this.inAppNotification.isTablet() && this.isTablet()) {
            int playerWidth = (int)TypedValue.applyDimension((int)1, (float)408.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            int playerHeight = (int)TypedValue.applyDimension((int)1, (float)229.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.playerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(playerWidth, playerHeight));
            iconWidth = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            iconHeight = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            layoutParams = new FrameLayout.LayoutParams(iconWidth, iconHeight);
            layoutParams.gravity = 0x800005;
            iconTop = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            int iconRight = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            layoutParams.setMargins(0, iconTop, iconRight, 0);
            this.fullScreenIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            int width = (int)TypedValue.applyDimension((int)1, (float)240.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            int height = (int)TypedValue.applyDimension((int)1, (float)134.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.playerView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
            iconWidth = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            iconHeight = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            layoutParams = new FrameLayout.LayoutParams(iconWidth, iconHeight);
            layoutParams.gravity = 0x800005;
            iconTop = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            int iconRight = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            layoutParams.setMargins(0, iconTop, iconRight, 0);
            this.fullScreenIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.playerView.setShowBuffering(1);
        this.playerView.setUseArtwork(true);
        this.playerView.setControllerAutoShow(false);
        this.videoFrameLayout.addView((View)this.playerView);
        this.videoFrameLayout.addView((View)this.fullScreenIcon);
        Drawable artwork = ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.ct_audio, null);
        this.playerView.setDefaultArtwork(artwork);
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter.Builder(this.context).build();
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory();
        DefaultTrackSelector trackSelector = new DefaultTrackSelector(this.context, (TrackSelection.Factory)videoTrackSelectionFactory);
        this.player = new SimpleExoPlayer.Builder(this.context).setTrackSelector((TrackSelector)trackSelector).build();
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(this.context, Util.getUserAgent((Context)this.context, (String)this.context.getApplicationContext().getPackageName()), (TransferListener)bandwidthMeter);
        HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)this.inAppNotification.getMediaList().get(0).getMediaUrl()));
        this.player.prepare((MediaSource)hlsMediaSource);
        this.player.setRepeatMode(1);
        this.player.seekTo(mediaPosition);
    }
}

