/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.login;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.BaseCTApiListener;
import com.clevertap.android.sdk.CTJsonConverter;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.StorageHelper;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LoginInfoProvider {
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final DeviceInfo mDeviceInfo;

    public LoginInfoProvider(BaseCTApiListener ctApiListener) {
        this.context = ctApiListener.context();
        this.config = ctApiListener.config();
        this.mDeviceInfo = ctApiListener.deviceInfo();
    }

    public void cacheGUIDForIdentifier(String guid, String key, String identifier) {
        if (this.isErrorDeviceId() || guid == null || key == null || identifier == null) {
            return;
        }
        String cacheKey = key + "_" + identifier;
        JSONObject cache = this.getCachedGUIDs();
        try {
            cache.put(cacheKey, (Object)guid);
            this.setCachedGUIDs(cache);
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error caching guid: " + t.toString());
        }
    }

    public boolean deviceIsMultiUser() {
        JSONObject cachedGUIDs = this.getCachedGUIDs();
        boolean deviceIsMultiUser = cachedGUIDs.length() > 1;
        this.config.log("ON_USER_LOGIN", "deviceIsMultiUser:[" + deviceIsMultiUser + "]");
        return deviceIsMultiUser;
    }

    public JSONObject getCachedGUIDs() {
        String json = StorageHelper.getStringFromPrefs(this.context, this.config, "cachedGUIDsKey", null);
        this.config.log("ON_USER_LOGIN", "getCachedGUIDs:[" + json + "]");
        return CTJsonConverter.toJsonObject(json, this.config.getLogger(), this.config.getAccountId());
    }

    public String getCachedIdentityKeysForAccount() {
        String cachedKeys = StorageHelper.getStringFromPrefs(this.context, this.config, "SP_KEY_PROFILE_IDENTITIES", "");
        this.config.log("ON_USER_LOGIN", "getCachedIdentityKeysForAccount:" + cachedKeys);
        return cachedKeys;
    }

    public String getGUIDForIdentifier(String key, String identifier) {
        if (key == null || identifier == null) {
            return null;
        }
        String cacheKey = key + "_" + identifier;
        JSONObject cache = this.getCachedGUIDs();
        try {
            String cachedGuid = cache.getString(cacheKey);
            this.config.log("ON_USER_LOGIN", "getGUIDForIdentifier:[Key:" + key + ", value:" + cachedGuid + "]");
            return cachedGuid;
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error reading guid cache: " + t.toString());
            return null;
        }
    }

    public boolean isAnonymousDevice() {
        JSONObject cachedGUIDs = this.getCachedGUIDs();
        boolean isAnonymousDevice = cachedGUIDs.length() <= 0;
        this.config.log("ON_USER_LOGIN", "isAnonymousDevice:[" + isAnonymousDevice + "]");
        return isAnonymousDevice;
    }

    public void setCachedGUIDs(JSONObject cachedGUIDs) {
        if (cachedGUIDs == null) {
            return;
        }
        try {
            String cachedGuid = cachedGUIDs.toString();
            StorageHelper.putString(this.context, StorageHelper.storageKeyWithSuffix(this.config, "cachedGUIDsKey"), cachedGuid);
            this.config.log("ON_USER_LOGIN", "setCachedGUIDs:[" + cachedGuid + "]");
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Error persisting guid cache: " + t.toString());
        }
    }

    public boolean isLegacyProfileLoggedIn() {
        JSONObject jsonObject = this.getCachedGUIDs();
        boolean isLoggedIn = jsonObject != null && jsonObject.length() > 0 && TextUtils.isEmpty((CharSequence)this.getCachedIdentityKeysForAccount());
        this.config.log("ON_USER_LOGIN", "isLegacyProfileLoggedIn:" + isLoggedIn);
        return isLoggedIn;
    }

    public void saveIdentityKeysForAccount(String valueCommaSeparated) {
        StorageHelper.putString(this.context, this.config, "SP_KEY_PROFILE_IDENTITIES", valueCommaSeparated);
        this.config.log("ON_USER_LOGIN", "saveIdentityKeysForAccount:" + valueCommaSeparated);
    }

    private boolean isErrorDeviceId() {
        boolean isErrorDeviceId = this.mDeviceInfo.isErrorDeviceId();
        this.config.log("ON_USER_LOGIN", "isErrorDeviceId:[" + isErrorDeviceId + "]");
        return isErrorDeviceId;
    }
}

