/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.login;

import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.Utils;
import java.util.HashSet;
import java.util.Iterator;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class IdentitySet {
    private final HashSet<String> identities = new HashSet();

    private IdentitySet(String[] keys) {
        this.init(keys);
    }

    private IdentitySet(HashSet<String> hashSet) {
        this.identities.addAll(hashSet);
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (thatObj == null || this.getClass() != thatObj.getClass()) {
            return false;
        }
        IdentitySet that = (IdentitySet)thatObj;
        return this.identities.equals(that.identities);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.identities.iterator();
        while (iterator.hasNext()) {
            String type = iterator.next();
            if (!Constants.ALL_IDENTITY_KEYS.contains(type)) continue;
            stringBuilder.append(type).append(iterator.hasNext() ? "," : "");
        }
        return stringBuilder.toString();
    }

    boolean contains(String Key) {
        return Utils.containsIgnoreCase(this.identities, Key);
    }

    boolean isValid() {
        return !this.identities.isEmpty();
    }

    private void init(String[] keysArrays) {
        if (keysArrays != null && keysArrays.length > 0) {
            for (String key : keysArrays) {
                if (!Utils.containsIgnoreCase(Constants.ALL_IDENTITY_KEYS, key)) continue;
                this.identities.add(Utils.convertToTitleCase(key));
            }
        }
    }

    static IdentitySet from(String keysCommaSeparated) {
        return new IdentitySet(keysCommaSeparated.split(","));
    }

    static IdentitySet from(String[] keysArray) {
        return new IdentitySet(keysArray);
    }

    static IdentitySet getDefault() {
        return new IdentitySet(Constants.LEGACY_IDENTITY_KEYS);
    }
}

