/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import com.clevertap.android.sdk.Utils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TaskManager {
    private static TaskManager sInstance;
    private final ExecutorService service = Executors.newFixedThreadPool(10);

    public static synchronized TaskManager getInstance() {
        if (sInstance == null) {
            sInstance = new TaskManager();
        }
        return sInstance;
    }

    private TaskManager() {
    }

    public <Params, Result> void execute(TaskListener<Params, Result> listener) {
        this.execute(null, listener);
    }

    public <Params, Result> void execute(final Params params, final TaskListener<Params, Result> listener) {
        this.service.execute(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    final Object result = listener.doInBackground(params);
                    Utils.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onPostExecute(result);
                        }
                    });
                }
            }
        });
    }

    public static interface TaskListener<Params, Result> {
        public Result doInBackground(Params var1);

        public void onPostExecute(Result var1);
    }
}

