/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.displayunits.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.displayunits.CTDisplayUnitType;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnitContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class CleverTapDisplayUnit
implements Parcelable {
    public static final Parcelable.Creator<CleverTapDisplayUnit> CREATOR = new Parcelable.Creator<CleverTapDisplayUnit>(){

        public CleverTapDisplayUnit createFromParcel(Parcel in) {
            return new CleverTapDisplayUnit(in);
        }

        public CleverTapDisplayUnit[] newArray(int size) {
            return new CleverTapDisplayUnit[size];
        }
    };
    private String bgColor;
    private ArrayList<CleverTapDisplayUnitContent> contents;
    private HashMap<String, String> customExtras;
    private String error;
    private JSONObject jsonObject;
    private CTDisplayUnitType type;
    private String unitID;

    @NonNull
    public static CleverTapDisplayUnit toDisplayUnit(JSONObject jsonObject) {
        try {
            String unitID = jsonObject.has("wzrk_id") ? jsonObject.getString("wzrk_id") : "0_0";
            CTDisplayUnitType displayUnitType = jsonObject.has("type") ? CTDisplayUnitType.type(jsonObject.getString("type")) : null;
            String bgColor = jsonObject.has("bg") ? jsonObject.getString("bg") : "";
            JSONArray contentArray = jsonObject.has("content") ? jsonObject.getJSONArray("content") : null;
            ArrayList<CleverTapDisplayUnitContent> contentArrayList = new ArrayList<CleverTapDisplayUnitContent>();
            if (contentArray != null) {
                for (int i = 0; i < contentArray.length(); ++i) {
                    CleverTapDisplayUnitContent displayUnitContent = CleverTapDisplayUnitContent.toContent(contentArray.getJSONObject(i));
                    if (!TextUtils.isEmpty((CharSequence)displayUnitContent.getError())) continue;
                    contentArrayList.add(displayUnitContent);
                }
            }
            JSONObject customKV = null;
            if (jsonObject.has("custom_kv")) {
                customKV = jsonObject.getJSONObject("custom_kv");
            }
            return new CleverTapDisplayUnit(jsonObject, unitID, displayUnitType, bgColor, contentArrayList, customKV, null);
        }
        catch (Exception e) {
            Logger.d("DisplayUnit : ", "Unable to init CleverTapDisplayUnit with JSON - " + e.getLocalizedMessage());
            return new CleverTapDisplayUnit(null, "", null, null, null, null, "Error Creating Display Unit from JSON : " + e.getLocalizedMessage());
        }
    }

    private CleverTapDisplayUnit(JSONObject jsonObject, String unitID, CTDisplayUnitType type, String bgColor, ArrayList<CleverTapDisplayUnitContent> contentArray, JSONObject kvObject, String error) {
        this.jsonObject = jsonObject;
        this.unitID = unitID;
        this.type = type;
        this.bgColor = bgColor;
        this.contents = contentArray;
        this.customExtras = this.getKeyValues(kvObject);
        this.error = error;
    }

    private CleverTapDisplayUnit(Parcel in) {
        try {
            this.unitID = in.readString();
            this.type = (CTDisplayUnitType)((Object)in.readValue(CTDisplayUnitType.class.getClassLoader()));
            this.bgColor = in.readString();
            if (in.readByte() == 1) {
                this.contents = new ArrayList();
                in.readList(this.contents, CleverTapDisplayUnitContent.class.getClassLoader());
            } else {
                this.contents = null;
            }
            this.customExtras = in.readHashMap(null);
            this.jsonObject = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.error = in.readString();
        }
        catch (Exception e) {
            this.error = "Error Creating Display Unit from parcel : " + e.getLocalizedMessage();
            Logger.d("DisplayUnit : ", this.error);
        }
    }

    public int describeContents() {
        return 0;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public ArrayList<CleverTapDisplayUnitContent> getContents() {
        return this.contents;
    }

    public HashMap<String, String> getCustomExtras() {
        return this.customExtras;
    }

    public String getError() {
        return this.error;
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public CTDisplayUnitType getType() {
        return this.type;
    }

    public String getUnitID() {
        return this.unitID;
    }

    public JSONObject getWZRKFields() {
        try {
            if (this.jsonObject != null) {
                Iterator iterator = this.jsonObject.keys();
                JSONObject object = new JSONObject();
                while (iterator.hasNext()) {
                    String keyName = (String)iterator.next();
                    if (!keyName.startsWith("wzrk_")) continue;
                    object.put(keyName, this.jsonObject.get(keyName));
                }
                return object;
            }
        }
        catch (Exception e) {
            Logger.d("DisplayUnit : ", "Error in getting WiZRK fields " + e.getLocalizedMessage());
        }
        return null;
    }

    @NonNull
    public String toString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append(" Unit id- ").append(this.unitID);
            stringBuilder.append(", Type- ").append(this.type != null ? this.type.toString() : null);
            stringBuilder.append(", bgColor- ").append(this.bgColor);
            if (this.contents != null && !this.contents.isEmpty()) {
                for (int i = 0; i < this.contents.size(); ++i) {
                    CleverTapDisplayUnitContent item = this.contents.get(i);
                    if (item == null) continue;
                    stringBuilder.append(", Content Item:").append(i).append(" ").append(item.toString());
                    stringBuilder.append("\n");
                }
            }
            if (this.customExtras != null) {
                stringBuilder.append(", Custom KV:").append(this.customExtras);
            }
            stringBuilder.append(", JSON -").append(this.jsonObject);
            stringBuilder.append(", Error-").append(this.error);
            stringBuilder.append(" ]");
            return stringBuilder.toString();
        }
        catch (Exception e) {
            Logger.d("DisplayUnit : ", "Exception in toString:" + e);
            return super.toString();
        }
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.unitID);
        parcel.writeValue((Object)this.type);
        parcel.writeString(this.bgColor);
        if (this.contents == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeList(this.contents);
        }
        parcel.writeMap(this.customExtras);
        if (this.jsonObject == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeString(this.jsonObject.toString());
        }
        parcel.writeString(this.error);
    }

    private HashMap<String, String> getKeyValues(JSONObject kvObj) {
        try {
            Iterator keys;
            if (kvObj != null && (keys = kvObj.keys()) != null) {
                HashMap<String, String> hashMap = null;
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = kvObj.getString(key);
                    if (TextUtils.isEmpty((CharSequence)key)) continue;
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                    }
                    hashMap.put(key, value);
                }
                return hashMap;
            }
        }
        catch (Exception e) {
            Logger.d("DisplayUnit : ", "Error in getting Key Value Pairs " + e.getLocalizedMessage());
        }
        return null;
    }
}

