/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing.uieditor;

import android.R;
import android.util.SparseArray;
import com.clevertap.android.sdk.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

final class ResourceIds {
    private final Map<String, Integer> idNameToId = new HashMap<String, Integer>();
    private final SparseArray<String> idToIdName = new SparseArray();
    private final String resourcePackageName;

    ResourceIds(String resourcePackageName) {
        this.resourcePackageName = resourcePackageName;
        this.read();
    }

    int idFromName(String name) {
        return this.idNameToId.get(name);
    }

    boolean knownIdName(String name) {
        return this.idNameToId.containsKey(name);
    }

    String nameForId(int id2) {
        return (String)this.idToIdName.get(id2);
    }

    private String getLocalClassName() {
        return this.resourcePackageName + ".R$id";
    }

    private Class<?> getSystemClass() {
        return R.id.class;
    }

    private void read() {
        this.idNameToId.clear();
        this.idToIdName.clear();
        Class<?> sysIdClass = this.getSystemClass();
        ResourceIds.readClassIds(sysIdClass, "android", this.idNameToId);
        String localClassName = this.getLocalClassName();
        try {
            Class<?> rIdClass = Class.forName(localClassName);
            ResourceIds.readClassIds(rIdClass, null, this.idNameToId);
        }
        catch (ClassNotFoundException e) {
            Logger.d("Can't load names for Android view ids from '" + localClassName + "', ids by name will not be available in the events editor.");
            Logger.d("You may be missing a Resources class for your package due to your proguard configuration, or you may be using an applicationId in your build that isn't the same as the package declared in your AndroidManifest.xml file.\nIf you're using proguard, you can fix this issue by adding the following to your proguard configuration:\n\n-keep class **.R$* {\n    <fields>;\n}\n\nIf you're not using proguard, or if your proguard configuration already contains the directive above, you can add the following to your AndroidManifest.xml file to explicitly point CleverTap SDK to the appropriate library for your resources class:\n\n<meta-data android:name=\"CLEVERTAP_APP_PACKAGE\" android:value=\"YOUR_PACKAGE_NAME\" />\n\nwhere YOUR_PACKAGE_NAME is the same string you use for the \"package\" attribute in your <manifest> tag.");
        }
        for (Map.Entry<String, Integer> idMapping : this.idNameToId.entrySet()) {
            this.idToIdName.put(idMapping.getValue().intValue(), (Object)idMapping.getKey());
        }
    }

    private static void readClassIds(Class<?> platformIdClass, String namespace, Map<String, Integer> namesToIds) {
        try {
            Field[] fields;
            for (Field field : fields = platformIdClass.getFields()) {
                Class<?> fieldType;
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || (fieldType = field.getType()) != Integer.TYPE) continue;
                String name = field.getName();
                int value = field.getInt(null);
                String namespacedName = null == namespace ? name : namespace + ":" + name;
                namesToIds.put(namespacedName, value);
            }
        }
        catch (IllegalAccessException e) {
            Logger.v("Can't read built-in id names from " + platformIdClass.getName(), e);
        }
    }
}

