/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification.fcm;

import android.content.Context;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.pushnotification.NotificationInfo;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import com.clevertap.android.sdk.pushnotification.fcm.IFcmMessageHandler;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;

public class FcmMessageHandlerImpl
implements IFcmMessageHandler {
    @Override
    public boolean onMessageReceived(Context context, RemoteMessage message) {
        boolean isSuccess = false;
        try {
            if (message.getData().size() > 0) {
                Bundle extras = new Bundle();
                for (Map.Entry entry : message.getData().entrySet()) {
                    extras.putString((String)entry.getKey(), (String)entry.getValue());
                }
                CleverTapAPI cleverTapAPI = CleverTapAPI.getGlobalInstance(context, PushNotificationUtil.getAccountIdFromNotificationBundle(extras));
                NotificationInfo info = CleverTapAPI.getNotificationInfo(extras);
                if (info.fromCleverTap) {
                    if (cleverTapAPI != null) {
                        cleverTapAPI.config().log("PushProvider", PushConstants.FCM_LOG_TAG + "received notification from CleverTap: " + extras.toString());
                    } else {
                        Logger.d("PushProvider", PushConstants.FCM_LOG_TAG + "received notification from CleverTap: " + extras.toString());
                    }
                    CleverTapAPI.createNotification(context, extras);
                    isSuccess = true;
                }
            }
        }
        catch (Throwable t) {
            Logger.d("PushProvider", PushConstants.FCM_LOG_TAG + "Error parsing FCM message", t);
        }
        return isSuccess;
    }

    @Override
    public boolean onNewToken(Context applicationContext, String token) {
        boolean isSuccess = false;
        try {
            CleverTapAPI.tokenRefresh(applicationContext, token, PushConstants.PushType.FCM);
            Logger.d("PushProvider", PushConstants.FCM_LOG_TAG + "New token received from FCM - " + token);
            isSuccess = true;
        }
        catch (Throwable t) {
            Logger.d("PushProvider", PushConstants.FCM_LOG_TAG + "Error onNewToken", t);
        }
        return isSuccess;
    }
}

