/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.content.res.ResourcesCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.clevertap.android.sdk.CTInboxActivity;
import com.clevertap.android.sdk.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.R;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;

public class MediaPlayerRecyclerView
extends RecyclerView {
    SimpleExoPlayer player;
    private Context appContext;
    private CTInboxBaseMessageViewHolder playingHolder;
    private PlayerView videoSurfaceView;

    public MediaPlayerRecyclerView(Context context) {
        super(context);
        this.initialize(context);
    }

    public MediaPlayerRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public MediaPlayerRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    public void onPausePlayer() {
        if (this.player != null) {
            this.player.setPlayWhenReady(false);
        }
    }

    public void onRestartPlayer() {
        if (this.videoSurfaceView == null) {
            this.initialize(this.appContext);
            this.playVideo();
        }
    }

    public void playVideo() {
        if (this.videoSurfaceView == null) {
            return;
        }
        CTInboxBaseMessageViewHolder targetHolder = this.findBestVisibleMediaHolder();
        if (targetHolder == null) {
            this.stop();
            this.removeVideoView();
            return;
        }
        if (this.playingHolder != null && this.playingHolder.itemView.equals(targetHolder.itemView)) {
            int visibleHeight;
            Rect rect = new Rect();
            boolean measured = this.playingHolder.itemView.getGlobalVisibleRect(rect);
            int n = visibleHeight = measured ? rect.height() : 0;
            if (this.player != null) {
                boolean play;
                boolean bl = play = visibleHeight >= 400;
                if (play) {
                    if (this.playingHolder.shouldAutoPlay()) {
                        this.player.setPlayWhenReady(true);
                    }
                } else {
                    this.player.setPlayWhenReady(false);
                }
            }
            return;
        }
        this.removeVideoView();
        boolean addedVideo = targetHolder.addMediaPlayer(this.videoSurfaceView);
        if (addedVideo) {
            this.playingHolder = targetHolder;
        }
    }

    public void release() {
        if (this.player != null) {
            this.player.stop();
            this.player.release();
            this.player = null;
        }
        this.playingHolder = null;
        this.videoSurfaceView = null;
    }

    public void removePlayer() {
        if (this.videoSurfaceView != null) {
            this.removeVideoView();
            this.videoSurfaceView = null;
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
        this.playingHolder = null;
    }

    private CTInboxBaseMessageViewHolder findBestVisibleMediaHolder() {
        CTInboxBaseMessageViewHolder bestHolder = null;
        int startPosition = ((LinearLayoutManager)this.getLayoutManager()).findFirstVisibleItemPosition();
        int endPosition = ((LinearLayoutManager)this.getLayoutManager()).findLastVisibleItemPosition();
        int bestHeight = 0;
        for (int i = startPosition; i <= endPosition; ++i) {
            int height;
            CTInboxBaseMessageViewHolder holder;
            int pos = i - startPosition;
            View child = this.getChildAt(pos);
            if (child == null || (holder = (CTInboxBaseMessageViewHolder)((Object)child.getTag())) == null || !holder.needsMediaPlayer()) continue;
            Rect rect = new Rect();
            boolean measured = holder.itemView.getGlobalVisibleRect(rect);
            int n = height = measured ? rect.height() : 0;
            if (height <= bestHeight) continue;
            bestHeight = height;
            bestHolder = holder;
        }
        return bestHolder;
    }

    private void initialize(Context context) {
        this.appContext = context.getApplicationContext();
        this.videoSurfaceView = new PlayerView(this.appContext);
        this.videoSurfaceView.setBackgroundColor(0);
        if (CTInboxActivity.orientation == 2) {
            this.videoSurfaceView.setResizeMode(3);
        } else {
            this.videoSurfaceView.setResizeMode(0);
        }
        this.videoSurfaceView.setUseArtwork(true);
        Drawable artwork = ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.ct_audio, null);
        this.videoSurfaceView.setDefaultArtwork(artwork);
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory();
        DefaultTrackSelector trackSelector = new DefaultTrackSelector(this.appContext, (TrackSelection.Factory)videoTrackSelectionFactory);
        this.player = new SimpleExoPlayer.Builder(context).setTrackSelector((TrackSelector)trackSelector).build();
        this.player.setVolume(0.0f);
        this.videoSurfaceView.setUseController(true);
        this.videoSurfaceView.setControllerAutoShow(false);
        this.videoSurfaceView.setPlayer((Player)this.player);
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    MediaPlayerRecyclerView.this.playVideo();
                }
            }

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
            }
        });
        this.addOnChildAttachStateChangeListener(new RecyclerView.OnChildAttachStateChangeListener(){

            public void onChildViewAttachedToWindow(@NonNull View view) {
            }

            public void onChildViewDetachedFromWindow(@NonNull View view) {
                if (MediaPlayerRecyclerView.this.playingHolder != null && ((MediaPlayerRecyclerView)MediaPlayerRecyclerView.this).playingHolder.itemView.equals(view)) {
                    MediaPlayerRecyclerView.this.stop();
                }
            }
        });
        this.player.addListener(new Player.EventListener(){

            public void onLoadingChanged(boolean isLoading) {
            }

            public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            }

            public void onPlayerError(ExoPlaybackException error) {
            }

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                switch (playbackState) {
                    case 2: {
                        if (MediaPlayerRecyclerView.this.playingHolder == null) break;
                        MediaPlayerRecyclerView.this.playingHolder.playerBuffering();
                        break;
                    }
                    case 4: {
                        if (MediaPlayerRecyclerView.this.player == null) break;
                        MediaPlayerRecyclerView.this.player.seekTo(0L);
                        MediaPlayerRecyclerView.this.player.setPlayWhenReady(false);
                        if (MediaPlayerRecyclerView.this.videoSurfaceView == null) break;
                        MediaPlayerRecyclerView.this.videoSurfaceView.showController();
                        break;
                    }
                    case 3: {
                        if (MediaPlayerRecyclerView.this.playingHolder == null) break;
                        MediaPlayerRecyclerView.this.playingHolder.playerReady();
                        break;
                    }
                }
            }

            public void onPositionDiscontinuity(int reason) {
            }

            public void onRepeatModeChanged(int repeatMode) {
            }

            public void onSeekProcessed() {
            }

            public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
            }

            public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
            }
        });
    }

    private void removeVideoView() {
        if (this.videoSurfaceView == null) {
            return;
        }
        ViewGroup parent = (ViewGroup)this.videoSurfaceView.getParent();
        if (parent == null) {
            return;
        }
        int index = parent.indexOfChild((View)this.videoSurfaceView);
        if (index >= 0) {
            parent.removeViewAt(index);
            if (this.player != null) {
                this.player.stop();
            }
            if (this.playingHolder != null) {
                this.playingHolder.playerRemoved();
                this.playingHolder = null;
            }
        }
    }
}

