/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.product_config;

import android.content.Context;
import android.text.TextUtils;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.FileUtils;
import com.clevertap.android.sdk.TaskManager;
import com.clevertap.android.sdk.product_config.CTProductConfigConstants;
import com.clevertap.android.sdk.product_config.ProductConfigUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class ProductConfigSettings {
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final String guid;
    private final HashMap<String, String> settingsMap = new HashMap();

    ProductConfigSettings(Context context, String guid, CleverTapInstanceConfig config) {
        this.context = context.getApplicationContext();
        this.guid = guid;
        this.config = config;
        this.initDefaults();
    }

    public void reset() {
        TaskManager.getInstance().execute(new TaskManager.TaskListener<Void, Void>(){

            @Override
            public Void doInBackground(Void aVoid) {
                try {
                    String fileName = ProductConfigSettings.this.getFullPath();
                    FileUtils.deleteFile(ProductConfigSettings.this.context, ProductConfigSettings.this.config, fileName);
                    ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "Deleted settings file" + fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "Error while resetting settings" + e.getLocalizedMessage());
                }
                return null;
            }

            @Override
            public void onPostExecute(Void aVoid) {
            }
        });
        this.initDefaults();
    }

    long getLastFetchTimeStampInMillis() {
        long lastFetchedTimeStamp = 0L;
        String value = this.settingsMap.get("ts");
        try {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                lastFetchedTimeStamp = (long)Double.parseDouble(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetLastFetchTimeStampInMillis failed: " + e.getLocalizedMessage());
        }
        return lastFetchedTimeStamp;
    }

    synchronized void setLastFetchTimeStampInMillis(long timeStampInMillis) {
        long lastFetchTimeStampInMillis = this.getLastFetchTimeStampInMillis();
        if (timeStampInMillis >= 0L && lastFetchTimeStampInMillis != timeStampInMillis) {
            this.settingsMap.put("ts", String.valueOf(timeStampInMillis));
            this.updateConfigToFile();
        }
    }

    long getNextFetchIntervalInSeconds() {
        long minFetchIntervalInSecondsSDK = this.getMinFetchIntervalInSeconds();
        long minFetchIntervalInSecondsServer = TimeUnit.MINUTES.toSeconds(this.getWindowIntervalInMinutes() / this.getNoOfCallsInAllowedWindow());
        return Math.max(minFetchIntervalInSecondsServer, minFetchIntervalInSecondsSDK);
    }

    void initDefaults() {
        this.settingsMap.put("rc_n", String.valueOf(5));
        this.settingsMap.put("rc_w", String.valueOf(60));
        this.settingsMap.put("ts", String.valueOf(0));
        this.settingsMap.put("fetch_min_interval_seconds", String.valueOf(CTProductConfigConstants.DEFAULT_MIN_FETCH_INTERVAL_SECONDS));
        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Settings loaded with default values: " + this.settingsMap);
    }

    synchronized void loadSettings() {
        String content;
        try {
            content = FileUtils.readFromFile(this.context, this.config, this.getFullPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "LoadSettings failed while reading file: " + e.getLocalizedMessage());
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)content)) {
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(content);
            }
            catch (JSONException e) {
                e.printStackTrace();
                this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "LoadSettings failed: " + e.getLocalizedMessage());
                return;
            }
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String value;
                String key;
                block8: {
                    key = (String)iterator.next();
                    if (TextUtils.isEmpty((CharSequence)key)) continue;
                    value = null;
                    try {
                        Object obj = jsonObject.get(key);
                        if (obj == null) break block8;
                        value = String.valueOf(obj);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Failed loading setting for key " + key + " Error: " + e.getLocalizedMessage());
                        continue;
                    }
                }
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                this.settingsMap.put(key, value);
            }
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "LoadSettings completed with settings: " + this.settingsMap);
        }
    }

    void setARPValue(JSONObject arp) {
        if (arp != null) {
            Iterator keys = arp.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    Object object;
                    if (TextUtils.isEmpty((CharSequence)key) || !((object = arp.get(key)) instanceof Number)) continue;
                    int update = (int)((Number)object).doubleValue();
                    if (!"rc_n".equalsIgnoreCase(key) && !"rc_w".equalsIgnoreCase(key)) continue;
                    this.setProductConfigValuesFromARP(key, update);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "Product Config setARPValue failed " + e.getLocalizedMessage());
                }
            }
        }
    }

    synchronized void setMinimumFetchIntervalInSeconds(long intervalInSeconds) {
        long minFetchIntervalInSeconds = this.getMinFetchIntervalInSeconds();
        if (intervalInSeconds > 0L && minFetchIntervalInSeconds != intervalInSeconds) {
            this.settingsMap.put("fetch_min_interval_seconds", String.valueOf(intervalInSeconds));
        }
    }

    private String getDirName() {
        return "Product_Config_" + this.config.getAccountId() + "_" + this.guid;
    }

    private String getFullPath() {
        return this.getDirName() + "/" + "config_settings.json";
    }

    private long getMinFetchIntervalInSeconds() {
        long minInterVal = CTProductConfigConstants.DEFAULT_MIN_FETCH_INTERVAL_SECONDS;
        String value = this.settingsMap.get("fetch_min_interval_seconds");
        try {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                minInterVal = (long)Double.parseDouble(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetMinFetchIntervalInSeconds failed: " + e.getLocalizedMessage());
        }
        return minInterVal;
    }

    private int getNoOfCallsInAllowedWindow() {
        int noCallsAllowedInWindow = 5;
        String value = this.settingsMap.get("rc_n");
        try {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                noCallsAllowedInWindow = (int)Double.parseDouble(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetNoOfCallsInAllowedWindow failed: " + e.getLocalizedMessage());
        }
        return noCallsAllowedInWindow;
    }

    private synchronized void setNoOfCallsInAllowedWindow(int callsInAllowedWindow) {
        long noOfCallsInAllowedWindow = this.getNoOfCallsInAllowedWindow();
        if (callsInAllowedWindow > 0 && noOfCallsInAllowedWindow != (long)callsInAllowedWindow) {
            this.settingsMap.put("rc_n", String.valueOf(callsInAllowedWindow));
            this.updateConfigToFile();
        }
    }

    private int getWindowIntervalInMinutes() {
        int windowIntervalInMinutes = 60;
        String value = this.settingsMap.get("rc_w");
        try {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                windowIntervalInMinutes = (int)Double.parseDouble(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getLogger().verbose(ProductConfigUtil.getLogTag(this.config), "GetWindowIntervalInMinutes failed: " + e.getLocalizedMessage());
        }
        return windowIntervalInMinutes;
    }

    private synchronized void setWindowIntervalInMinutes(int intervalInMinutes) {
        int windowIntervalInMinutes = this.getWindowIntervalInMinutes();
        if (intervalInMinutes > 0 && windowIntervalInMinutes != intervalInMinutes) {
            this.settingsMap.put("rc_w", String.valueOf(intervalInMinutes));
            this.updateConfigToFile();
        }
    }

    private void setProductConfigValuesFromARP(String key, int value) {
        switch (key) {
            case "rc_n": {
                this.setNoOfCallsInAllowedWindow(value);
                break;
            }
            case "rc_w": {
                this.setWindowIntervalInMinutes(value);
            }
        }
    }

    private synchronized void updateConfigToFile() {
        TaskManager.getInstance().execute(new TaskManager.TaskListener<Void, Boolean>(){

            @Override
            public Boolean doInBackground(Void aVoid) {
                try {
                    HashMap toWriteMap = new HashMap(ProductConfigSettings.this.settingsMap);
                    toWriteMap.remove("fetch_min_interval_seconds");
                    FileUtils.writeJsonToFile(ProductConfigSettings.this.context, ProductConfigSettings.this.config, ProductConfigSettings.this.getDirName(), "config_settings.json", new JSONObject(toWriteMap));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "UpdateConfigToFile failed: " + e.getLocalizedMessage());
                    return false;
                }
                return true;
            }

            @Override
            public void onPostExecute(Boolean isSuccess) {
                if (isSuccess.booleanValue()) {
                    ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "Product Config settings: writing Success " + ProductConfigSettings.this.settingsMap);
                } else {
                    ProductConfigSettings.this.config.getLogger().verbose(ProductConfigUtil.getLogTag(ProductConfigSettings.this.config), "Product Config settings: writing Failed");
                }
            }
        });
    }
}

