/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;

class ManifestInfo {
    private static String accountId;
    private static String accountToken;
    private static String accountRegion;
    private static boolean useADID;
    private static boolean appLaunchedDisabled;
    private static String notificationIcon;
    private static ManifestInfo instance;
    private static String excludedActivities;
    private static boolean sslPinning;
    private static boolean backgroundSync;
    private static boolean useCustomID;
    private static String fcmSenderId;
    private static String packageName;
    private static boolean beta;
    private static String intentServiceName;

    private static String _getManifestStringValueForKey(Bundle manifest, String name) {
        try {
            Object o = manifest.get(name);
            return o != null ? o.toString() : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private ManifestInfo(Context context) {
        Bundle metaData = null;
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 128);
            metaData = ai.metaData;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (metaData == null) {
            metaData = new Bundle();
        }
        if (accountId == null) {
            accountId = ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_ACCOUNT_ID");
        }
        if (accountToken == null) {
            accountToken = ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_TOKEN");
        }
        if (accountRegion == null) {
            accountRegion = ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_REGION");
        }
        notificationIcon = ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_NOTIFICATION_ICON");
        useADID = "1".equals(ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_USE_GOOGLE_AD_ID"));
        appLaunchedDisabled = "1".equals(ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_DISABLE_APP_LAUNCHED"));
        excludedActivities = ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_INAPP_EXCLUDE");
        sslPinning = "1".equals(ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_SSL_PINNING"));
        backgroundSync = "1".equals(ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_BACKGROUND_SYNC"));
        useCustomID = "1".equals(ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_USE_CUSTOM_ID"));
        fcmSenderId = ManifestInfo._getManifestStringValueForKey(metaData, "FCM_SENDER_ID");
        if (fcmSenderId != null) {
            fcmSenderId = fcmSenderId.replace("id:", "");
        }
        packageName = ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_APP_PACKAGE");
        beta = "1".equals(ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_BETA"));
        if (intentServiceName == null) {
            intentServiceName = ManifestInfo._getManifestStringValueForKey(metaData, "CLEVERTAP_INTENT_SERVICE");
        }
    }

    static synchronized ManifestInfo getInstance(Context context) {
        if (instance == null) {
            instance = new ManifestInfo(context);
        }
        return instance;
    }

    String getAccountId() {
        return accountId;
    }

    String getAcountToken() {
        return accountToken;
    }

    String getAccountRegion() {
        return accountRegion;
    }

    String getFCMSenderId() {
        return fcmSenderId;
    }

    boolean useGoogleAdId() {
        return useADID;
    }

    boolean enableBeta() {
        return beta;
    }

    boolean isAppLaunchedDisabled() {
        return appLaunchedDisabled;
    }

    boolean isSSLPinningEnabled() {
        return sslPinning;
    }

    String getNotificationIcon() {
        return notificationIcon;
    }

    String getExcludedActivities() {
        return excludedActivities;
    }

    boolean isBackgroundSync() {
        return backgroundSync;
    }

    boolean useCustomId() {
        return useCustomID;
    }

    String getPackageName() {
        return packageName;
    }

    String getIntentServiceName() {
        return intentServiceName;
    }

    static void changeCredentials(String id2, String token, String region) {
        accountId = id2;
        accountToken = token;
        accountRegion = region;
    }
}

