/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ValidationResult;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class Validator {
    private static final String[] eventNameCharsNotAllowed = new String[]{".", ":", "$", "'", "\"", "\\"};
    private static final String[] objectKeyCharsNotAllowed = new String[]{".", ":", "$", "'", "\"", "\\"};
    private static final String[] objectValueCharsNotAllowed = new String[]{"'", "\"", "\\"};
    private static final String[] restrictedNames = new String[]{"Stayed", "Notification Clicked", "Notification Viewed", "UTM Visited", "Notification Sent", "App Launched", "wzrk_d", "App Uninstalled", "Notification Bounced"};
    static final String ADD_VALUES_OPERATION = "multiValuePropertyAddValues";
    static final String REMOVE_VALUES_OPERATION = "multiValuePropertyRemoveValues";
    private ArrayList<String> discardedEvents;

    Validator() {
    }

    private ArrayList<String> getDiscardedEvents() {
        return this.discardedEvents;
    }

    public void setDiscardedEvents(ArrayList<String> discardedEvents) {
        this.discardedEvents = discardedEvents;
    }

    ValidationResult cleanEventName(String name) {
        ValidationResult vr = new ValidationResult();
        name = name.trim();
        for (String x : eventNameCharsNotAllowed) {
            name = name.replace(x, "");
        }
        if (name.length() > 512) {
            name = name.substring(0, 511);
            vr.setErrorDesc(name.trim() + "... exceeds the limit of " + 512 + " characters. Trimmed");
            vr.setErrorCode(510);
        }
        vr.setObject(name.trim());
        return vr;
    }

    ValidationResult cleanObjectKey(String name) {
        ValidationResult vr = new ValidationResult();
        name = name.trim();
        for (String x : objectKeyCharsNotAllowed) {
            name = name.replace(x, "");
        }
        if (name.length() > 120) {
            name = name.substring(0, 119);
            vr.setErrorDesc(name.trim() + "... exceeds the limit of " + 120 + " characters. Trimmed");
            vr.setErrorCode(520);
        }
        vr.setObject(name.trim());
        return vr;
    }

    ValidationResult cleanMultiValuePropertyKey(String name) {
        ValidationResult vr = this.cleanObjectKey(name);
        name = (String)vr.getObject();
        try {
            RestrictedMultiValueFields rf = RestrictedMultiValueFields.valueOf(name);
            if (rf != null) {
                vr.setErrorDesc(name + "... is a restricted key for multi-value properties. Operation aborted.");
                vr.setErrorCode(523);
                vr.setObject(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return vr;
    }

    ValidationResult cleanMultiValuePropertyValue(String value) {
        ValidationResult vr = new ValidationResult();
        value = value.trim().toLowerCase();
        for (String x : objectValueCharsNotAllowed) {
            value = value.replace(x, "");
        }
        try {
            if (value.length() > 512) {
                value = value.substring(0, 511);
                vr.setErrorDesc(value + "... exceeds the limit of " + 512 + " chars. Trimmed");
                vr.setErrorCode(521);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        vr.setObject(value);
        return vr;
    }

    ValidationResult mergeMultiValuePropertyForKey(JSONArray currentValues, JSONArray newValues, String action, String key) {
        ValidationResult vr = new ValidationResult();
        boolean remove = REMOVE_VALUES_OPERATION.equals(action);
        return this._mergeListInternalForKey(key, currentValues, newValues, remove, vr);
    }

    ValidationResult cleanObjectValue(Object o, ValidationContext validationContext) throws IllegalArgumentException {
        ValidationResult vr = new ValidationResult();
        if (o instanceof Integer || o instanceof Float || o instanceof Boolean || o instanceof Double || o instanceof Long) {
            vr.setObject(o);
            return vr;
        }
        if (o instanceof String || o instanceof Character) {
            String value = o instanceof Character ? String.valueOf(o) : (String)o;
            value = value.trim();
            for (String x : objectValueCharsNotAllowed) {
                value = value.replace(x, "");
            }
            try {
                if (value.length() > 512) {
                    value = value.substring(0, 511);
                    vr.setErrorDesc(value.trim() + "... exceeds the limit of " + 512 + " chars. Trimmed");
                    vr.setErrorCode(521);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            vr.setObject(value.trim());
            return vr;
        }
        if (o instanceof Date) {
            String date = "$D_" + ((Date)o).getTime() / 1000L;
            vr.setObject(date);
            return vr;
        }
        if ((o instanceof String[] || o instanceof ArrayList) && validationContext.equals((Object)ValidationContext.Profile)) {
            ArrayList valuesList = null;
            if (o instanceof ArrayList) {
                valuesList = (ArrayList)o;
            }
            String[] values = null;
            if (o instanceof String[]) {
                values = (String[])o;
            }
            ArrayList<Object> allStrings = new ArrayList<Object>();
            if (values != null) {
                for (String value : values) {
                    try {
                        allStrings.add(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } else {
                for (String value : valuesList) {
                    try {
                        allStrings.add(value);
                    }
                    catch (Exception exception) {}
                }
            }
            if ((values = allStrings.toArray(new String[0])).length > 0 && values.length <= 100) {
                JSONArray jsonArray = new JSONArray();
                JSONObject jsonObject = new JSONObject();
                for (String value : values) {
                    jsonArray.put((Object)value);
                }
                try {
                    jsonObject.put("$set", (Object)jsonArray);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                vr.setObject(jsonObject);
            } else {
                vr.setErrorDesc("Invalid user profile property array count - " + values.length + " max is - " + 100);
                vr.setErrorCode(521);
            }
            return vr;
        }
        throw new IllegalArgumentException("Not a String, Boolean, Long, Integer, Float, Double, or Date");
    }

    ValidationResult isRestrictedEventName(String name) {
        ValidationResult error = new ValidationResult();
        if (name == null) {
            error.setErrorCode(510);
            error.setErrorDesc("Event Name is null");
            return error;
        }
        for (String x : restrictedNames) {
            if (!name.equalsIgnoreCase(x)) continue;
            error.setErrorCode(513);
            error.setErrorDesc(name + " is a restricted event name. Last event aborted.");
            Logger.v(name + " is a restricted system event name. Last event aborted.");
            return error;
        }
        return error;
    }

    ValidationResult isEventDiscarded(String name) {
        ValidationResult error = new ValidationResult();
        if (name == null) {
            error.setErrorCode(510);
            error.setErrorDesc("Event Name is null");
            return error;
        }
        if (this.getDiscardedEvents() != null) {
            for (String x : this.getDiscardedEvents()) {
                if (!name.equalsIgnoreCase(x)) continue;
                error.setErrorCode(513);
                error.setErrorDesc(name + " is a discarded event name. Last event aborted.");
                Logger.d(name + " s a discarded event name as per CleverTap. Dropping event at SDK level. Check discarded events in CleverTap Dashboard settings.");
                return error;
            }
        }
        return error;
    }

    private ValidationResult _mergeListInternalForKey(String key, JSONArray left, JSONArray right, boolean remove, ValidationResult vr) {
        int i;
        if (left == null) {
            vr.setObject(null);
            return vr;
        }
        if (right == null) {
            vr.setObject(left);
            return vr;
        }
        int maxValNum = 100;
        JSONArray mergedList = new JSONArray();
        HashSet<String> set = new HashSet<String>();
        int lsize = left.length();
        int rsize = right.length();
        BitSet dupSetForAdd = null;
        if (!remove) {
            dupSetForAdd = new BitSet(lsize + rsize);
        }
        int lidx = 0;
        int ridx = this.scan(right, set, dupSetForAdd, lsize);
        if (!remove && set.size() < maxValNum) {
            lidx = this.scan(left, set, dupSetForAdd, 0);
        }
        for (i = lidx; i < lsize; ++i) {
            try {
                if (remove) {
                    String _j = (String)left.get(i);
                    if (set.contains(_j)) continue;
                    mergedList.put((Object)_j);
                    continue;
                }
                if (dupSetForAdd.get(i)) continue;
                mergedList.put(left.get(i));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!remove && mergedList.length() < maxValNum) {
            for (i = ridx; i < rsize; ++i) {
                try {
                    if (dupSetForAdd.get(i + lsize)) continue;
                    mergedList.put(right.get(i));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (ridx > 0 || lidx > 0) {
            vr.setErrorDesc("Multi value property for key " + key + " exceeds the limit of " + maxValNum + " items. Trimmed");
            vr.setErrorCode(521);
        }
        vr.setObject(mergedList);
        return vr;
    }

    private int scan(JSONArray list, Set<String> set, BitSet dupSetForAdd, int off) {
        if (list != null) {
            int maxValNum = 100;
            for (int i = list.length() - 1; i >= 0; --i) {
                try {
                    String n;
                    Object obj = list.get(i);
                    String string = n = obj != null ? obj.toString() : null;
                    if (dupSetForAdd == null) {
                        if (n != null) {
                            set.add(n);
                        }
                        continue;
                    }
                    if (n == null || set.contains(n)) {
                        dupSetForAdd.set(i + off, true);
                        continue;
                    }
                    set.add(n);
                    if (set.size() != maxValNum) continue;
                    return i;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    static enum ValidationContext {
        Profile,
        Event;

    }

    private static enum RestrictedMultiValueFields {
        Name,
        Email,
        Education,
        Married,
        DOB,
        Gender,
        Phone,
        Age,
        FBID,
        GPID,
        Birthday;

    }
}

