/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class CTCarouselViewPagerAdapter
extends PagerAdapter {
    private Context context;
    private LayoutInflater layoutInflater;
    private ArrayList<String> carouselImages;
    private View view;
    private LinearLayout.LayoutParams layoutParams;
    private CTInboxMessage inboxMessage;
    private int row;
    private WeakReference<CTInboxListViewFragment> parentWeakReference;

    CTCarouselViewPagerAdapter(Context context, CTInboxListViewFragment parent, CTInboxMessage inboxMessage, LinearLayout.LayoutParams layoutParams, int row) {
        this.context = context;
        this.parentWeakReference = new WeakReference<CTInboxListViewFragment>(parent);
        this.carouselImages = inboxMessage.getCarouselImages();
        this.layoutParams = layoutParams;
        this.inboxMessage = inboxMessage;
        this.row = row;
    }

    CTInboxListViewFragment getParent() {
        return (CTInboxListViewFragment)((Object)this.parentWeakReference.get());
    }

    public int getCount() {
        return this.carouselImages.size();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object o) {
        return view == o;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, final int position) {
        block7: {
            this.layoutInflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            this.view = this.layoutInflater.inflate(R.layout.inbox_carousel_image_layout, container, false);
            try {
                if (this.inboxMessage.getOrientation().equalsIgnoreCase("l")) {
                    ImageView imageView = (ImageView)this.view.findViewById(R.id.imageView);
                    imageView.setVisibility(0);
                    try {
                        Glide.with((Context)imageView.getContext()).load(this.carouselImages.get(position)).apply(((RequestOptions)new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image"))).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(imageView);
                    }
                    catch (NoSuchMethodError error) {
                        Logger.d("CleverTap SDK requires Glide v4.9.0 or above. Please refer CleverTap Documentation for more info");
                        Glide.with((Context)imageView.getContext()).load(this.carouselImages.get(position)).into(imageView);
                    }
                    container.addView(this.view, (ViewGroup.LayoutParams)this.layoutParams);
                    this.view.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            CTInboxListViewFragment parent = CTCarouselViewPagerAdapter.this.getParent();
                            if (parent != null) {
                                parent.handleViewPagerClick(CTCarouselViewPagerAdapter.this.row, position);
                            }
                        }
                    });
                    break block7;
                }
                if (!this.inboxMessage.getOrientation().equalsIgnoreCase("p")) break block7;
                ImageView imageView = (ImageView)this.view.findViewById(R.id.squareImageView);
                imageView.setVisibility(0);
                try {
                    Glide.with((Context)imageView.getContext()).load(this.carouselImages.get(position)).apply(((RequestOptions)new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image"))).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(imageView);
                }
                catch (NoSuchMethodError error) {
                    Logger.d("CleverTap SDK requires Glide v4.9.0 or above. Please refer CleverTap Documentation for more info");
                    Glide.with((Context)imageView.getContext()).load(this.carouselImages.get(position)).into(imageView);
                }
                container.addView(this.view, (ViewGroup.LayoutParams)this.layoutParams);
                this.view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CTInboxListViewFragment parent = CTCarouselViewPagerAdapter.this.getParent();
                        if (parent != null) {
                            parent.handleViewPagerClick(CTCarouselViewPagerAdapter.this.row, position);
                        }
                    }
                });
            }
            catch (NoClassDefFoundError error) {
                Logger.d("CleverTap SDK requires Glide dependency. Please refer CleverTap Documentation for more info");
            }
        }
        return this.view;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        View view = (View)object;
        container.removeView(view);
    }
}

