/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing;

import android.support.annotation.NonNull;
import com.clevertap.android.sdk.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

final class CTVar {
    private String name;
    private CTVarType type;
    private Object _value;
    private String _stringValue;
    private Double _numberValue;
    private List<?> _listValue;
    private Map<?, ?> _mapValue;

    private void _computeValue() {
        this._stringValue = null;
        this._numberValue = null;
        this._listValue = null;
        this._mapValue = null;
        if (this._value == null) {
            return;
        }
        if (this._value instanceof String) {
            this._stringValue = (String)this._value;
            try {
                this._numberValue = Double.valueOf(this._stringValue);
            }
            catch (Throwable throwable) {}
        } else if (this._value instanceof Number) {
            this._stringValue = "" + this._value;
            this._numberValue = ((Number)this._value).doubleValue();
        } else {
            try {
                this._stringValue = this._value.toString();
            }
            catch (Throwable t) {
                Logger.d("Error parsing var", t);
                return;
            }
        }
        switch (this.type) {
            case CTVarTypeListOfBool: 
            case CTVarTypeListOfDouble: 
            case CTVarTypeListOfInteger: 
            case CTVarTypeListOfString: {
                this._listValue = this.listFromString(this._stringValue, this.type);
                break;
            }
            case CTVarTypeMapOfBool: 
            case CTVarTypeMapOfDouble: 
            case CTVarTypeMapOfInteger: 
            case CTVarTypeMapOfString: {
                this._mapValue = this.mapFromString(this._stringValue, this.type);
            }
        }
    }

    private Map<String, ?> mapFromString(String stringValue, CTVarType type) {
        try {
            String[] stringArray = stringValue.replace("\"", "").replace("{", "").replace("}", "").split(",");
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            for (String s : stringArray) {
                String[] stringValuesArray = s.split(":");
                String key = stringValuesArray[0];
                String _stringValue = stringValuesArray[1];
                Object value = null;
                switch (type) {
                    case CTVarTypeMapOfBool: {
                        value = Boolean.valueOf(_stringValue);
                        break;
                    }
                    case CTVarTypeMapOfDouble: {
                        value = Double.valueOf(_stringValue);
                        break;
                    }
                    case CTVarTypeMapOfInteger: {
                        value = Integer.valueOf(_stringValue);
                        break;
                    }
                    case CTVarTypeMapOfString: {
                        value = _stringValue;
                    }
                }
                if (value == null) continue;
                objectMap.put(key, value);
            }
            return objectMap;
        }
        catch (Throwable t) {
            Logger.d("Unable to parse map of type: " + type.toString() + " from : " + stringValue);
            return null;
        }
    }

    private List<?> listFromString(String stringValue, CTVarType type) {
        try {
            String[] stringArray = stringValue.replace("[", "").replace("]", "").replace("\"", "").split(",");
            if (type == CTVarType.CTVarTypeListOfString) {
                return Arrays.asList(stringArray);
            }
            ArrayList<Comparable<Boolean>> parsed = new ArrayList<Comparable<Boolean>>();
            block7: for (String s : stringArray) {
                switch (type) {
                    case CTVarTypeListOfBool: {
                        parsed.add(Boolean.valueOf(s));
                        continue block7;
                    }
                    case CTVarTypeListOfDouble: {
                        parsed.add(Double.valueOf(s));
                        continue block7;
                    }
                    case CTVarTypeListOfInteger: {
                        parsed.add(Integer.valueOf(s));
                    }
                }
            }
            return parsed;
        }
        catch (Throwable t) {
            Logger.d("Unable to parse list of type: " + type.toString() + " from : " + stringValue);
            return null;
        }
    }

    CTVar(String name, CTVarType type, Object value) {
        this.name = name;
        this.type = type;
        this._value = value;
        this._computeValue();
    }

    void update(CTVarType type, Object value) {
        this.type = type;
        this._value = value;
        this._computeValue();
    }

    void clearValue() {
        this._value = null;
        this._computeValue();
    }

    String getName() {
        return this.name;
    }

    CTVarType getType() {
        return this.type;
    }

    Boolean booleanValue() {
        if (this._stringValue == null) {
            return null;
        }
        try {
            return Boolean.valueOf(this._stringValue);
        }
        catch (Throwable t) {
            return null;
        }
    }

    Integer integerValue() {
        if (this._numberValue == null) {
            return null;
        }
        try {
            return this._numberValue.intValue();
        }
        catch (Throwable t) {
            return null;
        }
    }

    Double doubleValue() {
        return this._numberValue;
    }

    String stringValue() {
        return this._stringValue;
    }

    List<?> listValue() {
        return this._listValue;
    }

    Map<?, ?> mapValue() {
        return this._mapValue;
    }

    JSONObject toJSON() {
        JSONObject json = new JSONObject();
        try {
            json.put("name", (Object)this.name);
            json.put("type", (Object)this.type.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return json;
    }

    static enum CTVarType {
        CTVarTypeBool("bool"),
        CTVarTypeDouble("double"),
        CTVarTypeInteger("integer"),
        CTVarTypeString("string"),
        CTVarTypeListOfBool("arrayofbool"),
        CTVarTypeListOfDouble("arrayofdouble"),
        CTVarTypeListOfInteger("arrayofinteger"),
        CTVarTypeListOfString("arrayofstring"),
        CTVarTypeMapOfBool("dictionaryofbool"),
        CTVarTypeMapOfDouble("dictionaryofdouble"),
        CTVarTypeMapOfInteger("dictionaryofinteger"),
        CTVarTypeMapOfString("dictionaryofstring"),
        CTVarTypeUnknown("unknown");

        private final String varType;

        private CTVarType(String type) {
            this.varType = type;
        }

        static CTVarType fromString(String type) {
            switch (type) {
                case "bool": {
                    return CTVarTypeBool;
                }
                case "double": {
                    return CTVarTypeDouble;
                }
                case "integer": {
                    return CTVarTypeInteger;
                }
                case "string": {
                    return CTVarTypeString;
                }
                case "arrayofbool": {
                    return CTVarTypeListOfBool;
                }
                case "arrayofdouble": {
                    return CTVarTypeListOfDouble;
                }
                case "arrayofinteger": {
                    return CTVarTypeListOfInteger;
                }
                case "arrayofstring": {
                    return CTVarTypeListOfString;
                }
                case "dictionaryofbool": {
                    return CTVarTypeMapOfBool;
                }
                case "dictionaryofdouble": {
                    return CTVarTypeMapOfDouble;
                }
                case "dictionaryofinteger": {
                    return CTVarTypeMapOfInteger;
                }
                case "dictionaryofstring": {
                    return CTVarTypeMapOfString;
                }
            }
            return CTVarTypeUnknown;
        }

        @NonNull
        public String toString() {
            return this.varType;
        }
    }
}

