/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.Toast;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import java.util.HashMap;
import org.json.JSONObject;

class CTInboxButtonClickListener
implements View.OnClickListener {
    private int position;
    private CTInboxMessage inboxMessage;
    private String buttonText;
    private CTInboxListViewFragment fragment;
    private ViewPager viewPager;
    private JSONObject buttonObject;

    CTInboxButtonClickListener(int position, CTInboxMessage inboxMessage, String buttonText, JSONObject jsonObject, CTInboxListViewFragment fragment) {
        this.position = position;
        this.inboxMessage = inboxMessage;
        this.buttonText = buttonText;
        this.fragment = fragment;
        this.buttonObject = jsonObject;
    }

    CTInboxButtonClickListener(int position, CTInboxMessage inboxMessage, String buttonText, CTInboxListViewFragment fragment, ViewPager viewPager) {
        this.position = position;
        this.inboxMessage = inboxMessage;
        this.buttonText = buttonText;
        this.fragment = fragment;
        this.viewPager = viewPager;
    }

    public void onClick(View v) {
        if (this.viewPager != null) {
            if (this.fragment != null) {
                this.fragment.handleViewPagerClick(this.position, this.viewPager.getCurrentItem());
            }
        } else if (this.buttonText != null && this.buttonObject != null) {
            if (this.fragment != null) {
                if (this.inboxMessage.getInboxMessageContents().get(0).getLinktype(this.buttonObject).equalsIgnoreCase("copy") && this.fragment.getActivity() != null) {
                    this.copyToClipboard((Context)this.fragment.getActivity());
                }
                HashMap<String, String> keyValues = null;
                if (this.inboxMessage != null && this.inboxMessage.getInboxMessageContents() != null && this.inboxMessage.getInboxMessageContents().get(0) != null) {
                    keyValues = this.inboxMessage.getInboxMessageContents().get(0).getLinkKeyValue(this.buttonObject);
                }
                this.fragment.handleClick(this.position, this.buttonText, this.buttonObject, keyValues);
            }
        } else if (this.fragment != null) {
            this.fragment.handleClick(this.position, null, null, null);
        }
    }

    private void copyToClipboard(Context context) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)this.buttonText, (CharSequence)this.inboxMessage.getInboxMessageContents().get(0).getLinkCopyText(this.buttonObject));
        if (clipboardManager != null) {
            clipboardManager.setPrimaryClip(clipData);
            Toast.makeText((Context)context, (CharSequence)"Text Copied to Clipboard", (int)0).show();
        }
    }
}

