/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.clevertap.android.sdk.CTMessageDAO;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import java.io.File;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DBAdapter {
    private static final String KEY_DATA = "data";
    private static final String KEY_CREATED_AT = "created_at";
    private static final long DATA_EXPIRATION = 432000000L;
    private static final String _ID = "_id";
    private static final String IS_READ = "isRead";
    private static final String EXPIRES = "expires";
    private static final String TAGS = "tags";
    private static final String USER_ID = "messageUser";
    private static final String CAMPAIGN = "campaignId";
    private static final String WZRKPARAMS = "wzrkParams";
    private static final int DB_UPDATE_ERROR = -1;
    private static final int DB_OUT_OF_MEMORY_ERROR = -2;
    public static final int DB_UNDEFINED_CODE = -3;
    private static final String DATABASE_NAME = "clevertap";
    private static final int DATABASE_VERSION = 3;
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE " + Table.EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String CREATE_PROFILE_EVENTS_TABLE = "CREATE TABLE " + Table.PROFILE_EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String CREATE_USER_PROFILES_TABLE = "CREATE TABLE " + Table.USER_PROFILES.getName() + " (_id STRING UNIQUE PRIMARY KEY, " + "data" + " STRING NOT NULL);";
    private static final String CREATE_INBOX_MESSAGES_TABLE = "CREATE TABLE " + Table.INBOX_MESSAGES.getName() + " (_id STRING NOT NULL, " + "data" + " TEXT NOT NULL, " + "wzrkParams" + " TEXT NOT NULL, " + "campaignId" + " STRING NOT NULL, " + "tags" + " TEXT NOT NULL, " + "isRead" + " INTEGER NOT NULL DEFAULT 0, " + "expires" + " INTEGER NOT NULL, " + "created_at" + " INTEGER NOT NULL, " + "messageUser" + " STRING NOT NULL);";
    private static final String INBOX_MESSAGES_COMP_ID_USERID_INDEX = "CREATE UNIQUE INDEX IF NOT EXISTS userid_id_idx ON " + Table.INBOX_MESSAGES.getName() + " (" + "messageUser" + "," + "_id" + ");";
    private static final String EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.EVENTS.getName() + " (" + "created_at" + ");";
    private static final String PROFILE_EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PROFILE_EVENTS.getName() + " (" + "created_at" + ");";
    private static final String CREATE_PUSH_NOTIFICATIONS_TABLE = "CREATE TABLE " + Table.PUSH_NOTIFICATIONS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL," + "isRead" + " INTEGER NOT NULL);";
    private static final String PUSH_NOTIFICATIONS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PUSH_NOTIFICATIONS.getName() + " (" + "created_at" + ");";
    private static final String CREATE_UNINSTALL_TS_TABLE = "CREATE TABLE " + Table.UNINSTALL_TS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "created_at" + " INTEGER NOT NULL);";
    private static final String UNINSTALL_TS_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.UNINSTALL_TS.getName() + " (" + "created_at" + ");";
    private static final String CREATE_NOTIFICATION_VIEWED_TABLE = "CREATE TABLE " + Table.PUSH_NOTIFICATION_VIEWED.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL);";
    private static final String NOTIFICATION_VIEWED_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PUSH_NOTIFICATION_VIEWED.getName() + " (" + "created_at" + ");";
    private final DatabaseHelper dbHelper;
    private CleverTapInstanceConfig config;
    private boolean rtlDirtyFlag = true;

    private static String getDatabaseName(CleverTapInstanceConfig config) {
        return config.isDefaultInstance() ? DATABASE_NAME : "clevertap_" + config.getAccountId();
    }

    DBAdapter(Context context, CleverTapInstanceConfig config) {
        this(context, DBAdapter.getDatabaseName(config));
        this.config = config;
    }

    private DBAdapter(Context context, String dbName) {
        this.dbHelper = new DatabaseHelper(context, dbName);
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int storeObject(JSONObject obj, Table table) {
        if (!this.belowMemThreshold()) {
            Logger.v("There is not enough space left on the device to store data, data discarded");
            return -2;
        }
        String tableName = table.getName();
        Cursor cursor = null;
        int count = -1;
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, obj.toString());
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            db.insert(tableName, null, cv);
            cursor = db.rawQuery("SELECT COUNT(*) FROM " + tableName, null);
            cursor.moveToFirst();
            count = cursor.getInt(0);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
            if (cursor != null) {
                cursor.close();
                cursor = null;
            }
            this.dbHelper.deleteDatabase();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long storeUserProfile(String id2, JSONObject obj) {
        if (id2 == null) {
            return -1L;
        }
        if (!this.belowMemThreshold()) {
            this.getConfigLogger().verbose("There is not enough space left on the device to store data, data discarded");
            return -2L;
        }
        String tableName = Table.USER_PROFILES.getName();
        long ret = -1L;
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, obj.toString());
            cv.put(_ID, id2);
            ret = db.insertWithOnConflict(tableName, null, cv, 5);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeUserProfile(String id2) {
        if (id2 == null) {
            return;
        }
        String tableName = Table.USER_PROFILES.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tableName, "_id = ?", new String[]{id2});
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing user profile from " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized JSONObject fetchUserProfileById(String id2) {
        if (id2 == null) {
            return null;
        }
        String tName = Table.USER_PROFILES.getName();
        JSONObject profile = null;
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT * FROM " + tName + " WHERE _id = ?", new String[]{id2});
            if (cursor != null && cursor.moveToFirst()) {
                try {
                    profile = new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeEvents(Table table) {
        String tName = table.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, null, null);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing all events from table " + tName + " Recreating DB");
            this.deleteDB();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanupEventsFromLastId(String lastId, Table table) {
        String tName = table.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, "_id <= " + lastId, null);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing sent data from table " + tName + " Recreating DB");
            this.deleteDB();
        }
        finally {
            this.dbHelper.close();
        }
    }

    synchronized void cleanupStaleEvents(Table table) {
        this.cleanInternal(table, 432000000L);
    }

    synchronized void cleanUpPushNotifications() {
        this.cleanInternal(Table.PUSH_NOTIFICATIONS, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanInternal(Table table, long expiration) {
        long time = (System.currentTimeMillis() - expiration) / 1000L;
        String tName = table.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, "created_at <= " + time, null);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing stale event records from " + tName + ". Recreating DB.", e);
            this.deleteDB();
        }
        finally {
            this.dbHelper.close();
        }
    }

    private void deleteDB() {
        this.dbHelper.deleteDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized JSONObject fetchEvents(Table table, int limit) {
        String tName = table.getName();
        Cursor cursor = null;
        String lastId = null;
        JSONArray events = new JSONArray();
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT * FROM " + tName + " ORDER BY " + KEY_CREATED_AT + " ASC LIMIT " + limit, null);
            while (cursor.moveToNext()) {
                if (cursor.isLast()) {
                    lastId = cursor.getString(cursor.getColumnIndex(_ID));
                }
                try {
                    JSONObject j = new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                    events.put((Object)j);
                }
                catch (JSONException jSONException) {}
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
            lastId = null;
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        if (lastId != null) {
            try {
                JSONObject ret = new JSONObject();
                ret.put(lastId, (Object)events);
                return ret;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storePushNotificationId(String id2, long ttl) {
        if (id2 == null) {
            return;
        }
        if (!this.belowMemThreshold()) {
            this.getConfigLogger().verbose("There is not enough space left on the device to store data, data discarded");
            return;
        }
        String tableName = Table.PUSH_NOTIFICATIONS.getName();
        if (ttl <= 0L) {
            ttl = System.currentTimeMillis() + 345600000L;
        }
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, id2);
            cv.put(KEY_CREATED_AT, Long.valueOf(ttl));
            cv.put(IS_READ, Integer.valueOf(0));
            db.insert(tableName, null, cv);
            this.rtlDirtyFlag = true;
            Logger.v("Stored PN - " + id2 + " with TTL - " + ttl);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String fetchPushNotificationId(String id2) {
        String tName = Table.PUSH_NOTIFICATIONS.getName();
        Cursor cursor = null;
        String pushId = "";
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT * FROM " + tName + " WHERE " + KEY_DATA + " = ?", new String[]{id2});
            if (cursor != null && cursor.moveToFirst()) {
                pushId = cursor.getString(cursor.getColumnIndex(KEY_DATA));
            }
            Logger.v("Fetching PID for check - " + pushId);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        return pushId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String[] fetchPushNotificationIds() {
        if (!this.rtlDirtyFlag) {
            return new String[0];
        }
        String tName = Table.PUSH_NOTIFICATIONS.getName();
        Cursor cursor = null;
        ArrayList<String> pushIds = new ArrayList<String>();
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT * FROM " + tName + " WHERE " + IS_READ + " = 0", null);
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    Logger.v("Fetching PID - " + cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                    pushIds.add(cursor.getString(cursor.getColumnIndex(KEY_DATA)));
                }
                cursor.close();
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        return pushIds.toArray(new String[pushIds.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updatePushNotificationIds(String[] ids) {
        if (ids.length == 0) {
            return;
        }
        if (!this.belowMemThreshold()) {
            Logger.v("There is not enough space left on the device to store data, data discarded");
            return;
        }
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(IS_READ, Integer.valueOf(1));
            StringBuilder questionMarksBuilder = new StringBuilder();
            questionMarksBuilder.append("?");
            for (int i = 0; i < ids.length - 1; ++i) {
                questionMarksBuilder.append(", ?");
            }
            db.update(Table.PUSH_NOTIFICATIONS.getName(), cv, "data IN ( " + questionMarksBuilder.toString() + " )", ids);
            this.rtlDirtyFlag = false;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + Table.PUSH_NOTIFICATIONS.getName() + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
    }

    synchronized boolean doesPushNotificationIdExist(String id2) {
        return id2.equals(this.fetchPushNotificationId(id2));
    }

    private boolean belowMemThreshold() {
        return this.dbHelper.belowMemThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storeUninstallTimestamp() {
        if (!this.belowMemThreshold()) {
            this.getConfigLogger().verbose("There is not enough space left on the device to store data, data discarded");
            return;
        }
        String tableName = Table.UNINSTALL_TS.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            db.insert(tableName, null, cv);
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + tableName + " Recreating DB");
            this.dbHelper.deleteDatabase();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long getLastUninstallTimestamp() {
        String tName = Table.UNINSTALL_TS.getName();
        Cursor cursor = null;
        long timestamp = 0L;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT * FROM " + tName + " ORDER BY " + KEY_CREATED_AT + " DESC LIMIT 1", null);
            if (cursor != null && cursor.moveToFirst()) {
                timestamp = cursor.getLong(cursor.getColumnIndex(KEY_CREATED_AT));
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Could not fetch records out of database " + tName + ".", e);
        }
        finally {
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void upsertMessages(ArrayList<CTMessageDAO> inboxMessages) {
        if (!this.belowMemThreshold()) {
            Logger.v("There is not enough space left on the device to store data, data discarded");
            return;
        }
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            for (CTMessageDAO messageDAO : inboxMessages) {
                ContentValues cv = new ContentValues();
                cv.put(_ID, messageDAO.getId());
                cv.put(KEY_DATA, messageDAO.getJsonData().toString());
                cv.put(WZRKPARAMS, messageDAO.getWzrkParams().toString());
                cv.put(CAMPAIGN, messageDAO.getCampaignId());
                cv.put(TAGS, messageDAO.getTags());
                cv.put(IS_READ, Integer.valueOf(messageDAO.isRead()));
                cv.put(EXPIRES, Long.valueOf(messageDAO.getExpires()));
                cv.put(KEY_CREATED_AT, Long.valueOf(messageDAO.getDate()));
                cv.put(USER_ID, messageDAO.getUserId());
                db.insertWithOnConflict(Table.INBOX_MESSAGES.getName(), null, cv, 5);
            }
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error adding data to table " + Table.INBOX_MESSAGES.getName());
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean deleteMessageForId(String messageId, String userId) {
        if (messageId == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.delete(tName, "_id = ? AND messageUser = ?", new String[]{messageId, userId});
            boolean bl = true;
            return bl;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing stale records from " + tName, e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean markReadMessageForId(String messageId, String userId) {
        if (messageId == null || userId == null) {
            return false;
        }
        String tName = Table.INBOX_MESSAGES.getName();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(IS_READ, Integer.valueOf(1));
            db.update(Table.INBOX_MESSAGES.getName(), cv, "_id = ? AND messageUser = ?", new String[]{messageId, userId});
            boolean bl = true;
            return bl;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error removing stale records from " + tName, e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized ArrayList<CTMessageDAO> getMessages(String userId) {
        String tName = Table.INBOX_MESSAGES.getName();
        ArrayList<CTMessageDAO> messageDAOArrayList = new ArrayList<CTMessageDAO>();
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            Cursor cursor = db.rawQuery("SELECT * FROM " + tName + " WHERE " + USER_ID + " = ? ORDER BY " + KEY_CREATED_AT + " DESC", new String[]{userId});
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    CTMessageDAO ctMessageDAO = new CTMessageDAO();
                    ctMessageDAO.setId(cursor.getString(cursor.getColumnIndex(_ID)));
                    ctMessageDAO.setJsonData(new JSONObject(cursor.getString(cursor.getColumnIndex(KEY_DATA))));
                    ctMessageDAO.setWzrkParams(new JSONObject(cursor.getString(cursor.getColumnIndex(WZRKPARAMS))));
                    ctMessageDAO.setDate(cursor.getLong(cursor.getColumnIndex(KEY_CREATED_AT)));
                    ctMessageDAO.setExpires(cursor.getLong(cursor.getColumnIndex(EXPIRES)));
                    ctMessageDAO.setRead(cursor.getInt(cursor.getColumnIndex(IS_READ)));
                    ctMessageDAO.setUserId(cursor.getString(cursor.getColumnIndex(USER_ID)));
                    ctMessageDAO.setTags(cursor.getString(cursor.getColumnIndex(TAGS)));
                    ctMessageDAO.setCampaignId(cursor.getString(cursor.getColumnIndex(CAMPAIGN)));
                    messageDAOArrayList.add(ctMessageDAO);
                }
                cursor.close();
            }
            ArrayList<CTMessageDAO> arrayList = messageDAOArrayList;
            return arrayList;
        }
        catch (SQLiteException e) {
            this.getConfigLogger().verbose("Error retrieving records from " + tName, e);
            ArrayList<CTMessageDAO> arrayList = null;
            return arrayList;
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose("Error retrieving records from " + tName, e.getMessage());
            ArrayList<CTMessageDAO> arrayList = null;
            return arrayList;
        }
        finally {
            this.dbHelper.close();
        }
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        private final File databaseFile;
        private final int DB_LIMIT = 0x1400000;

        DatabaseHelper(Context context, String dbName) {
            super(context, dbName, null, 3);
            this.databaseFile = context.getDatabasePath(dbName);
        }

        void deleteDatabase() {
            this.close();
            this.databaseFile.delete();
        }

        @SuppressLint(value={"SQLiteString"})
        public void onCreate(SQLiteDatabase db) {
            Logger.v("Creating CleverTap DB");
            db.execSQL(CREATE_EVENTS_TABLE);
            db.execSQL(CREATE_PROFILE_EVENTS_TABLE);
            db.execSQL(CREATE_USER_PROFILES_TABLE);
            db.execSQL(CREATE_INBOX_MESSAGES_TABLE);
            db.execSQL(CREATE_PUSH_NOTIFICATIONS_TABLE);
            db.execSQL(CREATE_UNINSTALL_TS_TABLE);
            db.execSQL(CREATE_NOTIFICATION_VIEWED_TABLE);
            db.execSQL(EVENTS_TIME_INDEX);
            db.execSQL(PROFILE_EVENTS_TIME_INDEX);
            db.execSQL(UNINSTALL_TS_INDEX);
            db.execSQL(PUSH_NOTIFICATIONS_TIME_INDEX);
            db.execSQL(INBOX_MESSAGES_COMP_ID_USERID_INDEX);
            db.execSQL(NOTIFICATION_VIEWED_INDEX);
        }

        @SuppressLint(value={"SQLiteString"})
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Logger.v("Upgrading CleverTap DB to version " + newVersion);
            switch (oldVersion) {
                case 1: {
                    db.execSQL("DROP TABLE IF EXISTS " + Table.UNINSTALL_TS.getName());
                    db.execSQL("DROP TABLE IF EXISTS " + Table.INBOX_MESSAGES.getName());
                    db.execSQL("DROP TABLE IF EXISTS " + Table.PUSH_NOTIFICATION_VIEWED.getName());
                    db.execSQL(CREATE_PUSH_NOTIFICATIONS_TABLE);
                    db.execSQL(CREATE_UNINSTALL_TS_TABLE);
                    db.execSQL(CREATE_INBOX_MESSAGES_TABLE);
                    db.execSQL(CREATE_NOTIFICATION_VIEWED_TABLE);
                    db.execSQL(UNINSTALL_TS_INDEX);
                    db.execSQL(PUSH_NOTIFICATIONS_TIME_INDEX);
                    db.execSQL(INBOX_MESSAGES_COMP_ID_USERID_INDEX);
                    db.execSQL(NOTIFICATION_VIEWED_INDEX);
                    break;
                }
                case 2: {
                    db.execSQL("DROP TABLE IF EXISTS " + Table.PUSH_NOTIFICATION_VIEWED.getName());
                    db.execSQL(CREATE_NOTIFICATION_VIEWED_TABLE);
                    db.execSQL(NOTIFICATION_VIEWED_INDEX);
                }
            }
        }

        boolean belowMemThreshold() {
            if (this.databaseFile.exists()) {
                return Math.max(this.databaseFile.getUsableSpace(), 0x1400000L) >= this.databaseFile.length();
            }
            return true;
        }
    }

    public static enum Table {
        EVENTS("events"),
        PROFILE_EVENTS("profileEvents"),
        USER_PROFILES("userProfiles"),
        INBOX_MESSAGES("inboxMessages"),
        PUSH_NOTIFICATIONS("pushNotifications"),
        UNINSTALL_TS("uninstallTimestamp"),
        PUSH_NOTIFICATION_VIEWED("notificationViewed");

        private final String tableName;

        private Table(String name) {
            this.tableName = name;
        }

        public String getName() {
            return this.tableName;
        }
    }
}

