/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import org.json.JSONObject;

public class CleverTapInstanceConfig
implements Parcelable {
    private String accountId;
    private String accountToken;
    private String accountRegion;
    private String gcmSenderId;
    private boolean analyticsOnly;
    private boolean isDefaultInstance;
    private boolean useGoogleAdId;
    private boolean disableAppLaunchedEvent;
    private boolean personalization;
    private int debugLevel;
    protected Logger logger;
    private boolean createdPostAppLaunch;
    private boolean sslPinning;
    private boolean backgroundSync;
    private boolean enableCustomCleverTapId;
    private String fcmSenderId;
    public static final Parcelable.Creator<CleverTapInstanceConfig> CREATOR = new Parcelable.Creator<CleverTapInstanceConfig>(){

        public CleverTapInstanceConfig createFromParcel(Parcel in) {
            return new CleverTapInstanceConfig(in);
        }

        public CleverTapInstanceConfig[] newArray(int size) {
            return new CleverTapInstanceConfig[size];
        }
    };

    private CleverTapInstanceConfig(Context context, String accountId, String accountToken, String accountRegion, boolean isDefault) {
        this.accountId = accountId;
        this.accountToken = accountToken;
        this.accountRegion = accountRegion;
        this.isDefaultInstance = isDefault;
        this.analyticsOnly = false;
        this.personalization = true;
        this.debugLevel = CleverTapAPI.LogLevel.INFO.intValue();
        this.logger = new Logger(this.debugLevel);
        this.createdPostAppLaunch = false;
        ManifestInfo manifest = ManifestInfo.getInstance(context);
        this.useGoogleAdId = manifest.useGoogleAdId();
        this.disableAppLaunchedEvent = manifest.isAppLaunchedDisabled();
        this.gcmSenderId = manifest.getGCMSenderId();
        this.sslPinning = manifest.isSSLPinningEnabled();
        this.backgroundSync = manifest.isBackgroundSync();
        this.fcmSenderId = manifest.getFCMSenderId();
        this.enableCustomCleverTapId = manifest.useCustomId();
    }

    CleverTapInstanceConfig(CleverTapInstanceConfig config) {
        this.accountId = config.accountId;
        this.accountToken = config.accountToken;
        this.accountRegion = config.accountRegion;
        this.isDefaultInstance = config.isDefaultInstance;
        this.analyticsOnly = config.analyticsOnly;
        this.personalization = config.personalization;
        this.debugLevel = config.debugLevel;
        this.logger = config.logger;
        this.useGoogleAdId = config.useGoogleAdId;
        this.disableAppLaunchedEvent = config.disableAppLaunchedEvent;
        this.gcmSenderId = config.gcmSenderId;
        this.createdPostAppLaunch = config.createdPostAppLaunch;
        this.sslPinning = config.sslPinning;
        this.backgroundSync = config.backgroundSync;
        this.enableCustomCleverTapId = config.enableCustomCleverTapId;
        this.fcmSenderId = config.fcmSenderId;
    }

    private CleverTapInstanceConfig(String jsonString) throws Throwable {
        try {
            JSONObject configJsonObject = new JSONObject(jsonString);
            if (configJsonObject.has("accountId")) {
                this.accountId = configJsonObject.getString("accountId");
            }
            if (configJsonObject.has("accountToken")) {
                this.accountToken = configJsonObject.getString("accountToken");
            }
            if (configJsonObject.has("accountRegion")) {
                this.accountRegion = configJsonObject.getString("accountRegion");
            }
            if (configJsonObject.has("gcmSenderId")) {
                this.gcmSenderId = configJsonObject.getString("gcmSenderId");
            }
            if (configJsonObject.has("analyticsOnly")) {
                this.analyticsOnly = configJsonObject.getBoolean("analyticsOnly");
            }
            if (configJsonObject.has("isDefaultInstance")) {
                this.isDefaultInstance = configJsonObject.getBoolean("isDefaultInstance");
            }
            if (configJsonObject.has("useGoogleAdId")) {
                this.useGoogleAdId = configJsonObject.getBoolean("useGoogleAdId");
            }
            if (configJsonObject.has("disableAppLaunchedEvent")) {
                this.disableAppLaunchedEvent = configJsonObject.getBoolean("disableAppLaunchedEvent");
            }
            if (configJsonObject.has("personalization")) {
                this.personalization = configJsonObject.getBoolean("personalization");
            }
            if (configJsonObject.has("debugLevel")) {
                this.debugLevel = configJsonObject.getInt("debugLevel");
                this.logger = new Logger(this.debugLevel);
            }
            if (configJsonObject.has("createdPostAppLaunch")) {
                this.createdPostAppLaunch = configJsonObject.getBoolean("createdPostAppLaunch");
            }
            if (configJsonObject.has("sslPinning")) {
                this.sslPinning = configJsonObject.getBoolean("sslPinning");
            }
            if (configJsonObject.has("backgroundSync")) {
                this.backgroundSync = configJsonObject.getBoolean("backgroundSync");
            }
            if (configJsonObject.has("getEnableCustomCleverTapId")) {
                this.enableCustomCleverTapId = configJsonObject.getBoolean("getEnableCustomCleverTapId");
            }
            if (configJsonObject.has("fcmSenderId")) {
                this.gcmSenderId = configJsonObject.getString("fcmSenderId");
            }
        }
        catch (Throwable t) {
            Logger.v("Error constructing CleverTapInstanceConfig from JSON: " + jsonString + ": ", t.getCause());
            throw t;
        }
    }

    private CleverTapInstanceConfig(Parcel in) {
        this.accountId = in.readString();
        this.accountToken = in.readString();
        this.accountRegion = in.readString();
        this.gcmSenderId = in.readString();
        this.analyticsOnly = in.readByte() != 0;
        this.isDefaultInstance = in.readByte() != 0;
        this.useGoogleAdId = in.readByte() != 0;
        this.disableAppLaunchedEvent = in.readByte() != 0;
        this.personalization = in.readByte() != 0;
        this.debugLevel = in.readInt();
        this.createdPostAppLaunch = in.readByte() != 0;
        this.sslPinning = in.readByte() != 0;
        this.backgroundSync = in.readByte() != 0;
        this.enableCustomCleverTapId = in.readByte() != 0;
        this.fcmSenderId = in.readString();
    }

    public static CleverTapInstanceConfig createInstance(Context context, @NonNull String accountId, @NonNull String accountToken) {
        if (accountId == null || accountToken == null) {
            Logger.i("CleverTap accountId and accountToken cannot be null");
            return null;
        }
        return new CleverTapInstanceConfig(context, accountId, accountToken, null, false);
    }

    public static CleverTapInstanceConfig createInstance(Context context, @NonNull String accountId, @NonNull String accountToken, String accountRegion) {
        if (accountId == null || accountToken == null) {
            Logger.i("CleverTap accountId and accountToken cannot be null");
            return null;
        }
        return new CleverTapInstanceConfig(context, accountId, accountToken, accountRegion, false);
    }

    protected static CleverTapInstanceConfig createInstance(@NonNull String jsonString) {
        try {
            return new CleverTapInstanceConfig(jsonString);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected static CleverTapInstanceConfig createDefaultInstance(Context context, @NonNull String accountId, @NonNull String accountToken, String accountRegion) {
        return new CleverTapInstanceConfig(context, accountId, accountToken, accountRegion, true);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountToken() {
        return this.accountToken;
    }

    public String getAccountRegion() {
        return this.accountRegion;
    }

    private String getGCMSenderId() {
        return this.gcmSenderId;
    }

    public boolean isAnalyticsOnly() {
        return this.analyticsOnly;
    }

    public void setAnalyticsOnly(boolean analyticsOnly) {
        this.analyticsOnly = analyticsOnly;
    }

    boolean isDefaultInstance() {
        return this.isDefaultInstance;
    }

    boolean isCreatedPostAppLaunch() {
        return this.createdPostAppLaunch;
    }

    void setCreatedPostAppLaunch() {
        this.createdPostAppLaunch = true;
    }

    boolean isUseGoogleAdId() {
        return this.useGoogleAdId;
    }

    public void useGoogleAdId(boolean value) {
        this.useGoogleAdId = value;
    }

    boolean isDisableAppLaunchedEvent() {
        return this.disableAppLaunchedEvent;
    }

    public void setDisableAppLaunchedEvent(boolean disableAppLaunchedEvent) {
        this.disableAppLaunchedEvent = disableAppLaunchedEvent;
    }

    boolean isSslPinningEnabled() {
        return this.sslPinning;
    }

    public void enablePersonalization(boolean enablePersonalization) {
        this.personalization = enablePersonalization;
    }

    boolean isPersonalizationEnabled() {
        return this.personalization;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(CleverTapAPI.LogLevel debugLevel) {
        this.debugLevel = debugLevel.intValue();
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    public Logger getLogger() {
        return this.logger;
    }

    boolean isBackgroundSync() {
        return this.backgroundSync;
    }

    public void setBackgroundSync(boolean backgroundSync) {
        this.backgroundSync = backgroundSync;
    }

    boolean getEnableCustomCleverTapId() {
        return this.enableCustomCleverTapId;
    }

    public void setEnableCustomCleverTapId(boolean enableCustomCleverTapId) {
        this.enableCustomCleverTapId = enableCustomCleverTapId;
    }

    public String getFCMSenderId() {
        return this.fcmSenderId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.accountId);
        dest.writeString(this.accountToken);
        dest.writeString(this.accountRegion);
        dest.writeString(this.gcmSenderId);
        dest.writeByte((byte)(this.analyticsOnly ? 1 : 0));
        dest.writeByte((byte)(this.isDefaultInstance ? 1 : 0));
        dest.writeByte((byte)(this.useGoogleAdId ? 1 : 0));
        dest.writeByte((byte)(this.disableAppLaunchedEvent ? 1 : 0));
        dest.writeByte((byte)(this.personalization ? 1 : 0));
        dest.writeInt(this.debugLevel);
        dest.writeByte((byte)(this.sslPinning ? 1 : 0));
        dest.writeByte((byte)(this.createdPostAppLaunch ? 1 : 0));
        dest.writeByte((byte)(this.backgroundSync ? 1 : 0));
        dest.writeByte((byte)(this.enableCustomCleverTapId ? 1 : 0));
        dest.writeString(this.fcmSenderId);
    }

    String toJSONString() {
        JSONObject configJsonObject = new JSONObject();
        try {
            configJsonObject.put("accountId", (Object)this.getAccountId());
            configJsonObject.put("accountToken", (Object)this.getAccountToken());
            configJsonObject.put("accountRegion", (Object)this.getAccountRegion());
            configJsonObject.put("gcmSenderId", (Object)this.getGCMSenderId());
            configJsonObject.put("analyticsOnly", this.isAnalyticsOnly());
            configJsonObject.put("isDefaultInstance", this.isDefaultInstance());
            configJsonObject.put("useGoogleAdId", this.isUseGoogleAdId());
            configJsonObject.put("disableAppLaunchedEvent", this.isDisableAppLaunchedEvent());
            configJsonObject.put("personalization", this.isPersonalizationEnabled());
            configJsonObject.put("debugLevel", this.getDebugLevel());
            configJsonObject.put("createdPostAppLaunch", this.isCreatedPostAppLaunch());
            configJsonObject.put("sslPinning", this.isSslPinningEnabled());
            configJsonObject.put("backgroundSync", this.isBackgroundSync());
            configJsonObject.put("getEnableCustomCleverTapId", this.getEnableCustomCleverTapId());
            configJsonObject.put("fcmSenderId", (Object)this.getFCMSenderId());
            return configJsonObject.toString();
        }
        catch (Throwable e) {
            Logger.v("Unable to convert config to JSON : ", e.getCause());
            return null;
        }
    }
}

