/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.clevertap.android.sdk.CTInboxActivity;
import com.clevertap.android.sdk.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.CTInboxButtonClickListener;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxMessageContent;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CTIconMessageViewHolder
extends CTInboxBaseMessageViewHolder {
    private ImageView readDot;
    private ImageView mediaImage;
    private ImageView iconImage;
    private ImageView squareImage;
    private Button cta1;
    private Button cta2;
    private Button cta3;
    private TextView title;
    private TextView message;
    private TextView timestamp;
    private RelativeLayout clickLayout;
    private LinearLayout ctaLinearLayout;

    CTIconMessageViewHolder(@NonNull View itemView) {
        super(itemView);
        itemView.setTag((Object)this);
        this.title = (TextView)itemView.findViewById(R.id.messageTitle);
        this.message = (TextView)itemView.findViewById(R.id.messageText);
        this.mediaImage = (ImageView)itemView.findViewById(R.id.media_image);
        this.iconImage = (ImageView)itemView.findViewById(R.id.image_icon);
        this.readDot = (ImageView)itemView.findViewById(R.id.read_circle);
        this.timestamp = (TextView)itemView.findViewById(R.id.timestamp);
        this.cta1 = (Button)itemView.findViewById(R.id.cta_button_1);
        this.cta2 = (Button)itemView.findViewById(R.id.cta_button_2);
        this.cta3 = (Button)itemView.findViewById(R.id.cta_button_3);
        this.frameLayout = (FrameLayout)itemView.findViewById(R.id.icon_message_frame_layout);
        this.squareImage = (ImageView)itemView.findViewById(R.id.square_media_image);
        this.clickLayout = (RelativeLayout)itemView.findViewById(R.id.click_relative_layout);
        this.ctaLinearLayout = (LinearLayout)itemView.findViewById(R.id.cta_linear_layout);
        this.progressBarFrameLayout = (FrameLayout)itemView.findViewById(R.id.icon_progress_frame_layout);
    }

    @Override
    void configureWithMessage(CTInboxMessage inboxMessage, CTInboxListViewFragment parent, final int position) {
        super.configureWithMessage(inboxMessage, parent, position);
        CTInboxListViewFragment parentWeak = this.getParent();
        CTInboxMessageContent content = inboxMessage.getInboxMessageContents().get(0);
        this.title.setText((CharSequence)content.getTitle());
        this.title.setTextColor(Color.parseColor((String)content.getTitleColor()));
        this.message.setText((CharSequence)content.getMessage());
        this.message.setTextColor(Color.parseColor((String)content.getMessageColor()));
        this.clickLayout.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        String iconDisplayTimestamp = this.calculateDisplayTimestamp(inboxMessage.getDate());
        this.timestamp.setText((CharSequence)iconDisplayTimestamp);
        this.timestamp.setTextColor(Color.parseColor((String)content.getTitleColor()));
        if (inboxMessage.isRead()) {
            this.readDot.setVisibility(8);
        } else {
            this.readDot.setVisibility(0);
        }
        this.frameLayout.setVisibility(8);
        JSONArray iconlinksArray = content.getLinks();
        if (iconlinksArray != null) {
            this.ctaLinearLayout.setVisibility(0);
            int size = iconlinksArray.length();
            try {
                switch (size) {
                    case 1: {
                        JSONObject cta1Object = iconlinksArray.getJSONObject(0);
                        this.cta1.setVisibility(0);
                        this.cta1.setText((CharSequence)content.getLinkText(cta1Object));
                        this.cta1.setTextColor(Color.parseColor((String)content.getLinkColor(cta1Object)));
                        this.cta1.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta1Object)));
                        this.hideTwoButtons(this.cta1, this.cta2, this.cta3);
                        if (parentWeak == null) break;
                        this.cta1.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta1.getText().toString(), cta1Object, parentWeak));
                        break;
                    }
                    case 2: {
                        JSONObject cta1Object = iconlinksArray.getJSONObject(0);
                        this.cta1.setVisibility(0);
                        this.cta1.setText((CharSequence)content.getLinkText(cta1Object));
                        this.cta1.setTextColor(Color.parseColor((String)content.getLinkColor(cta1Object)));
                        this.cta1.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta1Object)));
                        JSONObject cta2Object = iconlinksArray.getJSONObject(1);
                        this.cta2.setVisibility(0);
                        this.cta2.setText((CharSequence)content.getLinkText(cta2Object));
                        this.cta2.setTextColor(Color.parseColor((String)content.getLinkColor(cta2Object)));
                        this.cta2.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta2Object)));
                        this.hideOneButton(this.cta1, this.cta2, this.cta3);
                        if (parentWeak == null) break;
                        this.cta1.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta1.getText().toString(), cta1Object, parentWeak));
                        this.cta2.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta2.getText().toString(), cta2Object, parentWeak));
                        break;
                    }
                    case 3: {
                        JSONObject cta1Object = iconlinksArray.getJSONObject(0);
                        this.cta1.setVisibility(0);
                        this.cta1.setText((CharSequence)content.getLinkText(cta1Object));
                        this.cta1.setTextColor(Color.parseColor((String)content.getLinkColor(cta1Object)));
                        this.cta1.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta1Object)));
                        JSONObject cta2Object = iconlinksArray.getJSONObject(1);
                        this.cta2.setVisibility(0);
                        this.cta2.setText((CharSequence)content.getLinkText(cta2Object));
                        this.cta2.setTextColor(Color.parseColor((String)content.getLinkColor(cta2Object)));
                        this.cta2.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta2Object)));
                        String cta3Object = iconlinksArray.getJSONObject(2);
                        this.cta3.setVisibility(0);
                        this.cta3.setText((CharSequence)content.getLinkText((JSONObject)cta3Object));
                        this.cta3.setTextColor(Color.parseColor((String)content.getLinkColor((JSONObject)cta3Object)));
                        this.cta3.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor((JSONObject)cta3Object)));
                        if (parentWeak == null) break;
                        this.cta1.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta1.getText().toString(), cta1Object, parentWeak));
                        this.cta2.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta2.getText().toString(), cta2Object, parentWeak));
                        this.cta3.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta3.getText().toString(), (JSONObject)cta3Object, parentWeak));
                    }
                }
            }
            catch (JSONException e) {
                Logger.d("Error parsing CTA JSON - " + e.getLocalizedMessage());
            }
        } else {
            this.ctaLinearLayout.setVisibility(8);
        }
        this.mediaImage.setVisibility(8);
        this.mediaImage.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        this.squareImage.setVisibility(8);
        this.squareImage.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        Resources resources = this.context.getResources();
        int width = CTInboxActivity.orientation == 2 ? (int)TypedValue.applyDimension((int)1, (float)450.0f, (DisplayMetrics)resources.getDisplayMetrics()) : resources.getDisplayMetrics().widthPixels;
        int height = inboxMessage.getOrientation().equalsIgnoreCase("l") ? Math.round((float)width * 0.5625f) : width;
        this.progressBarFrameLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, height));
        this.progressBarFrameLayout.setVisibility(8);
        try {
            switch (inboxMessage.getOrientation()) {
                case "l": {
                    if (content.mediaIsImage()) {
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        Glide.with((Context)this.mediaImage.getContext()).load(content.getMedia()).apply(new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image")).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(this.mediaImage);
                        break;
                    }
                    if (content.mediaIsGIF()) {
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        Glide.with((Context)this.mediaImage.getContext()).asGif().load(content.getMedia()).apply(new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image")).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(this.mediaImage);
                        break;
                    }
                    if (content.mediaIsVideo()) {
                        if (!content.getPosterUrl().isEmpty()) {
                            this.mediaImage.setVisibility(0);
                            this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                            Glide.with((Context)this.mediaImage.getContext()).load(content.getPosterUrl()).apply(new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_video_1")).error(Utils.getThumbnailImage(this.context, "ct_video_1"))).into(this.mediaImage);
                            break;
                        }
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        int drawableId = Utils.getThumbnailImage(this.context, "ct_video_1");
                        if (drawableId != -1) {
                            Glide.with((Context)this.mediaImage.getContext()).load(Integer.valueOf(drawableId)).into(this.mediaImage);
                        }
                    } else {
                        if (!content.mediaIsAudio()) break;
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        this.mediaImage.setBackgroundColor(this.getImageBackgroundColor());
                        int drawableId = Utils.getThumbnailImage(this.context, "ct_audio");
                        if (drawableId != -1) {
                            Glide.with((Context)this.mediaImage.getContext()).load(Integer.valueOf(drawableId)).into(this.mediaImage);
                        }
                    }
                    break;
                }
                case "p": {
                    if (content.mediaIsImage()) {
                        this.squareImage.setVisibility(0);
                        this.squareImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        Glide.with((Context)this.squareImage.getContext()).load(content.getMedia()).apply(new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image")).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(this.squareImage);
                        break;
                    }
                    if (content.mediaIsGIF()) {
                        this.squareImage.setVisibility(0);
                        this.squareImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        Glide.with((Context)this.squareImage.getContext()).asGif().load(content.getMedia()).apply(new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image")).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(this.squareImage);
                        break;
                    }
                    if (content.mediaIsVideo()) {
                        if (!content.getPosterUrl().isEmpty()) {
                            this.squareImage.setVisibility(0);
                            this.squareImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                            Glide.with((Context)this.squareImage.getContext()).load(content.getPosterUrl()).apply(new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_video_1")).error(Utils.getThumbnailImage(this.context, "ct_video_1"))).into(this.squareImage);
                            break;
                        }
                        this.squareImage.setVisibility(0);
                        this.squareImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        this.squareImage.setBackgroundColor(this.getImageBackgroundColor());
                        int drawableId = Utils.getThumbnailImage(this.context, "ct_video_1");
                        if (drawableId != -1) {
                            Glide.with((Context)this.squareImage.getContext()).load(Integer.valueOf(drawableId)).into(this.squareImage);
                        }
                        break;
                    }
                    if (!content.mediaIsAudio()) break;
                    this.squareImage.setVisibility(0);
                    this.squareImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    this.squareImage.setBackgroundColor(this.getImageBackgroundColor());
                    int drawableId = Utils.getThumbnailImage(this.context, "ct_audio");
                    if (drawableId == -1) break;
                    Glide.with((Context)this.squareImage.getContext()).load(Integer.valueOf(drawableId)).into(this.squareImage);
                }
            }
        }
        catch (NoClassDefFoundError error) {
            Logger.d("CleverTap SDK requires Glide dependency. Please refer CleverTap Documentation for more info");
        }
        Runnable iconRunnable = new Runnable(){

            @Override
            public void run() {
                final CTInboxListViewFragment parent = CTIconMessageViewHolder.this.getParent();
                if (parent != null) {
                    FragmentActivity activity = parent.getActivity();
                    if (activity == null) {
                        return;
                    }
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CTIconMessageViewHolder.this.readDot.getVisibility() == 0) {
                                parent.didShow(null, position);
                            }
                            CTIconMessageViewHolder.this.readDot.setVisibility(8);
                        }
                    });
                }
            }
        };
        Handler iconHandler = new Handler();
        iconHandler.postDelayed(iconRunnable, 2000L);
        try {
            if (!content.getIcon().isEmpty()) {
                this.iconImage.setVisibility(0);
                Glide.with((Context)this.iconImage.getContext()).load(content.getIcon()).apply(new RequestOptions().placeholder(Utils.getThumbnailImage(this.context, "ct_image")).error(Utils.getThumbnailImage(this.context, "ct_image"))).into(this.iconImage);
            } else {
                this.iconImage.setVisibility(8);
            }
        }
        catch (NoClassDefFoundError error) {
            Logger.d("CleverTap SDK requires Glide dependency. Please refer CleverTap Documentation for more info");
        }
        if (parentWeak != null) {
            this.clickLayout.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, null, null, parentWeak));
        }
    }
}

