/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.clevertap.android.sdk.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.CTInboxButtonClickListener;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxMessageContent;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CTSimpleMessageViewHolder
extends CTInboxBaseMessageViewHolder {
    private TextView title;
    private TextView message;
    private TextView timestamp;
    private ImageView readDot;
    private ImageView mediaImage;
    private ImageView squareImage;
    private Button cta1;
    private Button cta2;
    private Button cta3;

    CTSimpleMessageViewHolder(@NonNull View itemView) {
        super(itemView);
        itemView.setTag((Object)this);
        this.title = (TextView)itemView.findViewById(R.id.messageTitle);
        this.message = (TextView)itemView.findViewById(R.id.messageText);
        this.timestamp = (TextView)itemView.findViewById(R.id.timestamp);
        this.readDot = (ImageView)itemView.findViewById(R.id.read_circle);
        this.cta1 = (Button)itemView.findViewById(R.id.cta_button_1);
        this.cta2 = (Button)itemView.findViewById(R.id.cta_button_2);
        this.cta3 = (Button)itemView.findViewById(R.id.cta_button_3);
        this.mediaImage = (ImageView)itemView.findViewById(R.id.media_image);
        this.relativeLayout = (RelativeLayout)itemView.findViewById(R.id.simple_message_relative_layout);
        this.frameLayout = (FrameLayout)itemView.findViewById(R.id.simple_message_frame_layout);
        this.squareImage = (ImageView)itemView.findViewById(R.id.square_media_image);
        this.clickLayout = (RelativeLayout)itemView.findViewById(R.id.click_relative_layout);
        this.ctaLinearLayout = (LinearLayout)itemView.findViewById(R.id.cta_linear_layout);
        this.bodyRelativeLayout = (RelativeLayout)itemView.findViewById(R.id.body_relative_layout);
    }

    @Override
    void configureWithMessage(CTInboxMessage inboxMessage, CTInboxListViewFragment parent, final int position) {
        super.configureWithMessage(inboxMessage, parent, position);
        CTInboxListViewFragment parentWeak = this.getParent();
        CTInboxMessageContent content = inboxMessage.getInboxMessageContents().get(0);
        this.title.setText((CharSequence)content.getTitle());
        this.title.setTextColor(Color.parseColor((String)content.getTitleColor()));
        this.message.setText((CharSequence)content.getMessage());
        this.message.setTextColor(Color.parseColor((String)content.getMessageColor()));
        this.bodyRelativeLayout.setBackgroundColor(Color.parseColor((String)inboxMessage.getBgColor()));
        String displayTimestamp = this.calculateDisplayTimestamp(inboxMessage.getDate());
        this.timestamp.setText((CharSequence)displayTimestamp);
        this.timestamp.setTextColor(Color.parseColor((String)content.getTitleColor()));
        if (inboxMessage.isRead()) {
            this.readDot.setVisibility(8);
        } else {
            this.readDot.setVisibility(0);
        }
        JSONArray linksArray = content.getLinks();
        if (linksArray != null) {
            this.ctaLinearLayout.setVisibility(0);
            int size = linksArray.length();
            try {
                switch (size) {
                    case 1: {
                        JSONObject cta1Object = linksArray.getJSONObject(0);
                        this.cta1.setVisibility(0);
                        this.cta1.setText((CharSequence)content.getLinkText(cta1Object));
                        this.cta1.setTextColor(Color.parseColor((String)content.getLinkColor(cta1Object)));
                        this.cta1.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta1Object)));
                        this.hideTwoButtons(this.cta1, this.cta2, this.cta3);
                        if (parentWeak == null) break;
                        this.cta1.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta1.getText().toString(), cta1Object, parentWeak));
                        break;
                    }
                    case 2: {
                        JSONObject cta1Object = linksArray.getJSONObject(0);
                        this.cta1.setVisibility(0);
                        this.cta1.setText((CharSequence)content.getLinkText(cta1Object));
                        this.cta1.setTextColor(Color.parseColor((String)content.getLinkColor(cta1Object)));
                        this.cta1.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta1Object)));
                        JSONObject cta2Object = linksArray.getJSONObject(1);
                        this.cta2.setVisibility(0);
                        this.cta2.setText((CharSequence)content.getLinkText(cta2Object));
                        this.cta2.setTextColor(Color.parseColor((String)content.getLinkColor(cta2Object)));
                        this.cta2.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta2Object)));
                        this.hideOneButton(this.cta1, this.cta2, this.cta3);
                        if (parentWeak == null) break;
                        this.cta1.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta1.getText().toString(), cta1Object, parentWeak));
                        this.cta2.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta2.getText().toString(), cta2Object, parentWeak));
                        break;
                    }
                    case 3: {
                        JSONObject cta1Object = linksArray.getJSONObject(0);
                        this.cta1.setVisibility(0);
                        this.cta1.setText((CharSequence)content.getLinkText(cta1Object));
                        this.cta1.setTextColor(Color.parseColor((String)content.getLinkColor(cta1Object)));
                        this.cta1.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta1Object)));
                        JSONObject cta2Object = linksArray.getJSONObject(1);
                        this.cta2.setVisibility(0);
                        this.cta2.setText((CharSequence)content.getLinkText(cta2Object));
                        this.cta2.setTextColor(Color.parseColor((String)content.getLinkColor(cta2Object)));
                        this.cta2.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta2Object)));
                        JSONObject cta3Object = linksArray.getJSONObject(2);
                        this.cta3.setVisibility(0);
                        this.cta3.setText((CharSequence)content.getLinkText(cta3Object));
                        this.cta3.setTextColor(Color.parseColor((String)content.getLinkColor(cta3Object)));
                        this.cta3.setBackgroundColor(Color.parseColor((String)content.getLinkBGColor(cta3Object)));
                        if (parentWeak == null) break;
                        this.cta1.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta1.getText().toString(), cta1Object, parentWeak));
                        this.cta2.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta2.getText().toString(), cta2Object, parentWeak));
                        this.cta3.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, this.cta3.getText().toString(), cta3Object, parentWeak));
                    }
                }
            }
            catch (JSONException e) {
                Logger.d("Error parsing CTA JSON - " + e.getLocalizedMessage());
            }
        } else {
            this.ctaLinearLayout.setVisibility(8);
        }
        this.removeVideoView();
        this.mediaImage.setVisibility(8);
        this.squareImage.setVisibility(8);
        try {
            switch (inboxMessage.getOrientation()) {
                case "l": {
                    if (content.mediaIsImage()) {
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        Glide.with((Context)this.mediaImage.getContext()).load(content.getMedia()).into(this.mediaImage);
                        break;
                    }
                    if (content.mediaIsGIF()) {
                        this.mediaImage.setVisibility(0);
                        this.mediaImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        Glide.with((Context)this.mediaImage.getContext()).asGif().load(content.getMedia()).into(this.mediaImage);
                        break;
                    }
                    if (!content.mediaIsVideo() && !content.mediaIsAudio()) break;
                    this.addMediaPlayerView(inboxMessage);
                    break;
                }
                case "p": {
                    if (content.mediaIsImage()) {
                        this.squareImage.setVisibility(0);
                        this.squareImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        Glide.with((Context)this.squareImage.getContext()).load(content.getMedia()).into(this.squareImage);
                        break;
                    }
                    if (content.mediaIsGIF()) {
                        this.squareImage.setVisibility(0);
                        this.squareImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        Glide.with((Context)this.squareImage.getContext()).asGif().load(content.getMedia()).into(this.squareImage);
                        break;
                    }
                    if (!content.mediaIsVideo() && !content.mediaIsAudio()) break;
                    this.addMediaPlayerView(inboxMessage);
                }
            }
        }
        catch (NoClassDefFoundError error) {
            Logger.d("CleverTap SDK requires Glide dependency. Please refer CleverTap Documentation for more info");
        }
        Runnable simpleRunnable = new Runnable(){

            @Override
            public void run() {
                final CTInboxListViewFragment parent = CTSimpleMessageViewHolder.this.getParent();
                if (parent != null) {
                    FragmentActivity activity = parent.getActivity();
                    if (activity == null) {
                        return;
                    }
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (CTSimpleMessageViewHolder.this.readDot.getVisibility() == 0) {
                                parent.didShow(null, position);
                            }
                            CTSimpleMessageViewHolder.this.readDot.setVisibility(8);
                        }
                    });
                }
            }
        };
        Handler simpleHandler = new Handler();
        simpleHandler.postDelayed(simpleRunnable, 2000L);
        if (parentWeak != null) {
            this.clickLayout.setOnClickListener((View.OnClickListener)new CTInboxButtonClickListener(position, inboxMessage, null, null, parentWeak));
        }
    }
}

